/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.jmol.util.Parser;

public final class ArrayUtil {
    public static Object ensureLength(Object object, int n) {
        if (object != null && Array.getLength(object) >= n) {
            return object;
        }
        return ArrayUtil.setLength(object, n);
    }

    public static String[] ensureLength(String[] stringArray, int n) {
        if (stringArray != null && stringArray.length >= n) {
            return stringArray;
        }
        return ArrayUtil.setLength(stringArray, n);
    }

    public static float[] ensureLength(float[] fArray, int n) {
        if (fArray != null && fArray.length >= n) {
            return fArray;
        }
        return ArrayUtil.setLength(fArray, n);
    }

    public static int[] ensureLength(int[] nArray, int n) {
        if (nArray != null && nArray.length >= n) {
            return nArray;
        }
        return ArrayUtil.setLength(nArray, n);
    }

    public static short[] ensureLength(short[] sArray, int n) {
        if (sArray != null && sArray.length >= n) {
            return sArray;
        }
        return ArrayUtil.setLength(sArray, n);
    }

    public static byte[] ensureLength(byte[] byArray, int n) {
        if (byArray != null && byArray.length >= n) {
            return byArray;
        }
        return ArrayUtil.setLength(byArray, n);
    }

    public static Object doubleLength(Object object) {
        return ArrayUtil.setLength(object, object == null ? 16 : 2 * Array.getLength(object));
    }

    public static String[] doubleLength(String[] stringArray) {
        return ArrayUtil.setLength(stringArray, stringArray == null ? 16 : 2 * stringArray.length);
    }

    public static float[] doubleLength(float[] fArray) {
        return ArrayUtil.setLength(fArray, fArray == null ? 16 : 2 * fArray.length);
    }

    public static int[] doubleLength(int[] nArray) {
        return ArrayUtil.setLength(nArray, nArray == null ? 16 : 2 * nArray.length);
    }

    public static short[] doubleLength(short[] sArray) {
        return ArrayUtil.setLength(sArray, sArray == null ? 16 : 2 * sArray.length);
    }

    public static byte[] doubleLength(byte[] byArray) {
        return ArrayUtil.setLength(byArray, byArray == null ? 16 : 2 * byArray.length);
    }

    public static boolean[] doubleLength(boolean[] blArray) {
        return ArrayUtil.setLength(blArray, blArray == null ? 16 : 2 * blArray.length);
    }

    public static Object setLength(Object object, int n) {
        if (object == null) {
            return null;
        }
        Object object2 = Array.newInstance(object.getClass().getComponentType(), n);
        int n2 = Array.getLength(object);
        System.arraycopy(object, 0, object2, 0, n2 < n ? n2 : n);
        return object2;
    }

    public static Object deleteElements(Object object, int n, int n2) {
        int n3;
        if (n2 == 0 || object == null) {
            return object;
        }
        int n4 = Array.getLength(object);
        if (n4 - n2 <= 0) {
            return object;
        }
        Object object2 = Array.newInstance(object.getClass().getComponentType(), n4 - n2);
        if (n > 0) {
            System.arraycopy(object, 0, object2, 0, n);
        }
        if ((n3 = n4 - n - n2) > 0) {
            System.arraycopy(object, n + n2, object2, n, n3);
        }
        return object2;
    }

    public static String[] setLength(String[] stringArray, int n) {
        String[] stringArray2 = new String[n];
        if (stringArray != null) {
            int n2 = stringArray.length;
            System.arraycopy(stringArray, 0, stringArray2, 0, n2 < n ? n2 : n);
        }
        return stringArray2;
    }

    public static float[] setLength(float[] fArray, int n) {
        float[] fArray2 = new float[n];
        if (fArray != null) {
            int n2 = fArray.length;
            System.arraycopy(fArray, 0, fArray2, 0, n2 < n ? n2 : n);
        }
        return fArray2;
    }

    public static int[] setLength(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        if (nArray != null) {
            int n2 = nArray.length;
            System.arraycopy(nArray, 0, nArray2, 0, n2 < n ? n2 : n);
        }
        return nArray2;
    }

    public static int[] arrayCopy(int[] nArray, int n, int n2, boolean bl) {
        if (nArray == null) {
            return null;
        }
        int n3 = nArray.length;
        if (n2 == -1) {
            n2 = n3;
        }
        if (n2 == -2) {
            n2 = n3 / 2;
        }
        int[] nArray2 = new int[n2 -= n];
        System.arraycopy(nArray, n, nArray2, 0, n2);
        if (bl) {
            int n4 = n2 / 2;
            while (--n4 >= 0) {
                ArrayUtil.swap(nArray2, n4, n2 - 1 - n4);
            }
        }
        return nArray2;
    }

    public static short[] setLength(short[] sArray, int n) {
        short[] sArray2 = new short[n];
        if (sArray != null) {
            int n2 = sArray.length;
            System.arraycopy(sArray, 0, sArray2, 0, n2 < n ? n2 : n);
        }
        return sArray2;
    }

    public static byte[] setLength(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        if (byArray != null) {
            int n2 = byArray.length;
            System.arraycopy(byArray, 0, byArray2, 0, n2 < n ? n2 : n);
        }
        return byArray2;
    }

    public static boolean[] setLength(boolean[] blArray, int n) {
        boolean[] blArray2 = new boolean[n];
        if (blArray != null) {
            int n2 = blArray.length;
            System.arraycopy(blArray, 0, blArray2, 0, n2 < n ? n2 : n);
        }
        return blArray2;
    }

    public static void swap(short[] sArray, int n, int n2) {
        short s = sArray[n];
        sArray[n] = sArray[n2];
        sArray[n2] = s;
    }

    public static void swap(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }

    public static void swap(float[] fArray, int n, int n2) {
        float f = fArray[n];
        fArray[n] = fArray[n2];
        fArray[n2] = f;
    }

    public static String dumpArray(String string, float[][] fArray, int n, int n2, int n3, int n4) {
        int n5;
        String string2 = "dumpArray: " + string + "\n";
        for (n5 = n; n5 <= n2; ++n5) {
            string2 = string2 + "\t*" + n5 + "*";
        }
        for (n5 = n4; n5 >= n3; --n5) {
            string2 = string2 + "\n*" + n5 + "*";
            for (int i = n; i <= n2; ++i) {
                string2 = string2 + "\t" + (i < fArray.length && n5 < fArray[i].length ? fArray[i][n5] : Float.NaN);
            }
        }
        return string2;
    }

    public static String dumpIntArray(int[] nArray, int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + " " + nArray[i];
        }
        return string;
    }

    public static Object getMinMax(Object object, int n) {
        double d;
        float[] fArray;
        if (object instanceof String[]) {
            fArray = new float[((String[])object).length];
            Parser.parseFloatArray((String[])object, fArray);
        } else {
            fArray = (float[])object;
        }
        switch (n) {
            case 32: {
                d = 3.4028234663852886E38;
                break;
            }
            case 64: {
                d = -3.4028234663852886E38;
                break;
            }
            default: {
                d = 0.0;
            }
        }
        double d2 = 0.0;
        int n2 = 0;
        int n3 = fArray.length;
        while (--n3 >= 0) {
            float f = fArray[n3];
            if (Float.isNaN(f)) continue;
            ++n2;
            switch (n) {
                case 128: 
                case 160: {
                    d2 += (double)f * (double)f;
                }
                case 96: {
                    d += (double)f;
                    break;
                }
                case 32: {
                    if (!((double)f < d)) break;
                    d = f;
                    break;
                }
                case 64: {
                    if (!((double)f > d)) break;
                    d = f;
                }
            }
        }
        if (n2 == 0) {
            return "NaN";
        }
        switch (n) {
            case 96: {
                d /= (double)n2;
                break;
            }
            case 128: {
                if (n2 == 1) {
                    return "NaN";
                }
                d = Math.sqrt((d2 - d * d / (double)n2) / (double)(n2 - 1));
                break;
            }
            case 160: {
                d = d2;
            }
        }
        return new Float(d);
    }

    public static Object sortOrReverse(Object object, int n, boolean bl) {
        float[] fArray = null;
        if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            if (stringArray.length < 2) {
                return object;
            }
            if (bl && !Float.isNaN(Parser.parseFloat(stringArray[0]))) {
                fArray = new float[stringArray.length];
                Parser.parseFloatArray(stringArray, fArray);
            } else {
                Object[] objectArray = new String[stringArray.length];
                System.arraycopy(stringArray, 0, objectArray, 0, stringArray.length);
                switch (n) {
                    case 68157447: {
                        Arrays.sort(objectArray);
                        return objectArray;
                    }
                    case 68157445: {
                        int n2 = 0;
                        for (int i = objectArray.length - 1; n2 < i; ++n2, --i) {
                            Object object2 = objectArray[n2];
                            objectArray[n2] = objectArray[i];
                            objectArray[i] = object2;
                        }
                        return objectArray;
                    }
                }
            }
        } else if (object instanceof float[]) {
            fArray = new float[((float[])object).length];
            System.arraycopy(object, 0, fArray, 0, fArray.length);
            if (fArray.length < 2) {
                return object;
            }
        } else {
            return object;
        }
        switch (n) {
            case 68157447: {
                Arrays.sort(fArray);
                break;
            }
            case 68157445: {
                int n3 = 0;
                for (int i = fArray.length - 1; n3 < i; ++n3, --i) {
                    float f = fArray[n3];
                    fArray[n3] = fArray[i];
                    fArray[i] = f;
                }
                break;
            }
        }
        return fArray;
    }
}

