/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapesurface;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.jvxl.data.JvxlData;
import org.jmol.jvxl.readers.JvxlReader;
import org.jmol.shape.Mesh;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.viewer.Viewer;

public class IsosurfaceMesh
extends Mesh {
    JvxlData jvxlData = new JvxlData();
    int vertexIncrement = 1;
    int firstRealVertex = -1;
    int dataType;
    boolean hasGridPoints;
    Object calculatedArea;
    Object calculatedVolume;
    public boolean isSolvent;
    public float[] vertexValues;
    public short[] vertexColixes;
    Hashtable assocGridPointMap;
    Hashtable assocGridPointNormals;
    public short[] polygonColixes;
    private int lastColor;
    private short lastColix;
    private int iA;
    private int iB;
    private int iC;
    BitSet[] surfaceSet;
    int[] vertexSets;
    int nSets;
    int thisSet = -1;
    Point3f[] centers;
    public static final int CONTOUR_NPOLYGONS = 0;
    public static final int CONTOUR_BITSET = 1;
    public static final int CONTOUR_VALUE = 2;
    public static final int CONTOUR_COLOR = 3;
    public static final int CONTOUR_FDATA = 4;
    public static final int CONTOUR_POINTS = 5;

    IsosurfaceMesh(String string, Graphics3D graphics3D, short s, int n) {
        super(string, graphics3D, s, n);
        this.haveCheckByte = true;
        this.jvxlData.version = Viewer.getJmolVersion();
    }

    void clear(String string, boolean bl) {
        super.clear(string);
        this.nSets = 0;
        this.thisSet = -1;
        this.firstRealVertex = -1;
        this.hasGridPoints = bl;
        this.showPoints = bl;
        this.jvxlData.jvxlSurfaceData = "";
        this.jvxlData.jvxlEdgeData = "";
        this.jvxlData.jvxlColorData = "";
        this.isColorSolid = true;
        this.vertexColixes = null;
        this.vertexValues = null;
        this.polygonColixes = null;
        this.assocGridPointMap = null;
        this.assocGridPointNormals = null;
        this.vertexSets = null;
        this.centers = null;
        this.jvxlData.vContours = null;
        this.surfaceSet = null;
    }

    void allocVertexColixes() {
        if (this.vertexColixes == null) {
            this.vertexColixes = new short[this.vertexCount];
            int n = this.vertexCount;
            while (--n >= 0) {
                this.vertexColixes[n] = this.colix;
            }
        }
        this.isColorSolid = false;
    }

    int addVertexCopy(Point3f point3f, float f, int n, boolean bl) {
        int n2 = this.addVertexCopy(point3f, f);
        switch (n) {
            case -1: {
                if (this.firstRealVertex >= 0) break;
                this.firstRealVertex = n2;
                break;
            }
            case -2: {
                this.hasGridPoints = true;
                break;
            }
            case -3: {
                this.vertexIncrement = 3;
                break;
            }
            default: {
                if (this.firstRealVertex < 0) {
                    this.firstRealVertex = n2;
                }
                if (!bl) break;
                if (this.assocGridPointMap == null) {
                    this.assocGridPointMap = new Hashtable();
                    this.assocGridPointNormals = new Hashtable();
                }
                Integer n3 = new Integer(n);
                this.assocGridPointMap.put(new Integer(n2), n3);
                if (this.assocGridPointNormals.containsKey(n3)) break;
                this.assocGridPointNormals.put(n3, new Vector3f(0.0f, 0.0f, 0.0f));
            }
        }
        return n2;
    }

    int addVertexCopy(Point3f point3f, float f) {
        if (this.vertexCount == 0) {
            this.vertexValues = new float[25];
        } else if (this.vertexCount >= this.vertexValues.length) {
            this.vertexValues = ArrayUtil.doubleLength(this.vertexValues);
        }
        this.vertexValues[this.vertexCount] = f;
        return this.addVertexCopy(point3f);
    }

    public void setTranslucent(boolean bl, float f) {
        super.setTranslucent(bl, f);
        if (this.vertexColixes != null) {
            int n = this.vertexCount;
            while (--n >= 0) {
                this.vertexColixes[n] = Graphics3D.getColixTranslucent(this.vertexColixes[n], bl, f);
            }
        }
    }

    void addTriangleCheck(int n, int n2, int n3, int n4, int n5) {
        if (this.vertices == null || this.vertexValues != null && (Float.isNaN(this.vertexValues[n]) || Float.isNaN(this.vertexValues[n2]) || Float.isNaN(this.vertexValues[n3])) || Float.isNaN(this.vertices[n].x) || Float.isNaN(this.vertices[n2].x) || Float.isNaN(this.vertices[n3].x)) {
            return;
        }
        if (this.polygonCount == 0) {
            this.polygonIndexes = new int[25][];
        } else if (this.polygonCount == this.polygonIndexes.length) {
            this.polygonIndexes = (int[][])ArrayUtil.doubleLength(this.polygonIndexes);
        }
        if (n5 != 0) {
            short s;
            if (this.polygonColixes == null) {
                this.polygonColixes = new short[25];
                this.lastColor = 0;
            } else if (this.polygonCount == this.polygonColixes.length) {
                this.polygonColixes = ArrayUtil.doubleLength(this.polygonColixes);
            }
            if (n5 == this.lastColor) {
                s = this.lastColix;
            } else {
                this.lastColor = n5;
                s = this.lastColix = Graphics3D.getColix(this.lastColor);
            }
            this.polygonColixes[this.polygonCount] = s;
        }
        this.polygonIndexes[this.polygonCount++] = new int[]{n, n2, n3, n4};
    }

    void invalidateTriangles() {
        int n = this.polygonCount;
        while (--n >= 0) {
            if (this.setABC(n)) continue;
            this.polygonIndexes[n] = null;
        }
    }

    private boolean setABC(int n) {
        int[] nArray = this.polygonIndexes[n];
        return nArray != null && !Float.isNaN(this.vertexValues[this.iA = nArray[0]]) && !Float.isNaN(this.vertexValues[this.iB = nArray[1]]) && !Float.isNaN(this.vertexValues[this.iC = nArray[2]]);
    }

    Object calculateArea() {
        if (this.calculatedArea != null) {
            return this.calculatedArea;
        }
        boolean bl = this.nSets == 0 || this.thisSet >= 0;
        int n = bl ? 1 : this.nSets;
        double[] dArray = new double[n];
        int n2 = this.polygonCount;
        while (--n2 >= 0) {
            int n3;
            if (!this.setABC(n2)) continue;
            int n4 = n3 = this.nSets == 0 ? 0 : this.vertexSets[this.iA];
            if (this.thisSet >= 0 && n3 != this.thisSet) continue;
            this.vAB.sub(this.vertices[this.iB], this.vertices[this.iA]);
            this.vAC.sub(this.vertices[this.iC], this.vertices[this.iA]);
            this.vTemp.cross(this.vAB, this.vAC);
            int n5 = bl ? 0 : n3;
            dArray[n5] = dArray[n5] + (double)this.vTemp.length();
        }
        n2 = 0;
        while (n2 < n) {
            int n6 = n2++;
            dArray[n6] = dArray[n6] / 2.0;
        }
        if (bl) {
            this.calculatedArea = new Float(dArray[0]);
            return this.calculatedArea;
        }
        this.calculatedArea = dArray;
        return dArray;
    }

    Object calculateVolume() {
        if (this.calculatedVolume != null) {
            return this.calculatedVolume;
        }
        boolean bl = this.nSets == 0 || this.thisSet >= 0;
        int n = bl ? 1 : this.nSets;
        double[] dArray = new double[n];
        int n2 = this.polygonCount;
        while (--n2 >= 0) {
            int n3;
            if (!this.setABC(n2)) continue;
            int n4 = n3 = this.nSets == 0 ? 0 : this.vertexSets[this.iA];
            if (this.thisSet >= 0 && n3 != this.thisSet) continue;
            this.vAB.set(this.vertices[this.iB]);
            this.vAC.set(this.vertices[this.iC]);
            this.vTemp.cross(this.vAB, this.vAC);
            this.vAC.set(this.vertices[this.iA]);
            int n5 = bl ? 0 : n3;
            dArray[n5] = dArray[n5] + (double)this.vAC.dot(this.vTemp);
        }
        n2 = 0;
        while (n2 < n) {
            int n6 = n2++;
            dArray[n6] = dArray[n6] / 6.0;
        }
        if (bl) {
            this.calculatedVolume = new Float(dArray[0]);
            return this.calculatedVolume;
        }
        this.calculatedVolume = dArray;
        return dArray;
    }

    public void sumVertexNormals(Vector3f[] vector3fArray) {
        super.sumVertexNormals(vector3fArray);
        if (this.assocGridPointMap != null) {
            Integer n;
            Enumeration enumeration = this.assocGridPointMap.keys();
            while (enumeration.hasMoreElements()) {
                n = (Integer)enumeration.nextElement();
                ((Vector3f)this.assocGridPointNormals.get(this.assocGridPointMap.get(n))).add(vector3fArray[n]);
            }
            enumeration = this.assocGridPointMap.keys();
            while (enumeration.hasMoreElements()) {
                n = (Integer)enumeration.nextElement();
                vector3fArray[n.intValue()] = (Vector3f)this.assocGridPointNormals.get(this.assocGridPointMap.get(n));
            }
        }
    }

    Point3f[] getCenters() {
        if (this.centers != null) {
            return this.centers;
        }
        this.centers = new Point3f[this.polygonCount];
        for (int i = 0; i < this.polygonCount; ++i) {
            Point3f point3f = this.centers[i] = new Point3f();
            point3f.add(this.vertices[this.polygonIndexes[i][0]]);
            point3f.add(this.vertices[this.polygonIndexes[i][1]]);
            point3f.add(this.vertices[this.polygonIndexes[i][2]]);
            point3f.scale(0.33333334f);
        }
        return this.centers;
    }

    Point4f getFacePlane(int n, Vector3f vector3f) {
        return Measure.getPlaneThroughPoints(this.vertices[this.polygonIndexes[n][0]], this.vertices[this.polygonIndexes[n][1]], this.vertices[this.polygonIndexes[n][2]], vector3f, this.vAB, this.vAC);
    }

    Vector[] getContours() {
        Vector[] vectorArray;
        int n = this.jvxlData.nContours;
        if (n == 0 || this.polygonIndexes == null) {
            return null;
        }
        this.havePlanarContours = this.jvxlData.jvxlPlane != null;
        if (this.havePlanarContours) {
            return null;
        }
        if (n < 0) {
            n = -1 - n;
        }
        if ((vectorArray = this.jvxlData.vContours) != null) {
            for (int i = 0; i < n; ++i) {
                if (vectorArray[i].size() > 5) {
                    return this.jvxlData.vContours;
                }
                JvxlReader.set3dContourVector(vectorArray[i], this.polygonIndexes, this.vertices);
            }
            this.dumpData();
            return this.jvxlData.vContours;
        }
        this.dumpData();
        vectorArray = new Vector[n];
        for (int i = 0; i < n; ++i) {
            vectorArray[i] = new Vector();
        }
        float f = (this.jvxlData.valueMappedToBlue - this.jvxlData.valueMappedToRed) / (float)(n + 1);
        for (int i = 0; i < n; ++i) {
            float f2 = this.jvxlData.valueMappedToRed + (float)(i + 1) * f;
            this.get3dContour(vectorArray[i], f2, this.jvxlData.contourColors[i]);
        }
        Logger.info(n + " contour lines; separation = " + f);
        this.jvxlData.vContours = vectorArray;
        return vectorArray;
    }

    public static void setContourVector(Vector vector, int n, BitSet bitSet, float f, int n2, StringBuffer stringBuffer) {
        vector.add(new Integer(n));
        vector.add(bitSet);
        vector.add(new Float(f));
        vector.add(new int[]{n2});
        vector.add(stringBuffer);
    }

    private void get3dContour(Vector vector, float f, int n) {
        BitSet bitSet = new BitSet(this.polygonCount);
        StringBuffer stringBuffer = new StringBuffer();
        IsosurfaceMesh.setContourVector(vector, this.polygonCount, bitSet, f, n, stringBuffer);
        block4: for (int i = 0; i < this.polygonCount; ++i) {
            float f2;
            if (!this.setABC(i)) continue;
            int n2 = 0;
            float f3 = this.checkPt(this.iA, this.iB, f);
            if (!Float.isNaN(f3)) {
                n2 |= 1;
                vector.add(IsosurfaceMesh.getContourPoint(this.vertices, this.iA, this.iB, f3));
            }
            if (!Float.isNaN(f2 = this.checkPt(this.iB, this.iC, f))) {
                if (n2 == 0) {
                    f3 = f2;
                }
                n2 |= 2;
                vector.add(IsosurfaceMesh.getContourPoint(this.vertices, this.iB, this.iC, f2));
            }
            switch (n2) {
                case 0: {
                    continue block4;
                }
                case 3: {
                    break;
                }
                default: {
                    f2 = this.checkPt(this.iC, this.iA, f);
                    n2 |= 4;
                    vector.add(IsosurfaceMesh.getContourPoint(this.vertices, this.iC, this.iA, f2));
                }
            }
            bitSet.set(i);
            stringBuffer.append(n2);
            stringBuffer.append(JvxlReader.jvxlFractionAsCharacter(f3));
            stringBuffer.append(JvxlReader.jvxlFractionAsCharacter(f2));
        }
        vector.add(new Point3f(Float.NaN, Float.NaN, Float.NaN));
    }

    private float checkPt(int n, int n2, float f) {
        float f2;
        float f3;
        float f4 = this.vertexValues[n];
        float f5 = this.vertexValues[n2];
        return f3 <= f == f < f2 ? (f - f4) / (f5 - f4) : Float.NaN;
    }

    public static Point3f getContourPoint(Point3f[] point3fArray, int n, int n2, float f) {
        Point3f point3f = new Point3f();
        point3f.set(point3fArray[n2]);
        point3f.sub(point3fArray[n]);
        point3f.scale(f);
        point3f.add(point3fArray[n]);
        return point3f;
    }

    private void dumpData() {
    }
}

