/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapesurface;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.jvxl.api.MeshDataServer;
import org.jmol.jvxl.data.JvxlData;
import org.jmol.jvxl.data.MeshData;
import org.jmol.jvxl.readers.JvxlReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.shape.Mesh;
import org.jmol.shape.MeshCollection;
import org.jmol.shapesurface.IsosurfaceMesh;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.util.Parser;
import org.jmol.util.Point3fi;
import org.jmol.util.TextFormat;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.Viewer;

public class Isosurface
extends MeshCollection
implements MeshDataServer {
    private IsosurfaceMesh[] isomeshes = new IsosurfaceMesh[4];
    private IsosurfaceMesh thisMesh;
    private int lighting;
    private boolean iHaveBitSets;
    private boolean explicitContours;
    private int atomIndex;
    private int moNumber;
    private short defaultColix;
    private Point3f center;
    private boolean isPhaseColored;
    private boolean isColorExplicit;
    protected SurfaceGenerator sg;
    private JvxlData jvxlData;
    private ColorEncoder colorEncoder = new ColorEncoder();
    private int indexColorPositive;
    private int indexColorNegative;
    private int nLCAO = 0;
    private Point4f lcaoDir = new Point4f();
    private boolean associateNormals;
    private static final int MAX_OBJECT_CLICK_DISTANCE_SQUARED = 100;
    private final Point3i ptXY = new Point3i();

    public void allocMesh(String string) {
        int n = this.meshCount++;
        this.isomeshes = (IsosurfaceMesh[])ArrayUtil.ensureLength(this.isomeshes, this.meshCount * 2);
        this.meshes = this.isomeshes;
        this.thisMesh = this.isomeshes[n] = new IsosurfaceMesh(string, this.g3d, this.colix, n);
        this.currentMesh = this.isomeshes[n];
        this.jvxlData = this.thisMesh.jvxlData;
        this.sg.setJvxlData(this.jvxlData);
    }

    public void initShape() {
        super.initShape();
        this.myType = "isosurface";
        this.newSg();
    }

    private void newSg() {
        this.jvxlData = new JvxlData();
        this.sg = new SurfaceGenerator(this.viewer, this, this.colorEncoder, null, this.jvxlData);
        this.sg.setVersion("Jmol " + Viewer.getJmolVersion());
    }

    protected void clearSg() {
        this.sg = null;
    }

    public void setProperty(String string, Object object, BitSet bitSet) {
        if (Logger.debugging) {
            Logger.debug("Isosurface setProperty: " + string + " = " + object);
        }
        if ("navigate" == string) {
            this.navigate((Integer)object);
            return;
        }
        if ("delete" == string) {
            this.setPropertySuper(string, object, bitSet);
            if (!this.explicitID) {
                this.nUnnamed = 0;
                this.nLCAO = 0;
            }
            return;
        }
        if ("remapcolor" == string) {
            if (this.thisMesh != null) {
                this.remapColors();
            }
            return;
        }
        if ("thisID" == string) {
            this.setPropertySuper("thisID", object, null);
            return;
        }
        if ("map" == string) {
            this.setProperty("squareData", Boolean.FALSE, null);
            return;
        }
        if ("color" == string) {
            if (this.thisMesh != null) {
                this.thisMesh.isColorSolid = true;
                this.thisMesh.polygonColixes = null;
            } else if (!TextFormat.isWild(this.previousMeshID)) {
                int n = this.meshCount;
                while (--n >= 0) {
                    this.isomeshes[n].isColorSolid = true;
                    this.isomeshes[n].polygonColixes = null;
                }
            }
            this.setPropertySuper(string, object, bitSet);
            return;
        }
        if ("fixed" == string) {
            this.isFixed = (Boolean)object;
            this.setModelIndex();
            return;
        }
        if ("modelIndex" == string) {
            if (!this.iHaveModelIndex) {
                this.modelIndex = (Integer)object;
                this.sg.setModelIndex(Math.abs(this.modelIndex));
                this.isFixed = this.modelIndex < 0;
            }
            this.isFixed = this.modelIndex < 0;
            return;
        }
        if ("lcaoCartoon" == string || "lonePair" == string || "radical" == string) {
            Vector3f[] vector3fArray = (Vector3f[])object;
            if (!this.explicitID) {
                this.setPropertySuper("thisID", null, null);
            }
            if (!this.sg.setParameter("lcaoCartoonCenter", vector3fArray[2])) {
                this.drawLcaoCartoon(vector3fArray[0], vector3fArray[1], vector3fArray[3], "lonePair" == string ? 2 : ("radical" == string ? 1 : 0));
            }
            return;
        }
        if ("title" == string) {
            if (object instanceof String && "-".equals((String)object)) {
                object = null;
            }
            this.setPropertySuper(string, object, bitSet);
            this.sg.setParameter("title", this.title, bitSet);
            return;
        }
        if ("select" == string && this.iHaveBitSets) {
            return;
        }
        if ("ignore" == string && this.iHaveBitSets) {
            return;
        }
        if ("getSurfaceSets" == string && this.thisMesh != null) {
            this.thisMesh.thisSet = (Integer)object;
        }
        if ("contour" == string) {
            this.explicitContours = true;
        }
        if ("atomIndex" == string) {
            this.atomIndex = (Integer)object;
        }
        if ("pocket" == string) {
            Boolean bl = (Boolean)object;
            int n = this.lighting = bl != false ? 1073741845 : 1073741843;
        }
        if ("colorRGB" == string) {
            int n = (Integer)object;
            this.defaultColix = Graphics3D.getColix(n);
        }
        if ("molecularOrbital" == string) {
            this.moNumber = (Integer)object;
            if (!this.isColorExplicit) {
                this.isPhaseColored = true;
            }
        }
        if (string == "functionXY" && this.sg.isStateDataRead()) {
            this.setScriptInfo();
        }
        if ("center" == string) {
            this.center.set((Point3f)object);
        }
        if ("phase" == string) {
            this.isPhaseColored = true;
        }
        if ("plane" == string) {
            this.allowContourLines = false;
        }
        if ("functionXY" == string) {
            this.allowContourLines = false;
        }
        if ("finalize" == string) {
            this.setScriptInfo();
            this.setJvxlInfo();
            this.clearSg();
            return;
        }
        if ("init" == string) {
            this.newSg();
        }
        if (this.sg != null && this.sg.setParameter(string, object, bitSet)) {
            return;
        }
        if ("init" == string) {
            this.setPropertySuper("thisID", "+PREVIOUS_MESH+", null);
            if (object instanceof String && !(this.iHaveBitSets = this.getScriptBitSets((String)object, null))) {
                this.sg.setParameter("select", bitSet);
            }
            this.initializeIsosurface();
            this.sg.setModelIndex(this.modelIndex);
            return;
        }
        if ("clear" == string) {
            this.discardTempData(true);
            return;
        }
        if (string == "deleteModelAtoms") {
            int n = ((int[])((Object[])object)[2])[0];
            BitSet bitSet2 = new BitSet();
            bitSet2.set(n);
            int n2 = ((int[])((Object[])object)[2])[1];
            int n3 = ((int[])((Object[])object)[2])[2];
            int n4 = this.meshCount;
            while (--n4 >= 0) {
                Mesh mesh = this.meshes[n4];
                if (mesh == null) continue;
                if (mesh.modelIndex == n) {
                    --this.meshCount;
                    if (mesh == this.currentMesh) {
                        this.thisMesh = null;
                        this.currentMesh = null;
                    }
                    this.isomeshes = (IsosurfaceMesh[])ArrayUtil.deleteElements(this.meshes, n4, 1);
                    this.meshes = this.isomeshes;
                    continue;
                }
                if (mesh.modelIndex <= n) continue;
                --mesh.modelIndex;
                if (mesh.atomIndex >= n2) {
                    mesh.atomIndex -= n3;
                }
                if (mesh.bitsets == null) continue;
                BitSetUtil.deleteBits(mesh.bitsets[0], bitSet);
                BitSetUtil.deleteBits(mesh.bitsets[1], bitSet);
                BitSetUtil.deleteBits(mesh.bitsets[2], bitSet2);
            }
            return;
        }
        this.setPropertySuper(string, object, bitSet);
    }

    private void setPropertySuper(String string, Object object, BitSet bitSet) {
        if (string == "thisID" && this.currentMesh != null && this.currentMesh.thisID.equals((String)object)) {
            this.checkExplicit((String)object);
            return;
        }
        this.currentMesh = this.thisMesh;
        super.setProperty(string, object, bitSet);
        this.thisMesh = (IsosurfaceMesh)this.currentMesh;
        JvxlData jvxlData = this.jvxlData = this.thisMesh == null ? null : this.thisMesh.jvxlData;
        if (this.sg != null) {
            this.sg.setJvxlData(this.jvxlData);
        }
    }

    public Object getProperty(String string, int n) {
        Object object = super.getProperty(string, n);
        if (object != null) {
            return object;
        }
        if (string == "dataRange") {
            float[] fArray;
            if (this.thisMesh == null) {
                fArray = null;
            } else {
                float[] fArray2 = new float[4];
                fArray2[0] = this.jvxlData.mappedDataMin;
                fArray2[1] = this.jvxlData.mappedDataMax;
                fArray2[2] = this.jvxlData.valueMappedToRed;
                fArray = fArray2;
                fArray2[3] = this.jvxlData.valueMappedToBlue;
            }
            return fArray;
        }
        if (string == "moNumber") {
            return new Integer(this.moNumber);
        }
        if (string == "area") {
            return this.thisMesh == null ? new Float(Float.NaN) : this.thisMesh.calculateArea();
        }
        if (string == "volume") {
            return this.thisMesh == null ? new Float(Float.NaN) : this.thisMesh.calculateVolume();
        }
        if (this.thisMesh == null) {
            return "no current isosurface";
        }
        if (string == "cutoff") {
            return new Float(this.jvxlData.cutoff);
        }
        if (string == "plane") {
            return this.jvxlData.jvxlPlane;
        }
        if (string == "jvxlFileData") {
            MeshData meshData = null;
            if (this.jvxlData.vertexDataOnly) {
                meshData = new MeshData();
                this.fillMeshData(meshData, 1);
            }
            return JvxlReader.jvxlGetFile(this, this.jvxlData, meshData, this.title, "", true, n, this.thisMesh.getState(this.myType), this.thisMesh.scriptCommand == null ? "" : this.thisMesh.scriptCommand);
        }
        if (string == "jvxlFileHeader") {
            return JvxlReader.jvxlGetFile(this, this.jvxlData, null, this.title, "HEADERONLY", true, n, this.thisMesh.getState(this.myType), this.thisMesh.scriptCommand == null ? "" : this.thisMesh.scriptCommand);
        }
        if (string == "jvxlSurfaceData") {
            return JvxlReader.jvxlGetFile(this, this.jvxlData, null, this.title, "orbital #" + n, false, 1, this.thisMesh.getState(this.myType), this.thisMesh.scriptCommand == null ? "" : this.thisMesh.scriptCommand);
        }
        if (string == "jvxlFileInfo") {
            return this.jvxlData.jvxlInfoLine;
        }
        return super.getProperty(string, n);
    }

    protected void getColorState(StringBuffer stringBuffer, Mesh mesh) {
        boolean bl;
        boolean bl2 = bl = mesh.isColorSolid && ((IsosurfaceMesh)mesh).polygonColixes != null;
        if (mesh.isColorSolid && !bl) {
            Isosurface.appendCmd(stringBuffer, this.getColorCommand(this.myType, mesh.colix));
        }
    }

    private boolean getScriptBitSets(String string, BitSet[] bitSetArray) {
        this.script = string;
        this.getModelIndex(string);
        if (string == null) {
            return false;
        }
        int n = string.indexOf("# ({");
        if (n < 0) {
            return false;
        }
        int n2 = string.indexOf("})", n);
        if (n2 < 0) {
            return false;
        }
        BitSet bitSet = Escape.unescapeBitset(string.substring(n + 3, n2 + 1));
        if (bitSetArray == null) {
            this.sg.setParameter("select", bitSet);
        } else {
            bitSetArray[0] = bitSet;
        }
        n = string.indexOf("({", n2);
        if (n < 0) {
            return true;
        }
        n2 = string.indexOf("})", n);
        if (n2 < 0) {
            return false;
        }
        bitSet = Escape.unescapeBitset(string.substring(n + 1, n2 + 1));
        if (bitSetArray == null) {
            this.sg.setParameter("ignore", bitSet);
        } else {
            bitSetArray[1] = bitSet;
        }
        n = string.indexOf("/({", n2);
        if (n == n2 + 2) {
            n2 = string.indexOf("})", n);
            if (n2 < 0) {
                return false;
            }
            bitSet = Escape.unescapeBitset(string.substring(n + 3, n2 + 1));
            if (bitSetArray == null) {
                this.viewer.setTrajectory(bitSet);
            } else {
                bitSetArray[2] = bitSet;
            }
        }
        return true;
    }

    private void initializeIsosurface() {
        this.lighting = 1073741843;
        if (!this.iHaveModelIndex) {
            this.modelIndex = this.viewer.getCurrentModelIndex();
        }
        boolean bl = this.isFixed = this.modelIndex < 0;
        if (this.modelIndex < 0) {
            this.modelIndex = 0;
        }
        this.title = null;
        this.explicitContours = false;
        this.atomIndex = -1;
        this.colix = (short)5;
        this.defaultColix = 0;
        this.isColorExplicit = false;
        this.isPhaseColored = false;
        this.allowContourLines = true;
        this.center = new Point3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        this.linkedMesh = null;
        this.initState();
    }

    private void initState() {
        this.associateNormals = true;
        this.sg.initState();
    }

    private void discardTempData(boolean bl) {
        if (!bl) {
            return;
        }
        this.title = null;
        if (this.thisMesh == null) {
            return;
        }
        this.thisMesh.surfaceSet = null;
    }

    private short getDefaultColix() {
        int n;
        if (this.defaultColix != 0) {
            return this.defaultColix;
        }
        if (!this.sg.isCubeData()) {
            return this.colix;
        }
        if (this.sg.getCutoff() >= 0.0f) {
            this.indexColorPositive %= JmolConstants.argbsIsosurfacePositive.length;
            n = JmolConstants.argbsIsosurfacePositive[this.indexColorPositive++];
        } else {
            this.indexColorNegative %= JmolConstants.argbsIsosurfaceNegative.length;
            n = JmolConstants.argbsIsosurfaceNegative[this.indexColorNegative++];
        }
        return Graphics3D.getColix(n);
    }

    private void drawLcaoCartoon(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, int n) {
        Object object;
        Object object2;
        boolean bl;
        String string = this.sg.setLcao();
        float f = vector3f3.x + vector3f3.y + vector3f3.z;
        this.defaultColix = Graphics3D.getColix(this.sg.getColor(1));
        int n2 = this.sg.getColor(-1);
        Vector3f vector3f4 = new Vector3f();
        boolean bl2 = bl = string.length() > 0 && string.charAt(0) == '-';
        if (bl) {
            string = string.substring(1);
        }
        int n3 = bl ? -1 : 1;
        vector3f4.cross(vector3f, vector3f2);
        if (f != 0.0f) {
            object2 = new AxisAngle4f();
            if (vector3f3.x != 0.0f) {
                ((AxisAngle4f)object2).set(vector3f2, f);
            } else if (vector3f3.y != 0.0f) {
                ((AxisAngle4f)object2).set(vector3f4, f);
            } else {
                ((AxisAngle4f)object2).set(vector3f, f);
            }
            object = new Matrix3f();
            ((Matrix3f)object).set((AxisAngle4f)object2);
            ((Matrix3f)object).transform(vector3f2);
            ((Matrix3f)object).transform(vector3f4);
            ((Matrix3f)object).transform(vector3f);
        }
        if (this.thisMesh == null && this.nLCAO == 0) {
            this.nLCAO = this.meshCount;
        }
        Object object3 = this.thisMesh == null ? (n > 0 ? "lp" : "lcao") + ++this.nLCAO + "_" + string : (object2 = this.thisMesh.thisID);
        if (this.thisMesh == null) {
            this.allocMesh((String)object2);
        }
        if (string.equals("px")) {
            this.thisMesh.thisID = this.thisMesh.thisID + "a";
            object = this.thisMesh;
            this.createLcaoLobe(vector3f2, n3, n);
            if (n > 0) {
                return;
            }
            this.setProperty("thisID", (String)object2 + "b", null);
            this.createLcaoLobe(vector3f2, -n3, n);
            this.thisMesh.colix = Graphics3D.getColix(n2);
            this.linkedMesh = this.thisMesh.linkedMesh = object;
            return;
        }
        if (string.equals("py")) {
            this.thisMesh.thisID = this.thisMesh.thisID + "a";
            object = this.thisMesh;
            this.createLcaoLobe(vector3f4, n3, n);
            if (n > 0) {
                return;
            }
            this.setProperty("thisID", (String)object2 + "b", null);
            this.createLcaoLobe(vector3f4, -n3, n);
            this.thisMesh.colix = Graphics3D.getColix(n2);
            this.linkedMesh = this.thisMesh.linkedMesh = object;
            return;
        }
        if (string.equals("pz")) {
            this.thisMesh.thisID = this.thisMesh.thisID + "a";
            object = this.thisMesh;
            this.createLcaoLobe(vector3f, n3, n);
            if (n > 0) {
                return;
            }
            this.setProperty("thisID", (String)object2 + "b", null);
            this.createLcaoLobe(vector3f, -n3, n);
            this.thisMesh.colix = Graphics3D.getColix(n2);
            this.linkedMesh = this.thisMesh.linkedMesh = object;
            return;
        }
        if (string.equals("pxa")) {
            this.createLcaoLobe(vector3f2, n3, n);
            return;
        }
        if (string.equals("pxb")) {
            this.createLcaoLobe(vector3f2, -n3, n);
            return;
        }
        if (string.equals("pya")) {
            this.createLcaoLobe(vector3f4, n3, n);
            return;
        }
        if (string.equals("pyb")) {
            this.createLcaoLobe(vector3f4, -n3, n);
            return;
        }
        if (string.equals("pza")) {
            this.createLcaoLobe(vector3f, n3, n);
            return;
        }
        if (string.equals("pzb")) {
            this.createLcaoLobe(vector3f, -n3, n);
            return;
        }
        if (string.indexOf("sp") == 0 || string.indexOf("lp") == 0) {
            this.createLcaoLobe(vector3f, n3, n);
            return;
        }
        this.createLcaoLobe(null, 1.0f, n);
    }

    private void createLcaoLobe(Vector3f vector3f, float f, int n) {
        this.initState();
        if (Logger.debugging) {
            Logger.debug("creating isosurface ID " + this.thisMesh.thisID);
        }
        this.thisMesh.colix = this.defaultColix;
        if (vector3f == null) {
            this.setProperty("sphere", new Float(f / 2.0f), null);
        } else {
            this.lcaoDir.x = vector3f.x * f;
            this.lcaoDir.y = vector3f.y * f;
            this.lcaoDir.z = vector3f.z * f;
            this.lcaoDir.w = 0.7f;
            this.setProperty(n == 2 ? "lp" : (n == 1 ? "rad" : "lobe"), this.lcaoDir, null);
        }
        this.setScriptInfo();
    }

    public void invalidateTriangles() {
        this.thisMesh.invalidateTriangles();
    }

    public void fillMeshData(MeshData meshData, int n) {
        if (meshData == null) {
            if (this.thisMesh == null) {
                this.allocMesh(null);
            }
            this.thisMesh.clear("isosurface", this.sg.getIAddGridPoints());
            this.thisMesh.colix = this.getDefaultColix();
            if (this.isPhaseColored || this.thisMesh.jvxlData.isBicolorMap) {
                this.thisMesh.isColorSolid = false;
            }
            return;
        }
        switch (n) {
            case 1: {
                meshData.vertices = this.thisMesh.vertices;
                meshData.vertexValues = this.thisMesh.vertexValues;
                meshData.vertexCount = this.thisMesh.vertexCount;
                meshData.vertexIncrement = this.thisMesh.vertexIncrement;
                meshData.polygonCount = this.thisMesh.polygonCount;
                meshData.polygonIndexes = this.thisMesh.polygonIndexes;
                meshData.polygonColixes = this.thisMesh.polygonColixes;
                return;
            }
            case 2: {
                if (this.thisMesh.vertexColixes == null || this.thisMesh.vertexCount > this.thisMesh.vertexColixes.length) {
                    this.thisMesh.vertexColixes = new short[this.thisMesh.vertexCount];
                }
                meshData.vertexColixes = this.thisMesh.vertexColixes;
                meshData.polygonIndexes = null;
                return;
            }
            case 3: {
                this.thisMesh.surfaceSet = meshData.surfaceSet;
                this.thisMesh.vertexSets = meshData.vertexSets;
                this.thisMesh.nSets = meshData.nSets;
                return;
            }
            case 4: {
                this.thisMesh.vertices = meshData.vertices;
                this.thisMesh.vertexValues = meshData.vertexValues;
                this.thisMesh.vertexCount = meshData.vertexCount;
                this.thisMesh.vertexIncrement = meshData.vertexIncrement;
                this.thisMesh.polygonCount = meshData.polygonCount;
                this.thisMesh.polygonIndexes = meshData.polygonIndexes;
                this.thisMesh.polygonColixes = meshData.polygonColixes;
                return;
            }
        }
    }

    public void notifySurfaceGenerationCompleted() {
        this.setModelIndex();
        this.thisMesh.insideOut = this.sg.isInsideOut();
        this.thisMesh.calculatedArea = null;
        this.thisMesh.calculatedVolume = null;
        this.thisMesh.initialize(this.sg.getPlane() != null ? 1073741845 : this.lighting);
        if (this.thisMesh.jvxlData.jvxlPlane != null) {
            this.allowContourLines = false;
        }
        this.thisMesh.isSolvent = (this.sg.getDataType() & 0x80) != 0;
    }

    public void notifySurfaceMappingCompleted() {
        this.setModelIndex();
        String string = this.colorEncoder.getColorSchemeName();
        this.viewer.setPropertyColorScheme(string, false);
        this.viewer.setCurrentColorRange(this.jvxlData.valueMappedToRed, this.jvxlData.valueMappedToBlue);
        this.thisMesh.isColorSolid = false;
        this.thisMesh.getContours();
        if (this.thisMesh.jvxlData.jvxlPlane != null) {
            this.allowContourLines = false;
        }
        if (this.thisMesh.jvxlData.nContours != 0 && this.thisMesh.jvxlData.nContours != -1) {
            this.thisMesh.havePlanarContours = true;
            this.explicitContours = true;
        }
        this.setPropertySuper("token", new Integer(this.explicitContours ? 0x40000020 : 0x40000010), null);
        this.setPropertySuper("token", new Integer(this.explicitContours ? 0x40000070 : 1073741954), null);
        this.thisMesh.colorCommand = "color $" + this.thisMesh.thisID + " " + this.getUserColorScheme(string) + " range " + (this.jvxlData.isColorReversed ? this.jvxlData.valueMappedToBlue + " " + this.jvxlData.valueMappedToRed : this.jvxlData.valueMappedToRed + " " + this.jvxlData.valueMappedToBlue);
    }

    public Point3f[] calculateGeodesicSurface(BitSet bitSet, float f) {
        return this.viewer.calculateSurface(bitSet, f);
    }

    public int getSurfacePointIndexAndFraction(float f, boolean bl, int n, int n2, int n3, Point3i point3i, int n4, int n5, float f2, float f3, Point3f point3f, Vector3f vector3f, boolean bl2, float[] fArray) {
        return 0;
    }

    public int addVertexCopy(Point3f point3f, float f, int n) {
        return this.thisMesh.addVertexCopy(point3f, f, n, this.associateNormals);
    }

    public void addTriangleCheck(int n, int n2, int n3, int n4, boolean bl, int n5) {
        if (bl && !MeshData.checkCutoff(n, n2, n3, this.thisMesh.vertexValues)) {
            return;
        }
        this.thisMesh.addTriangleCheck(n, n2, n3, n4, n5);
    }

    private void setModelIndex() {
        this.setModelIndex(this.atomIndex, this.modelIndex);
        this.thisMesh.ptCenter.set(this.center);
    }

    protected void setScriptInfo() {
        int n;
        this.thisMesh.title = this.sg.getTitle();
        String string = this.sg.getScript();
        this.thisMesh.dataType = this.sg.getParams().dataType;
        this.thisMesh.bitsets = null;
        if (string != null) {
            if (string.charAt(0) == ' ') {
                string = this.myType + " ID " + Escape.escape(this.thisMesh.thisID) + string;
            } else if (this.sg.getIUseBitSets()) {
                this.thisMesh.bitsets = new BitSet[3];
                this.thisMesh.bitsets[0] = this.sg.getBsSelected();
                this.thisMesh.bitsets[1] = this.sg.getBsIgnore();
                this.thisMesh.bitsets[2] = this.viewer.getBitSetTrajectories();
            }
        }
        if (!this.explicitID && string != null && (n = string.indexOf("# ID=")) >= 0) {
            this.thisMesh.thisID = Parser.getNextQuotedString(string, n);
        }
        this.thisMesh.scriptCommand = string;
        Vector vector = this.sg.getFunctionXYinfo();
        if (this.thisMesh.data1 == null) {
            this.thisMesh.data1 = vector;
        } else {
            this.thisMesh.data2 = vector;
        }
    }

    private void setJvxlInfo() {
        if (this.sg.getJvxlData() != this.jvxlData || this.sg.getJvxlData() != this.thisMesh.jvxlData) {
            this.jvxlData = this.thisMesh.jvxlData = this.sg.getJvxlData();
        }
        this.jvxlData.jvxlDefinitionLine = JvxlReader.jvxlGetDefinitionLine(this.jvxlData, false);
        this.jvxlData.jvxlInfoLine = JvxlReader.jvxlGetDefinitionLine(this.jvxlData, true);
    }

    public Vector getShapeDetail() {
        Vector vector = new Vector();
        for (int i = 0; i < this.meshCount; ++i) {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            IsosurfaceMesh isosurfaceMesh = this.isomeshes[i];
            if (isosurfaceMesh == null) continue;
            hashtable.put("ID", isosurfaceMesh.thisID == null ? "<noid>" : isosurfaceMesh.thisID);
            hashtable.put("vertexCount", new Integer(isosurfaceMesh.vertexCount));
            if (isosurfaceMesh.ptCenter.x != Float.MAX_VALUE) {
                hashtable.put("center", isosurfaceMesh.ptCenter);
            }
            if (isosurfaceMesh.jvxlData.jvxlDefinitionLine != null) {
                hashtable.put("jvxlDefinitionLine", isosurfaceMesh.jvxlData.jvxlDefinitionLine);
            }
            hashtable.put("modelIndex", new Integer(isosurfaceMesh.modelIndex));
            if (isosurfaceMesh.title != null) {
                hashtable.put("title", isosurfaceMesh.title);
            }
            vector.addElement(hashtable);
        }
        return vector;
    }

    protected void remapColors() {
        JvxlData jvxlData = this.thisMesh.jvxlData;
        float[] fArray = this.thisMesh.vertexValues;
        short[] sArray = this.thisMesh.vertexColixes;
        this.thisMesh.polygonColixes = null;
        if (fArray == null || jvxlData.isBicolorMap || jvxlData.vertexCount == 0) {
            return;
        }
        if (sArray == null) {
            sArray = this.thisMesh.vertexColixes = new short[this.thisMesh.vertexCount];
        }
        boolean bl = Graphics3D.isColixTranslucent(this.thisMesh.colix);
        int n = this.thisMesh.vertexCount;
        while (--n >= 0) {
            sArray[n] = this.viewer.getColixForPropertyValue(fArray[n]);
            if (!bl) continue;
            sArray[n] = Graphics3D.getColixTranslucent(sArray[n], true, this.translucentLevel);
        }
        Vector[] vectorArray = this.thisMesh.getContours();
        if (vectorArray != null) {
            int n2 = vectorArray.length;
            while (--n2 >= 0) {
                float f = ((Float)vectorArray[n2].get(2)).floatValue();
                int[] nArray = (int[])vectorArray[n2].get(3);
                nArray[0] = this.viewer.getColixArgb(this.viewer.getColixForPropertyValue(f));
            }
        }
        float[] fArray2 = this.viewer.getCurrentColorRange();
        jvxlData.valueMappedToRed = Math.min(fArray2[0], fArray2[1]);
        jvxlData.valueMappedToBlue = Math.max(fArray2[0], fArray2[1]);
        jvxlData.isJvxlPrecisionColor = true;
        JvxlReader.jvxlCreateColorData(jvxlData, fArray);
        String string = this.viewer.getPropertyColorScheme();
        this.thisMesh.colorCommand = "color $" + this.thisMesh.thisID + " " + this.getUserColorScheme(string) + " range " + fArray2[0] + " " + fArray2[1];
        this.thisMesh.isColorSolid = false;
    }

    private String getUserColorScheme(String string) {
        String string2 = this.viewer.getColorSchemeList(string, false);
        return "\"" + (string2.length() == 0 ? string : string2) + "\"";
    }

    public float getValue(int n, int n2, int n3) {
        return 0.0f;
    }

    public boolean checkObjectHovered(int n, int n2, BitSet bitSet) {
        String string = this.findValue(n, n2, false, bitSet);
        if (string == null) {
            return false;
        }
        if (this.g3d.isDisplayAntialiased()) {
            n <<= 1;
            n2 <<= 1;
        }
        this.viewer.hoverOn(n, n2, string);
        return true;
    }

    public Point3fi checkObjectClicked(int n, int n2, int n3, BitSet bitSet) {
        Tuple3f tuple3f;
        if (n3 != 24) {
            return null;
        }
        int n4 = 100;
        if (this.g3d.isAntialiased()) {
            n <<= 1;
            n2 <<= 1;
            n4 <<= 1;
        }
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = Integer.MIN_VALUE;
        int n9 = Integer.MAX_VALUE;
        for (int i = 0; i < this.meshCount && n5 < 0; ++i) {
            IsosurfaceMesh isosurfaceMesh = this.isomeshes[i];
            if (isosurfaceMesh.visibilityFlags == 0 || isosurfaceMesh.modelIndex >= 0 && !bitSet.get(isosurfaceMesh.modelIndex)) continue;
            Point3f[] point3fArray = isosurfaceMesh.getCenters();
            int n10 = point3fArray.length;
            while (--n10 >= 0) {
                tuple3f = point3fArray[n10];
                int n11 = this.coordinateInRange(n, n2, (Point3f)tuple3f, n4, this.ptXY);
                if (n11 < 0) continue;
                n5 = i;
                if (this.ptXY.z < n9) {
                    n9 = this.ptXY.z;
                    n7 = n10;
                }
                if (this.ptXY.z <= n8) continue;
                n8 = this.ptXY.z;
                n6 = n10;
            }
        }
        if (n5 < 0) {
            return null;
        }
        IsosurfaceMesh isosurfaceMesh = this.isomeshes[n5];
        this.setPropertySuper("thisID", isosurfaceMesh.thisID, null);
        boolean bl = false;
        int n12 = bl ? n7 : n6;
        Point3fi point3fi = new Point3fi();
        point3fi.set(isosurfaceMesh.centers[n12]);
        point3fi.modelIndex = (short)isosurfaceMesh.modelIndex;
        tuple3f = new Vector3f();
        isosurfaceMesh.getFacePlane(n12, (Vector3f)tuple3f);
        tuple3f.scale(-1.0f);
        this.setHeading(point3fi, (Vector3f)tuple3f, 2);
        return point3fi;
    }

    private void navigate(int n) {
        if (this.thisMesh == null) {
            return;
        }
        Point3f point3f = new Point3f(this.viewer.getNavigationOffset());
        Point3f point3f2 = new Point3f();
        this.viewer.unTransformPoint(point3f, point3f2);
        point3f.z += (float)n;
        this.viewer.unTransformPoint(point3f, point3f2);
        Point3f point3f3 = new Point3f();
        Vector3f vector3f = new Vector3f();
        if (!this.getClosestNormal(this.thisMesh, point3f2, point3f3, vector3f)) {
            return;
        }
        Point3f point3f4 = new Point3f(point3f3);
        point3f4.add(vector3f);
        Point3f point3f5 = new Point3f();
        this.viewer.transformPoint(point3f4, point3f5);
        if (point3f5.y > point3f.y) {
            vector3f.scale(-1.0f);
        }
        this.setHeading(point3f3, vector3f, 0);
    }

    private void setHeading(Point3f point3f, Vector3f vector3f, int n) {
        StateManager.Orientation orientation = this.viewer.getOrientation();
        this.viewer.navigate(0.0f, point3f);
        Point3f point3f2 = new Point3f();
        Point3f point3f3 = new Point3f(vector3f);
        point3f3.add(point3f);
        this.viewer.transformPoint(point3f3, point3f2);
        Point3f point3f4 = new Point3f(this.viewer.getNavigationOffset());
        point3f2.sub(point3f4);
        point3f2.z = 0.0f;
        float f = Measure.computeTorsion(JmolConstants.axisNY, JmolConstants.center, JmolConstants.axisZ, point3f2, true);
        this.viewer.navigate(0.0f, JmolConstants.axisZ, f);
        point3f3.set(vector3f);
        point3f3.add(point3f);
        this.viewer.transformPoint(point3f3, point3f2);
        point3f2.sub(point3f4);
        f = Measure.computeTorsion(JmolConstants.axisNY, JmolConstants.center, JmolConstants.axisX, point3f2, true);
        this.viewer.navigate(0.0f, JmolConstants.axisX, 20.0f - f);
        point3f4 = new Point3f(this.viewer.getNavigationOffset());
        if (n <= 0) {
            return;
        }
        this.viewer.saveOrientation("_navsurf");
        orientation.restore(0.0f, true);
        this.viewer.script("restore orientation _navsurf " + n);
    }

    private boolean getClosestNormal(IsosurfaceMesh isosurfaceMesh, Point3f point3f, Point3f point3f2, Vector3f vector3f) {
        Point3f[] point3fArray = isosurfaceMesh.getCenters();
        float f = Float.MAX_VALUE;
        int n = -1;
        int n2 = point3fArray.length;
        while (--n2 >= 0) {
            float f2;
            float f3 = point3fArray[n2].distance(point3f);
            if (f2 >= f) continue;
            f = f3;
            n = n2;
        }
        if (n < 0) {
            return false;
        }
        this.getClosestPoint(isosurfaceMesh, n, point3f, point3f2, vector3f);
        return true;
    }

    private void getClosestPoint(IsosurfaceMesh isosurfaceMesh, int n, Point3f point3f, Point3f point3f2, Vector3f vector3f) {
        Point4f point4f = isosurfaceMesh.getFacePlane(n, vector3f);
        float f = Measure.distanceToPlane(point4f, point3f);
        vector3f.scale(-f);
        point3f2.set(point3f);
        point3f2.add(vector3f);
        f = Measure.distanceToPlane(point4f, point3f2);
        if (isosurfaceMesh.centers[n].distance(point3f) < point3f2.distance(point3f)) {
            point3f2.set(isosurfaceMesh.centers[n]);
        }
    }

    private String findValue(int n, int n2, boolean bl, BitSet bitSet) {
        int n3 = 100;
        if (this.g3d.isAntialiased()) {
            n <<= 1;
            n2 <<= 1;
            n3 <<= 1;
        }
        Vector vector = null;
        for (int i = 0; i < this.meshCount; ++i) {
            int n4;
            int n5;
            IsosurfaceMesh isosurfaceMesh = this.isomeshes[i];
            if (isosurfaceMesh.visibilityFlags == 0 || isosurfaceMesh.modelIndex >= 0 && !bitSet.get(isosurfaceMesh.modelIndex)) continue;
            Vector[] vectorArray = isosurfaceMesh.jvxlData.vContours;
            if (vectorArray != null) {
                for (n5 = 0; n5 < vectorArray.length; ++n5) {
                    Vector vector2 = vectorArray[n5];
                    int n6 = vector2.size() - 1;
                    for (n4 = 5; n4 < n6; ++n4) {
                        Point3f point3f = (Point3f)vector2.get(n4);
                        int n7 = this.coordinateInRange(n, n2, point3f, n3, this.ptXY);
                        if (n7 < 0) continue;
                        n3 = n7;
                        vector = vector2;
                    }
                }
                if (vector == null) continue;
                return vector.get(2).toString();
            }
            if (isosurfaceMesh.jvxlData.jvxlPlane == null || isosurfaceMesh.vertexValues == null) continue;
            n5 = -1;
            int n8 = isosurfaceMesh.vertexCount;
            while (--n8 >= isosurfaceMesh.firstRealVertex) {
                Point3f point3f = isosurfaceMesh.vertices[n8];
                n4 = this.coordinateInRange(n, n2, point3f, n3, this.ptXY);
                if (n4 < 0) continue;
                n3 = n4;
                n5 = n8;
            }
            if (n5 == -1) continue;
            return "v" + n5 + ": " + isosurfaceMesh.vertexValues[n5];
        }
        return null;
    }

    public int getColixArgb(short s) {
        return this.viewer.getColixArgb(s);
    }
}

