/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.shape.ShapeRenderer;
import org.jmol.shapespecial.Dipole;
import org.jmol.shapespecial.Dipoles;

public class DipolesRenderer
extends ShapeRenderer {
    private float dipoleVectorScale;
    private final Vector3f offset = new Vector3f();
    private final Point3i[] screens = new Point3i[6];
    private final Point3f[] points = new Point3f[6];
    private Point3f cross0;
    private Point3f cross1;
    private static final int cylinderBase = 0;
    private static final int cross = 1;
    private static final int crossEnd = 2;
    private static final int center = 3;
    private static final int arrowHeadBase = 4;
    private static final int arrowHeadTip = 5;
    private int diameter;
    private int headWidthPixels;
    private int crossWidthPixels;
    private static final float arrowHeadOffset = 0.9f;
    private static final float arrowHeadWidthFactor = 2.0f;
    private static final float crossOffset = 0.1f;
    private static final float crossWidth = 0.04f;

    public DipolesRenderer() {
        for (int i = 0; i < 6; ++i) {
            this.screens[i] = new Point3i();
            this.points[i] = new Point3f();
        }
        this.cross0 = new Point3f();
        this.cross1 = new Point3f();
    }

    protected void render() {
        Dipoles dipoles = (Dipoles)this.shape;
        this.dipoleVectorScale = this.viewer.getDipoleScale();
        int n = dipoles.dipoleCount;
        while (--n >= 0) {
            Dipole dipole = dipoles.dipoles[n];
            if (dipole.visibilityFlags == 0 || !this.transform(dipole)) continue;
            this.renderDipoleVector(dipole);
        }
    }

    private boolean transform(Dipole dipole) {
        int n;
        Vector3f vector3f = dipole.vector;
        this.offset.set(vector3f);
        if (dipole.center == null) {
            this.offset.scale(dipole.offsetAngstroms / dipole.dipoleValue);
            if (this.dipoleVectorScale < 0.0f) {
                this.offset.add(vector3f);
            }
            this.points[0].set(dipole.origin);
            this.points[0].add(this.offset);
        } else {
            this.offset.scale(-0.5f * this.dipoleVectorScale);
            this.points[0].set(dipole.center);
            this.points[0].add(this.offset);
            if (dipole.offsetAngstroms != 0.0f) {
                this.offset.set(vector3f);
                this.offset.scale(dipole.offsetAngstroms / dipole.dipoleValue);
                this.points[0].add(this.offset);
            }
        }
        this.points[1].scaleAdd(this.dipoleVectorScale * 0.1f, vector3f, this.points[0]);
        this.points[2].scaleAdd(this.dipoleVectorScale * 0.14f, vector3f, this.points[0]);
        this.points[3].scaleAdd(this.dipoleVectorScale / 2.0f, vector3f, this.points[0]);
        this.points[4].scaleAdd(this.dipoleVectorScale * 0.9f, vector3f, this.points[0]);
        this.points[5].scaleAdd(this.dipoleVectorScale, vector3f, this.points[0]);
        if (dipole.atoms[0] != null && this.modelSet.isAtomHidden(dipole.atoms[0].getAtomIndex())) {
            return false;
        }
        this.offset.set(this.points[3]);
        this.offset.cross(this.offset, vector3f);
        if (this.offset.length() == 0.0f) {
            this.offset.set(this.points[3].x + 0.2345f, this.points[3].y + 0.1234f, this.points[3].z + 0.4321f);
            this.offset.cross(this.offset, vector3f);
        }
        this.offset.scale(dipole.offsetSide / this.offset.length());
        for (n = 0; n < 6; ++n) {
            this.points[n].add(this.offset);
        }
        for (n = 0; n < 6; ++n) {
            this.viewer.transformPoint(this.points[n], this.screens[n]);
        }
        this.viewer.transformPoint(this.points[1], this.cross0);
        this.viewer.transformPoint(this.points[2], this.cross1);
        this.mad = dipole.mad;
        this.diameter = this.viewer.scaleToScreen(this.screens[3].z, this.mad);
        this.headWidthPixels = (int)((float)this.diameter * 2.0f);
        if (this.headWidthPixels < this.diameter + 5) {
            this.headWidthPixels = this.diameter + 5;
        }
        this.crossWidthPixels = this.headWidthPixels;
        return true;
    }

    private void renderDipoleVector(Dipole dipole) {
        short s;
        short s2 = s = dipole.bond == null ? dipole.colix : Graphics3D.getColixInherited(dipole.colix, dipole.bond.getColix());
        if (dipole.atoms[0] != null) {
            s = Graphics3D.getColixInherited(s, dipole.atoms[0].getColix());
            s2 = Graphics3D.getColixInherited(s2, dipole.atoms[1].getColix());
        }
        if (s == 0) {
            s = 5;
        }
        if (s2 == 0) {
            s2 = 5;
        }
        if (this.dipoleVectorScale < 0.0f) {
            short s3 = s;
            s = s2;
            s2 = s3;
        }
        this.colix = s;
        if (this.colix == s2) {
            if (!this.g3d.setColix(this.colix)) {
                return;
            }
            this.g3d.fillCylinder((byte)1, this.diameter, this.screens[0], this.screens[4]);
            if (!dipole.noCross) {
                this.g3d.fillCylinderBits((byte)2, this.crossWidthPixels, this.cross0, this.cross1);
            }
            this.g3d.fillCone((byte)2, this.headWidthPixels, this.screens[4], this.screens[5]);
            return;
        }
        if (this.g3d.setColix(this.colix)) {
            this.g3d.fillCylinder((byte)1, this.diameter, this.screens[0], this.screens[3]);
            if (!dipole.noCross) {
                this.g3d.fillCylinderBits((byte)2, this.crossWidthPixels, this.cross0, this.cross1);
            }
        }
        this.colix = s2;
        if (this.g3d.setColix(this.colix)) {
            this.g3d.fillCylinder((byte)4, this.diameter, this.screens[3], this.screens[4]);
            this.g3d.fillCone((byte)2, this.headWidthPixels, this.screens[4], this.screens[5]);
        }
    }
}

