/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import java.util.Hashtable;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.modelset.LabelToken;
import org.jmol.shape.AtomShape;
import org.jmol.shape.Object2d;
import org.jmol.shape.Text;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.viewer.JmolConstants;

public class Labels
extends AtomShape {
    String[] strings;
    String[] formats;
    short[] bgcolixes;
    byte[] fids;
    int[] offsets;
    private Hashtable atomLabels = new Hashtable();
    private Text text;
    private BitSet bsFontSet;
    private BitSet bsBgColixSet;
    private int defaultOffset;
    private int defaultAlignment;
    private int defaultZPos;
    private byte defaultFontId;
    private short defaultColix;
    private short defaultBgcolix;
    private byte defaultPaletteID;
    private int defaultPointer;
    private static int zeroOffset = 1028;
    byte zeroFontId;
    private boolean defaultsOnlyForNone = true;
    private boolean setDefaults = false;
    static final int POINTER_FLAGS = 3;
    static final int ALIGN_FLAGS = 12;
    static final int ZPOS_FLAGS = 48;
    static final int GROUP_FLAG = 16;
    static final int FRONT_FLAG = 32;
    static final int SCALE_FLAG = 64;
    static final int EXACT_OFFSET_FLAG = 128;
    static final int FLAGS = 255;
    static final int FLAG_OFFSET = 8;
    int pickedAtom = -1;
    int pickedOffset = 0;

    public void initShape() {
        super.initShape();
        this.defaultFontId = this.zeroFontId = this.g3d.getFont3D((String)"SansSerif", (String)"Plain", (float)13.0f).fid;
        this.defaultColix = 0;
        this.defaultBgcolix = 0;
        this.defaultOffset = zeroOffset;
        this.defaultZPos = 0;
        this.translucentAllowed = false;
    }

    public void setProperty(String string, Object object, BitSet bitSet) {
        this.isActive = true;
        if ("setDefaults" == string) {
            this.setDefaults = (Boolean)object;
            return;
        }
        if ("color" == string) {
            this.isActive = true;
            byte by = JmolConstants.pidOf(object);
            short s = Graphics3D.getColix(object);
            if (!this.setDefaults) {
                int n = this.atomCount;
                while (--n >= 0) {
                    if (!bitSet.get(n)) continue;
                    this.setColix(n, s, by);
                }
            }
            if (this.setDefaults || !this.defaultsOnlyForNone) {
                this.defaultColix = s;
                this.defaultPaletteID = by;
            }
            return;
        }
        if ("scalereference" == string) {
            if (this.strings == null) {
                return;
            }
            float f = ((Float)object).floatValue();
            float f2 = f == 0.0f ? 0.0f : 10000.0f / f;
            int n = this.atomCount;
            while (--n >= 0) {
                if (!bitSet.get(n) || this.strings.length <= n) continue;
                this.text = this.getLabel(n);
                if (this.text == null) {
                    this.text = new Text(this.g3d, null, this.strings[n], 0, 0, 0, 0, 0, 0, 0, f2);
                    this.putLabel(n, this.text);
                    continue;
                }
                this.text.setScalePixelsPerMicron(f2);
            }
            return;
        }
        if ("label" == string) {
            this.setLabel((String)object, bitSet);
            return;
        }
        if ("translucency" == string || "bgtranslucency" == string) {
            return;
        }
        if ("bgcolor" == string) {
            this.isActive = true;
            if (this.bsBgColixSet == null) {
                this.bsBgColixSet = new BitSet();
            }
            short s = Graphics3D.getColix(object);
            if (!this.setDefaults) {
                int n = this.atomCount;
                while (--n >= 0) {
                    if (!bitSet.get(n)) continue;
                    this.setBgcolix(n, s);
                }
            }
            if (this.setDefaults || !this.defaultsOnlyForNone) {
                this.defaultBgcolix = s;
            }
            return;
        }
        if (this.bsFontSet == null) {
            this.bsFontSet = new BitSet();
        }
        if ("fontsize" == string) {
            int n = (Integer)object;
            if (n < 0) {
                this.fids = null;
                return;
            }
            byte by = this.g3d.getFontFid(n);
            if (!this.setDefaults) {
                int n2 = this.atomCount;
                while (--n2 >= 0) {
                    if (!bitSet.get(n2)) continue;
                    this.setFont(n2, by);
                }
            }
            if (this.setDefaults || !this.defaultsOnlyForNone) {
                this.defaultFontId = by;
            }
            return;
        }
        if ("font" == string) {
            byte by = ((Font3D)object).fid;
            if (!this.setDefaults) {
                int n = this.atomCount;
                while (--n >= 0) {
                    if (!bitSet.get(n)) continue;
                    this.setFont(n, by);
                }
            }
            if (this.setDefaults || !this.defaultsOnlyForNone) {
                this.defaultFontId = by;
            }
            return;
        }
        if ("offset" == string || "offsetexact" == string) {
            boolean bl;
            int n = (Integer)object;
            boolean bl2 = bl = string == "offsetexact";
            if (n == 0) {
                n = Short.MAX_VALUE;
            } else if (n == zeroOffset) {
                n = 0;
            }
            if (!this.setDefaults) {
                int n3 = this.atomCount;
                while (--n3 >= 0) {
                    if (!bitSet.get(n3)) continue;
                    this.setOffsets(n3, n, bl);
                }
            }
            if (this.setDefaults || !this.defaultsOnlyForNone) {
                this.defaultOffset = n;
            }
            return;
        }
        if ("align" == string) {
            String string2 = (String)object;
            int n = 1;
            if (string2.equalsIgnoreCase("right")) {
                n = 3;
            } else if (string2.equalsIgnoreCase("center")) {
                n = 2;
            }
            int n4 = this.atomCount;
            while (--n4 >= 0) {
                if (!bitSet.get(n4)) continue;
                this.setAlignment(n4, n);
            }
            if (this.setDefaults || !this.defaultsOnlyForNone) {
                this.defaultAlignment = n;
            }
            return;
        }
        if ("pointer" == string) {
            int n = (Integer)object;
            if (!this.setDefaults) {
                int n5 = this.atomCount;
                while (--n5 >= 0) {
                    if (!bitSet.get(n5)) continue;
                    this.setPointer(n5, n);
                }
            }
            if (this.setDefaults || !this.defaultsOnlyForNone) {
                this.defaultPointer = n;
            }
            return;
        }
        if ("front" == string) {
            boolean bl = (Boolean)object;
            if (!this.setDefaults) {
                int n = this.atomCount;
                while (--n >= 0) {
                    if (!bitSet.get(n)) continue;
                    this.setFront(n, bl);
                }
            }
            if (this.setDefaults || !this.defaultsOnlyForNone) {
                this.defaultZPos = bl ? 32 : 0;
            }
            return;
        }
        if ("group" == string) {
            boolean bl = (Boolean)object;
            if (!this.setDefaults) {
                int n = this.atomCount;
                while (--n >= 0) {
                    if (!bitSet.get(n)) continue;
                    this.setGroup(n, bl);
                }
            }
            if (this.setDefaults || !this.defaultsOnlyForNone) {
                this.defaultZPos = bl ? 16 : 0;
            }
            return;
        }
        if ("toggleLabel" == string) {
            int n = this.atomCount;
            while (--n >= 0) {
                if (!bitSet.get(n)) continue;
                Atom atom = this.atoms[n];
                if (this.formats == null || n >= this.formats.length) {
                    this.formats = ArrayUtil.ensureLength(this.formats, n + 1);
                }
                if (this.strings != null && this.strings.length > n && this.strings[n] != null) {
                    this.mads[n] = (short)(this.mads[n] < 0 ? 1 : -1);
                } else {
                    String string3 = this.viewer.getStandardLabelFormat();
                    this.strings = ArrayUtil.ensureLength(this.strings, n + 1);
                    this.strings[n] = LabelToken.formatLabel(atom, string3);
                    this.formats[n] = string3;
                    this.bsSizeSet.set(n);
                    if (!(this.bsBgColixSet != null && this.bsBgColixSet.get(n) || this.defaultBgcolix == 0)) {
                        this.setBgcolix(n, this.defaultBgcolix);
                    }
                    this.mads[n] = 1;
                }
                atom.setShapeVisibility(this.myVisibilityFlag, this.strings != null && n < this.strings.length && this.strings[n] != null);
            }
            return;
        }
        if (string.startsWith("label:")) {
            this.setLabel(string.substring(6), (Integer)object);
            return;
        }
        if (string == "deleteModelAtoms") {
            int n = ((int[])((Object[])object)[2])[1];
            int n6 = ((int[])((Object[])object)[2])[2];
            this.fids = (byte[])ArrayUtil.deleteElements(this.fids, n, n6);
            this.bgcolixes = (short[])ArrayUtil.deleteElements(this.bgcolixes, n, n6);
            this.offsets = (int[])ArrayUtil.deleteElements(this.offsets, n, n6);
            this.formats = (String[])ArrayUtil.deleteElements(this.formats, n, n6);
            this.strings = (String[])ArrayUtil.deleteElements(this.strings, n, n6);
            BitSetUtil.deleteBits(this.bsFontSet, bitSet);
            BitSetUtil.deleteBits(this.bsBgColixSet, bitSet);
        }
        super.setProperty(string, object, bitSet);
    }

    private void setLabel(String string, BitSet bitSet) {
        this.isActive = true;
        if (this.bsSizeSet == null) {
            this.bsSizeSet = new BitSet();
        }
        String string2 = string;
        boolean bl = this.viewer.getFontScaling();
        float f = bl ? this.viewer.getScalePixelsPerAngstrom(false) * 10000.0f : 0.0f;
        int n = this.atomCount;
        while (--n >= 0) {
            if (!bitSet.get(n)) continue;
            this.setLabel(string2, n, bl, f);
        }
    }

    private void setLabel(String string, int n) {
        this.isActive = true;
        if (this.bsSizeSet == null) {
            this.bsSizeSet = new BitSet();
        }
        String string2 = string;
        boolean bl = this.viewer.getFontScaling();
        float f = bl ? this.viewer.getScalePixelsPerAngstrom(false) * 10000.0f : 0.0f;
        this.setLabel(string2, n, bl, f);
    }

    private void setLabel(String string, int n, boolean bl, float f) {
        Atom atom;
        String string2 = LabelToken.formatLabel(atom = this.atoms[n], string);
        atom.setShapeVisibility(this.myVisibilityFlag, string2 != null);
        if (this.strings == null || n >= this.strings.length) {
            this.strings = ArrayUtil.ensureLength(this.strings, n + 1);
        }
        if (this.formats == null || n >= this.formats.length) {
            this.formats = ArrayUtil.ensureLength(this.formats, n + 1);
        }
        this.strings[n] = string2;
        this.formats[n] = string;
        this.bsSizeSet.set(n, string != null);
        this.text = this.getLabel(n);
        if (bl) {
            this.text = new Text(this.g3d, null, string2, 0, 0, 0, 0, 0, 0, 0, f);
            this.putLabel(n, this.text);
        } else if (this.text != null) {
            this.text.setText(string2);
        }
        if (this.defaultOffset != zeroOffset) {
            this.setOffsets(n, this.defaultOffset, false);
        }
        if (this.defaultAlignment != 1) {
            this.setAlignment(n, this.defaultAlignment);
        }
        if ((this.defaultZPos & 0x20) != 0) {
            this.setFront(n, true);
        } else if ((this.defaultZPos & 0x10) != 0) {
            this.setGroup(n, true);
        }
        if (this.defaultPointer != 0) {
            this.setPointer(n, this.defaultPointer);
        }
        if (this.defaultColix != 0 || this.defaultPaletteID != 0) {
            this.setColix(n, this.defaultColix, this.defaultPaletteID);
        }
        if (this.defaultBgcolix != 0) {
            this.setBgcolix(n, this.defaultBgcolix);
        }
        if (this.defaultFontId != this.zeroFontId) {
            this.setFont(n, this.defaultFontId);
        }
    }

    public Object getProperty(String string, int n) {
        if (string.equals("offsets")) {
            return this.offsets;
        }
        if (string.equals("defaultState")) {
            return this.getDefaultState();
        }
        if (string.equals("label")) {
            return this.strings != null && n < this.strings.length && this.strings[n] != null ? this.strings[n] : "";
        }
        return null;
    }

    void putLabel(int n, Text text) {
        if (text == null) {
            this.atomLabels.remove(this.atoms[n]);
        } else {
            this.atomLabels.put(this.atoms[n], text);
        }
    }

    Text getLabel(int n) {
        return (Text)this.atomLabels.get(this.atoms[n]);
    }

    private void setColix(int n, short s, byte by) {
        this.setColixAndPalette(s, by, n);
        this.text = this.getLabel(n);
        if (this.text != null) {
            this.text.setColix(this.colixes[n]);
        }
    }

    private void setBgcolix(int n, short s) {
        if (this.bgcolixes == null || n >= this.bgcolixes.length) {
            if (s == 0) {
                return;
            }
            this.bgcolixes = ArrayUtil.ensureLength(this.bgcolixes, n + 1);
        }
        this.bgcolixes[n] = s;
        this.bsBgColixSet.set(n, s != 0);
        this.text = this.getLabel(n);
        if (this.text != null) {
            this.text.setBgColix(s);
        }
    }

    private void setOffsets(int n, int n2, boolean bl) {
        if (this.offsets == null || n >= this.offsets.length) {
            if (n2 == 0) {
                return;
            }
            this.offsets = ArrayUtil.ensureLength(this.offsets, n + 1);
        }
        this.offsets[n] = this.offsets[n] & 0xFF | n2 << 8;
        if (bl) {
            int n3 = n;
            this.offsets[n3] = this.offsets[n3] | 0x80;
        }
        this.text = this.getLabel(n);
        if (this.text != null) {
            this.text.setOffset(n2);
        }
    }

    private void setAlignment(int n, int n2) {
        if (this.offsets == null || n >= this.offsets.length) {
            if (n2 == 1) {
                return;
            }
            this.offsets = ArrayUtil.ensureLength(this.offsets, n + 1);
        }
        this.offsets[n] = this.offsets[n] & 0xFFFFFFF3 | n2 << 2;
        this.text = this.getLabel(n);
        if (this.text != null) {
            this.text.setAlignment(n2);
        }
    }

    static int getAlignment(int n) {
        return (n & 0xC) >> 2;
    }

    private void setPointer(int n, int n2) {
        if (this.offsets == null || n >= this.offsets.length) {
            if (n2 == 0) {
                return;
            }
            this.offsets = ArrayUtil.ensureLength(this.offsets, n + 1);
        }
        this.offsets[n] = (this.offsets[n] & 0xFFFFFFFC) + n2;
        this.text = this.getLabel(n);
        if (this.text != null) {
            this.text.setPointer(n2);
        }
    }

    private void setFront(int n, boolean bl) {
        if (this.offsets == null || n >= this.offsets.length) {
            if (!bl) {
                return;
            }
            this.offsets = ArrayUtil.ensureLength(this.offsets, n + 1);
        }
        this.offsets[n] = (this.offsets[n] & 0xFFFFFFCF) + (bl ? 32 : 0);
    }

    private void setGroup(int n, boolean bl) {
        if (this.offsets == null || n >= this.offsets.length) {
            if (!bl) {
                return;
            }
            this.offsets = ArrayUtil.ensureLength(this.offsets, n + 1);
        }
        this.offsets[n] = (this.offsets[n] & 0xFFFFFFCF) + (bl ? 16 : 0);
    }

    private void setFont(int n, byte by) {
        if (this.fids == null || n >= this.fids.length) {
            if (by == this.zeroFontId) {
                return;
            }
            this.fids = ArrayUtil.ensureLength(this.fids, n + 1);
        }
        this.fids[n] = by;
        this.bsFontSet.set(n);
        this.text = this.getLabel(n);
        if (this.text != null) {
            this.text.setFid(by);
        }
    }

    public void setModelClickability() {
        if (this.strings == null) {
            return;
        }
        int n = this.strings.length;
        while (--n >= 0) {
            String string = this.strings[n];
            if (string == null || this.modelSet.atoms.length <= n || this.modelSet.isAtomHidden(n)) continue;
            this.modelSet.atoms[n].setClickable(this.myVisibilityFlag);
        }
    }

    private String getDefaultState() {
        StringBuffer stringBuffer = new StringBuffer("\n# label defaults;\n");
        Labels.appendCmd(stringBuffer, "select none");
        Labels.appendCmd(stringBuffer, this.getColorCommand("label", this.defaultPaletteID, this.defaultColix));
        Labels.appendCmd(stringBuffer, "background label " + this.encodeColor(this.defaultBgcolix));
        Labels.appendCmd(stringBuffer, "set labelOffset " + Object2d.getXOffset(this.defaultOffset) + " " + -Object2d.getYOffset(this.defaultOffset));
        String string = Object2d.getAlignment(this.defaultAlignment);
        Labels.appendCmd(stringBuffer, "set labelAlignment " + (string.length() < 5 ? "left" : string));
        String string2 = Object2d.getPointer(this.defaultPointer);
        Labels.appendCmd(stringBuffer, "set labelPointer " + (string2.length() == 0 ? "off" : string2));
        if ((this.defaultZPos & 0x20) != 0) {
            Labels.appendCmd(stringBuffer, "set labelFront");
        } else if ((this.defaultZPos & 0x10) != 0) {
            Labels.appendCmd(stringBuffer, "set labelGroup");
        }
        Labels.appendCmd(stringBuffer, Labels.getFontCommand("label", Font3D.getFont3D(this.defaultFontId)));
        return stringBuffer.toString();
    }

    public String getShapeState() {
        if (!this.isActive) {
            return "";
        }
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        Hashtable hashtable3 = new Hashtable();
        int n = this.atomCount;
        while (--n >= 0) {
            Text text;
            float f;
            if (this.bsSizeSet == null || !this.bsSizeSet.get(n)) continue;
            Labels.setStateInfo(hashtable, n, "label " + Escape.escape(this.formats[n]));
            if (this.bsColixSet != null && this.bsColixSet.get(n)) {
                Labels.setStateInfo(hashtable2, n, this.getColorCommand("label", this.paletteIDs[n], this.colixes[n]));
            }
            if (this.bsBgColixSet != null && this.bsBgColixSet.get(n)) {
                Labels.setStateInfo(hashtable2, n, "background label " + this.encodeColor(this.bgcolixes[n]));
            }
            float f2 = f = (text = this.getLabel(n)) != null ? text.getScalePixelsPerMicron() : 0.0f;
            if (f > 0.0f) {
                Labels.setStateInfo(hashtable2, n, "set labelScaleReference " + 10000.0f / f);
            }
            if (this.offsets != null && this.offsets.length > n) {
                int n2 = this.offsets[n];
                Labels.setStateInfo(hashtable2, n, "set " + ((n2 & 0x80) == 128 ? "labelOffsetExact " : "labelOffset ") + Object2d.getXOffset(n2 >> 8) + " " + -Object2d.getYOffset(n2 >> 8));
                String string = Object2d.getAlignment(n2 >> 2);
                String string2 = Object2d.getPointer(n2);
                if (string2.length() > 0) {
                    Labels.setStateInfo(hashtable2, n, "set labelPointer " + string2);
                }
                if ((n2 & 0x20) != 0) {
                    Labels.setStateInfo(hashtable2, n, "set labelFront");
                } else if ((n2 & 0x10) != 0) {
                    Labels.setStateInfo(hashtable2, n, "set labelGroup");
                }
                if (string.length() > 0) {
                    Labels.setStateInfo(hashtable3, n, "set labelAlignment " + string);
                }
            }
            if (this.bsFontSet != null && this.bsFontSet.get(n)) {
                Labels.setStateInfo(hashtable2, n, Labels.getFontCommand("label", Font3D.getFont3D(this.fids[n])));
            }
            if (this.mads[n] >= 0) continue;
            Labels.setStateInfo(hashtable2, n, "set toggleLabel");
        }
        return Labels.getShapeCommands(hashtable, hashtable2, this.atomCount) + Labels.getShapeCommands(null, hashtable3, this.atomCount);
    }

    public synchronized boolean checkObjectDragged(int n, int n2, int n3, int n4, int n5, BitSet bitSet) {
        if (this.viewer.getPickingMode() != 2) {
            return false;
        }
        if (n == Integer.MIN_VALUE) {
            int n6 = this.viewer.findNearestAtomIndex(n3, n4);
            if (n6 >= 0 && this.atoms[n6].isVisible(this.myVisibilityFlag)) {
                this.pickedAtom = n6;
                this.pickedOffset = (this.offsets == null || this.pickedAtom >= this.offsets.length ? 0 : this.offsets[this.pickedAtom]) >> 8;
                return true;
            }
            return false;
        }
        if (n == Integer.MAX_VALUE) {
            this.pickedAtom = -1;
            return false;
        }
        if (this.pickedAtom < 0) {
            return false;
        }
        this.move2D(this.pickedAtom, n3, n4);
        return true;
    }

    private void move2D(int n, int n2, int n3) {
        if (this.g3d.isAntialiased()) {
            n2 <<= 1;
            n3 <<= 1;
        }
        Atom atom = this.atoms[n];
        int n4 = Object2d.getXOffset(this.pickedOffset);
        int n5 = -Object2d.getYOffset(this.pickedOffset);
        int n6 = Object2d.getOffset(n4 += n2 - atom.screenX, n5 += atom.screenY - n3);
        if (n6 == 0) {
            n6 = Short.MAX_VALUE;
        } else if (n6 == zeroOffset) {
            n6 = 0;
        }
        this.setOffsets(n, n6, true);
    }
}

