/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import javax.vecmath.Point3f;
import org.jmol.modelset.Atom;
import org.jmol.shape.ShapeRenderer;

public class BallsRenderer
extends ShapeRenderer {
    private int minX;
    private int minY;
    private int minZ;
    private int maxX;
    private int maxY;
    private int maxZ;

    protected void render() {
        int n;
        int n2;
        Point3f point3f;
        boolean bl = !this.viewer.getWireframeRotation() || !this.viewer.getInMotion();
        this.slabbing = this.viewer.getSlabEnabled();
        boolean bl2 = this.modelSet.getAtomCount() > 0 && this.viewer.getShowNavigationPoint() && !this.isGenerator && this.g3d.setColix((short)4);
        Point3f point3f2 = point3f = bl2 ? new Point3f(this.viewer.getNavigationOffset()) : null;
        if (this.slabbing) {
            this.minZ = this.g3d.getSlab();
            this.maxZ = this.g3d.getDepth();
        }
        if (bl2) {
            this.minX = Integer.MAX_VALUE;
            this.maxX = Integer.MIN_VALUE;
            this.minY = Integer.MAX_VALUE;
            this.maxY = Integer.MIN_VALUE;
        }
        Atom[] atomArray = this.modelSet.atoms;
        int n3 = n2 = this.modelSet.getAtomCount();
        while (--n3 >= 0) {
            Atom atom = atomArray[n3];
            if ((atom.getShapeVisibilityFlags() & 1) == 0) continue;
            atom.transform(this.viewer);
            if (this.slabbing && this.g3d.isClippedZ(atom.screenZ)) {
                atom.setClickable(0);
                n = atom.screenDiameter / 2;
                if (atom.screenZ < this.minZ - n || atom.screenZ > this.maxZ + n || !this.g3d.isInDisplayRange(atom.screenX, atom.screenY)) continue;
            }
            if (!bl || atom.screenDiameter <= 0 || (atom.getShapeVisibilityFlags() & this.myVisibilityFlag) == 0 || !this.g3d.setColix(atom.getColix())) continue;
            if (bl2) {
                if (atom.screenX < this.minX) {
                    this.minX = atom.screenX;
                }
                if (atom.screenX > this.maxX) {
                    this.maxX = atom.screenX;
                }
                if (atom.screenY < this.minY) {
                    this.minY = atom.screenY;
                }
                if (atom.screenY > this.maxY) {
                    this.maxY = atom.screenY;
                }
            }
            this.renderBall(atom);
        }
        if (bl2) {
            n3 = this.g3d.isAntialiased() ? 1 : 0;
            float f = this.viewer.getNavigationDepthPercent();
            this.g3d.setColix((short)(f < 0.0f ? 10 : (f > 100.0f ? 11 : 23)));
            n = Math.max(Math.min(this.viewer.getScreenWidth(), (int)point3f.x), 0);
            int n4 = Math.max(Math.min(this.viewer.getScreenHeight(), (int)point3f.y), 0);
            int n5 = (int)point3f.z + 1;
            int n6 = n3 != 0 ? 8 : 4;
            int n7 = n3 != 0 ? 20 : 10;
            int n8 = n3 != 0 ? 2 : 1;
            this.g3d.drawRect(n - n6, n4, n5, 0, n7, n8);
            this.g3d.drawRect(n, n4 - n6, n5, 0, n8, n7);
            this.g3d.drawRect(n - n6, n4 - n6, n5, 0, n7, n7);
            n6 = n7;
            this.g3d.setColix((float)this.maxX < point3f.x ? (short)21 : 11);
            this.g3d.drawRect(n - n6, n4, n5, 0, n7 >>= 1, n8);
            this.g3d.setColix((float)this.minX > point3f.x ? (short)21 : 11);
            this.g3d.drawRect(n + n7, n4, n5, 0, n7, n8);
            this.g3d.setColix((float)this.maxY < point3f.y ? (short)21 : 11);
            this.g3d.drawRect(n, n4 - n6, n5, 0, n8, n7);
            this.g3d.setColix((float)this.minY > point3f.y ? (short)21 : 11);
            this.g3d.drawRect(n, n4 + n7, n5, 0, n8, n7);
        }
    }

    protected void renderBall(Atom atom) {
        this.g3d.fillSphereCentered(atom.screenDiameter, atom.screenX, atom.screenY, atom.screenZ);
    }
}

