/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Group;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.Model;
import org.jmol.modelset.Polymer;
import org.jmol.modelsetbio.AlphaMonomer;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.AminoMonomer;
import org.jmol.modelsetbio.AminoPolymer;
import org.jmol.modelsetbio.CarbohydrateMonomer;
import org.jmol.modelsetbio.CarbohydratePolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.NucleicMonomer;
import org.jmol.modelsetbio.NucleicPolymer;
import org.jmol.modelsetbio.PhosphorusMonomer;
import org.jmol.modelsetbio.PhosphorusPolymer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Quaternion;
import org.jmol.util.TextFormat;

public abstract class BioPolymer
extends Polymer {
    Monomer[] monomers;
    int monomerCount;
    protected Model model;
    private float sheetSmoothing;
    private final Vector3f unitVectorX = new Vector3f(1.0f, 0.0f, 0.0f);
    private int selectedMonomerCount;
    BitSet bsSelectedMonomers;
    private static final String[] qColor = new String[]{"yellow", "orange", "purple"};

    public Monomer[] getMonomers() {
        return this.monomers;
    }

    public int getMonomerCount() {
        return this.monomerCount;
    }

    BioPolymer(Monomer[] monomerArray) {
        this.monomers = monomerArray;
        int n = this.monomerCount = monomerArray.length;
        while (--n >= 0) {
            monomerArray[n].setBioPolymer(this, n);
        }
        this.model = monomerArray[0].getModel();
    }

    static BioPolymer allocateBioPolymer(Group[] groupArray, int n, boolean bl) {
        Group group;
        Object object = null;
        int n2 = 0;
        for (int i = n; i < groupArray.length && (group = groupArray[i]) instanceof Monomer; ++i) {
            Monomer monomer = (Monomer)group;
            if (monomer.bioPolymer != null || object != null && object.getClass() != monomer.getClass() || bl && !monomer.isConnectedAfter((Monomer)object)) break;
            object = monomer;
            ++n2;
        }
        if (n2 == 0) {
            return null;
        }
        Monomer[] monomerArray = new Monomer[n2];
        for (int i = 0; i < n2; ++i) {
            monomerArray[i] = (Monomer)groupArray[n + i];
        }
        if (object instanceof AminoMonomer) {
            return new AminoPolymer(monomerArray);
        }
        if (object instanceof AlphaMonomer) {
            return new AlphaPolymer(monomerArray);
        }
        if (object instanceof NucleicMonomer) {
            return new NucleicPolymer(monomerArray);
        }
        if (object instanceof PhosphorusMonomer) {
            return new PhosphorusPolymer(monomerArray);
        }
        if (object instanceof CarbohydrateMonomer) {
            return new CarbohydratePolymer(monomerArray);
        }
        Logger.error("Polymer.allocatePolymer() ... no matching polymer for monomor " + object);
        throw new NullPointerException();
    }

    public void clearStructures() {
        for (int i = 0; i < this.monomerCount; ++i) {
            this.monomers[i].setStructure(null);
        }
    }

    void removeProteinStructure(int n, int n2) {
        Monomer monomer = this.monomers[n];
        byte by = monomer.getProteinStructureType();
        int n3 = -1;
        int n4 = 0;
        for (int i = n; n4 < n2 && i < this.monomerCount; ++n4, ++i) {
            this.monomers[i].setStructure(null);
            n3 = this.monomers[i].setProteinStructureType(by, n3);
        }
    }

    public int[] getLeadAtomIndices() {
        if (this.leadAtomIndices == null) {
            this.leadAtomIndices = new int[this.monomerCount];
            int n = this.monomerCount;
            while (--n >= 0) {
                this.leadAtomIndices[n] = this.monomers[n].getLeadAtomIndex();
            }
        }
        return this.leadAtomIndices;
    }

    int getIndex(char c, int n) {
        int n2 = this.monomerCount;
        while (--n2 >= 0 && (this.monomers[n2].getChainID() != c || this.monomers[n2].getSeqcode() != n)) {
        }
        return n2;
    }

    final Point3f getLeadPoint(int n) {
        return this.monomers[n].getLeadAtomPoint();
    }

    final Point3f getInitiatorPoint() {
        return this.monomers[0].getInitiatorAtom();
    }

    final Point3f getTerminatorPoint() {
        return this.monomers[this.monomerCount - 1].getTerminatorAtom();
    }

    void getLeadMidPoint(int n, Point3f point3f) {
        if (n == this.monomerCount) {
            --n;
        } else if (n > 0) {
            point3f.set(this.getLeadPoint(n));
            point3f.add(this.getLeadPoint(n - 1));
            point3f.scale(0.5f);
            return;
        }
        point3f.set(this.getLeadPoint(n));
    }

    void getLeadPoint(int n, Point3f point3f) {
        if (n == this.monomerCount) {
            --n;
        }
        point3f.set(this.getLeadPoint(n));
    }

    boolean hasWingPoints() {
        return false;
    }

    final Point3f getWingPoint(int n) {
        return this.monomers[n].getWingAtomPoint();
    }

    final Point3f getPointPoint(int n) {
        return this.monomers[n].getPointAtomPoint();
    }

    public void setConformation(BitSet bitSet, int n) {
        int n2 = this.monomerCount;
        while (--n2 >= 0) {
            this.monomers[n2].updateOffsetsForAlternativeLocations(bitSet, n);
        }
        this.recalculateLeadMidpointsAndWingVectors();
    }

    public void recalculateLeadMidpointsAndWingVectors() {
        this.leadAtomIndices = null;
        this.sheetPoints = null;
        this.getLeadAtomIndices();
        ProteinStructure proteinStructure = null;
        for (int i = 0; i < this.monomerCount; ++i) {
            ProteinStructure proteinStructure2 = this.getProteinStructure(i);
            if (proteinStructure2 != null && proteinStructure2 != proteinStructure) {
                proteinStructure = proteinStructure2;
                proteinStructure.resetAxes();
            }
            this.monomers[i].resetHydrogenPoint();
        }
        this.calcLeadMidpointsAndWingVectors(false);
    }

    public Point3f[] getLeadMidpoints() {
        if (this.leadMidpoints == null) {
            this.calcLeadMidpointsAndWingVectors(true);
        }
        return this.leadMidpoints;
    }

    Point3f[] getLeadPoints() {
        if (this.leadPoints == null) {
            this.calcLeadMidpointsAndWingVectors(true);
        }
        return this.leadPoints;
    }

    public Point3f[] getControlPoints(boolean bl, float f, boolean bl2) {
        if (bl2) {
            this.sheetPoints = null;
        }
        if (!bl) {
            return this.leadMidpoints;
        }
        if (f == 0.0f) {
            return this.leadPoints;
        }
        return this.getSheetPoints(f);
    }

    private Point3f[] getSheetPoints(float f) {
        if (this.sheetPoints != null && f == this.sheetSmoothing) {
            return this.sheetPoints;
        }
        this.sheetPoints = new Point3f[this.monomerCount + 1];
        this.getLeadPoints();
        for (int i = 0; i < this.monomerCount; ++i) {
            this.sheetPoints[i] = new Point3f();
        }
        Vector3f vector3f = new Vector3f();
        for (int i = 0; i < this.monomerCount; ++i) {
            if (this.monomers[i].isSheet()) {
                vector3f.sub(this.leadMidpoints[i], this.leadPoints[i]);
                vector3f.scale(f);
                this.sheetPoints[i].add(this.leadPoints[i], vector3f);
                continue;
            }
            this.sheetPoints[i] = this.leadPoints[i];
        }
        this.sheetPoints[this.monomerCount] = this.sheetPoints[this.monomerCount - 1];
        this.sheetSmoothing = f;
        return this.sheetPoints;
    }

    public final Vector3f[] getWingVectors() {
        if (this.leadMidpoints == null) {
            this.calcLeadMidpointsAndWingVectors(true);
        }
        return this.wingVectors;
    }

    private final void calcLeadMidpointsAndWingVectors(boolean bl) {
        Point3f point3f;
        int n = this.monomerCount;
        if (this.leadMidpoints == null || bl) {
            this.leadMidpoints = new Point3f[n + 1];
            this.leadPoints = new Point3f[n + 1];
            this.wingVectors = new Vector3f[n + 1];
            this.sheetSmoothing = Float.MIN_VALUE;
        }
        boolean bl2 = this.hasWingPoints();
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        Vector3f vector3f4 = new Vector3f();
        this.leadMidpoints[0] = this.getInitiatorPoint();
        this.leadPoints[0] = point3f = this.getLeadPoint(0);
        Vector3f vector3f5 = null;
        for (int i = 1; i < n; ++i) {
            Point3f point3f2 = point3f;
            this.leadPoints[i] = point3f = this.getLeadPoint(i);
            Point3f point3f3 = new Point3f(point3f);
            point3f3.add(point3f2);
            point3f3.scale(0.5f);
            this.leadMidpoints[i] = point3f3;
            if (!bl2) continue;
            vector3f.sub(point3f, point3f2);
            vector3f2.sub(point3f2, this.getWingPoint(i - 1));
            vector3f3.cross(vector3f, vector3f2);
            vector3f4.cross(vector3f, vector3f3);
            vector3f4.normalize();
            if (vector3f5 != null && (double)vector3f5.angle(vector3f4) > 1.5707963267948966) {
                vector3f4.scale(-1.0f);
            }
            vector3f5 = this.wingVectors[i] = new Vector3f(vector3f4);
        }
        this.leadPoints[n] = this.leadMidpoints[n] = this.getTerminatorPoint();
        if (!bl2) {
            if (n < 3) {
                this.wingVectors[1] = this.unitVectorX;
            } else {
                Vector3f vector3f6 = null;
                for (int i = 1; i < n; ++i) {
                    vector3f.sub(this.leadMidpoints[i], this.leadPoints[i]);
                    vector3f2.sub(this.leadPoints[i], this.leadMidpoints[i + 1]);
                    vector3f3.cross(vector3f, vector3f2);
                    vector3f3.normalize();
                    if (vector3f6 != null && (double)vector3f6.angle(vector3f3) > 1.5707963267948966) {
                        vector3f3.scale(-1.0f);
                    }
                    vector3f6 = this.wingVectors[i] = new Vector3f(vector3f3);
                }
            }
        }
        this.wingVectors[0] = this.wingVectors[1];
        this.wingVectors[n] = this.wingVectors[n - 1];
    }

    public void findNearestAtomIndex(int n, int n2, Atom[] atomArray, short[] sArray, int n3) {
        int n4 = this.monomerCount;
        while (--n4 >= 0) {
            if ((this.monomers[n4].shapeVisibilityFlags & n3) == 0 || !this.monomers[n4].getLeadAtom().isVisible(0) || sArray[n4] <= 0 && sArray[n4 + 1] <= 0) continue;
            this.monomers[n4].findNearestAtomIndex(n, n2, atomArray, sArray[n4], sArray[n4 + 1]);
        }
    }

    int getSelectedMonomerCount() {
        return this.selectedMonomerCount;
    }

    public void calcSelectedMonomersCount(BitSet bitSet) {
        this.selectedMonomerCount = 0;
        if (this.bsSelectedMonomers == null) {
            this.bsSelectedMonomers = new BitSet();
        }
        BitSetUtil.clear(this.bsSelectedMonomers);
        for (int i = 0; i < this.monomerCount; ++i) {
            if (!this.monomers[i].isSelected(bitSet)) continue;
            ++this.selectedMonomerCount;
            this.bsSelectedMonomers.set(i);
        }
    }

    boolean isMonomerSelected(int n) {
        return n >= 0 && this.bsSelectedMonomers.get(n);
    }

    public int getPolymerPointsAndVectors(int n, BitSet bitSet, Vector vector, boolean bl, float f) {
        Point3f[] point3fArray = this.getControlPoints(bl, f, false);
        Vector3f[] vector3fArray = this.getWingVectors();
        int n2 = this.monomerCount;
        for (int i = 0; i < n2; ++i) {
            if (bitSet.get(this.monomers[i].getLeadAtomIndex())) {
                vector.addElement(new Point3f[]{point3fArray[i], new Point3f(vector3fArray[i])});
                n = i;
                continue;
            }
            if (n == 0x7FFFFFFE) continue;
            vector.addElement(new Point3f[]{point3fArray[i], new Point3f(vector3fArray[i])});
            n = 0x7FFFFFFE;
        }
        if (n + 1 < n2) {
            vector.addElement(new Point3f[]{point3fArray[n + 1], new Point3f(vector3fArray[n + 1])});
        }
        return n;
    }

    public String getSequence() {
        char[] cArray = new char[this.monomerCount];
        for (int i = 0; i < this.monomerCount; ++i) {
            cArray[i] = this.monomers[i].getGroup1();
        }
        return String.valueOf(cArray);
    }

    public Hashtable getPolymerInfo(BitSet bitSet) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Vector<Hashtable> vector = new Vector<Hashtable>();
        Vector<Hashtable<String, Integer>> vector2 = null;
        ProteinStructure proteinStructure = null;
        int n = 0;
        for (int i = 0; i < this.monomerCount; ++i) {
            if (!bitSet.get(this.monomers[i].getLeadAtomIndex())) continue;
            Hashtable hashtable2 = this.monomers[i].getMyInfo();
            hashtable2.put("monomerIndex", new Integer(i));
            vector.addElement(hashtable2);
            ProteinStructure proteinStructure2 = this.getProteinStructure(i);
            if (proteinStructure2 == null || proteinStructure2 == proteinStructure) continue;
            Hashtable<String, Integer> hashtable3 = new Hashtable<String, Integer>();
            proteinStructure = proteinStructure2;
            proteinStructure.getInfo(hashtable3);
            if (vector2 == null) {
                vector2 = new Vector<Hashtable<String, Integer>>();
            }
            hashtable3.put("index", new Integer(n++));
            vector2.addElement(hashtable3);
        }
        if (vector.size() > 0) {
            hashtable.put("sequence", this.getSequence());
            hashtable.put("monomers", vector);
            if (vector2 != null) {
                hashtable.put("structures", vector2);
            }
        }
        return hashtable;
    }

    public void getPolymerSequenceAtoms(int n, int n2, int n3, int n4, BitSet bitSet, BitSet bitSet2) {
        int n5 = n3 + n4;
        for (int i = n3; i < this.monomerCount && i < n5; ++i) {
            this.monomers[i].getMonomerSequenceAtoms(bitSet, bitSet2);
        }
    }

    public ProteinStructure getProteinStructure(int n) {
        return this.monomers[n].getProteinStructure();
    }

    protected boolean calcPhiPsiAngles() {
        return false;
    }

    public static final void getPdbData(BioPolymer bioPolymer, char c, char c2, int n, int n2, boolean bl, BitSet bitSet, StringBuffer stringBuffer, StringBuffer stringBuffer2, BitSet bitSet2, boolean bl2, BitSet bitSet3) {
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6 = c2 == 'C' || c2 == 'P';
        boolean bl7 = bl5 = c == 'R' || c == 'S' && bl6;
        if (bl5 && !bioPolymer.calcPhiPsiAngles()) {
            return;
        }
        boolean bl8 = bioPolymer instanceof AminoPolymer;
        boolean bl9 = c == 'r';
        boolean bl10 = bl4 = !bl5 && c == 'S';
        if (n2 == 2 && bl9) {
            c = (char)119;
        }
        if (bl4) {
            n2 = 2;
        }
        boolean bl11 = c == 'S';
        boolean bl12 = bl3 = "rcpCP".indexOf(c2) >= 0;
        if (Logger.debugging && (bl4 || bl6)) {
            Logger.debug("For straightness calculation: useQuaternionStraightness = " + bl11 + " and quaternionFrame = " + c2);
        }
        if (bl2 && !bl) {
            stringBuffer.append("REMARK   6    AT GRP CH RESNO  ");
            switch (c) {
                default: {
                    stringBuffer.append("x*10___ y*10___ z*10___      w*10__       ");
                    break;
                }
                case 'x': {
                    stringBuffer.append("y*10___ z*10___ w*10___      x*10__       ");
                    break;
                }
                case 'y': {
                    stringBuffer.append("z*10___ w*10___ x*10___      y*10__       ");
                    break;
                }
                case 'z': {
                    stringBuffer.append("w*10___ x*10___ y*10___      z*10__       ");
                    break;
                }
                case 'R': {
                    if (bl3) {
                        stringBuffer.append("phi____ psi____ theta         Straightness");
                        break;
                    }
                    stringBuffer.append("phi____ psi____ omega-180    PartialCharge");
                }
            }
            stringBuffer.append("    Sym   q0_______ q1_______ q2_______ q3_______");
            stringBuffer.append("  theta_  aaX_______ aaY_______ aaZ_______");
            if (c != 'R') {
                stringBuffer.append("  centerX___ centerY___ centerZ___");
            }
            if (c2 == 'n') {
                stringBuffer.append("  NHX_______ NHY_______ NHZ_______");
            }
            stringBuffer.append("\n\n");
        }
        int n3 = n < 1 ? 1 : n;
        for (int i = 0; i < n3; ++i) {
            BioPolymer.getData(i, n, bioPolymer, c, c2, n2, bitSet, bitSet2, bitSet3, bl, bl5, bl6, bl11, bl3, bl4, bl8, bl9, stringBuffer, stringBuffer2);
        }
    }

    private static void getData(int n, int n2, BioPolymer bioPolymer, char c, char c2, int n3, BitSet bitSet, BitSet bitSet2, BitSet bitSet3, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        String string = n3 > 0 ? "dq" + (n3 == 2 ? "2" : "") : "q";
        Atom atom = null;
        Quaternion quaternion = null;
        Quaternion quaternion2 = null;
        Quaternion quaternion3 = null;
        Quaternion quaternion4 = null;
        int n4 = Integer.MIN_VALUE;
        float f = c == 'R' ? 1.0f : 10.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        String string2 = "";
        float f6 = Float.NaN;
        float f7 = Float.NaN;
        int n5 = n2 <= 1 ? 1 : n2;
        for (int i = n; i < bioPolymer.monomerCount; i += n5) {
            Quaternion quaternion5;
            Object object;
            Monomer monomer = bioPolymer.monomers[i];
            if (bitSet != null && !bitSet.get(monomer.getLeadAtomIndex())) continue;
            Atom atom2 = monomer.getLeadAtom();
            String string3 = monomer.getUniqueID();
            if (bl2) {
                float f8;
                float f9;
                if (c == 'S') {
                    monomer.setStraightness(Float.NaN);
                }
                f2 = monomer.getPhi();
                f3 = monomer.getPsi();
                f4 = monomer.getOmega();
                if (f4 < -90.0f) {
                    f4 += 360.0f;
                }
                if (Float.isNaN(f2) || Float.isNaN(f3) || Float.isNaN(f4 -= 180.0f)) {
                    if (bitSet == null) continue;
                    bitSet.clear(atom2.getAtomIndex());
                    continue;
                }
                float f10 = f9 = bl5 ? bioPolymer.calculateRamachandranHelixAngle(i, c2) : 0.0f;
                float f11 = bl3 ? BioPolymer.getStraightness((float)Math.cos((double)(f9 / 2.0f / 180.0f) * Math.PI)) : (f8 = bl5 ? monomer.getStraightness() : 0.0f);
                if (c == 'S') {
                    monomer.setStraightness(f8);
                    continue;
                }
                if (bl) {
                    if (bitSet2 != null && !bitSet2.get(atom2.getAtomIndex())) continue;
                    object = (AminoMonomer)monomer;
                    stringBuffer.append("draw phi" + string3 + " ARROW ARC ").append(Escape.escape(((AminoMonomer)object).getNitrogenAtomPoint())).append(Escape.escape(atom2)).append(Escape.escape(((AminoMonomer)object).getCarbonylCarbonAtomPoint())).append("{" + -f2 + " " + f2 + " 0.5} \"phi = " + (int)f2 + "\"").append(" color ").append(qColor[2]).append('\n');
                    stringBuffer.append("draw psi" + string3 + " ARROW ARC ").append(Escape.escape(atom2)).append(Escape.escape(((AminoMonomer)object).getCarbonylCarbonAtomPoint())).append(Escape.escape(((AminoMonomer)object).getNitrogenAtomPoint())).append("{0 " + f3 + " 0.5} \"psi = " + (int)f3 + "\"").append(" color ").append(qColor[1]).append('\n');
                    stringBuffer.append("draw planeNCC" + string3 + " ").append(Escape.escape(((AminoMonomer)object).getNitrogenAtomPoint())).append(Escape.escape(atom2)).append(Escape.escape(((AminoMonomer)object).getCarbonylCarbonAtomPoint())).append(" color ").append(qColor[0]).append('\n');
                    stringBuffer.append("draw planeCNC" + string3 + " ").append(Escape.escape(((AminoMonomer)bioPolymer.monomers[i - 1]).getCarbonylCarbonAtomPoint())).append(Escape.escape(((AminoMonomer)object).getNitrogenAtomPoint())).append(Escape.escape(atom2)).append(" color ").append(qColor[1]).append('\n');
                    stringBuffer.append("draw planeCCN" + string3 + " ").append(Escape.escape(atom2)).append(Escape.escape(((AminoMonomer)object).getCarbonylCarbonAtomPoint())).append(Escape.escape(((AminoMonomer)bioPolymer.monomers[i + 1]).getNitrogenAtomPoint())).append(" color ").append(qColor[2]).append('\n');
                    continue;
                }
                if (Float.isNaN(f9)) {
                    string2 = "";
                    if (bl5) {
                        continue;
                    }
                } else {
                    quaternion5 = new Quaternion(new Point3f(1.0f, 0.0f, 0.0f), f9);
                    string2 = quaternion5.getInfo();
                    if (bl5) {
                        f4 = f9;
                        f5 = BioPolymer.getStraightness((float)((double)(f9 / 180.0f) * Math.PI));
                    } else {
                        f5 = atom2.getPartialCharge();
                    }
                }
            } else {
                quaternion5 = monomer.getQuaternion(c2);
                if (quaternion5 != null) {
                    quaternion5.setRef(quaternion4);
                    quaternion4 = new Quaternion(quaternion5);
                }
                if (n3 == 2) {
                    monomer.setStraightness(Float.NaN);
                }
                if (quaternion5 == null) {
                    quaternion = null;
                    quaternion4 = null;
                } else if (n3 > 0) {
                    Atom atom3 = atom2;
                    Quaternion quaternion6 = quaternion5;
                    if (quaternion == null) {
                        quaternion5 = null;
                        quaternion3 = null;
                    } else {
                        quaternion2 = bl8 ? quaternion.leftDifference(quaternion5) : quaternion5.rightDifference(quaternion);
                        if (n3 == 1) {
                            quaternion5 = quaternion2;
                        } else if (quaternion3 == null) {
                            quaternion5 = null;
                        } else {
                            quaternion5 = quaternion2.rightDifference(quaternion3);
                            f6 = BioPolymer.getQuaternionStraightness(string3, quaternion3, quaternion2);
                            f7 = BioPolymer.get3DStraightness(string3, quaternion3, quaternion2);
                            atom.getGroup().setStraightness(bl4 ? f6 : f7);
                        }
                        quaternion3 = quaternion2;
                    }
                    atom = atom3;
                    quaternion = quaternion6;
                }
                if (quaternion5 == null) {
                    n4 = Integer.MIN_VALUE;
                    continue;
                }
                switch (c) {
                    default: {
                        f2 = quaternion5.q1;
                        f3 = quaternion5.q2;
                        f4 = quaternion5.q3;
                        f5 = quaternion5.q0;
                        break;
                    }
                    case 'x': {
                        f2 = quaternion5.q0;
                        f3 = quaternion5.q1;
                        f4 = quaternion5.q2;
                        f5 = quaternion5.q3;
                        break;
                    }
                    case 'y': {
                        f2 = quaternion5.q3;
                        f3 = quaternion5.q0;
                        f4 = quaternion5.q1;
                        f5 = quaternion5.q2;
                        break;
                    }
                    case 'z': {
                        f2 = quaternion5.q2;
                        f3 = quaternion5.q3;
                        f4 = quaternion5.q0;
                        f5 = quaternion5.q1;
                    }
                }
                Point3f point3f = monomer.getQuaternionFrameCenter(c2);
                if (point3f == null) {
                    point3f = new Point3f();
                }
                if (bl) {
                    if (bitSet2 != null && !bitSet2.get(atom2.getAtomIndex())) continue;
                    int n6 = (int)(Math.acos(f5) * 360.0 / Math.PI);
                    if (n3 == 0) {
                        stringBuffer.append(quaternion5.draw(string, string3, point3f, 1.0f));
                        if (c2 == 'n' && bl7 && (object = ((AminoMonomer)monomer).getNitrogenHydrogenPoint()) != null) {
                            stringBuffer.append("draw " + string + "nh" + string3 + " width 0.1 " + Escape.escape((Tuple3f)object) + "\n");
                        }
                    }
                    if (n3 == 1) {
                        stringBuffer.append(monomer.getHelixData(4112, c2, n2)).append('\n');
                        continue;
                    }
                    stringBuffer.append("draw " + string + "a" + string3 + " VECTOR " + Escape.escape(point3f) + " {" + f2 * 2.0f + "," + f3 * 2.0f + "," + f4 * 2.0f + "}" + " \">" + n6 + "\"").append(" color ").append(qColor[n3]).append('\n');
                    continue;
                }
                string2 = quaternion5.getInfo() + TextFormat.sprintf("  %10.5p %10.5p %10.5p", new Object[]{point3f});
                if (c2 == 'n' && bl7) {
                    string2 = string2 + TextFormat.sprintf("  %10.5p %10.5p %10.5p", new Object[]{((AminoMonomer)monomer).getNitrogenHydrogenPoint()});
                } else if (n3 == 2 && !Float.isNaN(f6)) {
                    string2 = string2 + TextFormat.sprintf(" %10.5f %10.5f", new Object[]{new float[]{f6, f7}});
                }
            }
            if (stringBuffer == null) continue;
            stringBuffer.append(LabelToken.formatLabel(atom2, "ATOM  %5i %4a%1A%3n %1c%4R%1E   "));
            stringBuffer.append(TextFormat.sprintf("%8.2f%8.2f%8.2f      %6.3f          %2s    %s\n", new Object[]{atom2.getElementSymbol(false).toUpperCase(), string2, new float[]{f2 * f, f3 * f, f4 * f, f5 * f}}));
            if (n4 != Integer.MIN_VALUE) {
                stringBuffer2.append("CONECT");
                stringBuffer2.append(TextFormat.formatString("%5i", "i", n4));
                stringBuffer2.append(TextFormat.formatString("%5i", "i", atom2.getAtomNumber()));
                stringBuffer2.append('\n');
                bitSet3.set(((Monomer)atom2.getGroup()).getLeadAtomIndex());
            }
            n4 = atom2.getAtomNumber();
        }
    }

    protected float calculateRamachandranHelixAngle(int n, char c) {
        return Float.NaN;
    }

    private static float get3DStraightness(String string, Quaternion quaternion, Quaternion quaternion2) {
        return quaternion.getNormal().dot(quaternion2.getNormal());
    }

    private static float getQuaternionStraightness(String string, Quaternion quaternion, Quaternion quaternion2) {
        return BioPolymer.getStraightness(quaternion.dot(quaternion2));
    }

    private static float getStraightness(float f) {
        return (float)(1.0 - 2.0 * Math.acos(Math.abs(f)) / Math.PI);
    }
}

