/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.BitSet;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.api.SymmetryInterface;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.ModelSet;
import org.jmol.util.Point3fi;
import org.jmol.util.Quaternion;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

public final class Atom
extends Point3fi {
    private static final byte VIBRATION_VECTOR_FLAG = 1;
    private static final byte IS_HETERO_FLAG = 2;
    private static final byte FLAG_MASK = 3;
    public static final int RADIUS_MAX = 16;
    private static final int MAD_MAX = 32000;
    Group group;
    int atomIndex;
    BitSet atomSymmetry;
    int atomSite;
    private float userDefinedVanDerWaalRadius;
    private short atomicAndIsotopeNumber;
    private byte formalChargeAndFlags;
    private byte valence;
    char alternateLocationID;
    short madAtom;
    short colixAtom;
    byte paletteID = 1;
    Bond[] bonds;
    int nBondsDisplayed = 0;
    int nBackbonesDisplayed = 0;
    int clickabilityFlags;
    int shapeVisibilityFlags;
    boolean isSimple = false;

    public int getScreenRadius() {
        return this.screenDiameter / 2;
    }

    public short getMadAtom() {
        return this.madAtom;
    }

    public int getNBackbonesDisplayed() {
        return this.nBackbonesDisplayed;
    }

    public boolean isSimple() {
        return this.isSimple;
    }

    public Atom(Point3f point3f) {
        this.isSimple = true;
        this.x = point3f.x;
        this.y = point3f.y;
        this.z = point3f.z;
    }

    Atom(Viewer viewer, int n, int n2, BitSet bitSet, int n3, short s, int n4, int n5, float f, float f2, float f3, boolean bl, char c, char c2, float f4) {
        this.modelIndex = (short)n;
        this.atomSymmetry = bitSet;
        this.atomSite = n3;
        this.atomIndex = n2;
        this.atomicAndIsotopeNumber = s;
        if (bl) {
            this.formalChargeAndFlags = (byte)2;
        }
        this.setFormalCharge(n5);
        this.alternateLocationID = c2;
        this.userDefinedVanDerWaalRadius = f4;
        this.setMadAtom(viewer, n4, Float.NaN);
        this.set(f, f2, f3);
    }

    public final void setShapeVisibilityFlags(int n) {
        this.shapeVisibilityFlags = n;
    }

    public final void setShapeVisibility(int n, boolean bl) {
        this.shapeVisibilityFlags = bl ? (this.shapeVisibilityFlags |= n) : (this.shapeVisibilityFlags &= ~n);
    }

    public boolean isBonded(Atom atom) {
        if (this.bonds != null) {
            int n = this.bonds.length;
            while (--n >= 0) {
                if (this.bonds[n].getOtherAtom(this) != atom) continue;
                return true;
            }
        }
        return false;
    }

    public Bond getBond(Atom atom) {
        if (this.bonds != null) {
            int n = this.bonds.length;
            while (--n >= 0) {
                if (this.bonds[n].getOtherAtom(atom) == null) continue;
                return this.bonds[n];
            }
        }
        return null;
    }

    void addDisplayedBond(int n, boolean bl) {
        this.nBondsDisplayed += bl ? 1 : -1;
        this.setShapeVisibility(n, bl);
    }

    public void addDisplayedBackbone(int n, boolean bl) {
        this.nBackbonesDisplayed += bl ? 1 : -1;
        this.setShapeVisibility(n, bl);
    }

    void deleteBond(Bond bond) {
        int n = this.bonds.length;
        while (--n >= 0) {
            if (this.bonds[n] != bond) continue;
            this.deleteBond(n);
            return;
        }
    }

    private void deleteBond(int n) {
        int n2;
        int n3 = this.bonds.length - 1;
        if (n3 == 0) {
            this.bonds = null;
            return;
        }
        Bond[] bondArray = new Bond[n3];
        for (n2 = 0; n2 < n; ++n2) {
            bondArray[n2] = this.bonds[n2];
        }
        while (n2 < n3) {
            bondArray[n2] = this.bonds[n2 + 1];
            ++n2;
        }
        this.bonds = bondArray;
    }

    void clearBonds() {
        this.bonds = null;
    }

    int getBondedAtomIndex(int n) {
        return this.bonds[n].getOtherAtom((Atom)this).atomIndex;
    }

    public void setMadAtom(Viewer viewer, int n, float f) {
        this.madAtom = this.convertEncodedMad(viewer, n, f);
    }

    public short convertEncodedMad(Viewer viewer, int n, float f) {
        short s;
        if (Float.isNaN(f)) {
            switch (n) {
                case 0: {
                    return 0;
                }
                case -1000: {
                    int n2 = this.getBfactor100() * 10 * 2;
                    if (n2 > 4000) {
                        n2 = 4000;
                    }
                    n = n2;
                    break;
                }
                case -1001: {
                    n = this.getBondingMar() * 2;
                    break;
                }
                case -100: {
                    n = this.getVanderwaalsMad(viewer);
                    break;
                }
                default: {
                    if (n <= Short.MIN_VALUE) {
                        float f2 = 2000.0f * this.getADPMinMax(false);
                        if (n < Short.MIN_VALUE) {
                            n = (int)(f2 * (float)(Short.MIN_VALUE - n) / 100.0f);
                            break;
                        }
                        n = (int)f2;
                        break;
                    }
                    if (n < -2000) {
                        int n3 = -n / 1000 - 2;
                        n = -n % 1000;
                        n = (int)((float)n / 50.0f * (float)viewer.getVanderwaalsMar(this.atomicAndIsotopeNumber % 128, n3));
                        break;
                    }
                    if (n < 0) {
                        if ((n = -n) > 200) {
                            n = 200;
                        }
                        n = (int)((float)n / 100.0f * (float)this.getVanderwaalsMad(viewer));
                        break;
                    }
                    if (n >= Short.MAX_VALUE) {
                        float f3 = 2000.0f * this.getADPMinMax(true);
                        if (n > Short.MAX_VALUE) {
                            n = (int)(f3 * (float)(n - Short.MAX_VALUE) / 100.0f);
                            break;
                        }
                        n = (int)f3;
                        break;
                    }
                    if (n >= 10000) {
                        n = n - 10000 + this.getVanderwaalsMad(viewer);
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else if ((n = (int)(f * 2000.0f) + (n == 1 ? this.getVanderwaalsMad(viewer) : 0)) > 32000) {
            n = 32000;
        }
        if ((s = (short)n) < 0) {
            s = 0;
        }
        return s;
    }

    public float getADPMinMax(boolean bl) {
        Object[] objectArray = this.getEllipsoid();
        if (objectArray == null) {
            return 0.0f;
        }
        return ((float[])objectArray[1])[bl ? 5 : 3];
    }

    public int getRasMolRadius() {
        return Math.abs(this.madAtom / 8);
    }

    public int getCovalentBondCount() {
        if (this.bonds == null) {
            return 0;
        }
        int n = 0;
        int n2 = this.bonds.length;
        while (--n2 >= 0) {
            if ((this.bonds[n2].order & 0x3FF) == 0) continue;
            ++n;
        }
        return n;
    }

    int getCovalentHydrogenCount() {
        if (this.bonds == null) {
            return 0;
        }
        int n = 0;
        int n2 = this.bonds.length;
        while (--n2 >= 0) {
            if ((this.bonds[n2].order & 0x3FF) == 0 || this.bonds[n2].getOtherAtom(this).getElementNumber() != 1) continue;
            ++n;
        }
        return n;
    }

    public Bond[] getBonds() {
        return this.bonds;
    }

    public void setColixAtom(short s) {
        this.colixAtom = s;
    }

    public void setPaletteID(byte by) {
        this.paletteID = by;
    }

    public void setTranslucent(boolean bl, float f) {
        this.colixAtom = Graphics3D.getColixTranslucent(this.colixAtom, bl, f);
    }

    public boolean isTranslucent() {
        return Graphics3D.isColixTranslucent(this.colixAtom);
    }

    public short getElementNumber() {
        return (short)(this.atomicAndIsotopeNumber % 128);
    }

    public short getIsotopeNumber() {
        return (short)(this.atomicAndIsotopeNumber >> 7);
    }

    public short getAtomicAndIsotopeNumber() {
        return this.atomicAndIsotopeNumber;
    }

    public void setAtomicAndIsotopeNumber(int n) {
        if (n < 0 || n % 128 >= JmolConstants.elementNumberMax || n > Short.MAX_VALUE) {
            n = 0;
        }
        this.atomicAndIsotopeNumber = (short)n;
    }

    public String getElementSymbol(boolean bl) {
        return JmolConstants.elementSymbolFromNumber(bl ? this.atomicAndIsotopeNumber : this.atomicAndIsotopeNumber % 128);
    }

    public String getElementSymbol() {
        return this.getElementSymbol(true);
    }

    public char getAlternateLocationID() {
        return this.alternateLocationID;
    }

    boolean isAlternateLocationMatch(String string) {
        if (string == null) {
            return this.alternateLocationID == '\u0000';
        }
        if (string.length() != 1) {
            return false;
        }
        char c = string.charAt(0);
        return c == '*' || c == '?' && this.alternateLocationID != '\u0000' || this.alternateLocationID == c;
    }

    public boolean isHetero() {
        return (this.formalChargeAndFlags & 2) != 0;
    }

    void setFormalCharge(int n) {
        this.formalChargeAndFlags = (byte)(this.formalChargeAndFlags & 3 | (n == Integer.MIN_VALUE ? 0 : (n > 7 ? 7 : (n < -3 ? -3 : n))) << 2);
    }

    void setVibrationVector() {
        this.formalChargeAndFlags = (byte)(this.formalChargeAndFlags | 1);
    }

    public int getFormalCharge() {
        return this.formalChargeAndFlags >> 2;
    }

    public int getOccupancy100() {
        byte[] byArray = this.group.chain.modelSet.occupancies;
        return byArray == null ? 100 : byArray[this.atomIndex];
    }

    public int getBfactor100() {
        short[] sArray = this.group.chain.modelSet.bfactor100s;
        if (sArray == null) {
            return 0;
        }
        return sArray[this.atomIndex];
    }

    public boolean setRadius(float f) {
        this.userDefinedVanDerWaalRadius = f > 0.0f ? f : Float.NaN;
        return !Float.isNaN(this.userDefinedVanDerWaalRadius);
    }

    public void setValence(int n) {
        this.valence = (byte)(n < 0 ? 0 : (n < 239 ? n : 239));
    }

    public int getValence() {
        int n = this.valence;
        if (n == 0 && this.bonds != null) {
            int n2 = this.bonds.length;
            while (--n2 >= 0) {
                n += this.bonds[n2].getValence();
            }
        }
        return n;
    }

    public float getDimensionValue(int n) {
        return n == 0 ? this.x : (n == 1 ? this.y : this.z);
    }

    private int getVanderwaalsMad(Viewer viewer) {
        return Float.isNaN(this.userDefinedVanDerWaalRadius) ? viewer.getVanderwaalsMar(this.atomicAndIsotopeNumber % 128) * 2 : (int)(this.userDefinedVanDerWaalRadius * 2000.0f);
    }

    short getBondingMar() {
        return JmolConstants.getBondingMar(this.atomicAndIsotopeNumber % 128, this.getFormalCharge());
    }

    public float getVanderwaalsRadiusFloat() {
        return Float.isNaN(this.userDefinedVanDerWaalRadius) ? (float)this.group.chain.modelSet.getVanderwaalsMar(this.atomicAndIsotopeNumber % 128) / 1000.0f : this.userDefinedVanDerWaalRadius;
    }

    public float getCovalentRadiusFloat() {
        return (float)JmolConstants.getBondingMar(this.atomicAndIsotopeNumber % 128, 0) / 1000.0f;
    }

    public float getBondingRadiusFloat() {
        return (float)this.getBondingMar() / 1000.0f;
    }

    int getCurrentBondCount() {
        return this.bonds == null ? 0 : this.bonds.length;
    }

    public short getColix() {
        return this.colixAtom;
    }

    public byte getPaletteID() {
        return this.paletteID;
    }

    public float getRadius() {
        return Math.abs((float)this.madAtom / 2000.0f);
    }

    public int getAtomIndex() {
        return this.atomIndex;
    }

    public int getAtomSite() {
        return this.atomSite;
    }

    public BitSet getAtomSymmetry() {
        return this.atomSymmetry;
    }

    void setGroup(Group group) {
        this.group = group;
    }

    public Group getGroup() {
        return this.group;
    }

    /*
     * Unable to fully structure code
     */
    public void transform(Viewer var1_1) {
        if ((this.formalChargeAndFlags & 1) == 0) ** GOTO lbl-1000
        var3_2 = this.group.chain.modelSet.vibrationVectors;
        if (this.group.chain.modelSet.vibrationVectors == null) lbl-1000:
        // 2 sources

        {
            var2_3 = var1_1.transformPoint(this);
        } else {
            var2_3 = var1_1.transformPoint((Point3f)this, var3_2[this.atomIndex]);
        }
        this.screenX = var2_3.x;
        this.screenY = var2_3.y;
        this.screenZ = var2_3.z;
        this.screenDiameter = var1_1.scaleToScreen(this.screenZ, Math.abs(this.madAtom));
    }

    public String getAtomName() {
        return this.group.chain.modelSet.atomNames[this.atomIndex];
    }

    public String getAtomType() {
        String[] stringArray = this.group.chain.modelSet.atomTypes;
        String string = stringArray == null ? null : stringArray[this.atomIndex];
        return string == null ? this.group.chain.modelSet.atomNames[this.atomIndex] : string;
    }

    public int getAtomNumber() {
        int[] nArray = this.group.chain.modelSet.atomSerials;
        return nArray != null ? nArray[this.atomIndex] : this.atomIndex;
    }

    public boolean isInFrame() {
        return (this.shapeVisibilityFlags & 1) != 0;
    }

    public int getShapeVisibilityFlags() {
        return this.shapeVisibilityFlags;
    }

    public boolean isShapeVisible(int n) {
        return (this.shapeVisibilityFlags & n) != 0;
    }

    public float getPartialCharge() {
        float[] fArray = this.group.chain.modelSet.partialCharges;
        return fArray == null ? 0.0f : fArray[this.atomIndex];
    }

    public float getStraightness() {
        return this.group.getStraightness();
    }

    public Object[] getEllipsoid() {
        return this.group.chain.modelSet.getEllipsoid(this.atomIndex);
    }

    public int getSymmetryTranslation(int n, int[] nArray, int n2) {
        int n3 = n;
        for (int i = 0; i < nArray.length; ++i) {
            if (!this.atomSymmetry.get(n3 += n2)) continue;
            return nArray[i];
        }
        return 0;
    }

    public int getCellTranslation(int n, int[] nArray, int n2) {
        int n3 = n2;
        for (int i = 0; i < nArray.length; ++i) {
            int n4 = 0;
            while (n4 < n2) {
                if (this.atomSymmetry.get(n3) && nArray[i] == n) {
                    return nArray[i];
                }
                ++n4;
                ++n3;
            }
        }
        return 0;
    }

    String getSymmetryOperatorList() {
        String string = "";
        ModelSet modelSet = this.group.chain.modelSet;
        int n = modelSet.getModelSymmetryCount(this.modelIndex);
        if (n == 0 || this.atomSymmetry == null) {
            return "";
        }
        int[] nArray = modelSet.getModelCellRange(this.modelIndex);
        int n2 = n;
        int n3 = nArray == null ? 1 : nArray.length;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n; ++j) {
                if (!this.atomSymmetry.get(n2++)) continue;
                string = string + "," + (j + 1) + "" + nArray[i];
            }
        }
        return string.substring(1);
    }

    public int getModelIndex() {
        return this.modelIndex;
    }

    public int getMoleculeNumber() {
        return this.group.chain.modelSet.getMoleculeIndex(this.atomIndex) + 1;
    }

    String getClientAtomStringProperty(String string) {
        Object[] objectArray = this.group.chain.modelSet.clientAtomReferences;
        return objectArray == null || objectArray.length <= this.atomIndex ? null : this.group.chain.modelSet.viewer.getClientAtomStringProperty(objectArray[this.atomIndex], string);
    }

    public byte getSpecialAtomID() {
        byte[] byArray = this.group.chain.modelSet.specialAtomIDs;
        return byArray == null ? (byte)0 : byArray[this.atomIndex];
    }

    public float getFractionalCoord(char c) {
        Point3f point3f = this.getFractionalCoord();
        return c == 'X' ? point3f.x : (c == 'Y' ? point3f.y : point3f.z);
    }

    public float getFractionalUnitCoord(char c) {
        Point3f point3f = this.getFractionalUnitCoord(false);
        return c == 'X' ? point3f.x : (c == 'Y' ? point3f.y : point3f.z);
    }

    public Point3f getFractionalCoord() {
        SymmetryInterface[] symmetryInterfaceArray = this.group.chain.modelSet.unitCells;
        Point3f point3f = new Point3f(this);
        if (symmetryInterfaceArray != null) {
            symmetryInterfaceArray[this.modelIndex].toFractional(point3f);
        }
        return point3f;
    }

    public Point3f getFractionalUnitCoord(boolean bl) {
        SymmetryInterface[] symmetryInterfaceArray = this.group.chain.modelSet.unitCells;
        Point3f point3f = new Point3f(this);
        if (symmetryInterfaceArray != null) {
            symmetryInterfaceArray[this.modelIndex].toUnitCell(point3f, null);
            if (!bl) {
                symmetryInterfaceArray[this.modelIndex].toFractional(point3f);
            }
        }
        return point3f;
    }

    public float getFractionalUnitDistance(Point3f point3f, Point3f point3f2, Point3f point3f3) {
        SymmetryInterface[] symmetryInterfaceArray = this.group.chain.modelSet.unitCells;
        if (symmetryInterfaceArray == null) {
            return this.distance(point3f);
        }
        point3f2.set(this);
        symmetryInterfaceArray[this.modelIndex].toUnitCell(point3f2, null);
        point3f3.set(point3f);
        symmetryInterfaceArray[this.modelIndex].toUnitCell(point3f3, null);
        return point3f2.distance(point3f3);
    }

    void setFractionalCoord(int n, float f) {
        SymmetryInterface[] symmetryInterfaceArray = this.group.chain.modelSet.unitCells;
        if (symmetryInterfaceArray != null) {
            symmetryInterfaceArray[this.modelIndex].toFractional(this);
        }
        switch (n) {
            case 38797574: {
                this.x = f;
                break;
            }
            case 38797575: {
                this.y = f;
                break;
            }
            case 38797576: {
                this.z = f;
            }
        }
        if (symmetryInterfaceArray != null) {
            symmetryInterfaceArray[this.modelIndex].toCartesian(this);
        }
    }

    void setFractionalCoord(Point3f point3f) {
        this.set(point3f);
        SymmetryInterface[] symmetryInterfaceArray = this.group.chain.modelSet.unitCells;
        if (symmetryInterfaceArray != null) {
            symmetryInterfaceArray[this.modelIndex].toCartesian(this);
        }
    }

    boolean isCursorOnTopOf(int n, int n2, int n3, Atom atom) {
        int n4;
        int n5;
        int n6;
        int n7 = this.screenDiameter / 2;
        if (n7 < n3) {
            n7 = n3;
        }
        if ((n6 = (n5 = this.screenX - n) * n5) > (n4 = n7 * n7)) {
            return false;
        }
        int n8 = this.screenY - n2;
        int n9 = n8 * n8;
        int n10 = n4 - (n6 + n9);
        if (n10 < 0) {
            return false;
        }
        if (atom == null) {
            return true;
        }
        int n11 = this.screenZ;
        int n12 = atom.screenZ;
        int n13 = atom.screenDiameter / 2;
        if (n11 < n12 - n13) {
            return true;
        }
        int n14 = atom.screenX - n;
        int n15 = n14 * n14;
        int n16 = atom.screenY - n2;
        int n17 = n16 * n16;
        int n18 = n13 * n13;
        int n19 = n18 - (n15 + n17);
        return (double)n11 - Math.sqrt(n10) < (double)n12 - Math.sqrt(n19);
    }

    public String getInfo() {
        return this.getIdentity(true);
    }

    String getInfoXYZ(boolean bl) {
        if (bl) {
            String string = this.getGroup3(true);
            char c = this.getChainID();
            Point3f point3f = this.group.chain.modelSet.unitCells == null ? null : this.getFractionalCoord();
            return "Atom: " + (string == null ? this.getElementSymbol() : this.getAtomName()) + " " + this.getAtomNumber() + (string != null && string.length() > 0 ? (this.isHetero() ? " Hetero: " : " Group: ") + string + " " + this.getResno() + (c != '\u0000' && c != ' ' ? " Chain: " + c : "") : "") + " Model: " + this.getModelNumber() + " Coordinates: " + this.x + " " + this.y + " " + this.z + (point3f == null ? "" : " Fractional: " + point3f.x + " " + point3f.y + " " + point3f.z);
        }
        return this.getIdentity(true) + " " + this.x + " " + this.y + " " + this.z;
    }

    String getIdentityXYZ() {
        return this.getIdentity(false) + " " + this.x + " " + this.y + " " + this.z;
    }

    String getIdentity(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getGroup3(true);
        String string2 = this.getSeqcodeString();
        char c = this.getChainID();
        if (string != null && string.length() > 0) {
            stringBuffer.append("[");
            stringBuffer.append(string);
            stringBuffer.append("]");
        }
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        if (c != '\u0000' && c != ' ') {
            stringBuffer.append(":");
            stringBuffer.append(c);
        }
        if (!bl) {
            return stringBuffer.toString();
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.append(".");
        }
        stringBuffer.append(this.getAtomName());
        if (stringBuffer.length() == 0) {
            stringBuffer.append(this.getElementSymbol(false));
            stringBuffer.append(" ");
            stringBuffer.append(this.getAtomNumber());
        }
        if (this.alternateLocationID != '\u0000') {
            stringBuffer.append("%");
            stringBuffer.append(this.alternateLocationID);
        }
        if (this.group.chain.modelSet.getModelCount() > 1) {
            stringBuffer.append("/");
            stringBuffer.append(this.getModelNumberForLabel());
        }
        stringBuffer.append(" #");
        stringBuffer.append(this.getAtomNumber());
        return stringBuffer.toString();
    }

    public int getGroupIndex() {
        return this.group.getGroupIndex();
    }

    public String getGroup3(boolean bl) {
        String string = this.group.getGroup3();
        return bl || string != null || string.length() > 0 ? string : "UNK";
    }

    public String getGroup1(char c) {
        char c2 = this.group.getGroup1();
        return c2 != '\u0000' ? "" + c2 : (c != '\u0000' ? "" + c : "");
    }

    boolean isGroup3(String string) {
        return this.group.isGroup3(string);
    }

    boolean isProtein() {
        return this.group.isProtein();
    }

    boolean isCarbohydrate() {
        return this.group.isCarbohydrate();
    }

    boolean isNucleic() {
        return this.group.isNucleic();
    }

    boolean isDna() {
        return this.group.isDna();
    }

    boolean isRna() {
        return this.group.isRna();
    }

    boolean isPurine() {
        return this.group.isPurine();
    }

    boolean isPyrimidine() {
        return this.group.isPyrimidine();
    }

    int getSeqcode() {
        return this.group.getSeqcode();
    }

    public int getResno() {
        return this.group.getResno();
    }

    public boolean isClickable() {
        if (!this.isVisible(0)) {
            return false;
        }
        int n = this.shapeVisibilityFlags | this.group.shapeVisibilityFlags;
        return (n & this.clickabilityFlags) != 0;
    }

    public int getClickabilityFlags() {
        return this.clickabilityFlags;
    }

    public void setClickable(int n) {
        this.clickabilityFlags = n == 0 ? 0 : (this.clickabilityFlags |= n);
    }

    public boolean isVisible(int n) {
        if (!this.isInFrame() || this.group.chain.modelSet.isAtomHidden(this.atomIndex)) {
            return false;
        }
        if (n != 0) {
            return this.isShapeVisible(n);
        }
        n = this.shapeVisibilityFlags;
        if (this.group.shapeVisibilityFlags != JmolConstants.BACKBONE_VISIBILITY_FLAG || this.group.isLeadAtom(this.atomIndex)) {
            n |= this.group.shapeVisibilityFlags;
        }
        return (n & 0xFFFFFFFE) != 0;
    }

    public float getGroupPhi() {
        return this.group.phi;
    }

    public float getGroupPsi() {
        return this.group.psi;
    }

    public char getChainID() {
        return this.group.chain.chainID;
    }

    public int getSurfaceDistance100() {
        return this.group.chain.modelSet.getSurfaceDistance100(this.atomIndex);
    }

    public Vector3f getVibrationVector() {
        return this.group.chain.modelSet.getVibrationVector(this.atomIndex, false);
    }

    public float getVibrationCoord(char c) {
        return this.group.chain.modelSet.getVibrationCoord(this.atomIndex, c);
    }

    public int getPolymerLength() {
        return this.group.getBioPolymerLength();
    }

    public Quaternion getQuaternion(char c) {
        return this.group.getQuaternion(c);
    }

    int getPolymerIndex() {
        return this.group.getBioPolymerIndex();
    }

    public int getSelectedGroupCountWithinChain() {
        return this.group.chain.getSelectedGroupCount();
    }

    public int getSelectedGroupIndexWithinChain() {
        return this.group.getSelectedGroupIndex();
    }

    public int getSelectedMonomerCountWithinPolymer() {
        return this.group.getSelectedMonomerCount();
    }

    public int getSelectedMonomerIndexWithinPolymer() {
        return this.group.getSelectedMonomerIndex();
    }

    Chain getChain() {
        return this.group.chain;
    }

    String getModelNumberForLabel() {
        return this.group.chain.modelSet.getModelNumberForAtomLabel(this.modelIndex);
    }

    public int getModelNumber() {
        return this.group.chain.modelSet.getModelNumber(this.modelIndex) % 1000000;
    }

    public int getModelFileIndex() {
        return this.group.chain.model.fileIndex;
    }

    public int getModelFileNumber() {
        return this.group.chain.modelSet.getModelFileNumber(this.modelIndex);
    }

    public byte getProteinStructureType() {
        return this.group.getProteinStructureType();
    }

    public int getStrucNo() {
        return this.group.getStrucNo();
    }

    public String getStructureId() {
        return this.group.getStructureId();
    }

    public String getProteinStructureTag() {
        return this.group.getProteinStructureTag();
    }

    public short getGroupID() {
        return this.group.groupID;
    }

    String getSeqcodeString() {
        return this.group.getSeqcodeString();
    }

    int getSeqNumber() {
        return this.group.getSeqNumber();
    }

    public char getInsertionCode() {
        return this.group.getInsertionCode();
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int hashCode() {
        return this.atomIndex;
    }

    public Atom findAromaticNeighbor(BitSet bitSet) {
        if (this.bonds == null) {
            return null;
        }
        int n = this.bonds.length;
        while (--n >= 0) {
            Bond bond = this.bonds[n];
            Atom atom = bond.getOtherAtom(this);
            if (!bond.isAromatic() || bitSet != null && bitSet.get(atom.atomIndex)) continue;
            return atom;
        }
        return null;
    }

    public Atom findAromaticNeighbor(int n) {
        if (this.bonds == null) {
            return null;
        }
        int n2 = this.bonds.length;
        while (--n2 >= 0) {
            Bond bond = this.bonds[n2];
            Atom atom = bond.getOtherAtom(this);
            if (!bond.isAromatic() || atom.atomIndex == n) continue;
            return atom;
        }
        return null;
    }

    public static int atomPropertyInt(Atom atom, int n) {
        switch (n) {
            case 0x1500001: {
                return atom.getAtomNumber();
            }
            case 22020098: {
                return atom.getSpecialAtomID();
            }
            case 22020099: {
                return atom.getAtomIndex();
            }
            case 22020100: {
                return atom.getCovalentBondCount();
            }
            case 558895366: {
                return atom.group.chain.modelSet.viewer.getColixArgb(atom.getColix());
            }
            case 13631749: 
            case 22020359: {
                return atom.getElementNumber();
            }
            case 156242439: {
                return atom.getModelFileIndex() + 1;
            }
            case 558891272: {
                return atom.getFormalCharge();
            }
            case 22020105: {
                return atom.getGroupID();
            }
            case 22020106: {
                return atom.getGroupIndex();
            }
            case 22024203: {
                return atom.getModelNumber();
            }
            case -22024203: {
                return atom.getModelFileNumber();
            }
            case 22020108: {
                return atom.modelIndex;
            }
            case 22020109: {
                return atom.getMoleculeNumber();
            }
            case 55574786: {
                return atom.getOccupancy100();
            }
            case 22020110: {
                return atom.getPolymerLength();
            }
            case 592445697: {
                return atom.getRasMolRadius();
            }
            case 22020111: {
                return atom.getResno();
            }
            case 0x1500010: {
                return atom.getAtomSite();
            }
            case 30412803: {
                return atom.getProteinStructureType();
            }
            case 22020114: {
                return atom.getStrucNo();
            }
            case 22020372: {
                return atom.getValence();
            }
        }
        return 0;
    }

    public static float atomPropertyFloat(Atom atom, int n) {
        switch (n) {
            case 592445697: {
                return atom.getRadius();
            }
            case 38797328: {
                atom.group.chain.modelSet.getSurfaceDistanceMax();
                return (float)atom.getSurfaceDistance100() / 100.0f;
            }
            case 38797585: {
                return (float)atom.getBfactor100() / 100.0f;
            }
            case 38797313: {
                return atom.getADPMinMax(true);
            }
            case 0x2500002: {
                return atom.getADPMinMax(false);
            }
            case 38797571: {
                return atom.x;
            }
            case 38797572: {
                return atom.y;
            }
            case 38797573: {
                return atom.z;
            }
            case 0x2500005: {
                return atom.getCovalentRadiusFloat();
            }
            case 38797574: {
                return atom.getFractionalCoord('X');
            }
            case 38797575: {
                return atom.getFractionalCoord('Y');
            }
            case 38797576: {
                return atom.getFractionalCoord('Z');
            }
            case 38797321: {
                return atom.getBondingRadiusFloat();
            }
            case 55574786: {
                return (float)atom.getOccupancy100() / 100.0f;
            }
            case 38797578: {
                return atom.getPartialCharge();
            }
            case 38797323: {
                return atom.getGroupPhi();
            }
            case 38797324: {
                return atom.getGroupPsi();
            }
            case 39325966: {
                return atom.getRadius();
            }
            case 38797327: {
                return atom.getStraightness();
            }
            case 38797330: {
                return atom.getFractionalUnitCoord('X');
            }
            case 38797331: {
                return atom.getFractionalUnitCoord('Y');
            }
            case 38797332: {
                return atom.getFractionalUnitCoord('Z');
            }
            case 38797589: {
                return atom.getVanderwaalsRadiusFloat();
            }
            case 38797590: {
                return atom.getVibrationCoord('X');
            }
            case 38797591: {
                return atom.getVibrationCoord('Y');
            }
            case 38797592: {
                return atom.getVibrationCoord('Z');
            }
        }
        return Atom.atomPropertyInt(atom, n);
    }

    public static String atomPropertyString(Atom atom, int n) {
        switch (n) {
            case 0xD00003: {
                char c = atom.getAlternateLocationID();
                return c == '\u0000' ? "" : "" + c;
            }
            case 13631746: {
                return atom.getAtomName();
            }
            case 0xD00101: {
                return atom.getAtomType();
            }
            case 0xD00004: {
                char c = atom.getChainID();
                return c == '\u0000' ? "" : "" + c;
            }
            case 0xD00008: {
                return atom.getGroup1('?');
            }
            case 0xD00007: {
                return atom.getGroup1('\u0000');
            }
            case 0xD00006: {
                return atom.getGroup3(false);
            }
            case 13631749: {
                return atom.getElementSymbol(true);
            }
            case 0xD00009: {
                return atom.getIdentity(true);
            }
            case 0xD0000A: {
                char c = atom.getInsertionCode();
                return c == '\u0000' ? "" : "" + c;
            }
            case 214958338: 
            case 752374019: {
                String string = atom.group.chain.modelSet.getAtomLabel(atom.getAtomIndex());
                if (string == null) {
                    string = "";
                }
                return string;
            }
            case 30412803: {
                return JmolConstants.getProteinStructureName(atom.getProteinStructureType());
            }
            case 0xD0000B: {
                return atom.getStructureId();
            }
            case 13631756: {
                return atom.getElementSymbol(false);
            }
            case 0xF0000D: {
                return atom.getSymmetryOperatorList();
            }
        }
        return "";
    }

    public static Tuple3f atomPropertyTuple(Atom atom, int n) {
        switch (n) {
            case 72352011: {
                return atom.getFractionalCoord();
            }
            case 72351756: {
                return atom.getFractionalUnitCoord(false);
            }
            case 72352013: {
                Vector3f vector3f = atom.getVibrationVector();
                if (vector3f == null) {
                    vector3f = new Vector3f();
                }
                return vector3f;
            }
            case 72352010: {
                return atom;
            }
            case 558895366: {
                return Graphics3D.colorPointFromInt2(atom.group.chain.modelSet.viewer.getColixArgb(atom.getColix()));
            }
        }
        return null;
    }

    boolean isWithinStructure(byte by) {
        return this.group.isWithinStructure(by);
    }
}

