/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import java.util.Vector;
import org.jmol.minimize.MinAtom;
import org.jmol.minimize.MinBond;
import org.jmol.minimize.Util;
import org.jmol.minimize.forcefield.Calculation;
import org.jmol.minimize.forcefield.Calculations;
import org.jmol.minimize.forcefield.FFParam;
import org.jmol.minimize.forcefield.ForceField;
import org.jmol.util.TextFormat;

class CalculationsUFF
extends Calculations {
    public static final int PAR_R = 0;
    public static final int PAR_THETA = 1;
    public static final int PAR_X = 2;
    public static final int PAR_D = 3;
    public static final int PAR_ZETA = 4;
    public static final int PAR_Z = 5;
    public static final int PAR_V = 6;
    public static final int PAR_U = 7;
    public static final int PAR_XI = 8;
    public static final int PAR_HARD = 9;
    public static final int PAR_RADIUS = 10;
    DistanceCalc bondCalc = new DistanceCalc();
    AngleCalc angleCalc = new AngleCalc();
    TorsionCalc torsionCalc = new TorsionCalc();
    OOPCalc oopCalc = new OOPCalc();
    VDWCalc vdwCalc = new VDWCalc();
    ESCalc esCalc = new ESCalc();
    static final double KCAL644 = 2696.8016159999997;
    static final double KCAL6 = 25.1208;
    static final double KCAL22 = 92.1096;
    static final double KCAL44 = 184.2192;
    static final double KCAL332 = 1390.2842991599998;

    CalculationsUFF(ForceField forceField, MinAtom[] minAtomArray, MinBond[] minBondArray, int[][] nArray, int[][] nArray2, double[] dArray, Vector vector) {
        super(forceField, minAtomArray, minBondArray, nArray, nArray2, dArray, vector);
    }

    String getUnit() {
        return "kJ/mol";
    }

    boolean setupCalculations() {
        DistanceCalc distanceCalc = new DistanceCalc();
        Vector vector = this.calculations[0] = new Vector();
        for (int i = 0; i < this.bondCount; ++i) {
            MinBond minBond = this.bonds[i];
            double d = minBond.atomIndexes[2];
            if (minBond.isAromatic) {
                d = 1.5;
            }
            if (minBond.isAmide) {
                d = 1.41;
            }
            distanceCalc.setData(vector, minBond.atomIndexes[0], minBond.atomIndexes[1], d);
        }
        this.calculations[1] = new Vector();
        vector = this.calculations[1];
        AngleCalc angleCalc = new AngleCalc();
        int n = this.angles.length;
        while (--n >= 0) {
            angleCalc.setData(vector, n);
        }
        this.calculations[2] = new Vector();
        vector = this.calculations[2];
        TorsionCalc torsionCalc = new TorsionCalc();
        int n2 = this.torsions.length;
        while (--n2 >= 0) {
            torsionCalc.setData(vector, n2);
        }
        this.calculations[3] = new Vector();
        vector = this.calculations[3];
        OOPCalc oOPCalc = new OOPCalc();
        for (int i = 0; i < this.atomCount; ++i) {
            short s;
            MinAtom minAtom = this.atoms[i];
            if (minAtom.nBonds != 3 || !this.isInvertible(s = minAtom.atom.getElementNumber())) continue;
            oOPCalc.setData(vector, i, s);
        }
        this.calculations[4] = new Vector();
        this.pairSearch(this.calculations[4], new VDWCalc());
        return true;
    }

    private boolean isInvertible(int n) {
        switch (n) {
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 33: 
            case 51: 
            case 83: {
                return true;
            }
        }
        return false;
    }

    private void pairSearch(Vector vector, PairCalc pairCalc) {
        for (int i = 0; i < this.atomCount - 1; ++i) {
            MinAtom minAtom = this.atoms[i];
            int[] nArray = minAtom.getBondedAtomIndexes();
            block1: for (int j = i + 1; j < this.atomCount; ++j) {
                MinAtom minAtom2 = this.atoms[j];
                int n = nArray.length;
                while (--n >= 0) {
                    MinAtom minAtom3 = this.atoms[nArray[n]];
                    if (minAtom3 == minAtom2) continue block1;
                    if (minAtom3.nBonds == 1) continue;
                    int[] nArray2 = minAtom3.getBondedAtomIndexes();
                    int n2 = nArray2.length;
                    while (--n2 >= 0) {
                        MinAtom minAtom4 = this.atoms[nArray2[n2]];
                        if (minAtom4 != minAtom2) continue;
                        continue block1;
                    }
                }
                pairCalc.setData(vector, i, j);
            }
        }
    }

    boolean setupElectrostatics() {
        if (this.partialCharges == null) {
            return true;
        }
        this.calculations[5] = new Vector();
        this.pairSearch(this.calculations[5], new ESCalc());
        return true;
    }

    static double calculateR0(double d, double d2, double d3, double d4, double d5) {
        double d6 = -0.1332 * (d + d2) * Math.log(d5);
        double d7 = Math.sqrt(d3) - Math.sqrt(d4);
        double d8 = d * d2 * d7 * d7 / (d3 * d + d4 * d2);
        return d + d2 + d6 - d8;
    }

    double compute(int n, Object[] objectArray) {
        switch (n) {
            case 0: {
                return this.bondCalc.compute(objectArray);
            }
            case 1: {
                return this.angleCalc.compute(objectArray);
            }
            case 2: {
                return this.torsionCalc.compute(objectArray);
            }
            case 3: {
                return this.oopCalc.compute(objectArray);
            }
            case 4: {
                return this.vdwCalc.compute(objectArray);
            }
            case 5: {
                return this.esCalc.compute(objectArray);
            }
        }
        return 0.0;
    }

    String getAtomList(String string) {
        String string2 = "-----------------------------------------------------------------------------------------------\n";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n" + string + "\n\n" + " ATOM    X        Y        Z    TYPE     GRADX    GRADY    GRADZ  " + "---------BONDED ATOMS--------\n" + string2);
        for (int i = 0; i < this.atomCount; ++i) {
            MinAtom minAtom = this.atoms[i];
            int[] nArray = minAtom.getBondedAtomIndexes();
            int[] nArray2 = new int[nArray.length + 1];
            nArray2[0] = minAtom.atom.getAtomNumber();
            String string3 = "   ";
            for (int j = 0; j < nArray.length; ++j) {
                string3 = string3 + " %3d";
                nArray2[j + 1] = this.atoms[nArray[j]].atom.getAtomNumber();
            }
            stringBuffer.append(TextFormat.sprintf("%3d %8.3f %8.3f %8.3f  %-5s %8.3f %8.3f %8.3f" + string3 + "\n", new Object[]{minAtom.type, new float[]{(float)minAtom.coord[0], (float)minAtom.coord[1], (float)minAtom.coord[2], (float)minAtom.force[0], (float)minAtom.force[1], (float)minAtom.force[2]}, nArray2}));
        }
        stringBuffer.append(string2 + "\n\n");
        return stringBuffer.toString();
    }

    String getDebugHeader(int n) {
        switch (n) {
            case -1: {
                return "Universal Force Field -- Rappe, A. K., et. al.; J. Am. Chem. Soc. (1992) 114(25) p. 10024-10035\n";
            }
            case 0: {
                return "\nB O N D   S T R E T C H I N G (" + this.bondCount + " bonds)\n\n" + "  ATOMS  ATOM TYPES   BOND    BOND       IDEAL      FORCE\n" + "  I   J   I     J     TYPE   LENGTH     LENGTH    CONSTANT      DELTA     ENERGY\n" + "--------------------------------------------------------------------------------";
            }
            case 1: {
                return "\nA N G L E   B E N D I N G (" + this.angles.length + " angles)\n\n" + "    ATOMS      ATOM TYPES        VALENCE    IDEAL        FORCE\n" + "  I   J   K   I     J     K       ANGLE     ANGLE      CONSTANT     ENERGY\n" + "--------------------------------------------------------------------------";
            }
            case 2: {
                return "\nT O R S I O N A L (" + this.torsions.length + " torsions)\n\n" + "      ATOMS           ATOM TYPES             FORCE      TORSION\n" + "  I   J   K   L   I     J     K     L       CONSTANT     ANGLE        ENERGY\n" + "----------------------------------------------------------------------------";
            }
            case 3: {
                return "\nO U T - O F - P L A N E   B E N D I N G\n\n      ATOMS           ATOM TYPES             OOP        FORCE \n  I   J   K   L   I     J     K     L       ANGLE     CONSTANT      ENERGY\n--------------------------------------------------------------------------";
            }
            case 4: {
                return "\nV A N   D E R   W A A L S\n\n  ATOMS  ATOM TYPES\n  I   J   I     J      Rij       kij     ENERGY\n-----------------------------------------------";
            }
            case 5: {
                return "\nE L E C T R O S T A T I C   I N T E R A C T I O N S\n\n  ATOMS  ATOM TYPES            QiQj\n  I   J   I     J      Rij    *332.17    ENERGY\n-----------------------------------------------";
            }
        }
        return "";
    }

    String getDebugLine(int n, Calculation calculation) {
        switch (n) {
            case 0: {
                return TextFormat.sprintf("%3d %3d  %-5s %-5s  %4.2f%8.3f   %8.3f     %8.3f   %8.3f   %8.3f", new Object[]{this.atoms[calculation.ia].type, this.atoms[calculation.ib].type, new float[]{(float)calculation.dData[2], (float)calculation.rab, (float)calculation.dData[0], (float)calculation.dData[1], (float)calculation.delta, (float)calculation.energy}, new int[]{this.atoms[calculation.ia].atom.getAtomNumber(), this.atoms[calculation.ib].atom.getAtomNumber()}});
            }
            case 1: {
                return TextFormat.sprintf("%3d %3d %3d  %-5s %-5s %-5s  %8.3f  %8.3f     %8.3f   %8.3f", new Object[]{this.atoms[calculation.ia].type, this.atoms[calculation.ib].type, this.atoms[calculation.ic].type, new float[]{(float)(calculation.theta * 57.29577951308232), (float)calculation.dData[4], (float)calculation.dData[0], (float)calculation.energy}, new int[]{this.atoms[calculation.ia].atom.getAtomNumber(), this.atoms[calculation.ib].atom.getAtomNumber(), this.atoms[calculation.ic].atom.getAtomNumber()}});
            }
            case 2: {
                return TextFormat.sprintf("%3d %3d %3d %3d  %-5s %-5s %-5s %-5s  %8.3f     %8.3f     %8.3f", new Object[]{this.atoms[calculation.ia].type, this.atoms[calculation.ib].type, this.atoms[calculation.ic].type, this.atoms[calculation.id].type, new float[]{(float)calculation.dData[0], (float)(calculation.theta * 57.29577951308232), (float)calculation.energy}, new int[]{this.atoms[calculation.ia].atom.getAtomNumber(), this.atoms[calculation.ib].atom.getAtomNumber(), this.atoms[calculation.ic].atom.getAtomNumber(), this.atoms[calculation.id].atom.getAtomNumber()}});
            }
            case 3: {
                return TextFormat.sprintf("%3d %3d %3d %3d  %-5s %-5s %-5s %-5s  %8.3f   %8.3f     %8.3f", new Object[]{this.atoms[calculation.ia].type, this.atoms[calculation.ib].type, this.atoms[calculation.ic].type, this.atoms[calculation.id].type, new float[]{(float)(calculation.theta * 57.29577951308232), (float)calculation.dData[0], (float)calculation.energy}, new int[]{this.atoms[calculation.ia].atom.getAtomNumber(), this.atoms[calculation.ib].atom.getAtomNumber(), this.atoms[calculation.ic].atom.getAtomNumber(), this.atoms[calculation.id].atom.getAtomNumber()}});
            }
            case 4: {
                return TextFormat.sprintf("%3d %3d  %-5s %-5s %6.3f  %8.3f  %8.3f", new Object[]{this.atoms[calculation.iData[0]].type, this.atoms[calculation.iData[1]].type, new float[]{(float)calculation.rab, (float)calculation.dData[0], (float)calculation.energy}, new int[]{this.atoms[calculation.ia].atom.getAtomNumber(), this.atoms[calculation.ib].atom.getAtomNumber()}});
            }
            case 5: {
                return TextFormat.sprintf("%3d %3d  %-5s %-5s %6.3f  %8.3f  %8.3f", new Object[]{this.atoms[calculation.iData[0]].type, this.atoms[calculation.iData[1]].type, new float[]{(float)calculation.rab, (float)calculation.dData[0], (float)calculation.energy}, new int[]{this.atoms[calculation.ia].atom.getAtomNumber(), this.atoms[calculation.ib].atom.getAtomNumber()}});
            }
        }
        return "";
    }

    String getDebugFooter(int n, double d) {
        String string = "";
        switch (n) {
            case 0: {
                string = "BOND STRETCHING";
                break;
            }
            case 1: {
                string = "ANGLE BENDING";
                break;
            }
            case 2: {
                string = "TORSIONAL";
                break;
            }
            case 3: {
                string = "OUT-OF-PLANE BENDING";
                break;
            }
            case 4: {
                string = "VAN DER WAALS";
                break;
            }
            case 5: {
                string = "ELECTROSTATIC ENERGY";
            }
        }
        return TextFormat.sprintf("\n     TOTAL %s ENERGY = %8.3f %s\n", new Object[]{string, this.getUnit(), new Float(d)});
    }

    class ESCalc
    extends PairCalc {
        ESCalc() {
        }

        void setData(Vector vector, int n, int n2) {
            this.a = CalculationsUFF.this.atoms[n];
            this.b = CalculationsUFF.this.atoms[n2];
            double d = 1390.2842991599998 * CalculationsUFF.this.partialCharges[n] * CalculationsUFF.this.partialCharges[n2];
            if (d != 0.0) {
                vector.addElement(new Object[]{new int[]{n, n2}, new double[]{d}});
            }
        }

        double compute(Object[] objectArray) {
            this.getPointers(objectArray);
            double d = this.dData[0];
            this.ia = this.iData[0];
            this.ib = this.iData[1];
            if (CalculationsUFF.this.gradients) {
                CalculationsUFF.this.da.set(CalculationsUFF.this.atoms[this.ia].coord);
                CalculationsUFF.this.db.set(CalculationsUFF.this.atoms[this.ib].coord);
                this.rab = Util.restorativeForceAndDistance(CalculationsUFF.this.da, CalculationsUFF.this.db, CalculationsUFF.this.dc);
            } else {
                this.rab = Math.sqrt(Util.distance2(CalculationsUFF.this.atoms[this.ia].coord, CalculationsUFF.this.atoms[this.ib].coord));
            }
            if (Util.isNearZero(this.rab, 0.001)) {
                this.rab = 0.001;
            }
            this.energy = d / this.rab;
            if (CalculationsUFF.this.gradients) {
                this.dE = -d / (this.rab * this.rab);
                CalculationsUFF.this.addForce(CalculationsUFF.this.da, this.ia, this.dE);
                CalculationsUFF.this.addForce(CalculationsUFF.this.db, this.ib, this.dE);
            }
            if (CalculationsUFF.this.logging) {
                CalculationsUFF.this.appendLogData(CalculationsUFF.this.getDebugLine(5, this));
            }
            return this.energy;
        }
    }

    class VDWCalc
    extends PairCalc {
        VDWCalc() {
        }

        void setData(Vector vector, int n, int n2) {
            this.a = CalculationsUFF.this.atoms[n];
            this.b = CalculationsUFF.this.atoms[n2];
            FFParam fFParam = Calculations.getParameter(this.a.type, CalculationsUFF.this.ffParams);
            FFParam fFParam2 = Calculations.getParameter(this.b.type, CalculationsUFF.this.ffParams);
            double d = fFParam.dVal[2];
            double d2 = fFParam.dVal[3];
            double d3 = fFParam2.dVal[2];
            double d4 = fFParam2.dVal[3];
            double d5 = 4.1868 * Math.sqrt(d2 * d4);
            double d6 = Math.sqrt(d * d3);
            vector.addElement(new Object[]{new int[]{n, n2}, new double[]{d6, d5}});
        }

        double compute(Object[] objectArray) {
            this.getPointers(objectArray);
            double d = this.dData[0];
            double d2 = this.dData[1];
            this.ia = this.iData[0];
            this.ib = this.iData[1];
            if (CalculationsUFF.this.gradients) {
                CalculationsUFF.this.da.set(CalculationsUFF.this.atoms[this.ia].coord);
                CalculationsUFF.this.db.set(CalculationsUFF.this.atoms[this.ib].coord);
                this.rab = Util.restorativeForceAndDistance(CalculationsUFF.this.da, CalculationsUFF.this.db, CalculationsUFF.this.dc);
            } else {
                this.rab = Math.sqrt(Util.distance2(CalculationsUFF.this.atoms[this.ia].coord, CalculationsUFF.this.atoms[this.ib].coord));
            }
            if (Util.isNearZero(this.rab, 0.001)) {
                this.rab = 0.001;
            }
            double d3 = d / this.rab;
            double d4 = d3 * d3 * d3;
            d4 *= d4;
            this.energy = d2 * d4 * (d4 - 2.0);
            if (CalculationsUFF.this.gradients) {
                this.dE = d2 * 12.0 * (1.0 - d4) * d4 * d3 / d;
                CalculationsUFF.this.addForce(CalculationsUFF.this.da, this.ia, this.dE);
                CalculationsUFF.this.addForce(CalculationsUFF.this.db, this.ib, this.dE);
            }
            if (CalculationsUFF.this.logging) {
                CalculationsUFF.this.appendLogData(CalculationsUFF.this.getDebugLine(4, this));
            }
            return this.energy;
        }
    }

    abstract class PairCalc
    extends Calculation {
        PairCalc() {
        }

        abstract void setData(Vector var1, int var2, int var3);
    }

    class OOPCalc
    extends Calculation {
        OOPCalc() {
        }

        void setData(Vector vector, int n, int n2) {
            this.b = CalculationsUFF.this.atoms[n];
            int[] nArray = this.b.getBondedAtomIndexes();
            this.ia = nArray[0];
            this.a = CalculationsUFF.this.atoms[this.ia];
            this.ic = nArray[1];
            this.c = CalculationsUFF.this.atoms[this.ic];
            this.id = nArray[2];
            this.d = CalculationsUFF.this.atoms[this.id];
            double d = 1.0;
            double d2 = -1.0;
            double d3 = 0.0;
            double d4 = 25.1208;
            switch (n2) {
                case 6: {
                    if ((this.a.type + this.c.type + this.d.type).indexOf("O_2") < 0) break;
                    d4 += 184.2192;
                    break;
                }
                case 7: 
                case 8: {
                    break;
                }
                default: {
                    d4 = 92.1096;
                    double d5 = Math.PI / 180;
                    switch (n2) {
                        case 15: {
                            d5 *= 84.4339;
                            break;
                        }
                        case 33: {
                            d5 *= 86.9735;
                            break;
                        }
                        case 51: {
                            d5 *= 87.7047;
                            break;
                        }
                        case 83: {
                            d5 *= 90.0;
                        }
                    }
                    double d6 = Math.cos(d5);
                    d = d6 * d6;
                    d2 = -2.0 * d6;
                    d3 = 1.0;
                }
            }
            vector.addElement(new Object[]{new int[]{this.ia, n, this.ic, this.id}, new double[]{d4 /= 3.0, d, d2, d3, d4 * 10.0}});
            vector.addElement(new Object[]{new int[]{this.ic, n, this.id, this.ia}, new double[]{d4, d, d2, d3, d4 * 10.0}});
            vector.addElement(new Object[]{new int[]{this.id, n, this.ia, this.ic}, new double[]{d4, d, d2, d3, d4 * 10.0}});
        }

        double compute(Object[] objectArray) {
            this.getPointers(objectArray);
            double d = CalculationsUFF.this.isPreliminary ? this.dData[4] : this.dData[0];
            double d2 = this.dData[1];
            double d3 = this.dData[2];
            double d4 = this.dData[3];
            this.ia = this.iData[0];
            this.ib = this.iData[1];
            this.ic = this.iData[2];
            this.id = this.iData[3];
            CalculationsUFF.this.da.set(CalculationsUFF.this.atoms[this.ia].coord);
            CalculationsUFF.this.db.set(CalculationsUFF.this.atoms[this.ib].coord);
            CalculationsUFF.this.dc.set(CalculationsUFF.this.atoms[this.ic].coord);
            CalculationsUFF.this.dd.set(CalculationsUFF.this.atoms[this.id].coord);
            this.theta = CalculationsUFF.this.gradients ? Util.restorativeForceAndOutOfPlaneAngleRadians(CalculationsUFF.this.da, CalculationsUFF.this.db, CalculationsUFF.this.dc, CalculationsUFF.this.dd, CalculationsUFF.this.v1, CalculationsUFF.this.v2, CalculationsUFF.this.v3) : Util.pointPlaneAngleRadians(CalculationsUFF.this.da, CalculationsUFF.this.db, CalculationsUFF.this.dc, CalculationsUFF.this.dd, CalculationsUFF.this.v1, CalculationsUFF.this.v2, CalculationsUFF.this.v3);
            if (!Util.isFinite(this.theta)) {
                this.theta = 0.0;
            }
            double d5 = Math.cos(this.theta);
            this.energy = d * (d2 + d3 * d5 + d4 * d5 * d5);
            if (CalculationsUFF.this.gradients) {
                this.dE = d * (d3 * Math.sin(this.theta) + d4 * 2.0 * Math.sin(this.theta) * d5);
                CalculationsUFF.this.addForce(CalculationsUFF.this.da, this.ia, this.dE);
                CalculationsUFF.this.addForce(CalculationsUFF.this.db, this.ib, this.dE);
                CalculationsUFF.this.addForce(CalculationsUFF.this.dc, this.ic, this.dE);
                CalculationsUFF.this.addForce(CalculationsUFF.this.dd, this.id, this.dE);
            }
            if (CalculationsUFF.this.logging) {
                CalculationsUFF.this.appendLogData(CalculationsUFF.this.getDebugLine(3, this));
            }
            return this.energy;
        }
    }

    class TorsionCalc
    extends Calculation {
        TorsionCalc() {
        }

        void setData(Vector vector, int n) {
            int[] nArray = CalculationsUFF.this.torsions[n];
            double d = -1.0;
            int n2 = 0;
            double d2 = 0.0;
            this.ia = nArray[0];
            this.a = CalculationsUFF.this.atoms[this.ia];
            this.ib = nArray[1];
            this.b = CalculationsUFF.this.atoms[this.ib];
            this.ic = nArray[2];
            this.c = CalculationsUFF.this.atoms[this.ic];
            this.id = nArray[3];
            this.d = CalculationsUFF.this.atoms[this.id];
            MinBond minBond = this.c.getBondTo(this.ib);
            double d3 = minBond.atomIndexes[2];
            if (minBond.isAromatic) {
                d3 = 1.5;
            }
            if (minBond.isAmide) {
                d3 = 1.41;
            }
            this.parB = Calculations.getParameter(this.b.type, CalculationsUFF.this.ffParams);
            this.parC = Calculations.getParameter(this.c.type, CalculationsUFF.this.ffParams);
            switch (this.parB.iVal[0] * this.parC.iVal[0]) {
                case 9: {
                    n2 = 3;
                    double d4 = this.parB.dVal[6];
                    double d5 = this.parC.dVal[6];
                    double d6 = 0.0;
                    switch (this.b.atom.getElementNumber()) {
                        case 8: {
                            d6 = 2.0;
                            break;
                        }
                        case 16: 
                        case 34: 
                        case 52: 
                        case 84: {
                            d6 = 6.8;
                        }
                    }
                    if (d6 != 0.0) {
                        switch (this.c.atom.getElementNumber()) {
                            case 8: {
                                d4 = d6;
                                d5 = 2.0;
                                n2 = 2;
                                break;
                            }
                            case 16: 
                            case 34: 
                            case 52: 
                            case 84: {
                                d4 = d6;
                                d5 = 6.8;
                                n2 = 2;
                            }
                        }
                    }
                    d2 = 2.0934 * Math.sqrt(d4 * d5);
                    break;
                }
                case 4: {
                    d = 1.0;
                    n2 = 2;
                    d2 = 10.466999999999999 * Math.sqrt(this.parB.dVal[7] * this.parC.dVal[7]) * (1.0 + 4.18 * Math.log(d3));
                    break;
                }
                case 6: {
                    d = 1.0;
                    n2 = 6;
                    boolean bl = this.parC.iVal[0] == 3;
                    block13 : switch ((bl ? this.c : this.b).atom.getElementNumber()) {
                        case 8: 
                        case 16: 
                        case 34: 
                        case 52: 
                        case 84: {
                            switch ((bl ? this.b : this.c).atom.getElementNumber()) {
                                case 8: 
                                case 16: 
                                case 34: 
                                case 52: 
                                case 84: {
                                    break block13;
                                }
                            }
                            n2 = 2;
                            d = -1.0;
                        }
                    }
                    d2 = 2.0934;
                }
            }
            if (Util.isNearZero(d2)) {
                return;
            }
            vector.addElement(new Object[]{new int[]{this.ia, this.ib, this.ic, this.id, n2}, new double[]{d2, d}});
        }

        double compute(Object[] objectArray) {
            this.getPointers(objectArray);
            double d = this.dData[0];
            double d2 = this.dData[1];
            this.ia = this.iData[0];
            this.ib = this.iData[1];
            this.ic = this.iData[2];
            this.id = this.iData[3];
            int n = this.iData[4];
            if (CalculationsUFF.this.gradients) {
                CalculationsUFF.this.da.set(CalculationsUFF.this.atoms[this.ia].coord);
                CalculationsUFF.this.db.set(CalculationsUFF.this.atoms[this.ib].coord);
                CalculationsUFF.this.dc.set(CalculationsUFF.this.atoms[this.ic].coord);
                CalculationsUFF.this.dd.set(CalculationsUFF.this.atoms[this.id].coord);
                this.theta = Util.restorativeForceAndTorsionAngleRadians(CalculationsUFF.this.da, CalculationsUFF.this.db, CalculationsUFF.this.dc, CalculationsUFF.this.dd);
                if (!Util.isFinite(this.theta)) {
                    this.theta = 1.7453292519943296E-5;
                }
            } else {
                this.theta = Util.getTorsionAngleRadians(CalculationsUFF.this.atoms[this.ia].coord, CalculationsUFF.this.atoms[this.ib].coord, CalculationsUFF.this.atoms[this.ic].coord, CalculationsUFF.this.atoms[this.id].coord, CalculationsUFF.this.v1, CalculationsUFF.this.v2, CalculationsUFF.this.v3);
            }
            this.energy = d * (1.0 - d2 * Math.cos(this.theta * (double)n));
            if (CalculationsUFF.this.gradients) {
                this.dE = d * (double)n * d2 * Math.sin((double)n * this.theta);
                CalculationsUFF.this.addForce(CalculationsUFF.this.da, this.ia, this.dE);
                CalculationsUFF.this.addForce(CalculationsUFF.this.db, this.ib, this.dE);
                CalculationsUFF.this.addForce(CalculationsUFF.this.dc, this.ic, this.dE);
                CalculationsUFF.this.addForce(CalculationsUFF.this.dd, this.id, this.dE);
            }
            if (CalculationsUFF.this.logging) {
                CalculationsUFF.this.appendLogData(CalculationsUFF.this.getDebugLine(2, this));
            }
            return this.energy;
        }
    }

    class AngleCalc
    extends Calculation {
        AngleCalc() {
        }

        void setData(Vector vector, int n) {
            double d;
            double d2;
            double d3;
            int[] nArray = CalculationsUFF.this.angles[n];
            this.ia = nArray[0];
            this.a = CalculationsUFF.this.atoms[this.ia];
            this.ib = nArray[1];
            this.b = CalculationsUFF.this.atoms[this.ib];
            this.ic = nArray[2];
            this.c = CalculationsUFF.this.atoms[this.ic];
            boolean bl = this.a.type.equals("H_") && this.c.type.equals("H_");
            this.parA = Calculations.getParameter(this.a.type, CalculationsUFF.this.ffParams);
            this.parB = Calculations.getParameter(this.b.type, CalculationsUFF.this.ffParams);
            this.parC = Calculations.getParameter(this.c.type, CalculationsUFF.this.ffParams);
            int n2 = this.parB.iVal[0];
            double d4 = this.parA.dVal[5];
            double d5 = this.parC.dVal[5];
            double d6 = this.parB.dVal[1];
            double d7 = Math.cos(d6);
            double d8 = Math.sin(d6);
            switch (n2) {
                case 1: 
                case 2: 
                case 4: 
                case 6: {
                    d3 = 0.0;
                    d2 = 0.0;
                    d = 0.0;
                    break;
                }
                default: {
                    d3 = 1.0 / (4.0 * d8 * d8);
                    d2 = -4.0 * d3 * d7;
                    d = d3 * (2.0 * d7 * d7 + 1.0);
                }
            }
            MinBond minBond = this.a.getBondTo(this.ib);
            double d9 = minBond.atomIndexes[2];
            if (minBond.isAromatic) {
                d9 = 1.5;
            }
            if (minBond.isAmide) {
                d9 = 1.41;
            }
            this.rab = CalculationsUFF.calculateR0(this.parA.dVal[0], this.parB.dVal[0], this.parA.dVal[8], this.parB.dVal[8], d9);
            minBond = this.c.getBondTo(this.ib);
            d9 = minBond.atomIndexes[2];
            if (minBond.isAromatic) {
                d9 = 1.5;
            }
            if (minBond.isAmide) {
                d9 = 1.41;
            }
            double d10 = CalculationsUFF.calculateR0(this.parB.dVal[0], this.parC.dVal[0], this.parB.dVal[8], this.parC.dVal[8], d9);
            double d11 = Math.sqrt(this.rab * this.rab + d10 * d10 - 2.0 * this.rab * d10 * d7);
            double d12 = 2696.8016159999997 * (d4 * d5 / Math.pow(d11, 5.0)) * (3.0 * this.rab * d10 * (1.0 - d7 * d7) - d11 * d11 * d7);
            vector.addElement(new Object[]{new int[]{this.ia, this.ib, this.ic, n2}, new double[]{d12, d - d3, d2, 2.0 * d3, d6 * 57.29577951308232, bl ? d12 * 10.0 : d12}});
        }

        double compute(Object[] objectArray) {
            this.getPointers(objectArray);
            this.ia = this.iData[0];
            this.ib = this.iData[1];
            this.ic = this.iData[2];
            int n = this.iData[3];
            double d = CalculationsUFF.this.isPreliminary ? this.dData[4] : this.dData[0];
            double d2 = this.dData[1];
            double d3 = this.dData[2];
            double d4 = this.dData[3];
            if (CalculationsUFF.this.gradients) {
                CalculationsUFF.this.da.set(CalculationsUFF.this.atoms[this.ia].coord);
                CalculationsUFF.this.db.set(CalculationsUFF.this.atoms[this.ib].coord);
                CalculationsUFF.this.dc.set(CalculationsUFF.this.atoms[this.ic].coord);
                this.theta = Util.restorativeForceAndAngleRadians(CalculationsUFF.this.da, CalculationsUFF.this.db, CalculationsUFF.this.dc);
            } else {
                this.theta = Util.getAngleRadiansABC(CalculationsUFF.this.atoms[this.ia].coord, CalculationsUFF.this.atoms[this.ib].coord, CalculationsUFF.this.atoms[this.ic].coord);
            }
            if (!Util.isFinite(this.theta)) {
                this.theta = 0.0;
            }
            if ((n == 4 || n == 6) && (this.theta > 2.35619 || this.theta < 0.785398)) {
                n = 1;
            }
            double d5 = Math.cos(this.theta);
            double d6 = Math.sin(this.theta);
            switch (n) {
                case 0: 
                case 1: {
                    this.energy = d * (1.0 + d5) * (1.0 + d5) / 4.0;
                    break;
                }
                case 2: {
                    this.energy = d * (1.0 + 4.0 * d5 * (1.0 + d5)) / 9.0;
                    break;
                }
                case 4: 
                case 6: {
                    this.energy = d * d5 * d5;
                    break;
                }
                default: {
                    this.energy = d * (d2 + d3 * d5 + d4 * d5 * d5);
                }
            }
            if (CalculationsUFF.this.gradients) {
                switch (n) {
                    case 0: 
                    case 1: {
                        this.dE = -0.5 * d * d6 * (1.0 + d5);
                        break;
                    }
                    case 2: {
                        this.dE = -4.0 * d6 * d * (1.0 - 2.0 * d5) / 9.0;
                        break;
                    }
                    case 4: 
                    case 6: {
                        this.dE = -d * d6 * d5;
                        break;
                    }
                    default: {
                        this.dE = -d * (d3 * d6 - 2.0 * d4 * d5 * d6);
                    }
                }
                CalculationsUFF.this.addForce(CalculationsUFF.this.da, this.ia, this.dE);
                CalculationsUFF.this.addForce(CalculationsUFF.this.db, this.ib, this.dE);
                CalculationsUFF.this.addForce(CalculationsUFF.this.dc, this.ic, this.dE);
            }
            if (CalculationsUFF.this.logging) {
                CalculationsUFF.this.appendLogData(CalculationsUFF.this.getDebugLine(1, this));
            }
            return this.energy;
        }
    }

    class DistanceCalc
    extends Calculation {
        double r0;
        double kb;

        DistanceCalc() {
        }

        void setData(Vector vector, int n, int n2, double d) {
            this.parA = Calculations.getParameter(CalculationsUFF.this.atoms[n].type, CalculationsUFF.this.ffParams);
            this.parB = Calculations.getParameter(CalculationsUFF.this.atoms[n2].type, CalculationsUFF.this.ffParams);
            this.r0 = CalculationsUFF.calculateR0(this.parA.dVal[0], this.parB.dVal[0], this.parA.dVal[8], this.parB.dVal[8], d);
            this.kb = 1390.2842991599998 * this.parA.dVal[5] * this.parB.dVal[5] / (this.r0 * this.r0 * this.r0);
            vector.addElement(new Object[]{new int[]{n, n2}, new double[]{this.r0, this.kb, d}});
        }

        double compute(Object[] objectArray) {
            this.getPointers(objectArray);
            this.r0 = this.dData[0];
            this.kb = this.dData[1];
            this.ia = this.iData[0];
            this.ib = this.iData[1];
            if (CalculationsUFF.this.gradients) {
                CalculationsUFF.this.da.set(CalculationsUFF.this.atoms[this.ia].coord);
                CalculationsUFF.this.db.set(CalculationsUFF.this.atoms[this.ib].coord);
                this.rab = Util.restorativeForceAndDistance(CalculationsUFF.this.da, CalculationsUFF.this.db, CalculationsUFF.this.dc);
            } else {
                this.rab = Math.sqrt(Util.distance2(CalculationsUFF.this.atoms[this.ia].coord, CalculationsUFF.this.atoms[this.ib].coord));
            }
            this.delta = this.rab - this.r0;
            this.energy = this.kb * this.delta * this.delta;
            if (CalculationsUFF.this.gradients) {
                this.dE = 2.0 * this.kb * this.delta;
                CalculationsUFF.this.addForce(CalculationsUFF.this.da, this.ia, this.dE);
                CalculationsUFF.this.addForce(CalculationsUFF.this.db, this.ib, this.dE);
            }
            if (CalculationsUFF.this.logging) {
                CalculationsUFF.this.appendLogData(CalculationsUFF.this.getDebugLine(0, this));
            }
            return this.energy;
        }
    }
}

