/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import org.jmol.jvxl.readers.LimitedLineReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.SurfaceReader;
import org.jmol.util.BinaryDocument;
import org.jmol.util.Parser;

abstract class SurfaceFileReader
extends SurfaceReader {
    protected BufferedReader br;
    protected BinaryDocument binarydoc;
    String line;
    int[] next = new int[1];

    SurfaceFileReader(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        super(surfaceGenerator);
        this.br = bufferedReader;
    }

    static String determineFileType(BufferedReader bufferedReader) {
        LimitedLineReader limitedLineReader = new LimitedLineReader(bufferedReader, 16000);
        String string = limitedLineReader.info();
        if (string.indexOf("#JVXL+") >= 0) {
            return "Jvxl+";
        }
        if (string.indexOf("#JVXL") >= 0) {
            return "Jvxl";
        }
        if (string.indexOf("&plot") == 0) {
            return "Jaguar";
        }
        if (string.indexOf("!NTITLE") >= 0 || string.indexOf("REMARKS ") >= 0) {
            return "Xplor";
        }
        if (string.indexOf("MAP ") == 208) {
            return "MRC" + (string.charAt(67) == '\u0000' ? "-" : "+");
        }
        if (string.indexOf("<efvet ") >= 0) {
            return "Efvet";
        }
        if (string.indexOf("PM\u0001\u0000") == 0) {
            return "Pmesh";
        }
        string = limitedLineReader.readNonCommentLine();
        if (string.indexOf("object 1 class gridpositions counts") == 0) {
            return "Apbs";
        }
        String[] stringArray = Parser.getTokens(string);
        string = limitedLineReader.readNonCommentLine();
        if (stringArray.length == 2 && Parser.parseInt(stringArray[0]) == 3 && Parser.parseInt(stringArray[1]) != Integer.MIN_VALUE && (stringArray = Parser.getTokens(string)).length == 3 && Parser.parseInt(stringArray[0]) != Integer.MIN_VALUE && Parser.parseInt(stringArray[1]) != Integer.MIN_VALUE && Parser.parseInt(stringArray[2]) != Integer.MIN_VALUE) {
            return "PltFormatted";
        }
        string = limitedLineReader.readNonCommentLine();
        int n = Parser.parseInt(string);
        if (n == Integer.MIN_VALUE) {
            return string.indexOf("+") == 0 ? "Jvxl+" : "UNKNOWN";
        }
        if (n >= 0) {
            return "Cube";
        }
        n = -n;
        int n2 = 4 + n;
        while (--n2 >= 0) {
            string = limitedLineReader.readNonCommentLine();
            if (string != null) continue;
            return "UNKNOWN";
        }
        n2 = Parser.parseInt(string);
        if (n2 == Integer.MIN_VALUE) {
            return "UNKNOWN";
        }
        return n2 < 0 ? "Jvxl" : "Cube";
    }

    void discardTempData(boolean bl) {
        try {
            if (this.br != null) {
                this.br.close();
            }
            if (this.binarydoc != null) {
                this.binarydoc.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.discardTempData(bl);
    }

    String[] getTokens() {
        return Parser.getTokens(this.line, 0);
    }

    float parseFloat() {
        return Parser.parseFloat(this.line, this.next);
    }

    float parseFloat(String string) {
        this.next[0] = 0;
        return Parser.parseFloat(string, this.next);
    }

    int parseInt() {
        return Parser.parseInt(this.line, this.next);
    }

    int parseInt(String string) {
        this.next[0] = 0;
        return Parser.parseInt(string, this.next);
    }

    int parseIntNext(String string) {
        return Parser.parseInt(string, this.next);
    }

    protected void skipTo(String string, String string2) throws Exception {
        if (string != null) {
            while ((this.line = this.br.readLine()).indexOf(string) < 0) {
            }
        }
        if (string2 != null) {
            this.next[0] = this.line.indexOf(string2) + string2.length() + 2;
        }
    }
}

