/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import org.jmol.jvxl.readers.MapFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.BinaryDocument;
import org.jmol.util.Logger;

class MrcBinaryReader
extends MapFileReader {
    protected String[] labels;
    private static byte[] b8 = new byte[8];

    MrcBinaryReader(SurfaceGenerator surfaceGenerator, String string, boolean bl) {
        super(surfaceGenerator, null);
        this.binarydoc = new BinaryDocument();
        this.binarydoc.setStream(surfaceGenerator.getAtomDataServer().getBufferedInputStream(string), bl);
        this.params.insideOut = !this.params.insideOut;
    }

    protected void readParameters() throws Exception {
        int n;
        byte[] byArray = new byte[100];
        byte[] byArray2 = new byte[4];
        byte[] byArray3 = new byte[4];
        this.nx = this.binarydoc.readInt();
        this.ny = this.binarydoc.readInt();
        this.nz = this.binarydoc.readInt();
        this.mode = this.binarydoc.readInt();
        Logger.info("MRC header: mode: " + this.mode);
        this.nxyzStart[0] = this.binarydoc.readInt();
        this.nxyzStart[1] = this.binarydoc.readInt();
        this.nxyzStart[2] = this.binarydoc.readInt();
        this.na = this.binarydoc.readInt();
        this.nb = this.binarydoc.readInt();
        this.nc = this.binarydoc.readInt();
        if (this.na == 0) {
            this.na = this.nx - 1;
        }
        if (this.nb == 0) {
            this.nb = this.ny - 1;
        }
        if (this.nc == 0) {
            this.nc = this.nz - 1;
        }
        this.a = this.binarydoc.readFloat();
        this.b = this.binarydoc.readFloat();
        this.c = this.binarydoc.readFloat();
        this.alpha = this.binarydoc.readFloat();
        this.beta = this.binarydoc.readFloat();
        this.gamma = this.binarydoc.readFloat();
        this.mapc = this.binarydoc.readInt();
        this.mapr = this.binarydoc.readInt();
        this.maps = this.binarydoc.readInt();
        float f = this.binarydoc.readFloat();
        float f2 = this.binarydoc.readFloat();
        float f3 = this.binarydoc.readFloat();
        Logger.info("MRC header: dmin,dmax,dmean: " + f + "," + f2 + "," + f3);
        int n2 = this.binarydoc.readInt();
        int n3 = this.binarydoc.readInt();
        Logger.info("MRC header: ispg,nsymbt: " + n2 + "," + n3);
        this.binarydoc.readByteArray(byArray);
        this.origin.x = this.binarydoc.readFloat();
        this.origin.y = this.binarydoc.readFloat();
        this.origin.z = this.binarydoc.readFloat();
        this.binarydoc.readByteArray(byArray2);
        this.binarydoc.readByteArray(byArray3);
        float f4 = this.binarydoc.readFloat();
        Logger.info("MRC header: rms: " + f4);
        int n4 = this.binarydoc.readInt();
        Logger.info("MRC header: labels: " + n4);
        this.labels = new String[n4];
        this.labels[0] = "Jmol MrcBinaryReader";
        for (n = 0; n < 10; ++n) {
            String string = this.binarydoc.readString(80).trim();
            if (n >= n4) continue;
            this.labels[n] = string;
            Logger.info(this.labels[n]);
        }
        for (n = 0; n < n3; ++n) {
            long l = this.binarydoc.getPosition();
            String string = this.binarydoc.readString(80).trim();
            if (string.indexOf(0) != string.lastIndexOf(0)) {
                Logger.error("File indicates " + n3 + " symmetry lines, but " + n + " found!");
                this.binarydoc.seek(l);
                break;
            }
            Logger.info("MRC file symmetry information: " + string);
        }
        Logger.info("MRC header: bytes read: " + this.binarydoc.getPosition() + "\n");
        if (this.params.cutoff == 0.02f) {
            this.params.cutoff = f4 * 2.0f + f3;
            Logger.info("Cutoff set to (dmean + 2*rms) = " + this.params.cutoff);
        }
        this.getVectorsAndOrigin();
        Logger.info("\n");
        this.jvxlFileHeaderBuffer = new StringBuffer();
        this.jvxlFileHeaderBuffer.append("MRC DATA ").append(this.labels[0]).append("\n");
        this.jvxlFileHeaderBuffer.append("see http://ami.scripps.edu/software/mrctools/mrc_specification.php\n");
    }

    protected float nextVoxel() throws Exception {
        float f;
        switch (this.mode) {
            case 0: {
                f = this.binarydoc.readByte();
                break;
            }
            case 1: {
                f = this.binarydoc.readShort();
                break;
            }
            default: {
                f = this.binarydoc.readFloat();
                break;
            }
            case 3: {
                f = this.binarydoc.readShort();
                this.binarydoc.readShort();
                break;
            }
            case 4: {
                f = this.binarydoc.readFloat();
                this.binarydoc.readFloat();
                break;
            }
            case 6: {
                f = this.binarydoc.readUnsignedShort();
            }
        }
        this.nBytes = this.binarydoc.getPosition();
        return f;
    }

    protected void skipData(int n) throws Exception {
        block5: for (int i = 0; i < n; ++i) {
            switch (this.mode) {
                case 0: {
                    this.binarydoc.readByte();
                    continue block5;
                }
                case 1: 
                case 6: {
                    this.binarydoc.readByteArray(b8, 0, 2);
                    continue block5;
                }
                default: {
                    this.binarydoc.readByteArray(b8, 0, 4);
                    continue block5;
                }
                case 4: {
                    this.binarydoc.readByteArray(b8);
                }
            }
        }
    }
}

