/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javax.vecmath.Point3f;
import org.jmol.api.Interface;
import org.jmol.api.SymmetryInterface;
import org.jmol.jvxl.readers.JvxlReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;
import org.jmol.util.Logger;

abstract class MapFileReader
extends VolumeFileReader {
    protected int mapc;
    protected int mapr;
    protected int maps;
    protected int nx;
    protected int ny;
    protected int nz;
    protected int mode;
    protected int[] nxyzStart = new int[3];
    protected int na;
    protected int nb;
    protected int nc;
    protected float a;
    protected float b;
    protected float c;
    protected float alpha;
    protected float beta;
    protected float gamma;
    protected Point3f origin = new Point3f();
    protected Point3f adjustment = new Point3f();
    protected Point3f[] vectors = new Point3f[3];

    MapFileReader(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        super(surfaceGenerator, bufferedReader);
        this.isAngstroms = true;
        this.adjustment = surfaceGenerator.getParams().center;
        if (this.adjustment.x == Float.MAX_VALUE) {
            this.adjustment = new Point3f();
        }
    }

    protected abstract void readParameters() throws Exception;

    protected int readVolumetricHeader() {
        try {
            int n;
            boolean bl;
            this.readParameters();
            int n2 = this.params.downsampleFactor;
            boolean bl2 = bl = this.canDownsample && n2 > 0;
            if (bl) {
                this.downsampleRemainders = new int[3];
                Logger.info("downsample factor = " + n2);
                for (n = 0; n < 3; ++n) {
                    int n3 = this.voxelCounts[n];
                    this.downsampleRemainders[n] = n3 % n2;
                    int n4 = n;
                    this.voxelCounts[n4] = this.voxelCounts[n4] / n2;
                    this.volumetricVectors[n].scale(n2);
                    Logger.info("downsampling axis " + (n + 1) + " from " + n3 + " to " + this.voxelCounts[n]);
                }
            }
            for (n = 0; n < 3; ++n) {
                this.line = this.voxelCounts[n] + " " + this.volumetricVectors[n].x + " " + this.volumetricVectors[n].y + " " + this.volumetricVectors[n].z;
                this.jvxlFileHeaderBuffer.append(this.line).append('\n');
                Logger.info("voxel grid count/vector:" + this.line);
            }
            JvxlReader.jvxlReadAtoms(this.br, this.jvxlFileHeaderBuffer, this.atomCount, this.volumeData);
            return 1;
        }
        catch (Exception exception) {
            Logger.error(exception.toString());
            return 0;
        }
    }

    protected void getVectorsAndOrigin() {
        Logger.info("grid parameters: nx,ny,nz: " + this.nx + "," + this.ny + "," + this.nz);
        Logger.info("grid parameters: nxStart,nyStart,nzStart: " + this.nxyzStart[0] + "," + this.nxyzStart[1] + "," + this.nxyzStart[2]);
        Logger.info("grid parameters: mx,my,mz: " + this.na + "," + this.nb + "," + this.nc);
        Logger.info("grid parameters: a,b,c,alpha,beta,gamma: " + this.a + "," + this.b + "," + this.c + "," + this.alpha + "," + this.beta + "," + this.gamma);
        Logger.info("grid parameters: mapc,mapr,maps: " + this.mapc + "," + this.mapr + "," + this.maps);
        Logger.info("grid parameters: originX,Y,Z: " + this.origin);
        SymmetryInterface symmetryInterface = (SymmetryInterface)Interface.getOptionInterface("symmetry.Symmetry");
        symmetryInterface.setUnitCell(new float[]{this.a, this.b, this.c, this.alpha, this.beta, this.gamma});
        this.vectors[0] = new Point3f(1.0f / (float)this.na, 0.0f, 0.0f);
        this.vectors[1] = new Point3f(0.0f, 1.0f / (float)this.nb, 0.0f);
        this.vectors[2] = new Point3f(0.0f, 0.0f, 1.0f / (float)this.nc);
        symmetryInterface.toCartesian(this.vectors[0]);
        symmetryInterface.toCartesian(this.vectors[1]);
        symmetryInterface.toCartesian(this.vectors[2]);
        Logger.info("Jmol unit cell vectors:");
        Logger.info("    a: " + this.vectors[0]);
        Logger.info("    b: " + this.vectors[1]);
        Logger.info("    c: " + this.vectors[2]);
        this.voxelCounts[0] = this.nz;
        this.voxelCounts[1] = this.ny;
        this.voxelCounts[2] = this.nx;
        this.volumetricVectors[0].set(this.vectors[this.maps - 1]);
        this.volumetricVectors[1].set(this.vectors[this.mapr - 1]);
        this.volumetricVectors[2].set(this.vectors[this.mapc - 1]);
        if (this.origin.x == 0.0f && this.origin.y == 0.0f && this.origin.z == 0.0f) {
            int[] nArray = new int[3];
            nArray[this.mapc - 1] = 0;
            nArray[this.mapr - 1] = 1;
            nArray[this.maps - 1] = 2;
            int n = nArray[0];
            int n2 = nArray[1];
            int n3 = nArray[2];
            this.origin.scaleAdd((float)this.nxyzStart[n] + this.adjustment.x, this.vectors[0], this.origin);
            this.origin.scaleAdd((float)this.nxyzStart[n2] + this.adjustment.y, this.vectors[1], this.origin);
            this.origin.scaleAdd((float)this.nxyzStart[n3] + this.adjustment.z, this.vectors[2], this.origin);
        }
        this.volumetricOrigin.set(this.origin);
        Logger.info("Jmol grid origin in Cartesian coordinates: " + this.origin);
        Logger.info("Use  isosurface OFFSET {x y z}  if you want to shift it.");
    }
}

