/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import java.util.BitSet;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.jvxl.api.MeshDataServer;
import org.jmol.jvxl.data.JvxlData;
import org.jmol.jvxl.data.MeshData;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;
import org.jmol.shapesurface.IsosurfaceMesh;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Parser;

public class JvxlReader
extends VolumeFileReader {
    private static final String JVXL_VERSION = "2.0";
    public static final int defaultEdgeFractionBase = 35;
    public static final int defaultEdgeFractionRange = 90;
    public static final int defaultColorFractionBase = 35;
    public static final int defaultColorFractionRange = 90;
    private int surfaceDataCount;
    private int edgeDataCount;
    private int colorDataCount;
    private boolean haveContourData;
    private int nThisValue;
    private boolean thisInside;
    private int fractionPtr;
    private String strFractionTemp = "";

    JvxlReader(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        super(surfaceGenerator, bufferedReader);
        this.isJvxl = true;
        this.jvxlData.wasJvxl = true;
        this.isXLowToHigh = false;
    }

    protected static void jvxlUpdateInfo(JvxlData jvxlData, String[] stringArray, int n) {
        jvxlData.title = stringArray;
        jvxlData.nBytes = n;
        JvxlReader.jvxlUpdateInfoLines(jvxlData);
    }

    public static void jvxlUpdateInfoLines(JvxlData jvxlData) {
        jvxlData.jvxlDefinitionLine = JvxlReader.jvxlGetDefinitionLine(jvxlData, false);
        jvxlData.jvxlInfoLine = JvxlReader.jvxlGetDefinitionLine(jvxlData, true);
    }

    protected boolean readVolumeData(boolean bl) {
        if (!super.readVolumeData(bl)) {
            return false;
        }
        this.strFractionTemp = this.jvxlEdgeDataRead;
        this.fractionPtr = 0;
        return true;
    }

    protected boolean gotoAndReadVoxelData(boolean bl) {
        this.initializeVolumetricData();
        if (this.nPointsX < 0 || this.nPointsY < 0 || this.nPointsZ < 0) {
            return true;
        }
        try {
            this.gotoData(this.params.fileIndex - 1, this.nPointsX * this.nPointsY * this.nPointsZ);
            if (this.vertexDataOnly) {
                return true;
            }
            this.readSurfaceData(bl);
            if (this.edgeDataCount > 0) {
                this.jvxlEdgeDataRead = this.jvxlReadData("edge", this.edgeDataCount);
            }
            if (this.colorDataCount > 0) {
                this.jvxlColorDataRead = this.jvxlReadData("color", this.colorDataCount);
            }
            if (this.haveContourData) {
                this.jvxlDecodeContourData(this.getXmlData("jvxlContourData", null, false));
            }
        }
        catch (Exception exception) {
            Logger.error(exception.toString());
            try {
                this.br.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    protected void initializeVoxelData() {
        this.thisInside = !this.params.isContoured;
        this.nThisValue = 0;
    }

    protected void readSurfaceData(boolean bl) throws Exception {
        this.initializeVoxelData();
        if (this.vertexDataOnly) {
            this.getEncodedVertexData();
            return;
        }
        if (this.params.thePlane == null) {
            super.readSurfaceData(false);
            return;
        }
        this.volumeData.setDataDistanceToPlane(this.params.thePlane);
        this.setVolumeData(this.volumeData);
        this.params.cutoff = 0.0f;
        JvxlReader.setSurfaceInfo(this.jvxlData, this.params.thePlane, 0, new StringBuffer());
    }

    protected void readTitleLines() throws Exception {
        this.jvxlFileHeaderBuffer = new StringBuffer(this.skipComments(false));
        if (this.line == null || this.line.length() == 0) {
            this.line = "Line 1";
        }
        this.jvxlFileHeaderBuffer.append(this.line).append('\n');
        this.line = this.br.readLine();
        if (this.line == null || this.line.length() == 0) {
            this.line = "Line 2";
        }
        this.jvxlFileHeaderBuffer.append(this.line).append('\n');
    }

    protected static boolean jvxlCheckAtomLine(boolean bl, boolean bl2, String string, String string2, StringBuffer stringBuffer) {
        int n;
        if (string != null) {
            n = Parser.parseInt(string);
            if (n == Integer.MIN_VALUE) {
                n = 0;
                string2 = " " + string2.substring(string2.indexOf(" ") + 1);
            } else {
                String string3 = "" + n;
                string2 = string2.substring(string2.indexOf(string3) + string3.length());
            }
            stringBuffer.append((bl ? "+" : "-") + Math.abs(n));
        }
        n = string2.indexOf("ANGSTROM");
        if (bl2 && n < 0) {
            string2 = string2 + " ANGSTROMS";
        } else if (string2.indexOf("ANGSTROMS") >= 0) {
            bl2 = true;
        }
        n = string2.indexOf("BOHR");
        if (!bl2 && n < 0) {
            string2 = string2 + " BOHR";
        }
        stringBuffer.append(string2).append('\n');
        return bl2;
    }

    protected void readAtomCountAndOrigin() throws Exception {
        this.jvxlFileHeaderBuffer.append(this.skipComments(false));
        String string = this.line;
        String[] stringArray = Parser.getTokens(string, 0);
        this.isXLowToHigh = false;
        this.negativeAtomCount = true;
        this.atomCount = 0;
        if (stringArray[0] != "-0") {
            if (stringArray[0].charAt(0) == '+') {
                this.isXLowToHigh = true;
                this.atomCount = this.parseInt(stringArray[0].substring(1));
            } else {
                this.atomCount = -this.parseInt(stringArray[0]);
            }
        }
        if (this.atomCount == Integer.MIN_VALUE) {
            return;
        }
        this.volumetricOrigin.set(this.parseFloat(stringArray[1]), this.parseFloat(stringArray[2]), this.parseFloat(stringArray[3]));
        this.isAngstroms = JvxlReader.jvxlCheckAtomLine(this.isXLowToHigh, this.isAngstroms, null, string, this.jvxlFileHeaderBuffer);
        if (!this.isAngstroms) {
            this.volumetricOrigin.scale(0.5291772f);
        }
    }

    protected static void jvxlReadAtoms(BufferedReader bufferedReader, StringBuffer stringBuffer, int n, VolumeData volumeData) throws Exception {
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(bufferedReader.readLine() + "\n");
        }
    }

    protected int readExtraLine() throws Exception {
        this.skipComments(true);
        Logger.info("Reading extra JVXL information line: " + this.line);
        int n = this.parseInt(this.line);
        this.isJvxl = n < 0;
        if (!this.isJvxl) {
            return n;
        }
        n = -n;
        Logger.info("jvxl file surfaces: " + n);
        int n2 = this.parseInt();
        if (n2 == Integer.MIN_VALUE) {
            Logger.info("using default edge fraction base and range");
        } else {
            this.edgeFractionBase = n2;
            this.edgeFractionRange = this.parseInt();
        }
        n2 = this.parseInt();
        if (n2 == Integer.MIN_VALUE) {
            Logger.info("using default color fraction base and range");
        } else {
            this.colorFractionBase = n2;
            this.colorFractionRange = this.parseInt();
        }
        this.cJvxlEdgeNaN = (char)(this.edgeFractionBase + this.edgeFractionRange);
        return n;
    }

    private void jvxlReadDefinitionLine(boolean bl) throws Exception {
        String string = this.skipComments(true);
        if (bl) {
            Logger.info("reading jvxl data set: " + string + this.line);
        }
        this.haveContourData = string.indexOf("+contourlines") >= 0;
        this.jvxlCutoff = this.parseFloat(this.line);
        Logger.info("JVXL read: cutoff " + this.jvxlCutoff);
        int n = this.parseInt();
        int n2 = this.parseInt();
        int n3 = this.parseInt();
        if (n3 == Integer.MIN_VALUE || n3 == -1) {
            n3 = 0;
        }
        if (n == -1) {
            try {
                this.params.thePlane = new Point4f(this.parseFloat(), this.parseFloat(), this.parseFloat(), this.parseFloat());
            }
            catch (Exception exception) {
                Logger.error("Error reading 4 floats for PLANE definition -- setting to 0 0 1 0  (z=0)");
                this.params.thePlane = new Point4f(0.0f, 0.0f, 1.0f, 0.0f);
            }
            Logger.info("JVXL read: {" + this.params.thePlane.x + " " + this.params.thePlane.y + " " + this.params.thePlane.z + " " + this.params.thePlane.w + "}");
            if (n2 == -1 && n3 < 0) {
                n3 = -n3;
            }
        } else {
            this.params.thePlane = null;
        }
        if (n < 0 && n2 != -1) {
            this.params.isContoured = n3 != 0;
            int n4 = this.parseInt();
            if (n4 != Integer.MIN_VALUE) {
                if (n4 < 0) {
                    n4 = -1 - n4;
                    this.params.contourFromZero = false;
                }
                if (n4 != 0 && this.params.nContours == 0) {
                    this.params.nContours = n4;
                    Logger.info("JVXL read: contours " + this.params.nContours);
                }
            }
        } else {
            this.params.isContoured = false;
        }
        this.jvxlDataIsPrecisionColor = n == -1 && n2 == -2 || n3 < 0;
        this.params.isBicolorMap = n > 0 && n2 < 0;
        this.jvxlDataIsColorMapped = n3 != 0;
        boolean bl2 = this.jvxlDataIs2dContour = this.jvxlDataIsColorMapped && this.params.isContoured;
        if (this.params.isBicolorMap || this.params.colorBySign) {
            this.jvxlCutoff = 0.0f;
        }
        int n5 = n < -1 ? -1 - n : (this.surfaceDataCount = n > 0 ? n : 0);
        if (n == -1) {
            this.edgeDataCount = 0;
        } else {
            int n6 = n2 < -1 ? -n2 : (this.edgeDataCount = n2 > 0 ? n2 : 0);
        }
        int n7 = this.params.isBicolorMap ? -n2 : (n3 < -1 ? -n3 : (this.colorDataCount = n3 > 0 ? n3 : 0));
        if (this.params.colorBySign) {
            this.params.isBicolorMap = true;
        }
        if (this.jvxlDataIsColorMapped) {
            float f = this.parseFloat();
            float f2 = this.parseFloat();
            float f3 = this.parseFloat();
            float f4 = this.parseFloat();
            if (!Float.isNaN(f) && !Float.isNaN(f2)) {
                if (f2 == 0.0f && f == 0.0f) {
                    f = -1.0f;
                    f2 = 1.0f;
                }
                this.params.mappedDataMin = f;
                this.params.mappedDataMax = f2;
                Logger.info("JVXL read: data min/max: " + this.params.mappedDataMin + "/" + this.params.mappedDataMax);
            }
            if (!this.params.rangeDefined) {
                if (!Float.isNaN(f3) && !Float.isNaN(f4)) {
                    if (f3 == 0.0f && f4 == 0.0f) {
                        f3 = -1.0f;
                        f4 = 1.0f;
                    }
                    this.params.valueMappedToRed = f3;
                    this.params.valueMappedToBlue = f4;
                    this.params.rangeDefined = true;
                } else {
                    this.params.valueMappedToRed = 0.0f;
                    this.params.valueMappedToBlue = 1.0f;
                    this.params.rangeDefined = true;
                }
            }
            Logger.info("JVXL read: color red/blue: " + this.params.valueMappedToRed + "/" + this.params.valueMappedToBlue);
        }
        boolean bl3 = this.jvxlData.insideOut = this.line.indexOf("insideOut") >= 0;
        if (this.params.insideOut) {
            this.jvxlData.insideOut = !this.jvxlData.insideOut;
        }
        this.params.insideOut = this.jvxlData.insideOut;
        this.jvxlData.valueMappedToRed = this.params.valueMappedToRed;
        this.jvxlData.valueMappedToBlue = this.params.valueMappedToBlue;
        this.jvxlData.mappedDataMin = this.params.mappedDataMin;
        this.jvxlData.mappedDataMax = this.params.mappedDataMax;
    }

    private String jvxlReadData(String string, int n) {
        String string2 = "";
        try {
            while (string2.length() < n) {
                this.line = this.br.readLine();
                string2 = string2 + JvxlReader.jvxlUncompressString(this.line);
            }
        }
        catch (Exception exception) {
            Logger.error("Error reading " + string + " data " + exception);
            throw new NullPointerException();
        }
        return string2;
    }

    public static String jvxlCompressString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char c = '\u0000';
        string = string + '\u0000';
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 == '\n' || c2 == '\r') continue;
            if (c2 == c) {
                ++n;
                if (c2 != '~') {
                    c2 = '\u0000';
                }
            } else if (n > 0) {
                if (n < 4 || c == '~' || c == ' ' || c == '\t') {
                    while (--n >= 0) {
                        stringBuffer.append(c);
                    }
                } else {
                    stringBuffer.append("~" + n + " ");
                }
                n = 0;
            }
            if (c2 == '\u0000') continue;
            stringBuffer.append(c2);
            c = c2;
        }
        return stringBuffer.toString();
    }

    private static String jvxlUncompressString(String string) {
        if (string.indexOf("~") < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char c = '\u0000';
        int[] nArray = new int[1];
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 == '~') {
                nArray[0] = ++i;
                int n = Parser.parseInt(string, nArray);
                if (n == Integer.MIN_VALUE) {
                    if (c == '~') {
                        stringBuffer.append('~');
                        while ((c2 = string.charAt(++i)) == '~') {
                            stringBuffer.append('~');
                        }
                        continue;
                    }
                    Logger.error("Error uncompressing string " + string.substring(0, i) + "?");
                    continue;
                }
                for (int j = 0; j < n; ++j) {
                    stringBuffer.append(c);
                }
                i = nArray[0];
                continue;
            }
            stringBuffer.append(c2);
            c = c2;
        }
        return stringBuffer.toString();
    }

    protected BitSet getVoxelBitSet(int n) throws Exception {
        BitSet bitSet = new BitSet();
        if (this.surfaceDataCount <= 0) {
            return bitSet;
        }
        int n2 = 0;
        for (int i = 0; i < n; i += n2) {
            n2 = this.parseInt();
            if (n2 == Integer.MIN_VALUE) {
                this.line = this.br.readLine();
                if (this.line == null || (n2 = this.parseInt(this.line)) == Integer.MIN_VALUE) {
                    if (!this.endOfData) {
                        Logger.error("end of file in JvxlReader? line=" + this.line);
                    }
                    this.endOfData = true;
                    n2 = 10000;
                }
            }
            this.thisInside = !this.thisInside;
            ++this.jvxlNSurfaceInts;
            if (!this.thisInside) continue;
            bitSet.set(i, i + n2);
        }
        return bitSet;
    }

    protected float getNextVoxelValue(StringBuffer stringBuffer) throws Exception {
        if (this.surfaceDataCount <= 0) {
            return 0.0f;
        }
        while (this.nThisValue == 0) {
            this.nThisValue = this.parseInt();
            if (this.nThisValue == Integer.MIN_VALUE) {
                this.line = this.br.readLine();
                if (this.line == null || (this.nThisValue = this.parseInt(this.line)) == Integer.MIN_VALUE) {
                    if (!this.endOfData) {
                        Logger.error("end of file in JvxlReader? line=" + this.line);
                    }
                    this.endOfData = true;
                    this.nThisValue = 10000;
                } else if (stringBuffer != null) {
                    stringBuffer.append(this.line).append('\n');
                }
            }
            this.thisInside = !this.thisInside;
            ++this.jvxlNSurfaceInts;
        }
        --this.nThisValue;
        return this.thisInside ? 1.0f : 0.0f;
    }

    public static void setSurfaceInfoFromBitSet(JvxlData jvxlData, BitSet bitSet, Point4f point4f) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = jvxlData.nPointsX * jvxlData.nPointsY * jvxlData.nPointsZ;
        int n2 = JvxlReader.jvxlEncodeBitSet(bitSet, n, stringBuffer);
        JvxlReader.setSurfaceInfo(jvxlData, point4f, n2, stringBuffer);
    }

    private static int jvxlEncodeBitSet(BitSet bitSet, int n, StringBuffer stringBuffer) {
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if (bl == bitSet.get(i)) {
                ++n2;
                continue;
            }
            stringBuffer.append(' ').append(n2);
            ++n3;
            n2 = 1;
            bl = !bl;
        }
        stringBuffer.append(' ').append(n2).append('\n');
        return n3;
    }

    private static BitSet jvxlDecodeBitSet(String string) {
        BitSet bitSet = new BitSet();
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        int[] nArray = new int[1];
        while ((n = Parser.parseInt(string, nArray)) != Integer.MIN_VALUE) {
            if (bl) {
                bitSet.set(n2, n2 + n);
            }
            n2 += n;
            bl = !bl;
        }
        return bitSet;
    }

    protected static void setSurfaceInfo(JvxlData jvxlData, Point4f point4f, int n, StringBuffer stringBuffer) {
        jvxlData.jvxlSurfaceData = stringBuffer.toString();
        if (jvxlData.jvxlSurfaceData.indexOf("--") == 0) {
            jvxlData.jvxlSurfaceData = jvxlData.jvxlSurfaceData.substring(2);
        }
        jvxlData.jvxlPlane = point4f;
        jvxlData.nSurfaceInts = n;
    }

    protected float getSurfacePointAndFraction(float f, boolean bl, float f2, float f3, Point3f point3f, Vector3f vector3f, float[] fArray, Point3f point3f2) {
        if (this.edgeDataCount <= 0) {
            return super.getSurfacePointAndFraction(f, bl, f2, f3, point3f, vector3f, fArray, point3f2);
        }
        fArray[0] = this.jvxlGetNextFraction(this.edgeFractionBase, this.edgeFractionRange, 0.5f);
        point3f2.scaleAdd(fArray[0], vector3f, point3f);
        return fArray[0];
    }

    private float jvxlGetNextFraction(int n, int n2, float f) {
        if (this.fractionPtr >= this.strFractionTemp.length()) {
            if (!this.endOfData) {
                Logger.error("end of file reading compressed fraction data");
            }
            this.endOfData = true;
            this.strFractionTemp = "" + (char)n;
            this.fractionPtr = 0;
        }
        return JvxlReader.jvxlFractionFromCharacter(this.strFractionTemp.charAt(this.fractionPtr++), n, n2, f);
    }

    protected String readColorData() {
        this.fractionPtr = 0;
        int n = this.jvxlData.vertexCount = this.meshData.vertexCount;
        short[] sArray = this.meshData.vertexColixes;
        float[] fArray = this.meshData.vertexValues;
        String string = this.strFractionTemp = this.isJvxl ? this.jvxlColorDataRead : "";
        if (this.isJvxl && this.strFractionTemp.length() == 0) {
            Logger.error("You cannot use JVXL data to map onto OTHER data, because it only contains the data for one surface. Use ISOSURFACE \"file.jvxl\" not ISOSURFACE .... MAP \"file.jvxl\".");
            return "";
        }
        this.fractionPtr = 0;
        Logger.info("JVXL reading color data mapped min/max: " + this.params.mappedDataMin + "/" + this.params.mappedDataMax + " for " + n + " vertices." + " using encoding keys " + this.colorFractionBase + " " + this.colorFractionRange);
        Logger.info("mapping red-->blue for " + this.params.valueMappedToRed + " to " + this.params.valueMappedToBlue + " colorPrecision:" + this.jvxlDataIsPrecisionColor);
        float f = this.params.mappedDataMin == Float.MAX_VALUE ? 0.0f : this.params.mappedDataMin;
        float f2 = (this.params.mappedDataMin == Float.MAX_VALUE ? 1.0f : this.params.mappedDataMax) - f;
        float f3 = this.params.valueMappedToBlue - this.params.valueMappedToRed;
        float f4 = Float.MAX_VALUE;
        float f5 = -3.4028235E38f;
        if (sArray == null || sArray.length < n) {
            this.meshData.vertexColixes = sArray = new short[n];
        }
        String string2 = this.jvxlColorDataRead;
        int n2 = 0;
        short s = 0;
        short s2 = 0;
        if (this.params.colorBySign) {
            s2 = ColorEncoder.getColorIndex(this.params.isColorReversed ? this.params.colorNeg : this.params.colorPos);
            s = ColorEncoder.getColorIndex(this.params.isColorReversed ? this.params.colorPos : this.params.colorNeg);
        }
        int n3 = this.meshData.vertexIncrement;
        for (int i = 0; i < n; i += n3) {
            float f6;
            float f7;
            if (this.jvxlDataIsPrecisionColor) {
                f7 = JvxlReader.jvxlFractionFromCharacter2(string2.charAt(n2), string2.charAt(n2 + n), this.colorFractionBase, this.colorFractionRange);
                f6 = f + f7 * f2;
            } else {
                f7 = JvxlReader.jvxlFractionFromCharacter(string2.charAt(n2), this.colorFractionBase, this.colorFractionRange, 0.5f);
                f6 = this.params.valueMappedToRed + f7 * f3;
            }
            fArray[i] = f6;
            ++n2;
            if (f6 < f4) {
                f4 = f6;
            }
            if (f6 > f5) {
                f5 = f6;
            }
            if (this.params.isContoured) {
                this.marchingSquares.setContourData(i, f6);
                continue;
            }
            sArray[i] = this.params.colorBySign ? ((this.params.isColorReversed ? f6 > 0.0f : f6 <= 0.0f) ? s : s2) : this.getColorIndexFromPalette(f6);
        }
        if (this.params.mappedDataMin == Float.MAX_VALUE) {
            this.params.mappedDataMin = f4;
            this.params.mappedDataMax = f5;
        }
        return string2 + "\n";
    }

    protected void gotoData(int n, int n2) throws Exception {
        if (n > 0) {
            Logger.info("skipping " + n + " data sets, " + n2 + " points each");
        }
        this.jvxlData.vertexDataOnly = n2 == 0;
        this.vertexDataOnly = this.jvxlData.vertexDataOnly;
        for (int i = 0; i < n; ++i) {
            this.jvxlReadDefinitionLine(true);
            Logger.info("JVXL skipping: jvxlSurfaceDataCount=" + this.surfaceDataCount + " jvxlEdgeDataCount=" + this.edgeDataCount + " jvxlDataIsColorMapped=" + this.jvxlDataIsColorMapped);
            this.jvxlSkipData(n2, true);
        }
        this.jvxlReadDefinitionLine(true);
    }

    private void jvxlSkipData(int n, boolean bl) throws Exception {
        if (this.surfaceDataCount > 0) {
            this.jvxlSkipDataBlock(n, true);
        }
        if (this.edgeDataCount > 0) {
            this.jvxlSkipDataBlock(this.edgeDataCount, false);
        }
        if (this.jvxlDataIsColorMapped && bl) {
            this.jvxlSkipDataBlock(this.colorDataCount, false);
        }
    }

    private void jvxlSkipDataBlock(int n, boolean bl) throws Exception {
        for (int i = 0; i < n; i += bl ? this.countData(this.line) : JvxlReader.jvxlUncompressString(this.line).length()) {
            this.line = this.br.readLine();
        }
    }

    private int countData(String string) {
        int n = 0;
        int n2 = this.parseInt(string);
        while (n2 != Integer.MIN_VALUE) {
            n += n2;
            n2 = this.parseIntNext(string);
        }
        return n;
    }

    protected static void jvxlCreateHeaderWithoutTitleOrAtoms(VolumeData volumeData, StringBuffer stringBuffer) {
        JvxlReader.jvxlCreateHeader(volumeData, Integer.MAX_VALUE, null, null, stringBuffer);
    }

    protected static void jvxlCreateHeader(VolumeData volumeData, int n, Point3f[] point3fArray, int[] nArray, StringBuffer stringBuffer) {
        int n2;
        if (stringBuffer.length() == 0) {
            stringBuffer.append("Line 1\nLine 2\n");
        }
        stringBuffer.append(n == Integer.MAX_VALUE ? -2 : -n).append(' ').append(volumeData.volumetricOrigin.x).append(' ').append(volumeData.volumetricOrigin.y).append(' ').append(volumeData.volumetricOrigin.z).append(" ANGSTROMS\n");
        for (n2 = 0; n2 < 3; ++n2) {
            stringBuffer.append(volumeData.voxelCounts[n2]).append(' ').append(volumeData.volumetricVectors[n2].x).append(' ').append(volumeData.volumetricVectors[n2].y).append(' ').append(volumeData.volumetricVectors[n2].z).append('\n');
        }
        if (n == Integer.MAX_VALUE) {
            JvxlReader.jvxlAddDummyAtomList(volumeData, stringBuffer);
            return;
        }
        n = Math.abs(n);
        int n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            n3 = Math.abs(nArray[n2]);
            stringBuffer.append(n3 + " " + n3 + ".0 " + point3fArray[n2].x + " " + point3fArray[n2].y + " " + point3fArray[n2].z + "\n");
        }
    }

    private static void jvxlAddDummyAtomList(VolumeData volumeData, StringBuffer stringBuffer) {
        Point3f point3f = new Point3f(volumeData.volumetricOrigin);
        stringBuffer.append("1 1.0 ").append(point3f.x).append(' ').append(point3f.y).append(' ').append(point3f.z).append(" //BOGUS H ATOM ADDED FOR JVXL FORMAT\n");
        for (int i = 0; i < 3; ++i) {
            point3f.scaleAdd(volumeData.voxelCounts[i] - 1, volumeData.volumetricVectors[i], point3f);
        }
        stringBuffer.append("2 2.0 ").append(point3f.x).append(' ').append(point3f.y).append(' ').append(point3f.z).append(" //BOGUS He ATOM ADDED FOR JVXL FORMAT\n");
    }

    public static String jvxlGetDefinitionLine(JvxlData jvxlData, boolean bl) {
        float f;
        String string = (jvxlData.vContours == null ? "" : "#+contourlines\n") + jvxlData.cutoff + " ";
        if (jvxlData.jvxlSurfaceData == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = jvxlData.nSurfaceInts;
        int n2 = jvxlData.vertexDataOnly ? 0 : jvxlData.jvxlEdgeData.length() - 1;
        int n3 = jvxlData.jvxlColorData.length() - 1;
        if (bl && !jvxlData.vertexDataOnly) {
            stringBuffer.append("\n  cutoff=\"" + jvxlData.cutoff + "\"");
            stringBuffer.append("\n  pointsPerAngstrom=\"" + jvxlData.pointsPerAngstrom + "\"");
            stringBuffer.append("\n  nSurfaceInts=\"" + n + "\"");
            stringBuffer.append("\n  nBytesData=\"" + (jvxlData.jvxlSurfaceData.length() + n2 + jvxlData.jvxlColorData.length()) + "\"");
        }
        if (jvxlData.jvxlPlane == null) {
            if (jvxlData.isContoured) {
                if (bl) {
                    stringBuffer.append("\n  contoured=\"true\"");
                } else {
                    string = string + (-1 - n) + " " + n2;
                }
            } else if (jvxlData.isBicolorMap) {
                if (bl) {
                    stringBuffer.append("\n  bicolorMap=\"true\"");
                } else {
                    string = string + n + " " + -n2;
                }
            } else if (!bl) {
                string = string + n + " " + n2;
            } else if (n3 > 0) {
                stringBuffer.append("\n  colorMapped=\"true\"");
            }
            if (!bl) {
                string = string + " " + (jvxlData.isJvxlPrecisionColor && n3 != -1 ? -n3 : n3);
            }
        } else {
            String string2 = " " + jvxlData.jvxlPlane.x + " " + jvxlData.jvxlPlane.y + " " + jvxlData.jvxlPlane.z + " " + jvxlData.jvxlPlane.w;
            if (!bl) {
                string = string + (jvxlData.isContoured ? "-1 -2 " + -n3 : "-1 -1 " + n3) + string2;
            } else if (n3 > 0) {
                stringBuffer.append("\n  colorMapped=\"true\"");
            }
            if (bl) {
                stringBuffer.append("\n  plane=\"{ " + string2 + " }\"");
            }
        }
        if (jvxlData.isContoured) {
            if (bl) {
                stringBuffer.append("\n  nContours=\"" + Math.abs(jvxlData.nContours) + "\"");
            } else {
                string = string + " " + jvxlData.nContours;
            }
        }
        float f2 = f = jvxlData.mappedDataMin == Float.MAX_VALUE ? 0.0f : jvxlData.mappedDataMin;
        if (!bl) {
            string = string + " " + f + " " + jvxlData.mappedDataMax + " " + jvxlData.valueMappedToRed + " " + jvxlData.valueMappedToBlue;
        }
        if (bl && jvxlData.jvxlColorData.length() > 0 && !jvxlData.isBicolorMap) {
            stringBuffer.append("\n  dataMinimum=\"" + f + "\"");
            stringBuffer.append("\n  dataMaximum=\"" + jvxlData.mappedDataMax + "\"");
            stringBuffer.append("\n  valueMappedToRed=\"" + jvxlData.valueMappedToRed + "\"");
            stringBuffer.append("\n  valueMappedToBlue=\"" + jvxlData.valueMappedToBlue + "\"");
        }
        if (bl && jvxlData.jvxlCompressionRatio > 0) {
            stringBuffer.append("\n  approximateCompressionRatio=\"" + jvxlData.jvxlCompressionRatio + ":1\"");
        }
        if (bl && jvxlData.isXLowToHigh) {
            stringBuffer.append("\n  note=\"progressive JVXL+ -- X values read from low(0) to high(" + (jvxlData.nPointsX - 1) + ")\"");
        }
        if (jvxlData.insideOut) {
            if (bl) {
                stringBuffer.append("\n  insideOut=\"true\"");
            } else {
                string = string + " insideOut";
            }
        }
        if (!bl) {
            return string;
        }
        stringBuffer.append("\n  precisionColor=\"" + jvxlData.isJvxlPrecisionColor + "\"");
        stringBuffer.append("\n  nColorData=\"" + n3 + "\"");
        stringBuffer.append("\n  version=\"" + jvxlData.version + "\"");
        return "<jvxlSurfaceInfo>" + stringBuffer.toString() + "\n</jvxlSurfaceInfo>";
    }

    protected static String jvxlExtraLine(JvxlData jvxlData, int n) {
        return -n + " " + jvxlData.edgeFractionBase + " " + jvxlData.edgeFractionRange + " " + jvxlData.colorFractionBase + " " + jvxlData.colorFractionRange + " Jmol voxel format version " + JVXL_VERSION + "\n";
    }

    public static String jvxlGetFile(MeshDataServer meshDataServer, JvxlData jvxlData, MeshData meshData, String[] stringArray, String string, boolean bl, int n, String string2, String string3) {
        CharSequence charSequence;
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            charSequence = jvxlData.jvxlFileHeader + (n > 0 ? -n + jvxlData.jvxlExtraLine.substring(2) : jvxlData.jvxlExtraLine);
            if (((String)charSequence).indexOf("#JVXL") != 0) {
                stringBuffer.append("#JVXL").append(jvxlData.isXLowToHigh ? "+" : "").append(" VERSION ").append(JVXL_VERSION).append("\n");
            }
            stringBuffer.append((String)charSequence);
        }
        if ("HEADERONLY".equals(string)) {
            return stringBuffer.toString();
        }
        stringBuffer.append("# ").append(string).append('\n');
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append("# ").append(stringArray[i]).append('\n');
            }
        }
        stringBuffer.append(jvxlData.jvxlDefinitionLine + " rendering:" + string2).append('\n');
        charSequence = new StringBuffer();
        if (jvxlData.vertexDataOnly && meshData != null) {
            int[] nArray = new int[meshData.vertexCount];
            ((StringBuffer)charSequence).append("<jvxlSurfaceData>\n");
            ((StringBuffer)charSequence).append(JvxlReader.jvxlEncodeTriangleData(meshData.polygonIndexes, meshData.polygonCount, nArray));
            ((StringBuffer)charSequence).append(JvxlReader.jvxlEncodeVertexData(meshDataServer, jvxlData, nArray, meshData.vertices, meshData.vertexValues, meshData.vertexCount, meshData.polygonColixes, meshData.polygonCount, jvxlData.jvxlColorData.length() > 0));
            ((StringBuffer)charSequence).append("</jvxlSurfaceData>\n");
        } else if (jvxlData.jvxlPlane == null) {
            ((StringBuffer)charSequence).append(jvxlData.jvxlSurfaceData);
            ((StringBuffer)charSequence).append(JvxlReader.jvxlCompressString(jvxlData.jvxlEdgeData)).append('\n').append(JvxlReader.jvxlCompressString(jvxlData.jvxlColorData)).append('\n');
        } else {
            ((StringBuffer)charSequence).append(JvxlReader.jvxlCompressString(jvxlData.jvxlColorData)).append('\n');
        }
        int n2 = ((StringBuffer)charSequence).length();
        if (n2 > 0) {
            jvxlData.jvxlCompressionRatio = jvxlData.wasCubic && jvxlData.nBytes > 0 ? (int)((float)jvxlData.nBytes / (float)n2) : (int)((float)(jvxlData.nPointsX * jvxlData.nPointsY * jvxlData.nPointsZ * 13) / (float)n2);
        }
        stringBuffer.append((StringBuffer)charSequence);
        if (bl) {
            if (string != null && !jvxlData.vertexDataOnly) {
                stringBuffer.append("#-------end of jvxl file data-------\n");
            }
            stringBuffer.append(jvxlData.jvxlInfoLine).append('\n');
            if (jvxlData.vContours != null) {
                stringBuffer.append("<jvxlContourData>\n");
                JvxlReader.jvxlEncodeContourData(jvxlData.vContours, stringBuffer);
                stringBuffer.append("</jvxlContourData>\n");
            }
            if (string3 != null) {
                stringBuffer.append("<jvxlSurfaceCommand>\n  ").append(string3).append("\n</jvxlSurfaceCommand>\n");
            }
            if (string2 != null) {
                stringBuffer.append("<jvxlSurfaceState>\n  ").append(string2).append("\n</jvxlSurfaceState>\n");
            }
            if (bl) {
                stringBuffer.append("<jvxlFileTitle>\n").append(jvxlData.jvxlFileTitle).append("</jvxlFileTitle>\n");
            }
        }
        return stringBuffer.toString();
    }

    private static void jvxlEncodeContourData(Vector[] vectorArray, StringBuffer stringBuffer) {
        for (int i = 0; i < vectorArray.length; ++i) {
            if (vectorArray[i].size() < 5) continue;
            int n = (Integer)vectorArray[i].get(0);
            stringBuffer.append("<jvxlContour i=\"" + i + "\"");
            stringBuffer.append(" value=\"" + vectorArray[i].get(2) + "\"");
            stringBuffer.append(" color=\"" + Escape.escapeColor(((int[])vectorArray[i].get(3))[0]) + "\"");
            stringBuffer.append(" npolygons=\"" + n + "\"");
            StringBuffer stringBuffer2 = new StringBuffer();
            JvxlReader.jvxlEncodeBitSet((BitSet)vectorArray[i].get(1), n, stringBuffer2);
            stringBuffer.append(" data=\"" + vectorArray[i].get(4) + "\">\n");
            stringBuffer.append(stringBuffer2);
            stringBuffer.append("</jvxlContour>\n");
        }
    }

    protected static float jvxlFractionFromCharacter(int n, int n2, int n3, float f) {
        float f2;
        if (n == n2 + n3) {
            return Float.NaN;
        }
        if (n < n2) {
            n = 92;
        }
        if ((f2 = ((float)(n - n2) + f) / (float)n3) < 0.0f) {
            return 0.0f;
        }
        if (f2 > 1.0f) {
            return 0.999999f;
        }
        return f2;
    }

    protected static float jvxlValueFromCharacter2(int n, int n2, float f, float f2, int n3, int n4) {
        float f3 = JvxlReader.jvxlFractionFromCharacter2(n, n2, n3, n4);
        return f2 == f ? f3 : f + f3 * (f2 - f);
    }

    protected static float jvxlFractionFromCharacter2(int n, int n2, int n3, int n4) {
        float f = JvxlReader.jvxlFractionFromCharacter(n, n3, n4, 0.0f);
        float f2 = JvxlReader.jvxlFractionFromCharacter(n2, n3, n4, 0.5f);
        return f + f2 / (float)n4;
    }

    protected static char jvxlValueAsCharacter(float f, float f2, float f3, int n, int n2) {
        float f4 = f2 == f3 ? f : (f - f2) / (f3 - f2);
        return JvxlReader.jvxlFractionAsCharacter(f4, n, n2);
    }

    public static char jvxlFractionAsCharacter(float f) {
        return JvxlReader.jvxlFractionAsCharacter(f, 35, 90);
    }

    protected static char jvxlFractionAsCharacter(float f, int n, int n2) {
        if (f > 0.9999f) {
            f = 0.9999f;
        } else if (Float.isNaN(f)) {
            f = 1.0001f;
        }
        int n3 = (int)(f * (float)n2 + (float)n);
        if (n3 < n) {
            return (char)n;
        }
        if (n3 == 92) {
            return '!';
        }
        return (char)n3;
    }

    private static void jvxlAppendCharacter2(float f, float f2, float f3, int n, int n2, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        float f4 = f2 == f3 ? f : (f - f2) / (f3 - f2);
        char c = JvxlReader.jvxlFractionAsCharacter(f4, n, n2);
        stringBuffer.append(c);
        stringBuffer2.append(JvxlReader.jvxlFractionAsCharacter((f4 -= JvxlReader.jvxlFractionFromCharacter(c, n, n2, 0.0f)) * (float)n2, n, n2));
    }

    public static void jvxlUpdateSurfaceData(JvxlData jvxlData, float[] fArray, int n, int n2, char c) {
        char[] cArray = jvxlData.jvxlEdgeData.toCharArray();
        int n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            if (Float.isNaN(fArray[n3])) {
                cArray[n4] = c;
            }
            n3 += n2;
            ++n4;
        }
        jvxlData.jvxlEdgeData = String.copyValueOf(cArray);
    }

    public static void jvxlCreateColorData(JvxlData jvxlData, float[] fArray) {
        if (fArray == null) {
            jvxlData.jvxlColorData = "";
            return;
        }
        boolean bl = jvxlData.isJvxlPrecisionColor;
        boolean bl2 = jvxlData.isTruncated;
        int n = jvxlData.colorFractionBase;
        int n2 = jvxlData.colorFractionRange;
        float f = jvxlData.valueMappedToBlue;
        float f2 = jvxlData.valueMappedToRed;
        int n3 = jvxlData.vertexCount;
        float f3 = jvxlData.mappedDataMin;
        float f4 = jvxlData.mappedDataMax;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < n3; ++i) {
            float f5 = fArray[i];
            if (bl2) {
                float f6 = f5 = f5 > 0.0f ? 0.999f : -0.999f;
            }
            if (bl) {
                JvxlReader.jvxlAppendCharacter2(f5, f3, f4, n, n2, stringBuffer, stringBuffer2);
                continue;
            }
            stringBuffer.append(JvxlReader.jvxlValueAsCharacter(f5, f2, f, n, n2));
        }
        jvxlData.jvxlColorData = stringBuffer.append(stringBuffer2).append('\n').toString();
        JvxlReader.jvxlUpdateInfoLines(jvxlData);
    }

    public static String jvxlEncodeTriangleData(int[][] nArray, int n, int[] nArray2) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n2 = 1;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        int n5 = 0;
        while (n5 < n) {
            int n6 = nArray[n5][n3];
            n6 = nArray2[n6] > 0 ? nArray2[n6] : (nArray2[n6] = ++n4);
            if (++n3 % 3 == 0) {
                ++n5;
                n3 = 0;
            }
            int n7 = n6 - n2;
            n2 = n6;
            if (n7 == 0) {
                stringBuffer2.append('!');
                bl = false;
                continue;
            }
            if (n7 > 32) {
                if (bl) {
                    stringBuffer2.append('+');
                }
                stringBuffer2.append(n7);
                bl = true;
                continue;
            }
            if (n7 < -32) {
                stringBuffer2.append(n7);
                bl = true;
                continue;
            }
            stringBuffer2.append((char)(92 + n7));
            bl = false;
        }
        return stringBuffer.append("  <jvxlTriangleData len=\"" + stringBuffer2.length() + "\" count=\"" + n + "\">\n    ").append(stringBuffer2).append("\n  </jvxlTriangleData>\n").toString();
    }

    public static String jvxlEncodeVertexData(MeshDataServer meshDataServer, JvxlData jvxlData, int[] nArray, Point3f[] point3fArray, float[] fArray, int n, short[] sArray, int n2, boolean bl) {
        int n3;
        Point3f point3f;
        Point3f point3f2 = new Point3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        Point3f point3f3 = new Point3f(Float.MIN_VALUE, Float.MIN_VALUE, Float.MIN_VALUE);
        int n4 = jvxlData.colorFractionBase;
        int n5 = jvxlData.colorFractionRange;
        for (int i = 0; i < n; ++i) {
            point3f = point3fArray[i];
            if (point3f.x < point3f2.x) {
                point3f2.x = point3f.x;
            }
            if (point3f.y < point3f2.y) {
                point3f2.y = point3f.y;
            }
            if (point3f.z < point3f2.z) {
                point3f2.z = point3f.z;
            }
            if (point3f.x > point3f3.x) {
                point3f3.x = point3f.x;
            }
            if (point3f.y > point3f3.y) {
                point3f3.y = point3f.y;
            }
            if (!(point3f.z > point3f3.z)) continue;
            point3f3.z = point3f.z;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        int[] nArray2 = new int[n];
        for (n3 = 0; n3 < n; ++n3) {
            if (nArray[n3] <= 0) continue;
            nArray2[nArray[n3] - 1] = n3;
        }
        for (n3 = 0; n3 < n; ++n3) {
            point3f = point3fArray[nArray2[n3]];
            JvxlReader.jvxlAppendCharacter2(point3f.x, point3f2.x, point3f3.x, n4, n5, stringBuffer2, stringBuffer3);
            JvxlReader.jvxlAppendCharacter2(point3f.y, point3f2.y, point3f3.y, n4, n5, stringBuffer2, stringBuffer3);
            JvxlReader.jvxlAppendCharacter2(point3f.z, point3f2.z, point3f3.z, n4, n5, stringBuffer2, stringBuffer3);
        }
        stringBuffer2.append(stringBuffer3);
        stringBuffer.append("  <jvxlVertexData len=\"" + stringBuffer2.length() + "\" count=\"" + n + "\" min=\"" + point3f2 + "\" max=\"" + point3f3 + "\">\n    ");
        stringBuffer.append(stringBuffer2).append("\n  </jvxlVertexData>\n");
        if (sArray != null) {
            stringBuffer2 = new StringBuffer();
            n3 = 0;
            short s = 0;
            boolean bl2 = false;
            int n6 = 0;
            while (true) {
                if (n6 >= n2) {
                    bl2 = true;
                    if (!true) break;
                }
                if (bl2 || sArray[n6] != s) {
                    if (n3 != 0) {
                        stringBuffer2.append(" ").append(n3).append(" ").append(s == 0 ? 0 : meshDataServer.getColixArgb(s));
                    }
                    if (bl2) break;
                    s = sArray[n6];
                    n3 = 1;
                } else {
                    ++n3;
                }
                ++n6;
            }
            stringBuffer.append("  <jvxlPolygonColorData len=\"" + stringBuffer2.length() + "\" count=\"" + n2 + "\">\n    ").append(stringBuffer2).append("\n  </jvxlPolygonColorData>\n");
        }
        if (!bl) {
            return stringBuffer.toString();
        }
        stringBuffer2 = new StringBuffer();
        stringBuffer3 = new StringBuffer();
        for (n3 = 0; n3 < n; ++n3) {
            float f = fArray[nArray2[n3]];
            JvxlReader.jvxlAppendCharacter2(f, jvxlData.mappedDataMin, jvxlData.mappedDataMax, n4, n5, stringBuffer2, stringBuffer3);
        }
        String string = JvxlReader.jvxlCompressString(stringBuffer2.append(stringBuffer3).toString());
        return stringBuffer.append("  <jvxlColorData len=\"" + string.length() + "\" count=\"" + n + "\" compressed=\"1\" precision=\"true\">\n    ").append(string).append("\n  </jvxlColorData>\n").toString();
    }

    private void getEncodedVertexData() throws Exception {
        String string = this.getXmlData("jvxlSurfaceData", null, true);
        this.jvxlDecodeVertexData(this.getXmlData("jvxlVertexData", string, true), false);
        String string2 = this.getXmlData("jvxlPolygonColorData", string, false);
        this.jvxlDecodeTriangleData(this.getXmlData("jvxlTriangleData", string, true), string2, false);
        Logger.info("Checking for vertex values");
        this.jvxlColorDataRead = JvxlReader.jvxlUncompressString(this.getXmlData("jvxlColorData", string, false));
        this.jvxlDataIsColorMapped = this.jvxlColorDataRead.length() > 0;
        this.jvxlDataIsPrecisionColor = string.indexOf("precision=\"true\"") >= 0;
        this.jvxlDecodeContourData(this.getXmlData("jvxlContourData", null, false));
        Logger.info("Done");
    }

    private void jvxlDecodeContourData(String string) throws Exception {
        Vector vector = new Vector();
        int n = -1;
        this.vContours = null;
        if (string == null) {
            return;
        }
        while ((n = string.indexOf("<jvxlContour", n + 1)) >= 0) {
            Vector vector2 = new Vector();
            String string2 = this.getXmlData("jvxlContour", string.substring(n), true);
            int n2 = this.parseInt(JvxlReader.getXmlAttrib(string2, "npolygons"));
            float f = this.parseFloat(JvxlReader.getXmlAttrib(string2, "value"));
            int n3 = Escape.unescapeColor(JvxlReader.getXmlAttrib(string2, "color"));
            String string3 = JvxlReader.getXmlAttrib(string2, "data");
            BitSet bitSet = JvxlReader.jvxlDecodeBitSet(string2.substring(string2.lastIndexOf("\">") + 2));
            IsosurfaceMesh.setContourVector(vector2, n2, bitSet, f, n3, new StringBuffer(string3));
            vector.add(vector2);
        }
        this.vContours = new Vector[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            this.vContours[i] = (Vector)vector.get(i);
        }
    }

    public static void set3dContourVector(Vector vector, int[][] nArray, Point3f[] point3fArray) {
        if (vector.size() < 5) {
            return;
        }
        String string = ((StringBuffer)vector.get(4)).toString();
        BitSet bitSet = (BitSet)vector.get(1);
        int n = (Integer)vector.get(0);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3;
            int n4;
            int n5;
            int n6;
            if (!bitSet.get(i)) continue;
            int[] nArray2 = nArray[i];
            int n7 = string.charAt(n2++) - 48;
            char c = string.charAt(n2++);
            char c2 = string.charAt(n2++);
            float f = JvxlReader.jvxlFractionFromCharacter(c, 35, 90, 0.0f);
            float f2 = JvxlReader.jvxlFractionFromCharacter(c2, 35, 90, 0.0f);
            if ((n7 & 1) == 0) {
                n6 = nArray2[1];
                n4 = n5 = nArray2[2];
                n3 = nArray2[0];
            } else {
                n6 = nArray2[0];
                n4 = nArray2[1];
                if ((n7 & 2) != 0) {
                    n5 = n4;
                    n3 = nArray2[2];
                } else {
                    n5 = nArray2[2];
                    n3 = n6;
                }
            }
            Point3f point3f = IsosurfaceMesh.getContourPoint(point3fArray, n6, n4, f);
            Point3f point3f2 = IsosurfaceMesh.getContourPoint(point3fArray, n5, n3, f2);
            vector.add(point3f);
            vector.add(point3f2);
        }
        vector.add(new Point3f(Float.NaN, Float.NaN, Float.NaN));
    }

    private String getXmlData(String string, String string2, boolean bl) throws Exception {
        String string3 = "</" + string + ">";
        String string4 = "<" + string;
        if (string2 == null) {
            StringBuffer stringBuffer = new StringBuffer();
            try {
                while (this.line.indexOf(string4) < 0) {
                    this.line = this.br.readLine();
                }
            }
            catch (Exception exception) {
                return null;
            }
            stringBuffer.append(this.line);
            while (this.line.indexOf(string3) < 0) {
                this.line = this.br.readLine();
                stringBuffer.append(this.line);
            }
            string2 = stringBuffer.toString();
        }
        int n = string2.indexOf(string4);
        int n2 = string2.indexOf(string3);
        if (n >= 0 && !bl) {
            n = string2.indexOf(">", n) + 1;
            while (Character.isWhitespace(string2.charAt(n))) {
                ++n;
            }
        }
        if (n < 0 || n > n2) {
            return "";
        }
        return string2.substring(n, n2);
    }

    public Point3f[] jvxlDecodeVertexData(String string, boolean bl) {
        int[] nArray = new int[1];
        JvxlReader.setNext(string, "count", nArray, 2);
        int n = Parser.parseInt(string, nArray);
        if (!bl) {
            Logger.info("Reading " + n + " vertices");
        }
        nArray[0] = nArray[0] + 1;
        Point3f point3f = new Point3f();
        Point3f point3f2 = new Point3f();
        JvxlReader.setNext(string, "min", nArray, 3);
        point3f.x = Parser.parseFloat(string, nArray);
        nArray[0] = nArray[0] + 1;
        point3f.y = Parser.parseFloat(string, nArray);
        nArray[0] = nArray[0] + 1;
        point3f.z = Parser.parseFloat(string, nArray);
        JvxlReader.setNext(string, "max", nArray, 3);
        point3f2.x = Parser.parseFloat(string, nArray) - point3f.x;
        nArray[0] = nArray[0] + 1;
        point3f2.y = Parser.parseFloat(string, nArray) - point3f.y;
        nArray[0] = nArray[0] + 1;
        point3f2.z = Parser.parseFloat(string, nArray) - point3f.z;
        int n2 = this.jvxlData.colorFractionBase;
        int n3 = this.jvxlData.colorFractionRange;
        int n4 = n * 3;
        Point3f[] point3fArray = bl ? new Point3f[n] : null;
        Point3f point3f3 = bl ? null : new Point3f();
        JvxlReader.setNext(string, ">", nArray, 0);
        int n5 = nArray[0];
        while (Character.isWhitespace(string.charAt(n5))) {
            ++n5;
        }
        --n5;
        for (int i = 0; i < n; ++i) {
            if (bl) {
                point3f3 = point3fArray[i] = new Point3f();
            }
            float f = JvxlReader.jvxlFractionFromCharacter2(string.charAt(++n5), string.charAt(n5 + n4), n2, n3);
            point3f3.x = point3f.x + f * point3f2.x;
            f = JvxlReader.jvxlFractionFromCharacter2(string.charAt(++n5), string.charAt(n5 + n4), n2, n3);
            point3f3.y = point3f.y + f * point3f2.y;
            f = JvxlReader.jvxlFractionFromCharacter2(string.charAt(++n5), string.charAt(n5 + n4), n2, n3);
            point3f3.z = point3f.z + f * point3f2.z;
            if (bl) continue;
            this.addVertexCopy(point3f3, 0.0f, i);
        }
        return point3fArray;
    }

    int[][] jvxlDecodeTriangleData(String string, String string2, boolean bl) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n = string2 == null ? -1 : 0;
        int n2 = 0;
        JvxlReader.setNext(string, "count", nArray, 2);
        int n3 = Parser.parseInt(string, nArray);
        if (!bl) {
            Logger.info("Reading " + n3 + " triangles");
        }
        int[][] nArray3 = bl ? new int[n3][3] : (int[][])null;
        int[] nArray4 = bl ? nArray3[0] : new int[3];
        int n4 = 0;
        int n5 = 0;
        int n6 = 92;
        JvxlReader.setNext(string, ">", nArray, -1);
        int n7 = nArray[0];
        int n8 = 0;
        block5: while (n8 < n3) {
            int n9;
            char c = string.charAt(++n7);
            switch (c) {
                case '!': {
                    n9 = 0;
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '+': 
                case ',': 
                case '.': {
                    continue block5;
                }
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    nArray[0] = n7;
                    n9 = Parser.parseInt(string, nArray);
                    n7 = nArray[0] - 1;
                    break;
                }
                default: {
                    n9 = c - n6;
                }
            }
            n4 += n9;
            if (bl) {
                nArray3[n8][n5] = n4;
            } else {
                nArray4[n5] = n4;
            }
            if (++n5 % 3 != 0) continue;
            ++n8;
            n5 = 0;
            if (bl) continue;
            if (n >= 0) {
                if (n == 0) {
                    n = Parser.parseInt(string2, nArray2);
                    n2 = Parser.parseInt(string2, nArray2);
                    if (n2 == Integer.MIN_VALUE) {
                        n = 0;
                        n2 = 0;
                    }
                }
                --n;
            }
            this.addTriangleCheck(nArray4[0], nArray4[1], nArray4[2], 7, false, n2);
        }
        return nArray3;
    }

    private static String getXmlAttrib(String string, String string2) {
        int[] nArray = new int[1];
        int n = JvxlReader.setNext(string, string2, nArray, 2);
        if (n < 2) {
            return "";
        }
        int n2 = JvxlReader.setNext(string, "\"", nArray, -1);
        return n2 <= 0 ? "" : string.substring(n, n2);
    }

    private static int setNext(String string, String string2, int[] nArray, int n) {
        nArray[0] = string.indexOf(string2, nArray[0]) + string2.length() + n;
        return nArray[0];
    }
}

