/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import org.jmol.jvxl.readers.JvxlReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;
import org.jmol.util.Parser;

class ApbsReader
extends VolumeFileReader {
    ApbsReader(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        super(surfaceGenerator, bufferedReader);
        this.isApbsDx = true;
        this.jvxlData.wasCubic = true;
    }

    protected void readTitleLines() throws Exception {
        this.jvxlFileHeaderBuffer = new StringBuffer(this.skipComments(false));
        while (this.line != null && this.line.length() == 0) {
            this.line = this.br.readLine();
        }
        this.jvxlFileHeaderBuffer.append("APBS OpenDx DATA ").append(this.line).append("\n");
        this.jvxlFileHeaderBuffer.append("see http://apbs.sourceforge.net\n");
        this.isAngstroms = true;
    }

    protected void readAtomCountAndOrigin() throws Exception {
        String string = this.br.readLine();
        String[] stringArray = Parser.getTokens(string, 0);
        this.negativeAtomCount = false;
        this.atomCount = 0;
        if (stringArray.length >= 4) {
            this.volumetricOrigin.set(this.parseFloat(stringArray[1]), this.parseFloat(stringArray[2]), this.parseFloat(stringArray[3]));
        }
        JvxlReader.jvxlCheckAtomLine(this.isXLowToHigh, this.isAngstroms, stringArray[0], string, this.jvxlFileHeaderBuffer);
    }

    protected void readVoxelVector(int n) throws Exception {
        super.readVoxelVector(n);
        if (n == 2) {
            this.line = this.br.readLine();
            String[] stringArray = this.getTokens();
            for (int i = 0; i < 3; ++i) {
                this.voxelCounts[i] = this.parseInt(stringArray[i + 5]);
            }
            this.br.readLine();
        }
    }
}

