/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.calc;

import java.util.BitSet;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.jvxl.api.VertexDataServer;
import org.jmol.jvxl.calc.TriangleData;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.jvxl.readers.JvxlReader;

public class MarchingCubes
extends TriangleData {
    private VertexDataServer surfaceReader;
    private VolumeData volumeData;
    private int contourType;
    private boolean isContoured;
    private float cutoff;
    private boolean isCutoffAbsolute;
    private boolean isSquared;
    private boolean isXLowToHigh;
    private int cubeCountX;
    private int cubeCountY;
    private int cubeCountZ;
    private int nY;
    private int nZ;
    private int yzCount;
    private float fractionOutside;
    private boolean integrateSquared = true;
    private BitSet bsVoxels;
    private StringBuffer edgeData = new StringBuffer();
    private int mode;
    private static final int MODE_CUBE = 1;
    private static final int MODE_BITSET = 2;
    private static final int MODE_GETXYZ = 3;
    private final float[] vertexValues = new float[8];
    int edgeCount;
    private final Vector3f[] voxelVertexVectors = new Vector3f[8];
    private final Vector3f[] edgeVectors = new Vector3f[12];
    private static int[] yzPlanePts = new int[]{0, 1, 1, 0, 0, 1, 1, 0};
    private final int[] edgePointIndexes;
    private int[][][] isoPointIndexPlanes;
    private float[][] yzPlanes;
    Vector3f vTemp;
    private BitSet bsValues;
    private final Point3f pt0;
    private final Point3f pointA;
    private static final int[] edgeVertexPointersLowToHigh = new int[]{1, 1, 2, 0, 5, 5, 6, 4, 0, 1, 2, 3};
    private static final int[] edgeVertexPointersHighToLow = new int[]{0, 1, 3, 0, 4, 5, 7, 4, 0, 1, 2, 3};
    private int[] edgeVertexPointers;
    private static final int[] edgeVertexPlanesLowToHigh = new int[]{1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 1, 0};
    private static final int[] edgeVertexPlanesHighToLow = new int[]{1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1};
    private int[] edgeVertexPlanes;
    private float[] fReturn;
    private static final Vector3f[] cubeVertexVectors = new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(0.0f, 1.0f, 1.0f)};
    private static final int[] edgeTypeTable = new int[]{0, 2, 0, 2, 0, 2, 0, 2, 1, 1, 1, 1};
    private final int[] linearOffsets;
    private static final short[] insideMaskTable = new short[]{0, 265, 515, 778, 1030, 1295, 1541, 1804, 2060, 2309, 2575, 2822, 3082, 3331, 3593, 3840, 400, 153, 915, 666, 1430, 1183, 1941, 1692, 2460, 2197, 2975, 2710, 3482, 3219, 3993, 3728, 560, 825, 51, 314, 1590, 1855, 1077, 1340, 2620, 2869, 2111, 2358, 3642, 3891, 3129, 3376, 928, 681, 419, 170, 1958, 1711, 1445, 1196, 2988, 2725, 2479, 2214, 4010, 3747, 3497, 3232, 1120, 1385, 1635, 1898, 102, 367, 613, 876, 3180, 3429, 3695, 3942, 2154, 2403, 2665, 2912, 1520, 1273, 2035, 1786, 502, 255, 1013, 764, 3580, 3317, 4095, 3830, 2554, 2291, 3065, 2800, 1616, 1881, 1107, 1370, 598, 863, 85, 348, 3676, 3925, 3167, 3414, 2650, 2899, 2137, 2384, 1984, 1737, 1475, 1226, 966, 719, 453, 204, 4044, 3781, 3535, 3270, 3018, 2755, 2505, 2240, 2240, 2505, 2755, 3018, 3270, 3535, 3781, 4044, 204, 453, 719, 966, 1226, 1475, 1737, 1984, 2384, 2137, 2899, 2650, 3414, 3167, 3925, 3676, 348, 85, 863, 598, 1370, 1107, 1881, 1616, 2800, 3065, 2291, 2554, 3830, 4095, 3317, 3580, 764, 1013, 255, 502, 1786, 2035, 1273, 1520, 2912, 2665, 2403, 2154, 3942, 3695, 3429, 3180, 876, 613, 367, 102, 1898, 1635, 1385, 1120, 3232, 3497, 3747, 4010, 2214, 2479, 2725, 2988, 1196, 1445, 1711, 1958, 170, 419, 681, 928, 3376, 3129, 3891, 3642, 2358, 2111, 2869, 2620, 1340, 1077, 1855, 1590, 314, 51, 825, 560, 3728, 3993, 3219, 3482, 2710, 2975, 2197, 2460, 1692, 1941, 1183, 1430, 666, 915, 153, 400, 3840, 3593, 3331, 3082, 2822, 2575, 2309, 2060, 1804, 1541, 1295, 1030, 778, 515, 265, 0};

    public BitSet getBsVoxels() {
        return this.bsVoxels;
    }

    public MarchingCubes() {
        int n = 12;
        while (--n >= 0) {
            this.edgeVectors[n] = new Vector3f();
        }
        this.edgePointIndexes = new int[12];
        this.vTemp = new Vector3f();
        this.bsValues = new BitSet();
        this.pt0 = new Point3f();
        this.pointA = new Point3f();
        this.fReturn = new float[1];
        this.linearOffsets = new int[8];
    }

    public MarchingCubes(VertexDataServer vertexDataServer, VolumeData volumeData, BitSet bitSet, boolean bl, int n, float f, boolean bl2, boolean bl3, boolean bl4) {
        int n2 = 12;
        while (--n2 >= 0) {
            this.edgeVectors[n2] = new Vector3f();
        }
        this.edgePointIndexes = new int[12];
        this.vTemp = new Vector3f();
        this.bsValues = new BitSet();
        this.pt0 = new Point3f();
        this.pointA = new Point3f();
        this.fReturn = new float[1];
        this.linearOffsets = new int[8];
        this.surfaceReader = vertexDataServer;
        this.volumeData = volumeData;
        this.isContoured = bl;
        this.cutoff = f;
        this.isCutoffAbsolute = bl2;
        this.contourType = n;
        this.isSquared = bl3;
        this.isXLowToHigh = bl4;
        this.cubeCountX = volumeData.voxelCounts[0] - 1;
        this.nY = volumeData.voxelCounts[1];
        this.cubeCountY = this.nY - 1;
        this.nZ = volumeData.voxelCounts[2];
        this.cubeCountZ = this.nZ - 1;
        if (volumeData.voxelData != null) {
            this.mode = 1;
        } else {
            this.mode = bitSet == null ? 3 : 2;
            this.bsVoxels = bitSet;
        }
        this.yzCount = this.nY * this.nZ;
        if (this.bsVoxels == null) {
            this.bsVoxels = new BitSet();
        }
        this.edgeVertexPointers = bl4 ? edgeVertexPointersLowToHigh : edgeVertexPointersHighToLow;
        this.edgeVertexPlanes = bl4 ? edgeVertexPlanesLowToHigh : edgeVertexPlanesHighToLow;
        this.isoPointIndexPlanes = new int[2][this.yzCount][3];
        this.yzPlanes = this.mode == 3 ? new float[2][this.yzCount] : (float[][])null;
        this.setLinearOffsets();
        this.calcVoxelVertexVectors();
    }

    private void calcVoxelVertexVectors() {
        this.volumeData.setMatrix();
        int n = 8;
        while (--n >= 0) {
            this.voxelVertexVectors[n] = new Vector3f();
            this.volumeData.transform(cubeVertexVectors[n], this.voxelVertexVectors[n]);
        }
        n = 12;
        while (--n >= 0) {
            this.edgeVectors[n].sub(this.voxelVertexVectors[edgeVertexes[n + n + 1]], this.voxelVertexVectors[edgeVertexes[n + n]]);
        }
    }

    private int[][] resetIndexPlane(int[][] nArray) {
        for (int i = 0; i < this.yzCount; ++i) {
            for (int j = 0; j < 3; ++j) {
                nArray[i][j] = -1;
            }
        }
        return nArray;
    }

    public String getEdgeData() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        this.edgeCount = 0;
        if (this.isXLowToHigh) {
            n7 = 0;
            n6 = this.cubeCountX;
            n5 = 1;
            n4 = this.yzCount;
            n2 = n3 = this.yzCount - 1 - this.nZ - 1;
        } else {
            n7 = this.cubeCountX - 1;
            n6 = -1;
            n5 = -1;
            n4 = -this.yzCount;
            n2 = n3 = this.cubeCountX * this.yzCount - 1 - this.nZ - 1;
        }
        int n11 = n = this.cubeCountY * this.cubeCountZ - 1;
        this.resetIndexPlane(this.isoPointIndexPlanes[1]);
        for (int i = n7; i != n6; i += n5) {
            Object object;
            if (this.mode == 3) {
                object = this.yzPlanes[0];
                this.yzPlanes[0] = this.yzPlanes[1];
                this.yzPlanes[1] = object;
            }
            object = this.isoPointIndexPlanes[0];
            this.isoPointIndexPlanes[0] = this.isoPointIndexPlanes[1];
            this.isoPointIndexPlanes[1] = this.resetIndexPlane((int[][])object);
            int n12 = this.cubeCountY;
            while (--n12 >= 0) {
                int n13 = this.cubeCountZ;
                while (--n13 >= 0) {
                    int n14;
                    int n15 = 0;
                    int n16 = 8;
                    while (--n16 >= 0) {
                        Point3i point3i = cubeVertexOffsets[n16];
                        int n17 = n2 + this.linearOffsets[n16];
                        switch (this.mode) {
                            case 3: {
                                this.vertexValues[n16] = this.getValue(n16, i + point3i.x, n12 + point3i.y, n13 + point3i.z, n17, this.yzPlanes[yzPlanePts[n16]]);
                                n14 = this.bsVoxels.get(n17) ? 1 : 0;
                                break;
                            }
                            case 2: {
                                n14 = this.bsVoxels.get(n17);
                                this.vertexValues[n16] = n14 != 0 ? 1 : 0;
                                break;
                            }
                            default: {
                                this.vertexValues[n16] = this.volumeData.voxelData[i + point3i.x][n12 + point3i.y][n13 + point3i.z];
                                if (this.isSquared) {
                                    int n18 = n16;
                                    this.vertexValues[n18] = this.vertexValues[n18] * this.vertexValues[n16];
                                }
                                n14 = MarchingCubes.isInside(this.vertexValues[n16], this.cutoff, this.isCutoffAbsolute) ? 1 : 0;
                            }
                        }
                        if (n14 != 0) {
                            this.bsVoxels.set(n17);
                            n15 |= Pwr2[n16];
                            continue;
                        }
                        this.fractionOutside += this.integrateSquared ? this.vertexValues[n16] * this.vertexValues[n16] : this.vertexValues[n16];
                    }
                    if (n15 == 0) {
                        ++n9;
                    } else if (n15 == 255) {
                        ++n8;
                    } else {
                        ++n10;
                        if (this.processOneCubical(n15, i, n12, n13, n2) && !this.isContoured) {
                            byte[] byArray = triangleTable2[n15];
                            n14 = byArray.length;
                            while ((n14 -= 4) >= 0) {
                                this.addTriangle(byArray[n14], byArray[n14 + 1], byArray[n14 + 2], byArray[n14 + 3]);
                            }
                        }
                    }
                    --n2;
                    --n11;
                }
                --n2;
            }
            n2 = n3 += n4;
            n11 = n;
        }
        System.out.println("MarchingCubes: fractionOutside = " + this.fractionOutside / 8.0f);
        return this.edgeData.toString();
    }

    private void addTriangle(int n, int n2, int n3, int n4) {
        this.surfaceReader.addTriangleCheck(this.edgePointIndexes[n], this.edgePointIndexes[n2], this.edgePointIndexes[n3], n4, this.isCutoffAbsolute, 0);
    }

    private float getValue(int n, int n2, int n3, int n4, int n5, float[] fArray) {
        if (this.bsValues.get(n5)) {
            return fArray[n5 % this.yzCount];
        }
        this.bsValues.set(n5);
        float f = this.surfaceReader.getValue(n2, n3, n4);
        if (this.isSquared) {
            f *= f;
        }
        fArray[n5 % this.yzCount] = f;
        if (MarchingCubes.isInside(f, this.cutoff, this.isCutoffAbsolute)) {
            this.bsVoxels.set(n5);
        }
        return f;
    }

    public static boolean isInside(float f, float f2, boolean bl) {
        return f2 > 0.0f && (bl ? Math.abs(f) : f) >= f2 || f2 <= 0.0f && f <= f2;
    }

    private boolean processOneCubical(int n, int n2, int n3, int n4, int n5) {
        short s = insideMaskTable[n];
        boolean bl = false;
        int n6 = 12;
        while (--n6 >= 0) {
            int n7;
            int n8;
            int n9;
            int n10;
            int n11 = Pwr2[n6];
            if ((s & n11) == 0 || (n10 = (this.edgePointIndexes[n6] = this.isoPointIndexPlanes[n9 = this.edgeVertexPlanes[n6]][n8 = (n5 + this.linearOffsets[this.edgeVertexPointers[n6]]) % this.yzCount][n7 = edgeTypeTable[n6]])) >= 0) continue;
            byte by = edgeVertexes[n6 << 1];
            byte by2 = edgeVertexes[(n6 << 1) + 1];
            float f = this.vertexValues[by];
            float f2 = this.vertexValues[by2];
            if (Float.isNaN(f) || Float.isNaN(f2)) {
                bl = true;
            }
            this.calcVertexPoint(n2, n3, n4, by, this.pointA);
            ++this.edgeCount;
            int n12 = this.surfaceReader.getSurfacePointIndexAndFraction(this.cutoff, this.isCutoffAbsolute, n2, n3, n4, cubeVertexOffsets[by], by, by2, f, f2, this.pointA, this.edgeVectors[n6], n7 == this.contourType, this.fReturn);
            this.isoPointIndexPlanes[n9][n8][n7] = n12;
            this.edgePointIndexes[n6] = n12;
            this.edgeData.append(JvxlReader.jvxlFractionAsCharacter(this.fReturn[0]));
        }
        return !bl;
    }

    public void calcVertexPoint(int n, int n2, int n3, int n4, Point3f point3f) {
        this.volumeData.voxelPtToXYZ(n, n2, n3, this.pt0);
        point3f.add(this.pt0, this.voxelVertexVectors[n4]);
    }

    private void setLinearOffsets() {
        this.linearOffsets[0] = 0;
        this.linearOffsets[1] = this.yzCount;
        this.linearOffsets[2] = this.yzCount + 1;
        this.linearOffsets[3] = 1;
        this.linearOffsets[4] = this.nZ;
        this.linearOffsets[5] = this.yzCount + this.nZ;
        this.linearOffsets[6] = this.yzCount + this.nZ + 1;
        this.linearOffsets[7] = this.nZ + 1;
    }

    public int getLinearOffset(int n, int n2, int n3, int n4) {
        return n * this.yzCount + n2 * this.nZ + n3 + this.linearOffsets[n4];
    }
}

