/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import org.jmol.g3d.Graphics3D;

final class Shade3D {
    static final int shadeMax = 64;
    static final int shadeLast = 63;
    static byte shadeNormal = (byte)52;
    private static final float xLightsource = -1.0f;
    private static final float yLightsource = -1.0f;
    private static final float zLightsource = 2.5f;
    private static final float magnitudeLight = (float)Math.sqrt(8.25);
    static final float xLight = -1.0f / magnitudeLight;
    static final float yLight = -1.0f / magnitudeLight;
    static final float zLight = 2.5f / magnitudeLight;
    static int SPECULAR_ON = 0;
    static int SPECULAR_PERCENT = 1;
    static int SPECULAR_EXPONENT = 2;
    static int SPECULAR_POWER = 3;
    static int DIFFUSE_PERCENT = 4;
    static int AMBIENT_PERCENT = 5;
    static int INTENSITY_SPECULAR = 6;
    static int INTENSE_FRACTION = 7;
    static int INTENSITY_DIFFUSE = 8;
    static int AMBIENT_FRACTION = 9;
    static final float[] lighting = new float[]{1.0f, 22.0f, 6.0f, 40.0f, 84.0f, 45.0f, 0.22f, 0.4f, 0.84f, 0.45f};
    static final byte intensitySpecularSurfaceLimit = (byte)(shadeNormal + 4);
    static boolean sphereShadingCalculated = false;
    static final byte[] sphereIntensities = new byte[65536];
    private static int seed = 305419897;

    Shade3D() {
    }

    static int[] getShades(int n, boolean bl) {
        int n2;
        int[] nArray = new int[64];
        if (n == 0) {
            return nArray;
        }
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        float f = lighting[AMBIENT_FRACTION];
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        while (true) {
            n6 = (int)((float)n3 * f + 0.5f);
            n7 = (int)((float)n4 * f + 0.5f);
            n8 = (int)((float)n5 * f + 0.5f);
            if (!(f > 0.0f) || n6 >= 4 || n7 >= 4 || n8 >= 4) break;
            ++n3;
            ++n4;
            ++n5;
            if (f < 0.1f) {
                f += 0.1f;
            }
            n = Shade3D.rgb(n3, n4, n5);
        }
        float f2 = (1.0f - f) / (float)shadeNormal;
        int n9 = 0;
        while (n9 < shadeNormal) {
            n6 = (int)((float)n3 * f + 0.5f);
            n7 = (int)((float)n4 * f + 0.5f);
            n8 = (int)((float)n5 * f + 0.5f);
            nArray[n9] = Shade3D.rgb(n6, n7, n8);
            ++n9;
            f += f2;
        }
        nArray[Shade3D.shadeNormal] = Shade3D.rgb(n3, n4, n5);
        n9 = 64 - shadeNormal - 1;
        float f3 = lighting[INTENSE_FRACTION];
        float f4 = (float)(255 - n3) * f3;
        float f5 = (float)(255 - n4) * f3;
        float f6 = (float)(255 - n5) * f3;
        for (n2 = 1; n2 <= n9; ++n2) {
            nArray[Shade3D.shadeNormal + n2] = Shade3D.rgb(n3 + (int)(f4 * (float)n2 / (float)n9 + 0.5f), n4 + (int)(f5 * (float)n2 / (float)n9 + 0.5f), n5 + (int)(f6 * (float)n2 / (float)n9 + 0.5f));
        }
        if (bl) {
            n2 = 64;
            while (--n2 >= 0) {
                nArray[n2] = Graphics3D.calcGreyscaleRgbFromRgb(nArray[n2]);
            }
        }
        return nArray;
    }

    private static final int rgb(int n, int n2, int n3) {
        return 0xFF000000 | n << 16 | n2 << 8 | n3;
    }

    static byte calcIntensity(float f, float f2, float f3) {
        double d = Math.sqrt(f * f + f2 * f2 + f3 * f3);
        return (byte)(Shade3D.calcFloatIntensityNormalized((float)((double)f / d), (float)((double)f2 / d), (float)((double)f3 / d)) * 63.0f + 0.5f);
    }

    static byte calcIntensityNormalized(float f, float f2, float f3) {
        return (byte)(Shade3D.calcFloatIntensityNormalized(f, f2, f3) * 63.0f + 0.5f);
    }

    static int calcFp8Intensity(float f, float f2, float f3) {
        double d = Math.sqrt(f * f + f2 * f2 + f3 * f3);
        return (int)(Shade3D.calcFloatIntensityNormalized((float)((double)f / d), (float)((double)f2 / d), (float)((double)f3 / d)) * 63.0f * 256.0f);
    }

    private static float calcFloatIntensityNormalized(float f, float f2, float f3) {
        float f4;
        float f5 = f * xLight + f2 * yLight + f3 * zLight;
        if (f5 <= 0.0f) {
            return 0.0f;
        }
        float f6 = f5 * lighting[INTENSITY_DIFFUSE];
        if (lighting[SPECULAR_ON] != 0.0f && (f4 = f3 * 2.0f * f5 - zLight) > 0.0f) {
            int n = (int)lighting[SPECULAR_EXPONENT];
            while (--n >= 0 && f4 > 1.0E-4f) {
                f4 *= f4;
            }
            f6 += f4 * lighting[INTENSITY_SPECULAR];
        }
        if (f6 > 1.0f) {
            return 1.0f;
        }
        return f6;
    }

    static byte calcDitheredNoisyIntensity(float f, float f2, float f3, float f4) {
        int n;
        int n2 = (int)(Shade3D.calcFloatIntensityNormalized(f / f4, f2 / f4, f3 / f4) * 63.0f * 256.0f);
        int n3 = n2 >> 8;
        if ((n2 & 0xFF) > Shade3D.nextRandom8Bit()) {
            ++n3;
        }
        if ((n = seed & 0xFFFF) < 21845 && n3 > 0) {
            --n3;
        } else if (n > 43690 && n3 < 63) {
            ++n3;
        }
        return (byte)n3;
    }

    static synchronized void calcSphereShading() {
        float f = -127.5f;
        for (int i = 0; i < 256; ++i) {
            float f2 = -127.5f;
            for (int j = 0; j < 256; ++j) {
                byte by = 0;
                float f3 = 16900.0f - f * f - f2 * f2;
                if (f3 > 0.0f) {
                    float f4 = (float)Math.sqrt(f3);
                    by = Shade3D.calcDitheredNoisyIntensity(f, f2, f4, 130.0f);
                }
                Shade3D.sphereIntensities[(j << 8) + i] = by;
                f2 += 1.0f;
            }
            f += 1.0f;
        }
        sphereShadingCalculated = true;
    }

    static int nextRandom8Bit() {
        int n = seed;
        seed = n = (n << 16) + (n << 1) + n & Integer.MAX_VALUE;
        return n >> 23;
    }
}

