/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.awt.Image;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.export._Exporter;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.shape.Text;
import org.jmol.util.Escape;
import org.jmol.util.Quaternion;
import org.jmol.viewer.Viewer;

public class _X3dExporter
extends _Exporter {
    private AxisAngle4f viewpoint = new AxisAngle4f();
    private int iObj;
    private Hashtable htDefs = new Hashtable();
    private final Point3f ptAtom = new Point3f();
    private final Point3f pt2 = new Point3f();
    int iShapeBuffer;

    public _X3dExporter() {
        this.use2dBondOrderCalculation = true;
        this.canDoTriangles = false;
        this.isCartesianExport = true;
    }

    private void output(String string) {
        this.output.append(string);
    }

    private void output(Tuple3f tuple3f) {
        this.output.append(_X3dExporter.round(tuple3f.x)).append(" ").append(_X3dExporter.round(tuple3f.y)).append(" ").append(_X3dExporter.round(tuple3f.z));
    }

    private String getDef(String string) {
        if (this.htDefs.containsKey(string)) {
            return "USE='" + this.htDefs.get(string) + "'";
        }
        String string2 = "_" + this.iObj++;
        this.htDefs.put(string, string2);
        return string2;
    }

    public void getHeader() {
        this.output("<X3D profile='Immersive' version='3.1' xmlns:xsd='http://www.w3.org/2001/XMLSchema-instance' xsd:noNamespaceSchemaLocation=' http://www.web3d.org/specifications/x3d-3.1.xsd '>\n");
        this.output("<head>\n");
        this.output("<meta name='title' content=" + Escape.escape(this.viewer.getModelSetName()) + "/>\n");
        this.output("<meta name='description' content=' '/>\n");
        this.output("<meta name='creator' content=' '/>\n");
        this.output("<meta name='created' content='" + _X3dExporter.getExportDate() + "'/>\n");
        this.output("<meta name='generator' content='Jmol " + Viewer.getJmolVersion() + ", http://www.jmol.org'/>\n");
        this.output("<meta name='license' content='http://www.gnu.org/licenses/licenses.html#LGPL'/>\n");
        this.output("</head>\n");
        this.output("<Scene>\n");
        this.output("<NavigationInfo type='EXAMINE'/>\n");
        this.output("<Background skyColor='" + this.rgbFractionalFromColix(this.viewer.getObjectColix(0), ' ') + "'/>\n");
        this.getViewpointPosition(this.ptAtom);
        this.adjustViewpointPosition(this.ptAtom);
        float f = this.getFieldOfView();
        this.viewer.getAxisAngle(this.viewpoint);
        this.output("<Viewpoint fieldOfView='" + f + "' position='" + this.ptAtom.x + " " + this.ptAtom.y + " " + this.ptAtom.z + "' orientation='" + this.viewpoint.x + " " + this.viewpoint.y + " " + (this.viewpoint.angle == 0.0f ? 1.0f : this.viewpoint.z) + " " + -this.viewpoint.angle + "'\n jump='TRUE' description='v1'/>\n");
        this.output("\n  <!-- Jmol perspective:\n");
        this.output("  scalePixelsPerAngstrom: " + this.viewer.getScalePixelsPerAngstrom(false) + "\n");
        this.output("  cameraDepth: " + this.viewer.getCameraDepth() + "\n");
        this.output("  center: " + this.center + "\n");
        this.output("  rotationRadius: " + this.viewer.getRotationRadius() + "\n");
        this.output("  boundboxCenter: " + this.viewer.getBoundBoxCenter() + "\n");
        this.output("  translationOffset: " + this.viewer.getTranslationScript() + "\n");
        this.output("  zoom: " + this.viewer.getZoomPercentFloat() + "\n");
        this.output("  moveto command: " + this.viewer.getOrientationText(4133) + "\n");
        this.output("  screen width height dim: " + this.screenWidth + " " + this.screenHeight + " " + this.viewer.getScreenDim() + "\n  -->\n\n");
        this.output("<Transform translation='");
        this.ptAtom.set(this.center);
        this.ptAtom.scale(-1.0f);
        this.output(this.ptAtom);
        this.output("'>\n");
    }

    public void getFooter() {
        this.htDefs = null;
        this.output("</Transform>\n");
        this.output("</Scene>\n");
        this.output("</X3D>\n");
    }

    private void outputAppearance(short s, boolean bl) {
        String string = this.getDef((bl ? "T" : "") + s);
        this.output("<Appearance ");
        if (string.charAt(0) == '_') {
            String string2 = this.rgbFractionalFromColix(s, ' ');
            this.output("DEF='" + string + "'><Material diffuseColor='");
            if (bl) {
                this.output("0 0 0' specularColor='0 0 0' ambientIntensity='0.0' shininess='0.0' emissiveColor='" + string2 + "'/>");
            } else {
                this.output(string2 + "' transparency='" + this.translucencyFractionalFromColix(s) + "'/>");
            }
        } else {
            this.output(string + ">");
        }
        this.output("</Appearance>");
    }

    public void renderAtom(Atom atom, short s) {
        float f = (float)atom.getMadAtom() / 2000.0f;
        this.outputSphere(atom, f, s);
    }

    public void drawPixel(short s, int n, int n2, int n3) {
        this.pt.set(n, n2, n3);
        this.viewer.unTransformPoint(this.pt, this.ptAtom);
        this.outputSphere(this.ptAtom, 0.01f, s);
    }

    public void fillSphereCentered(short s, int n, Point3f point3f) {
        this.viewer.unTransformPoint(point3f, this.ptAtom);
        this.outputSphere(this.ptAtom, this.viewer.unscaleToScreen((int)point3f.z, n) / 2.0f, s);
    }

    private void outputSphere(Point3f point3f, float f, short s) {
        this.output("<Transform translation='");
        this.output(point3f);
        this.output("'>\n<Shape ");
        String string = this.getDef("S" + s + "_" + (int)(f * 100.0f));
        if (string.charAt(0) == '_') {
            this.output("DEF='" + string + "'>");
            this.output("<Sphere radius='" + f + "'/>");
            this.outputAppearance(s, false);
        } else {
            this.output(string + ">");
        }
        this.output("</Shape>\n");
        this.output("</Transform>\n");
    }

    public void fillCylinder(Point3f point3f, Point3f point3f2, short s, short s2, byte by, int n, int n2) {
        if (n2 == -1) {
            this.ptAtom.set(point3f);
            this.pt2.set(point3f2);
        } else {
            this.viewer.unTransformPoint(point3f, this.ptAtom);
            this.viewer.unTransformPoint(point3f2, this.pt2);
        }
        int n3 = n;
        if (n3 < 20) {
            n3 = 20;
        }
        if (s == s2) {
            this.outputCylinder(this.ptAtom, this.pt2, s, by, n3);
        } else {
            this.tempV2.set(this.pt2);
            this.tempV2.add(this.ptAtom);
            this.tempV2.scale(0.5f);
            this.pt.set(this.tempV2);
            this.outputCylinder(this.ptAtom, this.pt, s, (byte)2, n3);
            this.outputCylinder(this.pt, this.pt2, s2, (byte)2, n3);
            if (by == 3) {
                this.outputSphere(this.ptAtom, (float)n3 / 2000.0f * 1.01f, s);
                this.outputSphere(this.pt2, (float)n3 / 2000.0f * 1.01f, s2);
            }
        }
    }

    private void outputCylinder(Point3f point3f, Point3f point3f2, short s, byte by, int n) {
        this.output("<Transform");
        this.outputTransRot(point3f, point3f2, 0, 1, 0);
        this.output(">\n");
        this.outputCylinderChild(point3f, point3f2, s, by, n);
        this.output("\n</Transform>\n");
        if (by == 3) {
            this.outputSphere(point3f, (float)n / 2000.0f * 1.01f, s);
            this.outputSphere(point3f2, (float)n / 2000.0f * 1.01f, s);
        }
    }

    private void outputCylinderChild(Point3f point3f, Point3f point3f2, short s, byte by, int n) {
        float f = _X3dExporter.round(point3f.distance(point3f2));
        String string = this.getDef("C" + s + "_" + (int)(f * 100.0f) + "_" + n + "_" + by);
        this.output("<Shape ");
        if (string.charAt(0) == '_') {
            float f2 = (float)n / 2000.0f;
            this.output("DEF='" + string + "'>");
            this.output("<Cylinder ");
            String string2 = this.getDef("c" + f + "_" + by + "_" + n);
            if (string2.charAt(0) == '_') {
                this.output("DEF='" + string2 + "' height='" + _X3dExporter.round(f) + "' radius='" + f2 + "'" + (by == 2 ? "" : " top='FALSE' bottom='FALSE'") + "/>");
            } else {
                this.output(string2 + "/>");
            }
            this.outputAppearance(s, false);
        } else {
            this.output(string + ">");
        }
        this.output("</Shape>");
    }

    public void renderIsosurface(Point3f[] point3fArray, short s, short[] sArray, Vector3f[] vector3fArray, int[][] nArray, BitSet bitSet, int n, int n2, short[] sArray2, int n3) {
        int n4;
        int n5;
        if (n == 0) {
            return;
        }
        int n6 = 0;
        int n7 = n3;
        while (--n7 >= 0) {
            if (!bitSet.get(n7)) continue;
            n6 += n2 == 4 && nArray[n7].length == 4 ? 2 : 1;
        }
        if (n6 == 0) {
            return;
        }
        Vector vector = null;
        Hashtable hashtable = new Hashtable();
        if (sArray2 != null) {
            vector = this.getColorList(0, sArray2, n3, bitSet, hashtable);
        } else if (sArray != null) {
            vector = this.getColorList(0, sArray, n, null, hashtable);
        }
        this.output("<Shape>\n");
        this.outputAppearance(s, false);
        this.output("<IndexedFaceSet \n");
        if (sArray2 != null) {
            this.output(" colorPerVertex='FALSE'\n");
        }
        int[] nArray2 = new int[n];
        int n8 = 0;
        for (n5 = 0; n5 < n; ++n5) {
            if (Float.isNaN(point3fArray[n5].x)) continue;
            nArray2[n5] = n8++;
        }
        this.output("coordIndex='\n");
        n5 = n3;
        while (--n5 >= 0) {
            if (!bitSet.get(n5)) continue;
            this.output(" " + nArray2[nArray[n5][0]] + " " + nArray2[nArray[n5][1]] + " " + nArray2[nArray[n5][2]] + " -1\n");
            if (n2 != 4 || nArray[n5].length != 4) continue;
            this.output(" " + nArray2[nArray[n5][0]] + " " + nArray2[nArray[n5][2]] + " " + nArray2[nArray[n5][3]] + " -1\n");
        }
        this.output("'\n");
        Vector<String> vector2 = null;
        if (vector3fArray != null) {
            int n9;
            Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>();
            vector2 = new Vector<String>();
            int[] nArray3 = new int[n];
            this.output("  solid='FALSE'\n  normalPerVertex='TRUE'\n  ");
            for (n9 = 0; n9 < n; ++n9) {
                if (Float.isNaN(vector3fArray[n9].x)) continue;
                String string = _X3dExporter.round(vector3fArray[n9].x) + " " + _X3dExporter.round(vector3fArray[n9].y) + " " + _X3dExporter.round(vector3fArray[n9].z) + "\n";
                if (hashtable2.containsKey(string)) {
                    nArray3[n9] = (Integer)hashtable2.get(string);
                    continue;
                }
                nArray3[n9] = vector2.size();
                vector2.add(string);
                hashtable2.put(string, new Integer(nArray3[n9]));
            }
            hashtable2 = null;
            this.output("  normalIndex='\n");
            n9 = n3;
            while (--n9 >= 0) {
                if (!bitSet.get(n9)) continue;
                this.output(nArray3[nArray[n9][0]] + " " + nArray3[nArray[n9][1]] + " " + nArray3[nArray[n9][2]] + " -1\n");
                if (n2 != 4 || nArray[n9].length != 4) continue;
                this.output(nArray3[nArray[n9][0]] + " " + nArray3[nArray[n9][2]] + " " + nArray3[nArray[n9][3]] + " -1\n");
            }
            this.output("'\n");
        }
        if (vector != null) {
            this.output("  colorIndex='\n");
            int n10 = n3;
            while (--n10 >= 0) {
                if (!bitSet.get(n10)) continue;
                if (sArray2 == null) {
                    this.output(hashtable.get("" + sArray[nArray[n10][0]]) + " " + hashtable.get("" + sArray[nArray[n10][1]]) + " " + hashtable.get("" + sArray[nArray[n10][2]]) + " -1\n");
                    if (n2 != 4 || nArray[n10].length != 4) continue;
                    this.output(hashtable.get("" + sArray[nArray[n10][0]]) + " " + hashtable.get("" + sArray[nArray[n10][2]]) + " " + hashtable.get("" + sArray[nArray[n10][3]]) + " -1\n");
                    continue;
                }
                this.output(hashtable.get("" + sArray2[n10]) + "\n");
            }
            this.output("'\n");
        }
        this.output(">\n");
        this.output("<Coordinate point='\n");
        for (n4 = 0; n4 < n; ++n4) {
            if (Float.isNaN(point3fArray[n4].x)) continue;
            this.output(point3fArray[n4]);
            this.output("\n");
        }
        this.output("'/>\n");
        nArray2 = null;
        if (vector3fArray != null) {
            this.output("<Normal vector='\n");
            n8 = vector2.size();
            for (n4 = 0; n4 < n8; ++n4) {
                this.output((String)vector2.get(n4));
            }
            vector2 = null;
            this.output("'/>\n");
        }
        if (vector != null) {
            this.output("<Color color='\n");
            n4 = vector.size();
            for (int i = 0; i < n4; ++i) {
                String string = this.rgbFractionalFromColix((Short)vector.get(i), ' ');
                this.output(" ");
                this.output(string);
                this.output("\n");
            }
            this.output("'/>\n");
        }
        this.output("</IndexedFaceSet>\n");
        this.output("</Shape>\n");
    }

    private void outputTransRot(Point3f point3f, Point3f point3f2, int n, int n2, int n3) {
        this.output(" translation='");
        this.tempV1.set(point3f2);
        this.tempV1.add(point3f);
        this.tempV1.scale(0.5f);
        this.output(this.tempV1);
        this.tempV1.sub(point3f);
        this.getAxisAngle(this.tempV1, n, n2, n3);
        this.output("' rotation='" + _X3dExporter.round(this.tempA.x) + " " + _X3dExporter.round(this.tempA.y) + " " + _X3dExporter.round(this.tempA.z) + " " + _X3dExporter.round(this.tempA.angle) + "'");
    }

    public void fillCone(short s, byte by, int n, Point3f point3f, Point3f point3f2) {
        this.viewer.unTransformPoint(point3f, this.tempP1);
        this.viewer.unTransformPoint(point3f2, this.tempP2);
        float f = this.viewer.unscaleToScreen((int)point3f.z, n);
        if (f < 0.1f) {
            f = 0.1f;
        }
        float f2 = this.tempP1.distance(this.tempP2);
        this.output("<Transform");
        this.outputTransRot(this.tempP1, this.tempP2, 0, 1, 0);
        this.output(">\n<Shape ");
        String string = "o" + (int)(f2 * 100.0f) + "_" + (int)(f * 100.0f);
        String string2 = this.getDef("c" + string + "_" + s);
        if (string2.charAt(0) == '_') {
            this.output("DEF='" + string2 + "'>");
            string = this.getDef(string);
            this.output("<Cone ");
            if (string.charAt(0) == '_') {
                this.output("DEF='" + string + "' height='" + _X3dExporter.round(f2) + "' bottomRadius='" + _X3dExporter.round(f / 2.0f) + "'/>");
            } else {
                this.output(string + "/>");
            }
            this.outputAppearance(s, false);
        } else {
            this.output(string2 + ">");
        }
        this.output("</Shape>\n");
        this.output("</Transform>\n");
    }

    public void fillCylinder(short s, byte by, int n, Point3f point3f, Point3f point3f2) {
        Point3f point3f3 = new Point3f();
        Point3f point3f4 = new Point3f();
        this.viewer.unTransformPoint(point3f, point3f3);
        this.viewer.unTransformPoint(point3f2, point3f4);
        int n2 = (int)(this.viewer.unscaleToScreen((int)((point3f.z + point3f2.z) / 2.0f), n) * 1000.0f);
        if (n2 < 20) {
            n2 = 20;
        }
        this.outputCylinder(point3f3, point3f4, s, by, n2);
    }

    public void fillTriangle(short s, Point3f point3f, Point3f point3f2, Point3f point3f3) {
        this.output("<Shape>\n");
        this.output("<IndexedFaceSet solid='FALSE' ");
        this.output("coordIndex='0 1 2 -1'>");
        this.output("<Coordinate point='");
        this.viewer.unTransformPoint(point3f, this.pt);
        this.output(this.pt);
        this.output(" ");
        this.viewer.unTransformPoint(point3f2, this.pt);
        this.output(this.pt);
        this.output(" ");
        this.viewer.unTransformPoint(point3f3, this.pt);
        this.output(this.pt);
        this.output("'/>");
        this.output("</IndexedFaceSet>\n");
        this.outputAppearance(s, false);
        this.output("\n</Shape>\n");
    }

    public void plotText(int n, int n2, int n3, short s, String string, Font3D font3D) {
        if (n3 < 3) {
            this.viewer.transformPoint(this.center, this.pt);
            n3 = (int)this.pt.z;
        }
        String string2 = font3D.fontStyle.toUpperCase();
        String string3 = font3D.fontFace.toUpperCase();
        String string4 = string3.equals("MONOSPACED") ? "TYPEWRITER" : (string3.equals("SERIF") ? "SERIF" : "SANS");
        this.output("<Transform translation='");
        this.pt.set(n, n2, n3);
        this.viewer.unTransformPoint(this.pt, this.ptAtom);
        this.output(this.ptAtom);
        this.output("'>");
        this.output("<Billboard ");
        String string5 = this.getDef("T" + s + string4 + string2 + "_" + string);
        if (string5.charAt(0) == '_') {
            this.output("DEF='" + string5 + "' axisOfRotation='0 0 0'>" + "<Transform translation='0.0 0.0 0.0'>" + "<Shape>");
            this.outputAppearance(s, true);
            this.output("<Text string=" + Escape.escape(string) + ">");
            this.output("<FontStyle ");
            String string6 = this.getDef("F" + string4 + string2);
            if (string6.charAt(0) == '_') {
                this.output("DEF='" + string6 + "' size='0.4' family='" + string4 + "' style='" + string2 + "'/>");
            } else {
                this.output(string6 + "/>");
            }
            this.output("</Text>");
            this.output("</Shape>");
            this.output("</Transform>");
        } else {
            this.output(string5 + ">");
        }
        this.output("</Billboard>\n");
        this.output("</Transform>\n");
    }

    public void startShapeBuffer(int n) {
        this.iShapeBuffer = 1;
        this.iShapeBuffer = n;
        switch (this.iShapeBuffer) {
            default: 
        }
    }

    public void endShapeBuffer() {
        switch (this.iShapeBuffer) {
            default: 
        }
        this.output("}}\n");
        this.iShapeBuffer = 0;
    }

    public void renderText(Text text) {
    }

    public void drawString(short s, String string, Font3D font3D, int n, int n2, int n3, int n4) {
    }

    public void drawCircleCentered(short s, int n, int n2, int n3, int n4, boolean bl) {
        this.pt.set(n2, n3, n4);
        this.viewer.unTransformPoint(this.pt, this.ptAtom);
        float f = this.viewer.unscaleToScreen(n4, n);
        this.pt.set(n2, n3, n4 + 1);
        this.viewer.unTransformPoint(this.pt, this.pt);
        if (bl) {
            this.output("<Transform translation='");
            this.tempV1.set(this.pt);
            this.tempV1.add(this.ptAtom);
            this.tempV1.scale(0.5f);
            this.output(this.tempV1);
            this.output("'><Billboard axisOfRotation='0 0 0'><Transform rotation='1 0 0 1.5708'>");
            this.outputCylinderChild(this.ptAtom, this.pt, s, (byte)2, (int)(f * 1000.0f));
            this.output("</Transform></Billboard>");
            this.output("</Transform>\n");
            return;
        }
        String string = this.getDef("C" + s + "_" + f);
        this.output("<Transform");
        this.outputTransRot(this.pt, this.ptAtom, 0, 0, 1);
        this.pt.set(1.0f, 1.0f, 1.0f);
        this.pt.scale(f / 2.0f);
        this.output(" scale='");
        this.output(this.pt);
        this.output("'>\n<Billboard ");
        if (string.charAt(0) == '_') {
            int n5;
            this.output("DEF='" + string + "'");
            this.output(" axisOfRotation='0 0 0'><Transform>");
            this.output("<Shape><Extrusion beginCap='FALSE' convex='FALSE' endCap='FALSE' creaseAngle='1.57'");
            this.output(" crossSection='");
            float f2 = (float)Math.PI / 180;
            float f3 = 0.04f / f;
            for (n5 = 0; n5 <= 360; n5 += 10) {
                this.output(_X3dExporter.round(Math.cos((float)n5 * f2) * (double)f3) + " ");
                this.output(_X3dExporter.round(Math.sin((float)n5 * f2) * (double)f3) + " ");
            }
            this.output("' spine='");
            for (n5 = 0; n5 <= 360; n5 += 10) {
                this.output(_X3dExporter.round(Math.cos((float)n5 * f2)) + " ");
                this.output(_X3dExporter.round(Math.sin((float)n5 * f2)) + " 0 ");
            }
            this.output("'/>");
            this.outputAppearance(s, false);
            this.output("</Shape></Transform>");
        } else {
            this.output(string + ">");
        }
        this.output("</Billboard>\n");
        this.output("</Transform>\n");
    }

    public void fillScreenedCircleCentered(short s, int n, int n2, int n3, int n4) {
        this.drawCircleCentered(s, n, n2, n3, n4, false);
        this.drawCircleCentered(Graphics3D.getColixTranslucent(s, true, 0.5f), n, n2, n3, n4, true);
    }

    public void drawTextPixel(int n, int n2, int n3, int n4) {
        this.pt.set(n2, n3, n4);
        this.viewer.unTransformPoint(this.pt, this.ptAtom);
        String string = this.rgbFractionalFromArgb(n, ' ');
        this.output("<Transform translation='");
        this.output(this.ptAtom);
        this.output("'>\n<Shape ");
        String string2 = this.getDef("p" + n);
        if (string2.charAt(0) == '_') {
            this.output("DEF='" + string2 + "'>");
            this.output("<Sphere radius='0.01'/>");
            this.output("<Appearance><Material diffuseColor='0 0 0' specularColor='0 0 0' ambientIntensity='0.0' shininess='0.0' emissiveColor='" + string + "'/></Appearance>'");
        } else {
            this.output(string2 + ">");
        }
        this.output("</Shape>\n");
        this.output("</Transform>\n");
    }

    public void plotImage(int n, int n2, int n3, Image image, short s, int n4, int n5) {
    }

    void renderEllipsoid(Point3f point3f, Point3f[] point3fArray, short s, int n, int n2, int n3, int n4, Matrix3f matrix3f, double[] dArray, Matrix4f matrix4f, Point3i[] point3iArray) {
        this.output("<Transform translation='");
        this.output(point3f);
        this.output("'");
        AxisAngle4f axisAngle4f = Quaternion.getQuaternionFrame(point3f, point3fArray[1], point3fArray[3]).toAxisAngle4f();
        if (!Float.isNaN(axisAngle4f.x)) {
            this.output(" rotation='" + axisAngle4f.x + " " + axisAngle4f.y + " " + axisAngle4f.z + " " + axisAngle4f.angle + "'");
        }
        this.pt.set(0.0f, 0.0f, 0.0f);
        float f = point3fArray[1].distance(point3f);
        float f2 = point3fArray[3].distance(point3f);
        float f3 = point3fArray[5].distance(point3f);
        this.output(" scale='" + f + " " + f2 + " " + f3 + "'>");
        this.outputSphere(this.pt, 1.0f, s);
        this.output("</Transform>\n");
    }
}

