/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.awt.Image;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.export._Exporter;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.geodesic.Geodesic;
import org.jmol.modelset.Atom;
import org.jmol.shape.Text;
import org.jmol.util.Quaternion;

public class _IdtfExporter
extends _Exporter {
    private AxisAngle4f viewpoint = new AxisAngle4f();
    private boolean haveSphere;
    private boolean haveCylinder;
    private boolean haveCone;
    private boolean haveCircle;
    private Point3f ptMin = new Point3f(1.0E10f, 1.0E10f, 1.0E10f);
    private Point3f ptMax = new Point3f(-1.0E10f, -1.0E10f, -1.0E10f);
    private int iObj;
    private Hashtable htDefs = new Hashtable();
    private final Point3f ptAtom = new Point3f();
    private final Matrix4f m = new Matrix4f();
    private final StringBuffer models = new StringBuffer();
    private final StringBuffer resources = new StringBuffer();
    private final StringBuffer modifiers = new StringBuffer();
    private Hashtable htNodes = new Hashtable();
    private Matrix4f sphereMatrix = new Matrix4f();
    private Matrix4f cylinderMatrix = new Matrix4f();
    private final Point3f pt2 = new Point3f();

    public _IdtfExporter() {
        this.use2dBondOrderCalculation = true;
        this.canDoTriangles = false;
        this.isCartesianExport = true;
    }

    private void output(Tuple3f tuple3f, StringBuffer stringBuffer, boolean bl) {
        if (bl) {
            this.checkPoint(tuple3f);
        }
        stringBuffer.append(_IdtfExporter.round(tuple3f.x)).append(" ").append(_IdtfExporter.round(tuple3f.y)).append(" ").append(_IdtfExporter.round(tuple3f.z)).append(" ");
    }

    private void checkPoint(Tuple3f tuple3f) {
        if (tuple3f.x < this.ptMin.x) {
            this.ptMin.x = tuple3f.x;
        }
        if (tuple3f.y < this.ptMin.y) {
            this.ptMin.y = tuple3f.y;
        }
        if (tuple3f.z < this.ptMin.z) {
            this.ptMin.z = tuple3f.z;
        }
        if (tuple3f.x > this.ptMax.x) {
            this.ptMax.x = tuple3f.x;
        }
        if (tuple3f.y > this.ptMax.y) {
            this.ptMax.y = tuple3f.y;
        }
        if (tuple3f.z > this.ptMax.z) {
            this.ptMax.z = tuple3f.z;
        }
    }

    public void getHeader() {
        this.output.append("FILE_FORMAT \"IDTF\"\nFORMAT_VERSION 100\n");
        this.m.setIdentity();
        this.output.append("NODE \"GROUP\" {\n");
        this.output.append("NODE_NAME \"Jmol\"\n");
        this.output.append("PARENT_LIST {\nPARENT_COUNT 1\n");
        this.output.append("PARENT 0 {\n");
        this.output.append(this.getParentItem("", this.m));
        this.output.append("}}}\n");
    }

    private String getParentItem(String string, Matrix4f matrix4f) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PARENT_NAME \"" + string + "\"\n");
        stringBuffer.append("PARENT_TM {\n");
        stringBuffer.append(matrix4f.m00 + " " + matrix4f.m10 + " " + matrix4f.m20 + " 0.0\n");
        stringBuffer.append(matrix4f.m01 + " " + matrix4f.m11 + " " + matrix4f.m21 + " 0.0\n");
        stringBuffer.append(matrix4f.m02 + " " + matrix4f.m12 + " " + matrix4f.m22 + " 0.0\n");
        stringBuffer.append(matrix4f.m03 + " " + matrix4f.m13 + " " + matrix4f.m23 + " " + matrix4f.m33 + "\n");
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    private void addColix(short s, boolean bl) {
        String string = "_" + s;
        if (this.htDefs.containsKey(string)) {
            return;
        }
        String string2 = bl ? "1.0 1.0 1.0" : this.rgbFractionalFromColix(s, ' ');
        this.htDefs.put(string, Boolean.TRUE);
        this.resources.append("RESOURCE_LIST \"SHADER\" {\n");
        this.resources.append("RESOURCE_COUNT 1\n");
        this.resources.append("RESOURCE 0 {\n");
        this.resources.append("RESOURCE_NAME \"Shader" + string + "\"\n");
        this.resources.append("ATTRIBUTE_USE_VERTEX_COLOR \"FALSE\"\n");
        this.resources.append("SHADER_MATERIAL_NAME \"Mat" + string + "\"\n");
        this.resources.append("SHADER_ACTIVE_TEXTURE_COUNT 0\n");
        this.resources.append("}}\n");
        this.resources.append("RESOURCE_LIST \"MATERIAL\" {\n");
        this.resources.append("RESOURCE_COUNT 1\n");
        this.resources.append("RESOURCE 0 {\n");
        this.resources.append("RESOURCE_NAME \"Mat" + string + "\"\n");
        this.resources.append("MATERIAL_AMBIENT " + string2 + "\n");
        this.resources.append("MATERIAL_DIFFUSE " + string2 + "\n");
        this.resources.append("MATERIAL_SPECULAR 0.0 0.0 0.0\n");
        this.resources.append("MATERIAL_EMISSIVE 0.0 0.0 0.0\n");
        this.resources.append("MATERIAL_REFLECTIVITY 0.00000\n");
        this.resources.append("MATERIAL_OPACITY " + this.opacityFractionalFromColix(s) + "\n");
        this.resources.append("}}\n");
    }

    private void addShader(String string, short s) {
        this.modifiers.append("MODIFIER \"SHADING\" {\n");
        this.modifiers.append("MODIFIER_NAME \"" + string + "\"\n");
        this.modifiers.append("PARAMETERS {\n");
        this.modifiers.append("SHADER_LIST_COUNT 1\n");
        this.modifiers.append("SHADING_GROUP {\n");
        this.modifiers.append("SHADER_LIST 0 {\n");
        this.modifiers.append("SHADER_COUNT 1\n");
        this.modifiers.append("SHADER_NAME_LIST {\n");
        this.modifiers.append("SHADER 0 NAME: \"Shader_" + s + "\"\n");
        this.modifiers.append("}}}}}\n");
    }

    public void getFooter() {
        this.htDefs = null;
        this.outputNodes();
        this.output.append(this.models);
        this.output.append(this.resources);
        this.output.append("RESOURCE_LIST \"VIEW\" {\n");
        this.output.append("\tRESOURCE_COUNT 1\n");
        this.output.append("\tRESOURCE 0 {\n");
        this.output.append("\t\tRESOURCE_NAME \"View0\"\n");
        this.output.append("\t\tVIEW_PASS_COUNT 1\n");
        this.output.append("\t\tVIEW_ROOT_NODE_LIST {\n");
        this.output.append("\t\t\tROOT_NODE 0 {\n");
        this.output.append("\t\t\t\tROOT_NODE_NAME \"\"\n");
        this.output.append("\t\t\t}\n");
        this.output.append("\t\t}\n");
        this.output.append("\t}\n");
        this.output.append("}\n\n");
        this.viewer.getAxisAngle(this.viewpoint);
        Quaternion quaternion = new Quaternion(this.viewpoint);
        this.viewpoint.set(quaternion.getMatrix());
        if (this.viewpoint.angle == 0.0f) {
            this.viewpoint.z = 1.0f;
        }
        Quaternion quaternion2 = new Quaternion(0.6414883f, -0.5258319f, 0.3542887f, 0.43182528f);
        quaternion = quaternion2.inv().mul(quaternion);
        this.pt.set(this.ptMax);
        this.pt.add(this.ptMin);
        this.pt.scale(0.5f);
        this.pt.sub(this.center);
        this.ptAtom.set(quaternion.transform(this.pt));
        float f = this.viewer.getZoomPercentFloat() / 100.0f;
        this.ptAtom.scale(f);
        String string = this.ptAtom.x + " " + this.ptAtom.y + " " + this.ptAtom.z;
        String string2 = " " + f;
        string2 = string2 + string2 + string2;
        this.output.append("\nRESOURCE_LIST \"MOTION\" {");
        this.output.append("\n  RESOURCE_COUNT 1");
        this.output.append("\n  RESOURCE 0 {");
        this.output.append("\n    RESOURCE_NAME \"Motion0\"");
        this.output.append("\n    MOTION_TRACK_COUNT 1");
        this.output.append("\n    MOTION_TRACK_LIST {");
        this.output.append("\n      MOTION_TRACK 0 {");
        this.output.append("\n        MOTION_TRACK_NAME \"M00\"");
        this.output.append("\n        MOTION_TRACK_SAMPLE_COUNT 2");
        this.output.append("\n        KEY_FRAME_LIST {");
        this.output.append("\n          KEY_FRAME 0 {");
        this.output.append("\n            KEY_FRAME_TIME 0");
        this.output.append("\n            KEY_FRAME_DISPLACEMENT 0 0 0");
        this.output.append("\n            KEY_FRAME_ROTATION " + quaternion.toString0123());
        this.output.append("\n            KEY_FRAME_SCALE 1 1 1");
        this.output.append("\n          }");
        this.output.append("\n          KEY_FRAME 1 {");
        this.output.append("\n            KEY_FRAME_TIME 1");
        this.output.append("\n            KEY_FRAME_DISPLACEMENT " + string);
        this.output.append("\n            KEY_FRAME_ROTATION " + quaternion.toString0123());
        this.output.append("\n            KEY_FRAME_SCALE" + string2);
        this.output.append("\n          }");
        this.output.append("\n         }");
        this.output.append("\n      }");
        this.output.append("\n    }");
        this.output.append("\n  }");
        this.output.append("\n}\n");
        this.output.append("\nMODIFIER \"ANIMATION\" {");
        this.output.append("\n  MODIFIER_NAME \"Jmol\"");
        this.output.append("\n  PARAMETERS {");
        this.output.append("\n    ATTRIBUTE_ANIMATION_PLAYING \"TRUE\"");
        this.output.append("\n    ATTRIBUTE_ROOT_BONE_LOCKED \"TRUE\"");
        this.output.append("\n    ATTRIBUTE_SINGLE_TRACK \"TRUE\"");
        this.output.append("\n    ATTRIBUTE_AUTO_BLEND \"FALSE\"");
        this.output.append("\n    TIME_SCALE 1.0");
        this.output.append("\n    BLEND_TIME 0.0");
        this.output.append("\n    MOTION_COUNT 1");
        this.output.append("\n    MOTION_INFO_LIST {");
        this.output.append("\n      MOTION_INFO 0 {");
        this.output.append("\n        MOTION_NAME \"Motion0\"");
        this.output.append("\n        ATTRIBUTE_LOOP \"FALSE\"");
        this.output.append("\n        ATTRIBUTE_SYNC \"FALSE\"");
        this.output.append("\n        TIME_OFFSET 0.0");
        this.output.append("\n        TIME_SCALE 1.0");
        this.output.append("\n      }");
        this.output.append("\n    }");
        this.output.append("\n  }");
        this.output.append("\n}\n");
        this.output.append(this.modifiers);
    }

    private void outputNodes() {
        Enumeration enumeration = this.htNodes.keys();
        while (enumeration.hasMoreElements()) {
            int n;
            String string = (String)enumeration.nextElement();
            Vector vector = (Vector)this.htNodes.get(string);
            this.output.append("NODE \"MODEL\" {\n");
            this.output.append("NODE_NAME \"" + string + "\"\n");
            int n2 = vector.size();
            this.output.append("PARENT_LIST {\nPARENT_COUNT " + n2 + "\n");
            for (n = 0; n < n2; ++n) {
                this.output.append("PARENT " + n + " {\n");
                this.output.append((String)vector.get(n));
                this.output.append("}\n");
            }
            this.output.append("}\n");
            n = string.indexOf("_");
            if (n > 0) {
                string = string.substring(0, n);
            }
            this.output.append("RESOURCE_NAME \"" + string + "_Mesh\"\n}\n");
        }
    }

    public void renderAtom(Atom atom, short s) {
        float f = (float)atom.getMadAtom() / 2000.0f;
        this.outputSphere(atom, f, s);
    }

    public void drawPixel(short s, int n, int n2, int n3) {
        this.pt.set(n, n2, n3);
        this.viewer.unTransformPoint(this.pt, this.ptAtom);
        this.outputSphere(this.ptAtom, 0.02f, s);
    }

    public void fillSphereCentered(short s, int n, Point3f point3f) {
        this.viewer.unTransformPoint(point3f, this.ptAtom);
        this.outputSphere(this.ptAtom, this.viewer.unscaleToScreen((int)point3f.z, n) / 2.0f, s);
    }

    private void outputSphere(Point3f point3f, float f, short s) {
        this.outputEllipsoid(point3f, f, f, f, null, s);
    }

    private void outputEllipsoid(Point3f point3f, float f, float f2, float f3, AxisAngle4f axisAngle4f, short s) {
        if (!this.haveSphere) {
            this.models.append(this.getSphereResource());
            this.haveSphere = true;
            this.sphereMatrix = new Matrix4f();
        }
        this.checkPoint(point3f);
        this.addColix(s, false);
        String string = "Sphere_" + s;
        Vector<String> vector = (Vector<String>)this.htNodes.get(string);
        if (vector == null) {
            vector = new Vector<String>();
            this.htNodes.put(string, vector);
            this.addShader(string, s);
        }
        if (axisAngle4f != null) {
            Matrix3f matrix3f = new Matrix3f();
            Matrix3f matrix3f2 = new Matrix3f();
            matrix3f2.m00 = f;
            matrix3f2.m11 = f2;
            matrix3f2.m22 = f3;
            matrix3f.set(axisAngle4f);
            matrix3f.mul(matrix3f2);
            this.sphereMatrix.set(matrix3f);
        } else {
            this.sphereMatrix.setIdentity();
            this.sphereMatrix.m00 = f;
            this.sphereMatrix.m11 = f2;
            this.sphereMatrix.m22 = f3;
        }
        this.sphereMatrix.m03 = point3f.x;
        this.sphereMatrix.m13 = point3f.y;
        this.sphereMatrix.m23 = point3f.z;
        this.sphereMatrix.m33 = 1.0f;
        vector.add(this.getParentItem("Jmol", this.sphereMatrix));
    }

    private String getSphereResource() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("RESOURCE_LIST \"MODEL\" {\n").append("RESOURCE_COUNT 1\n").append("RESOURCE 0 {\n").append("RESOURCE_NAME \"Sphere_Mesh\"\n").append("MODEL_TYPE \"MESH\"\n").append("MESH {\n");
        int n = Geodesic.getVertexCount(2);
        short[] sArray = Geodesic.getFaceVertexes(2);
        int[] nArray = new int[sArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            nArray[i] = sArray[i];
        }
        Tuple3f[] tuple3fArray = new Vector3f[n];
        for (int i = 0; i < n; ++i) {
            tuple3fArray[i] = Geodesic.getVertexVector(i);
        }
        return this.getMeshData("Sphere", nArray, tuple3fArray, tuple3fArray);
    }

    private String getMeshData(String string, int[] nArray, Tuple3f[] tuple3fArray, Tuple3f[] tuple3fArray2) {
        int n;
        int n2 = nArray.length / 3;
        int n3 = tuple3fArray.length;
        int n4 = tuple3fArray2.length;
        StringBuffer stringBuffer = new StringBuffer();
        this.getMeshHeader(string, n2, n3, n4, 0, stringBuffer);
        stringBuffer.append("MESH_FACE_POSITION_LIST { ");
        for (n = 0; n < nArray.length; ++n) {
            stringBuffer.append(nArray[n]).append(" ");
        }
        stringBuffer.append("}\n");
        stringBuffer.append("MESH_FACE_NORMAL_LIST { ");
        for (n = 0; n < nArray.length; ++n) {
            stringBuffer.append(nArray[n]).append(" ");
        }
        stringBuffer.append("}\n");
        stringBuffer.append("MESH_FACE_SHADING_LIST { ");
        for (n = 0; n < n2; ++n) {
            stringBuffer.append("0 ");
        }
        stringBuffer.append("}\n");
        stringBuffer.append("MODEL_POSITION_LIST { ");
        for (n = 0; n < n3; ++n) {
            this.output(tuple3fArray[n], stringBuffer, false);
        }
        stringBuffer.append("}\n");
        stringBuffer.append("MODEL_NORMAL_LIST { ");
        for (n = 0; n < n4; ++n) {
            this.output(tuple3fArray2[n], stringBuffer, false);
        }
        stringBuffer.append("}\n}}}\n");
        return stringBuffer.toString();
    }

    private void getMeshHeader(String string, int n, int n2, int n3, int n4, StringBuffer stringBuffer) {
        stringBuffer.append("RESOURCE_LIST \"MODEL\" {\n").append("RESOURCE_COUNT 1\n").append("RESOURCE 0 {\n").append("RESOURCE_NAME \"").append(string).append("_Mesh\"\n").append("MODEL_TYPE \"MESH\"\n").append("MESH {\n").append("FACE_COUNT ").append(n).append("\n").append("MODEL_POSITION_COUNT ").append(n2).append("\n").append("MODEL_NORMAL_COUNT ").append(n3).append("\n").append("MODEL_DIFFUSE_COLOR_COUNT ").append(n4).append("\n").append("MODEL_SPECULAR_COLOR_COUNT 0\n").append("MODEL_TEXTURE_COORD_COUNT 0\n").append("MODEL_BONE_COUNT 0\n").append("MODEL_SHADING_COUNT 1\n").append("MODEL_SHADING_DESCRIPTION_LIST {\n").append("SHADING_DESCRIPTION 0 {\n").append("TEXTURE_LAYER_COUNT 0\n").append("SHADER_ID 0\n}}\n");
    }

    public void fillCylinder(Point3f point3f, Point3f point3f2, short s, short s2, byte by, int n, int n2) {
        if (n2 == -1) {
            this.ptAtom.set(point3f);
            this.pt2.set(point3f2);
        } else {
            this.viewer.unTransformPoint(point3f, this.ptAtom);
            this.viewer.unTransformPoint(point3f2, this.pt2);
        }
        int n3 = n;
        if (n3 < 20) {
            n3 = 20;
        }
        if (s == s2) {
            this.outputCylinder(this.ptAtom, this.pt2, s, by, n3);
        } else {
            this.tempV2.set(this.pt2);
            this.tempV2.add(this.ptAtom);
            this.tempV2.scale(0.5f);
            this.pt.set(this.tempV2);
            this.outputCylinder(this.ptAtom, this.pt, s, (byte)2, n3);
            this.outputCylinder(this.pt, this.pt2, s2, (byte)2, n3);
            if (by == 3) {
                this.outputSphere(this.ptAtom, (float)n3 / 2000.0f * 1.01f, s);
                this.outputSphere(this.pt2, (float)n3 / 2000.0f * 1.01f, s2);
            }
        }
    }

    private void outputCylinder(Point3f point3f, Point3f point3f2, short s, byte by, int n) {
        if (by == 3) {
            this.outputSphere(point3f, (float)n / 2000.0f * 1.01f, s);
            this.outputSphere(point3f2, (float)n / 2000.0f * 1.01f, s);
        } else if (by == 2) {
            this.outputCircle(point3f, point3f2, s, n);
            this.outputCircle(point3f2, point3f, s, n);
        }
        if (!this.haveCylinder) {
            this.models.append(this.getCylinderResource());
            this.haveCylinder = true;
            this.cylinderMatrix = new Matrix4f();
        }
        this.checkPoint(point3f);
        this.checkPoint(point3f2);
        this.addColix(s, false);
        String string = "Cylinder_" + s;
        Vector<String> vector = (Vector<String>)this.htNodes.get(string);
        if (vector == null) {
            vector = new Vector<String>();
            this.htNodes.put(string, vector);
            this.addShader(string, s);
        }
        float f = (float)n / 2000.0f;
        this.cylinderMatrix.set(this.getRotationMatrix(point3f, point3f2, f));
        this.cylinderMatrix.m03 = point3f.x;
        this.cylinderMatrix.m13 = point3f.y;
        this.cylinderMatrix.m23 = point3f.z;
        this.cylinderMatrix.m33 = 1.0f;
        vector.add(this.getParentItem("Jmol", this.cylinderMatrix));
    }

    private void outputCircle(Point3f point3f, Point3f point3f2, short s, int n) {
        if (!this.haveCircle) {
            this.models.append(this.getCircleResource());
            this.haveCircle = true;
            this.cylinderMatrix = new Matrix4f();
        }
        this.addColix(s, false);
        String string = "Circle_" + s;
        Vector<String> vector = (Vector<String>)this.htNodes.get(string);
        if (vector == null) {
            vector = new Vector<String>();
            this.htNodes.put(string, vector);
            this.addShader(string, s);
        }
        this.checkPoint(point3f);
        float f = (float)n / 2000.0f;
        this.cylinderMatrix.set(this.getRotationMatrix(point3f, point3f2, f));
        this.cylinderMatrix.m03 = point3f.x;
        this.cylinderMatrix.m13 = point3f.y;
        this.cylinderMatrix.m23 = point3f.z;
        this.cylinderMatrix.m33 = 1.0f;
        vector.add(this.getParentItem("Jmol", this.cylinderMatrix));
    }

    private Matrix3f getRotationMatrix(Point3f point3f, Point3f point3f2, float f) {
        Matrix3f matrix3f;
        Matrix3f matrix3f2 = new Matrix3f();
        if (point3f2.x == point3f.x && point3f2.y == point3f.y) {
            matrix3f = new Matrix3f();
            matrix3f.setIdentity();
            if (point3f.z > point3f2.z) {
                matrix3f.mul(-1.0f);
            }
        } else {
            this.tempV1.set(point3f2);
            this.tempV1.sub(point3f);
            this.tempV2.set(0.0f, 0.0f, 1.0f);
            this.tempV2.cross(this.tempV2, this.tempV1);
            this.tempV1.cross(this.tempV1, this.tempV2);
            Quaternion quaternion = Quaternion.getQuaternionFrame(this.tempV2, this.tempV1, null);
            matrix3f = quaternion.getMatrix();
        }
        matrix3f2.m00 = f;
        matrix3f2.m11 = f;
        matrix3f2.m22 = point3f2.distance(point3f);
        matrix3f.mul(matrix3f2);
        return matrix3f;
    }

    private Object getCylinderResource() {
        float f;
        float f2;
        int n;
        int n2 = 10;
        int n3 = 360 / n2 * 2;
        int n4 = n3 / 2;
        int[] nArray = new int[n3 * 3];
        int n5 = -1;
        for (int i = 0; i < n4; ++i) {
            nArray[++n5] = i;
            nArray[++n5] = (i + 1) % n4;
            nArray[++n5] = i + n4;
            nArray[++n5] = (i + 1) % n4;
            nArray[++n5] = (i + 1) % n4 + n4;
            nArray[++n5] = i + n4;
        }
        Tuple3f[] tuple3fArray = new Point3f[n3];
        Tuple3f[] tuple3fArray2 = new Point3f[n3];
        for (n = 0; n < n4; ++n) {
            f2 = (float)Math.cos((double)(n * n2) / 180.0 * Math.PI);
            f = (float)Math.sin((double)(n * n2) / 180.0 * Math.PI);
            tuple3fArray2[n] = tuple3fArray[n] = new Point3f(f2, f, 0.0f);
        }
        for (n = 0; n < n4; ++n) {
            f2 = (float)Math.cos(((double)n + 0.5) * (double)n2 / 180.0 * Math.PI);
            f = (float)Math.sin(((double)n + 0.5) * (double)n2 / 180.0 * Math.PI);
            tuple3fArray[n + n4] = new Point3f(f2, f, 1.0f);
            tuple3fArray2[n + n4] = new Point3f(f2, f, 0.0f);
        }
        return this.getMeshData("Cylinder", nArray, tuple3fArray, tuple3fArray2);
    }

    public void renderIsosurface(Point3f[] point3fArray, short s, short[] sArray, Vector3f[] vector3fArray, int[][] nArray, BitSet bitSet, int n, int n2, short[] sArray2, int n3) {
        int n4;
        Object object;
        Serializable serializable;
        if (n == 0) {
            return;
        }
        int n5 = 0;
        int n6 = n3;
        while (--n6 >= 0) {
            if (!bitSet.get(n6)) continue;
            n5 += n2 == 4 && nArray[n6].length == 4 ? 2 : 1;
        }
        if (n5 == 0) {
            return;
        }
        Vector vector = null;
        Hashtable hashtable = new Hashtable();
        if (sArray2 != null) {
            vector = this.getColorList(0, sArray2, n3, bitSet, hashtable);
        } else if (sArray != null) {
            vector = this.getColorList(0, sArray, n, null, hashtable);
        }
        this.addColix(s, sArray2 != null || sArray != null);
        if (sArray2 != null) {
            return;
        }
        int[] nArray2 = new int[n];
        int n7 = 0;
        for (int i = 0; i < n; ++i) {
            if (Float.isNaN(point3fArray[i].x)) continue;
            nArray2[i] = n7++;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n8 = n3;
        while (--n8 >= 0) {
            if (!bitSet.get(n8)) continue;
            stringBuffer.append(" " + nArray2[nArray[n8][0]] + " " + nArray2[nArray[n8][1]] + " " + nArray2[nArray[n8][2]]);
            if (n2 != 4 || nArray[n8].length != 4) continue;
            stringBuffer.append(" " + nArray2[nArray[n8][0]] + " " + nArray2[nArray[n8][2]] + " " + nArray2[nArray[n8][3]]);
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        Vector<String> vector2 = null;
        if (vector3fArray != null) {
            serializable = new Hashtable();
            vector2 = new Vector<String>();
            object = new int[n];
            for (n4 = 0; n4 < n; ++n4) {
                if (Float.isNaN(vector3fArray[n4].x)) continue;
                String string = " " + _IdtfExporter.round(vector3fArray[n4].x) + " " + _IdtfExporter.round(vector3fArray[n4].y) + " " + _IdtfExporter.round(vector3fArray[n4].z);
                if (((Hashtable)serializable).containsKey(string)) {
                    object[n4] = (Integer)((Hashtable)serializable).get(string);
                    continue;
                }
                object[n4] = vector2.size();
                vector2.add(string);
                ((Hashtable)serializable).put(string, new Integer((int)object[n4]));
            }
            serializable = null;
            n4 = n3;
            while (--n4 >= 0) {
                if (!bitSet.get(n4)) continue;
                stringBuffer2.append(" " + (int)object[nArray[n4][0]] + " " + (int)object[nArray[n4][1]] + " " + (int)object[nArray[n4][2]]);
                if (n2 != 4 || nArray[n4].length != 4) continue;
                stringBuffer2.append(" " + (int)object[nArray[n4][0]] + " " + (int)object[nArray[n4][2]] + " " + (int)object[nArray[n4][3]]);
            }
        }
        serializable = new StringBuffer();
        if (vector != null) {
            int n9 = n3;
            while (--n9 >= 0) {
                if (!bitSet.get(n9) || sArray2 != null) continue;
                ((StringBuffer)serializable).append(" " + hashtable.get("" + sArray[nArray[n9][0]]) + " " + hashtable.get("" + sArray[nArray[n9][1]]) + " " + hashtable.get("" + sArray[nArray[n9][2]]));
                if (n2 != 4 || nArray[n9].length != 4) continue;
                ((StringBuffer)serializable).append(" " + hashtable.get("" + sArray[nArray[n9][0]]) + " " + hashtable.get("" + sArray[nArray[n9][2]]) + " " + hashtable.get("" + sArray[nArray[n9][3]]));
            }
        }
        object = new StringBuffer();
        for (n4 = 0; n4 < n; ++n4) {
            if (Float.isNaN(point3fArray[n4].x)) continue;
            this.output(point3fArray[n4], (StringBuffer)object, true);
        }
        nArray2 = null;
        StringBuffer stringBuffer3 = new StringBuffer();
        int n10 = 0;
        if (vector3fArray != null) {
            n10 = vector2.size();
            for (int i = 0; i < n10; ++i) {
                stringBuffer3.append(vector2.get(i));
            }
            vector2 = null;
        }
        StringBuffer stringBuffer4 = new StringBuffer();
        int n11 = 0;
        if (vector != null) {
            n11 = vector.size();
            for (int i = 0; i < n11; ++i) {
                short s2 = (Short)vector.get(i);
                stringBuffer4.append(this.rgbFractionalFromColix(s2, ' ')).append(" ").append(this.translucencyFractionalFromColix(s2)).append(" ");
            }
        }
        String string = "mesh" + ++this.iObj;
        this.addMeshData(string, n5, n7, n10, n11, stringBuffer, stringBuffer2, (StringBuffer)serializable, (StringBuffer)object, stringBuffer3, stringBuffer4);
        Vector<String> vector3 = new Vector<String>();
        this.htNodes.put(string, vector3);
        this.addShader(string, s);
        this.cylinderMatrix.setIdentity();
        vector3.add(this.getParentItem("Jmol", this.cylinderMatrix));
    }

    private void addMeshData(String string, int n, int n2, int n3, int n4, StringBuffer stringBuffer, StringBuffer stringBuffer2, StringBuffer stringBuffer3, StringBuffer stringBuffer4, StringBuffer stringBuffer5, StringBuffer stringBuffer6) {
        this.getMeshHeader(string, n, n2, n3, n4, this.models);
        this.models.append("MESH_FACE_POSITION_LIST { ").append(stringBuffer).append(" }\n").append("MESH_FACE_NORMAL_LIST { ").append(stringBuffer2).append(" }\n");
        this.models.append("MESH_FACE_SHADING_LIST { ");
        for (int i = 0; i < n; ++i) {
            this.models.append("0 ");
        }
        this.models.append("}\n");
        if (n4 > 0) {
            this.models.append("MESH_FACE_DIFFUSE_COLOR_LIST { ").append(stringBuffer3).append(" }\n");
        }
        this.models.append("MODEL_POSITION_LIST { ").append(stringBuffer4).append(" }\n").append("MODEL_NORMAL_LIST { ").append(stringBuffer5).append(" }\n");
        if (n4 > 0) {
            this.models.append("MODEL_DIFFUSE_COLOR_LIST { ").append(stringBuffer6).append(" }\n");
        }
        this.models.append("}}}\n");
    }

    public void fillCone(short s, byte by, int n, Point3f point3f, Point3f point3f2) {
        this.viewer.unTransformPoint(point3f, this.tempP1);
        this.viewer.unTransformPoint(point3f2, this.tempP2);
        float f = this.viewer.unscaleToScreen((int)point3f.z, n) / 2.0f;
        if (f < 0.05f) {
            f = 0.05f;
        }
        if (!this.haveCone) {
            this.models.append(this.getConeResource());
            this.haveCone = true;
        }
        this.checkPoint(this.tempP1);
        this.checkPoint(this.tempP2);
        this.addColix(s, false);
        String string = "Cone_" + s;
        Vector<String> vector = (Vector<String>)this.htNodes.get(string);
        if (vector == null) {
            vector = new Vector<String>();
            this.htNodes.put(string, vector);
            this.addShader(string, s);
        }
        this.cylinderMatrix.set(this.getRotationMatrix(this.tempP1, this.tempP2, f));
        this.cylinderMatrix.m03 = this.tempP1.x;
        this.cylinderMatrix.m13 = this.tempP1.y;
        this.cylinderMatrix.m23 = this.tempP1.z;
        this.cylinderMatrix.m33 = 1.0f;
        vector.add(this.getParentItem("Jmol", this.cylinderMatrix));
    }

    private Object getConeResource() {
        int n = 10;
        int n2 = 360 / n;
        int n3 = n2 + 1;
        int[] nArray = new int[n2 * 3];
        int n4 = -1;
        for (int i = 0; i < n2; ++i) {
            nArray[++n4] = i;
            nArray[++n4] = (i + 1) % n2;
            nArray[++n4] = n2;
        }
        Tuple3f[] tuple3fArray = new Point3f[n3];
        for (int i = 0; i < n2; ++i) {
            float f = (float)Math.cos((double)(i * n) / 180.0 * Math.PI);
            float f2 = (float)Math.sin((double)(i * n) / 180.0 * Math.PI);
            tuple3fArray[i] = new Point3f(f, f2, 0.0f);
        }
        tuple3fArray[n2] = new Point3f(0.0f, 0.0f, 1.0f);
        return this.getMeshData("Cone", nArray, tuple3fArray, tuple3fArray);
    }

    private Object getCircleResource() {
        int n = 10;
        int n2 = 360 / n;
        int n3 = n2 + 1;
        int[] nArray = new int[n2 * 3];
        int n4 = -1;
        for (int i = 0; i < n2; ++i) {
            nArray[++n4] = i;
            nArray[++n4] = (i + 1) % n2;
            nArray[++n4] = n2;
        }
        Tuple3f[] tuple3fArray = new Point3f[n3];
        Tuple3f[] tuple3fArray2 = new Point3f[n3];
        for (int i = 0; i < n2; ++i) {
            float f = (float)Math.cos((double)(i * n) / 180.0 * Math.PI);
            float f2 = (float)Math.sin((double)(i * n) / 180.0 * Math.PI);
            tuple3fArray[i] = new Point3f(f, f2, 0.0f);
            tuple3fArray2[i] = new Point3f(0.0f, 0.0f, 1.0f);
        }
        tuple3fArray[n2] = new Point3f(0.0f, 0.0f, 0.0f);
        tuple3fArray2[n2] = new Point3f(0.0f, 0.0f, 1.0f);
        return this.getMeshData("Circle", nArray, tuple3fArray, tuple3fArray2);
    }

    public void fillCylinder(short s, byte by, int n, Point3f point3f, Point3f point3f2) {
        Point3f point3f3 = new Point3f();
        Point3f point3f4 = new Point3f();
        this.viewer.unTransformPoint(point3f, point3f3);
        this.viewer.unTransformPoint(point3f2, point3f4);
        int n2 = (int)(this.viewer.unscaleToScreen((int)((point3f.z + point3f2.z) / 2.0f), n) * 1000.0f);
        if (n2 < 20) {
            n2 = 20;
        }
        this.outputCylinder(point3f3, point3f4, s, by, n2);
    }

    public void fillTriangle(short s, Point3f point3f, Point3f point3f2, Point3f point3f3) {
        this.viewer.unTransformPoint(point3f, this.tempP1);
        this.viewer.unTransformPoint(point3f2, this.tempP2);
        this.viewer.unTransformPoint(point3f3, this.tempP3);
        this.addColix(s, false);
        String string = "T" + ++this.iObj;
        this.models.append(this.getTriangleResource(string, this.tempP1, this.tempP2, this.tempP3));
        Vector<String> vector = new Vector<String>();
        this.htNodes.put(string, vector);
        this.addShader(string, s);
        if (this.cylinderMatrix == null) {
            this.cylinderMatrix = new Matrix4f();
        }
        this.cylinderMatrix.setIdentity();
        vector.add(this.getParentItem("Jmol", this.cylinderMatrix));
    }

    private Object getTriangleResource(String string, Point3f point3f, Point3f point3f2, Point3f point3f3) {
        int[] nArray = new int[]{0, 1, 2};
        Tuple3f[] tuple3fArray = new Point3f[]{point3f, point3f2, point3f3};
        this.tempV1.set(point3f3);
        this.tempV1.sub(point3f);
        this.tempV2.set(point3f2);
        this.tempV2.sub(point3f);
        this.tempV2.cross(this.tempV2, this.tempV1);
        this.tempV2.normalize();
        Tuple3f[] tuple3fArray2 = new Vector3f[]{this.tempV2, this.tempV2, this.tempV2};
        return this.getMeshData(string, nArray, tuple3fArray, tuple3fArray2);
    }

    public void plotText(int n, int n2, int n3, short s, String string, Font3D font3D) {
        if (n3 < 3) {
            this.viewer.transformPoint(this.center, this.pt);
            n3 = (int)this.pt.z;
        }
        this.g3d.plotText(n, n2, n3, this.g3d.getColixArgb(s), string, font3D, this.jmolRenderer);
    }

    public void startShapeBuffer(int n) {
    }

    public void endShapeBuffer() {
    }

    public void renderText(Text text) {
    }

    public void drawString(short s, String string, Font3D font3D, int n, int n2, int n3, int n4) {
    }

    public void drawCircleCentered(short s, int n, int n2, int n3, int n4, boolean bl) {
        this.pt.set(n2, n3, n4);
        this.viewer.unTransformPoint(this.pt, this.ptAtom);
        float f = this.viewer.unscaleToScreen(n4, n);
        int n5 = (int)(f * 1000.0f);
        this.pt.set(n2, n3, n4 + 1);
        this.viewer.unTransformPoint(this.pt, this.pt);
        if (bl) {
            this.outputCircle(this.ptAtom, this.pt, s, n5);
            return;
        }
    }

    public void fillScreenedCircleCentered(short s, int n, int n2, int n3, int n4) {
        this.drawCircleCentered(s, n, n2, n3, n4, false);
        this.drawCircleCentered(Graphics3D.getColixTranslucent(s, true, 0.5f), n, n2, n3, n4, true);
    }

    public void drawTextPixel(int n, int n2, int n3, int n4) {
        this.pt.set(n2, n3, n4);
        this.viewer.unTransformPoint(this.pt, this.ptAtom);
        short s = Graphics3D.getColix(n);
        this.outputSphere(this.ptAtom, 0.02f, s);
    }

    public void plotImage(int n, int n2, int n3, Image image, short s, int n4, int n5) {
    }

    void renderEllipsoid(Point3f point3f, Point3f[] point3fArray, short s, int n, int n2, int n3, int n4, Matrix3f matrix3f, double[] dArray, Matrix4f matrix4f, Point3i[] point3iArray) {
        AxisAngle4f axisAngle4f = Quaternion.getQuaternionFrame(point3f, point3fArray[1], point3fArray[3]).toAxisAngle4f();
        float f = point3fArray[1].distance(point3f);
        float f2 = point3fArray[3].distance(point3f);
        float f3 = point3fArray[5].distance(point3f);
        this.outputEllipsoid(point3f, f, f2, f3, axisAngle4f, s);
    }
}

