/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.awt.Image;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.api.JmolRendererInterface;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.shape.Text;
import org.jmol.viewer.Viewer;

public abstract class _Exporter {
    protected Viewer viewer;
    protected JmolRendererInterface jmolRenderer;
    protected StringBuffer output;
    protected BufferedWriter bw;
    private FileOutputStream os;
    protected String fileName;
    protected String commandLineOptions;
    protected boolean isToFile;
    protected Graphics3D g3d;
    protected int screenWidth;
    protected int screenHeight;
    protected int slabZ;
    protected int depthZ;
    boolean use2dBondOrderCalculation;
    boolean canDoTriangles;
    boolean isCartesianExport;
    protected Point3f center = new Point3f();
    protected Point3f tempP1 = new Point3f();
    protected Point3f tempP2 = new Point3f();
    protected Point3f tempP3 = new Point3f();
    protected Vector3f tempV1 = new Vector3f();
    protected Vector3f tempV2 = new Vector3f();
    protected Vector3f tempV3 = new Vector3f();
    protected AxisAngle4f tempA = new AxisAngle4f();
    protected static final float degreesPerRadian = 57.29578f;
    protected final Point3f pt = new Point3f();

    public void setRenderer(JmolRendererInterface jmolRendererInterface) {
        this.jmolRenderer = jmolRendererInterface;
    }

    public boolean initializeOutput(Viewer viewer, Graphics3D graphics3D, Object object) {
        this.viewer = viewer;
        this.g3d = graphics3D;
        this.center.set(viewer.getRotationCenter());
        if (this.screenWidth <= 0 || this.screenHeight <= 0) {
            this.screenWidth = viewer.getScreenWidth();
            this.screenHeight = viewer.getScreenHeight();
        }
        this.slabZ = graphics3D.getSlab();
        this.depthZ = graphics3D.getDepth();
        this.isToFile = object instanceof String;
        if (this.isToFile) {
            this.fileName = (String)object;
            int n = this.fileName.indexOf(":::");
            if (n > 0) {
                this.commandLineOptions = this.fileName.substring(n + 3);
                this.fileName = this.fileName.substring(0, n);
            }
            try {
                this.os = new FileOutputStream(this.fileName);
                this.bw = new BufferedWriter(new OutputStreamWriter(this.os));
            }
            catch (FileNotFoundException fileNotFoundException) {
                return false;
            }
        } else {
            this.output = (StringBuffer)object;
        }
        this.getHeader();
        return true;
    }

    public String finalizeOutput() {
        this.getFooter();
        if (!this.isToFile) {
            return this.output.toString();
        }
        try {
            this.bw.flush();
            this.bw.close();
            this.os = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    protected static String getExportDate() {
        return new SimpleDateFormat("yyyy-MM-dd', 'HH:mm").format(new Date());
    }

    protected float getFieldOfView() {
        float f = this.viewer.getCameraDepth() + 0.5f;
        return (float)(2.0 * Math.atan(0.5 / (double)f));
    }

    protected void getViewpointPosition(Point3f point3f) {
        this.pt.set(this.screenWidth / 2, this.screenHeight / 2, 0.0f);
        this.viewer.unTransformPoint(this.pt, point3f);
        point3f.sub(this.center);
    }

    protected void adjustViewpointPosition(Point3f point3f) {
        float f = this.viewer.getCameraDepth() + 0.5f;
        float f2 = this.viewer.getScalePixelsPerAngstrom(false);
        float f3 = this.viewer.getRotationRadius();
        float f4 = this.viewer.getZoomPercentFloat() / 100.0f;
        float f5 = f * 2.0f * f3 * f2 / f4;
        this.pt.set(this.screenWidth / 2, this.screenHeight / 2, f5);
        this.viewer.unTransformPoint(this.pt, this.pt);
        this.pt.sub(this.center);
        point3f.add(this.pt);
    }

    protected Vector3f getRotation(Vector3f vector3f) {
        this.tempV3.set(vector3f);
        this.tempV3.normalize();
        float f = (float)Math.sqrt(vector3f.x * vector3f.x + vector3f.y * vector3f.y + vector3f.z * vector3f.z);
        float f2 = (float)Math.acos(vector3f.y / f) * 57.29578f;
        if (vector3f.x < 0.0f) {
            f2 += 180.0f;
        }
        float f3 = (float)Math.atan2(vector3f.x, vector3f.z) * 57.29578f;
        this.tempV3.set(f2, f3, 0.0f);
        return this.tempV3;
    }

    protected AxisAngle4f getAxisAngle(Vector3f vector3f, int n, int n2, int n3) {
        this.tempV3.set(n, n2, n3);
        this.tempV2.set(vector3f);
        this.tempV2.normalize();
        this.tempV3.add(this.tempV2);
        this.tempA.set(this.tempV3.x, this.tempV3.y, this.tempV3.z, 3.14159f);
        return this.tempA;
    }

    protected String rgbFromColix(short s, char c) {
        int n = this.g3d.getColixArgb(s);
        return "" + (n >> 16 & 0xFF) + c + (n >> 8 & 0xFF) + c + (n & 0xFF);
    }

    protected String rgbFractionalFromColix(short s, char c) {
        return this.rgbFractionalFromArgb(this.g3d.getColixArgb(s), c);
    }

    protected String rgbFractionalFromArgb(int n, char c) {
        return "" + _Exporter.round((float)(n >> 16 & 0xFF) / 255.0f) + c + _Exporter.round((float)(n >> 8 & 0xFF) / 255.0f) + c + _Exporter.round((float)(n & 0xFF) / 255.0f);
    }

    protected String translucencyFractionalFromColix(short s) {
        int n = Graphics3D.getColixTranslucencyLevel(s);
        if (Graphics3D.isColixTranslucent(s)) {
            return "" + (float)n / 255.0f;
        }
        return "" + 0.0f;
    }

    protected String opacityFractionalFromColix(short s) {
        int n = Graphics3D.getColixTranslucencyLevel(s);
        if (Graphics3D.isColixTranslucent(s)) {
            return "" + (1.0f - (float)n / 255.0f);
        }
        return "" + 1.0f;
    }

    protected static float round(double d) {
        return (float)Math.round(d * 1000.0) / 1000.0f;
    }

    protected Vector getColorList(int n, short[] sArray, int n2, BitSet bitSet, Hashtable hashtable) {
        int n3 = 0;
        Vector<Short> vector = new Vector<Short>();
        for (int i = 0; i < n2; ++i) {
            String string;
            if (bitSet != null && !bitSet.get(i) || hashtable.containsKey(string = "" + sArray[i])) continue;
            vector.add(new Short(sArray[i]));
            hashtable.put(string, "" + (n + n3++));
        }
        return vector;
    }

    abstract void getHeader();

    abstract void getFooter();

    abstract void renderAtom(Atom var1, short var2);

    abstract void renderIsosurface(Point3f[] var1, short var2, short[] var3, Vector3f[] var4, int[][] var5, BitSet var6, int var7, int var8, short[] var9, int var10);

    abstract void renderText(Text var1);

    abstract void drawString(short var1, String var2, Font3D var3, int var4, int var5, int var6, int var7);

    abstract void fillCylinder(Point3f var1, Point3f var2, short var3, short var4, byte var5, int var6, int var7);

    abstract void fillCylinder(short var1, byte var2, int var3, Point3f var4, Point3f var5);

    abstract void drawCircleCentered(short var1, int var2, int var3, int var4, int var5, boolean var6);

    abstract void fillScreenedCircleCentered(short var1, int var2, int var3, int var4, int var5);

    abstract void drawPixel(short var1, int var2, int var3, int var4);

    abstract void drawTextPixel(int var1, int var2, int var3, int var4);

    abstract void fillCone(short var1, byte var2, int var3, Point3f var4, Point3f var5);

    abstract void fillTriangle(short var1, Point3f var2, Point3f var3, Point3f var4);

    abstract void fillSphereCentered(short var1, int var2, Point3f var3);

    abstract void plotText(int var1, int var2, int var3, short var4, String var5, Font3D var6);

    abstract void plotImage(int var1, int var2, int var3, Image var4, short var5, int var6, int var7);

    abstract void startShapeBuffer(int var1);

    abstract void endShapeBuffer();

    abstract void renderEllipsoid(Point3f var1, Point3f[] var2, short var3, int var4, int var5, int var6, int var7, Matrix3f var8, double[] var9, Matrix4f var10, Point3i[] var11);
}

