/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import java.io.BufferedReader;
import java.util.BitSet;
import java.util.HashMap;
import netscape.javascript.JSObject;
import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.util.TextFormat;
import org.xml.sax.XMLReader;

public class XmlXsdReader
extends XmlReader {
    String[] xsdImplementedAttributes = new String[]{"ID", "XYZ", "Connections", "Components", "IsBackboneAtom", "Connects", "Type", "Name"};
    private BitSet bsBackbone = new BitSet();
    private int iChain = -1;
    private int iGroup = 0;
    private int iAtom = 0;

    protected void processXml(XmlReader xmlReader, AtomSetCollection atomSetCollection, BufferedReader bufferedReader, XMLReader xMLReader) {
        this.init(xmlReader, atomSetCollection);
        this.reader = bufferedReader;
        new XsdHandler(xMLReader);
        this.parseReaderXML(xMLReader);
        this.fin();
    }

    protected void processXml(XmlReader xmlReader, AtomSetCollection atomSetCollection, BufferedReader bufferedReader, JSObject jSObject) {
        this.init(xmlReader, atomSetCollection);
        this.implementedAttributes = this.xsdImplementedAttributes;
        new XsdHandler().walkDOMTree(jSObject);
        this.fin();
    }

    private void init(XmlReader xmlReader, AtomSetCollection atomSetCollection) {
        this.parent = xmlReader;
        this.atomSetCollection = atomSetCollection;
        xmlReader.htParams.put("backboneAtoms", this.bsBackbone);
    }

    private void fin() {
        this.atomSetCollection.clearSymbolicMap();
    }

    public void processStartElement(String string, String string2, String string3, HashMap hashMap) {
        System.out.println(string + " " + string2 + " " + hashMap);
        if ("Molecule".equals(string2)) {
            this.atomSetCollection.newAtomSet();
            this.atomSetCollection.setAtomSetName((String)hashMap.get("Name"));
            return;
        }
        if ("LinearChain".equals(string2)) {
            this.iGroup = 0;
            ++this.iChain;
        }
        if ("RepeatUnit".equals(string2)) {
            ++this.iGroup;
        }
        if ("Atom3d".equals(string2)) {
            boolean bl;
            this.atom = new Atom();
            this.atom.elementSymbol = (String)hashMap.get("Components");
            this.atom.atomName = (String)hashMap.get("ID");
            this.atom.atomSerial = ++this.iAtom;
            if (this.iChain >= 0) {
                this.atom.chainID = (char)((this.iChain - 1) % 26 + 65);
            }
            this.atom.group3 = "UNK";
            if (this.iGroup == 0) {
                this.iGroup = 1;
            }
            this.atom.sequenceNumber = this.iGroup;
            String string4 = (String)hashMap.get("XYZ");
            if (string4 != null) {
                String[] stringArray = XmlXsdReader.getTokens(string4.replace(',', ' '));
                this.atom.set(this.parseFloat(stringArray[0]), this.parseFloat(stringArray[1]), this.parseFloat(stringArray[2]));
            }
            if (bl = "1".equals((String)hashMap.get("IsBackboneAtom"))) {
                this.bsBackbone.set(this.iAtom);
            }
            return;
        }
        if ("Bond".equals(string2)) {
            String[] stringArray = TextFormat.split((String)hashMap.get("Connects"), ',');
            int n = 1;
            if (hashMap.containsKey("Type")) {
                String string5 = (String)hashMap.get("Type");
                if (string5.equals("Double")) {
                    n = 2;
                } else if (string5.equals("Triple")) {
                    n = 3;
                }
            }
            this.atomSetCollection.addNewBond(stringArray[0], stringArray[1], n);
            return;
        }
    }

    public void processEndElement(String string, String string2, String string3) {
        if ("Atom3d".equals(string2)) {
            if (this.atom.elementSymbol != null && !Float.isNaN(this.atom.z)) {
                this.atomSetCollection.addAtomWithMappedName(this.atom);
            }
            this.atom = null;
            return;
        }
        this.keepChars = false;
        this.chars = null;
    }

    class XsdHandler
    extends XmlReader.JmolXmlHandler {
        XsdHandler() {
        }

        XsdHandler(XMLReader xMLReader) {
            this.setHandler(xMLReader, this);
        }
    }
}

