/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import java.util.Hashtable;
import org.jmol.adapter.readers.more.SpartanArchive;
import org.jmol.adapter.readers.more.SpartanInputReader;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Logger;

public class SpartanSmolReader
extends SpartanInputReader {
    boolean isCompoundDocument = false;
    private String endCheck = "END Directory Entry ";
    private Hashtable moData = new Hashtable();
    private String title;
    SpartanArchive spartanArchive;
    Hashtable titles;

    public void readAtomSetCollection(BufferedReader bufferedReader) {
        this.modelName = "Spartan file";
        this.reader = bufferedReader;
        try {
            this.isCompoundDocument = this.readLine().indexOf("Compound Document File Directory") >= 0;
            this.atomSetCollection = new AtomSetCollection("spartan smol");
            boolean bl = false;
            boolean bl2 = false;
            while (this.line != null) {
                String string;
                if (this.isCompoundDocument && (string = this.line.toLowerCase()).equals("begin directory entry molecule") || this.line.indexOf("JMOL_MODEL") >= 0 && !this.line.startsWith("END")) {
                    if (this.modelNumber > 0) {
                        this.applySymmetryAndSetTrajectory();
                    }
                    bl = true;
                    int n = this.getModelNumber();
                    this.modelNumber = this.bsModels == null && n != Integer.MIN_VALUE ? n : this.modelNumber + 1;
                    this.bondData = "";
                    if (!this.doGetModel(this.modelNumber)) {
                        if (this.isLastModel(this.modelNumber) && bl2) break;
                        bl2 = false;
                        this.readLine();
                        continue;
                    }
                    bl2 = true;
                    this.atomSetCollection.newAtomSet();
                    this.moData = new Hashtable();
                    this.moData.put("isNormalized", Boolean.TRUE);
                    if (n == Integer.MIN_VALUE) {
                        n = this.modelNumber;
                        this.title = "Model " + this.line.substring(this.line.lastIndexOf(" ") + 1);
                    } else {
                        this.title = (String)this.titles.get("Title" + n);
                        this.title = "Profile " + n + (this.title == null ? "" : ": " + this.title);
                    }
                    Logger.info(this.title);
                    this.atomSetCollection.setAtomSetAuxiliaryInfo("title", this.title);
                    this.atomSetCollection.setAtomSetName(this.title);
                    this.atomSetCollection.setAtomSetAuxiliaryInfo("isPDB", Boolean.FALSE);
                    this.atomSetCollection.setAtomSetNumber(n);
                    if (this.isCompoundDocument) {
                        this.readTransform();
                    }
                    this.readLine();
                    continue;
                }
                if (bl && !bl2) {
                    this.readLine();
                    continue;
                }
                if (this.line.indexOf("BEGIN") == 0) {
                    string = this.line.toLowerCase();
                    if (string.endsWith("input")) {
                        this.bondData = "";
                        this.readInputRecords();
                        if (this.atomSetCollection.errorMessage != null) {
                            return;
                        }
                        if (this.title != null) {
                            this.atomSetCollection.setAtomSetName(this.title);
                        }
                    } else {
                        if (string.endsWith("_output")) {
                            this.readLine();
                            continue;
                        }
                        if (string.endsWith("output")) {
                            this.readOutput();
                            continue;
                        }
                        if (string.endsWith("molecule") || string.endsWith("molecule:asbinarystring")) {
                            this.readTransform();
                            continue;
                        }
                        if (string.endsWith("proparc") || string.endsWith("propertyarchive")) {
                            this.readProperties();
                            continue;
                        }
                        if (string.endsWith("archive")) {
                            this.readArchive();
                            continue;
                        }
                    }
                }
                if (this.line != null && this.line.indexOf("5D shell") >= 0) {
                    this.calculationType = this.line;
                    this.moData.put("calculationType", this.calculationType);
                }
                this.readLine();
            }
            if (this.atomCount > 0) {
                this.applySymmetryAndSetTrajectory();
            }
            if (this.atomCount > 0 && this.spartanArchive != null && this.atomSetCollection.getBondCount() == 0 && this.bondData != null) {
                this.spartanArchive.addBonds(this.bondData, 0);
            }
        }
        catch (Exception exception) {
            this.setError(exception);
        }
    }

    private void readOutput() throws Exception {
        this.titles = new Hashtable();
        String string = "";
        while (this.readLine() != null && !this.line.startsWith("END ")) {
            string = string + this.line + "\n";
            int n = this.line.indexOf(")");
            if (n <= 0) continue;
            this.titles.put("Title" + this.parseInt(this.line.substring(0, n)), this.line.substring(n + 1).trim());
        }
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("fileHeader", string);
    }

    private void readArchive() throws Exception {
        this.spartanArchive = new SpartanArchive(this, this.atomSetCollection, this.moData, this.bondData, this.endCheck);
        if (this.readArchiveHeader()) {
            this.modelAtomCount = this.spartanArchive.readArchive(this.line, false, this.atomCount, false);
            if (this.atomCount == 0 || !this.isTrajectory) {
                this.atomCount += this.modelAtomCount;
            }
        }
    }

    private void readProperties() throws Exception {
        this.spartanArchive.readProperties();
        if (!this.atomSetCollection.setAtomSetCollectionPartialCharges("MULCHARGES")) {
            this.atomSetCollection.setAtomSetCollectionPartialCharges("Q1_CHARGES");
        }
        Float f = (Float)this.atomSetCollection.getAtomSetCollectionAuxiliaryInfo("HOMO_N");
        if (this.moData != null && f != null) {
            this.moData.put("HOMO", new Integer(f.intValue()));
        }
        this.readLine();
    }

    private int getModelNumber() {
        try {
            int n = this.line.indexOf("JMOL_MODEL ") + 11;
            return this.parseInt(this.line, n);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private void readTransform() throws Exception {
        MoleculeRecord moleculeRecord = new MoleculeRecord(this.readLine());
        moleculeRecord.setTrans();
    }

    private boolean readArchiveHeader() throws Exception {
        String string = this.readLine();
        Logger.debug(string);
        if (string.indexOf("Error:") == 0) {
            return false;
        }
        this.atomSetCollection.setCollectionName(string);
        this.modelName = this.readLine();
        Logger.debug(this.modelName);
        this.readLine();
        return true;
    }

    private class MoleculeRecord {
        float[] mat;

        MoleculeRecord(String string) {
            int n;
            String[] stringArray = AtomSetCollectionReader.getTokens(string.trim());
            if (stringArray.length < 16) {
                return;
            }
            byte[] byArray = new byte[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                byArray[n] = (byte)Integer.parseInt(stringArray[n], 16);
            }
            this.mat = new float[16];
            n = 16;
            int n2 = byArray.length;
            while (--n >= 0) {
                this.mat[n] = this.bytesToDoubleToFloat(byArray, n2);
                n2 -= 8;
            }
        }

        private float bytesToDoubleToFloat(byte[] byArray, int n) {
            double d = Double.longBitsToDouble(((long)byArray[--n] & 0xFFL) << 56 | ((long)byArray[--n] & 0xFFL) << 48 | ((long)byArray[--n] & 0xFFL) << 40 | ((long)byArray[--n] & 0xFFL) << 32 | ((long)byArray[--n] & 0xFFL) << 24 | ((long)byArray[--n] & 0xFFL) << 16 | ((long)byArray[--n] & 0xFFL) << 8 | (long)byArray[--n] & 0xFFL);
            return (float)d;
        }

        protected void setTrans() {
            if (this.mat == null) {
                return;
            }
            SpartanSmolReader.this.setTransform(this.mat[0], this.mat[1], this.mat[2], this.mat[4], this.mat[5], this.mat[6], this.mat[8], this.mat[9], this.mat[10]);
        }
    }
}

