/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.util.Logger;

abstract class SpartanInputReader
extends AtomSetCollectionReader {
    protected String modelName;
    protected int atomCount;
    protected int bondCount;
    protected String bondData = "";
    int modelAtomCount;
    int atomCount0;

    SpartanInputReader() {
    }

    protected void readInputRecords() {
        int n = this.atomCount;
        try {
            String[] stringArray;
            this.readInputHeader();
            while (this.readLine() != null && ((stringArray = this.getTokens()).length != 2 || this.parseInt(stringArray[0]) == Integer.MIN_VALUE || this.parseInt(stringArray[1]) < 0)) {
            }
            if (this.line == null) {
                return;
            }
            this.readInputAtoms();
            this.discardLinesUntilContains("ATOMLABELS");
            if (this.line != null) {
                this.readAtomNames();
            }
            this.discardLinesUntilContains("HESSIAN");
            if (this.line != null) {
                this.readBonds(n);
            }
            while (this.line != null && this.line.indexOf("END ") < 0 && this.line.indexOf("MOLSTATE") < 0) {
                this.readLine();
            }
            if (this.line != null && this.line.indexOf("MOLSTATE") >= 0) {
                this.readTransform();
            }
            if (this.atomSetCollection.getAtomCount() > 0) {
                this.atomSetCollection.setAtomSetName(this.modelName);
            }
        }
        catch (Exception exception) {
            this.setError(exception);
        }
    }

    private void readTransform() throws Exception {
        this.readLine();
        String[] stringArray = SpartanInputReader.getTokens(this.readLine() + " " + this.readLine());
        this.setTransform(this.parseFloat(stringArray[0]), this.parseFloat(stringArray[1]), this.parseFloat(stringArray[2]), this.parseFloat(stringArray[4]), this.parseFloat(stringArray[5]), this.parseFloat(stringArray[6]), this.parseFloat(stringArray[8]), this.parseFloat(stringArray[9]), this.parseFloat(stringArray[10]));
    }

    private void readInputHeader() throws Exception {
        while (this.readLine() != null && !this.line.startsWith(" ")) {
        }
        this.readLine();
        this.modelName = this.line + ";";
        this.modelName = this.modelName.substring(0, this.modelName.indexOf(";")).trim();
    }

    private void readInputAtoms() throws Exception {
        this.modelAtomCount = 0;
        this.atomCount0 = this.atomCount;
        while (this.readLine() != null && !this.line.startsWith("ENDCART")) {
            String[] stringArray = this.getTokens();
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = SpartanInputReader.getElementSymbol(this.parseInt(stringArray[0]));
            atom.set(this.parseFloat(stringArray[1]), this.parseFloat(stringArray[2]), this.parseFloat(stringArray[3]));
            ++this.modelAtomCount;
        }
        this.atomCount = this.atomSetCollection.getAtomCount();
        if (Logger.debugging) {
            Logger.debug(this.atomCount + " atoms read");
        }
    }

    private void readAtomNames() throws Exception {
        int n = this.atomCount - this.modelAtomCount;
        for (int i = 0; i < this.modelAtomCount; ++i) {
            String string;
            this.line = this.readLine().trim();
            this.atomSetCollection.getAtom((int)(n + i)).atomName = string = this.line.substring(1, this.line.length() - 1);
        }
    }

    private void readBonds(int n) throws Exception {
        int n2 = this.modelAtomCount;
        this.bondData = "";
        while (this.readLine() != null && !this.line.startsWith("ENDHESS")) {
            String[] stringArray = this.getTokens();
            this.bondData = this.bondData + this.line + " ";
            if (n2 == 0) {
                int n3 = this.parseInt(stringArray[0]) - 1 + n;
                int n4 = this.parseInt(stringArray[1]) - 1 + n;
                int n5 = this.parseInt(stringArray[2]);
                if (n5 <= 0) continue;
                this.atomSetCollection.addBond(new Bond(n3, n4, n5 < 4 ? n5 : (n5 == 5 ? 515 : 1)));
                continue;
            }
            n2 -= stringArray.length;
        }
        this.bondCount = this.atomSetCollection.getBondCount();
        if (Logger.debugging) {
            Logger.debug(this.bondCount + " bonds read");
        }
    }
}

