/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import java.util.Hashtable;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.util.Logger;

public class OdysseyXMLReader
extends AtomSetCollectionReader {
    String modelName = "Odyssey XML file";
    int atomCount;
    int bondCount;

    public void readAtomSetCollection(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
        this.atomSetCollection = new AtomSetCollection("odyssey(XML)");
        try {
            if (this.discardLinesUntilContains("<description") != null) {
                this.readDescription();
            }
            if (this.discardLinesUntilContains("<atoms") != null) {
                this.readAtoms();
            }
            if (this.discardLinesUntilContains("<bonds") != null) {
                this.readBonds();
            }
            if (this.atomCount > 0) {
                this.atomSetCollection.setAtomSetName(this.modelName);
            }
        }
        catch (Exception exception) {
            this.setError(exception);
        }
    }

    void readDescription() throws Exception {
        String string = "";
        String string2 = null;
        while (this.readLine() != null && this.line.indexOf("</description>") < 0) {
            if (this.line.indexOf("title") >= 0) {
                string = this.line.substring(this.line.indexOf(">") + 1, this.line.lastIndexOf("<"));
                continue;
            }
            if (this.line.indexOf("phase") < 0) continue;
            string2 = this.line.substring(this.line.indexOf(">") + 1, this.line.lastIndexOf("<"));
        }
        this.modelName = string + (string2 != null ? " - " + string2 : "");
    }

    void readAtoms() throws Exception {
        this.atomCount = 0;
        while (this.readLine() != null && this.line.indexOf("</atoms>") < 0) {
            Hashtable hashtable = this.readXML("atom");
            Atom atom = new Atom();
            atom.atomName = (String)hashtable.get("id");
            atom.elementSymbol = (String)hashtable.get("element");
            String[] stringArray = OdysseyXMLReader.getTokens((String)hashtable.get("xyz"));
            atom.set(this.parseFloat(stringArray[0]), this.parseFloat(stringArray[1]), this.parseFloat(stringArray[2]));
            this.atomSetCollection.addAtomWithMappedName(atom);
            atom.atomName = (String)hashtable.get("label");
            ++this.atomCount;
        }
    }

    Hashtable readXML(String string) throws Exception {
        String string2 = "<" + string;
        this.line = this.discardLinesUntilContains(string2);
        string2 = "/" + string + ">";
        String string3 = "/>";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        while (this.line != null) {
            this.line = this.line.trim();
            int n = 0;
            int n2 = 0;
            while ((n = this.line.indexOf("=", n)) >= 0) {
                String string4 = this.line.substring(n2, n);
                if (string4.indexOf(" ") > 0) {
                    string4 = string4.substring(string4.lastIndexOf(" ") + 1);
                }
                int n3 = this.line.indexOf("\"", n2);
                n2 = this.line.indexOf("\"", n3 + 1);
                String string5 = this.line.substring(n3 + 1, n2);
                hashtable.put(string4, string5);
            }
            this.readLine();
            if (this.line.indexOf(string2) < 0 && this.line.indexOf(string3) < 0) continue;
            break;
        }
        return hashtable;
    }

    void readBonds() throws Exception {
        while (this.readLine() != null && this.line.indexOf("</bonds>") < 0) {
            Hashtable hashtable = this.readXML("bond");
            int n = this.atomSetCollection.getAtomNameIndex((String)hashtable.get("a"));
            int n2 = this.atomSetCollection.getAtomNameIndex((String)hashtable.get("b"));
            String string = (String)hashtable.get("order");
            int n3 = string == "single" ? 1 : (string == "double" ? 2 : (string == "triple" ? 3 : 1));
            this.atomSetCollection.addBond(new Bond(n, n2, n3 < 4 ? n3 : 1));
            ++this.bondCount;
        }
        if (Logger.debugging) {
            Logger.debug(this.bondCount + " bonds read");
        }
    }
}

