/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Vector;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class MopacReader
extends AtomSetCollectionReader {
    int baseAtomIndex;
    private boolean chargesFound = false;

    public void readAtomSetCollection(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
        this.atomSetCollection = new AtomSetCollection("mopac");
        try {
            while (this.readLine() != null && !this.line.startsWith(" ---")) {
                if (this.line.indexOf("MOLECULAR POINT GROUP") >= 0 || !this.line.trim().equals("CARTESIAN COORDINATES")) continue;
                this.processCoordinates();
                this.atomSetCollection.setAtomSetName("Input Structure");
            }
            while (this.readLine() != null) {
                if (this.line.indexOf("TOTAL ENERGY") >= 0) {
                    this.processTotalEnergy();
                    continue;
                }
                if (this.line.indexOf("ATOMIC CHARGES") >= 0) {
                    this.processAtomicCharges();
                    continue;
                }
                if (this.line.trim().equals("CARTESIAN COORDINATES")) {
                    this.processCoordinates();
                    continue;
                }
                if (this.line.indexOf("ORIENTATION OF MOLECULE IN FORCE") >= 0) {
                    this.processCoordinates();
                    this.atomSetCollection.setAtomSetName("Orientation in Force Field");
                    continue;
                }
                if (this.line.indexOf("NORMAL COORDINATE ANALYSIS") < 0) continue;
                this.readFrequencies();
            }
        }
        catch (Exception exception) {
            this.setError(exception);
        }
    }

    void processTotalEnergy() {
    }

    void processAtomicCharges() throws Exception {
        int n;
        this.discardLines(2);
        this.atomSetCollection.newAtomSet();
        this.baseAtomIndex = this.atomSetCollection.getAtomCount();
        int n2 = 0;
        while (this.readLine() != null && (n = this.parseInt(this.line)) != Integer.MIN_VALUE) {
            if (n != ++n2) {
                throw new Exception("unexpected atom number in atomic charges");
            }
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = this.parseToken();
            atom.partialCharge = this.parseFloat();
        }
        this.chargesFound = true;
    }

    void processCoordinates() throws Exception {
        int n;
        this.discardLines(3);
        int n2 = 0;
        if (!this.chargesFound) {
            this.atomSetCollection.newAtomSet();
            this.baseAtomIndex = this.atomSetCollection.getAtomCount();
        } else {
            this.chargesFound = false;
        }
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        while (this.readLine() != null && (n = this.parseInt(this.line)) != Integer.MIN_VALUE) {
            if (n != ++n2) {
                throw new Exception("unexpected atom number in coordinates");
            }
            String string = this.parseToken();
            Atom atom = atomArray[this.baseAtomIndex + n - 1];
            if (atom == null) {
                atom = this.atomSetCollection.addNewAtom();
            }
            atom.atomSerial = n;
            atom.x = this.parseFloat();
            atom.y = this.parseFloat();
            atom.z = this.parseFloat();
            int n3 = this.parseInt(string);
            if (n3 != Integer.MIN_VALUE) {
                string = MopacReader.getElementSymbol(n3);
            }
            atom.elementSymbol = string;
        }
    }

    private void readFrequencies() throws Exception {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        int n = this.atomSetCollection.getLastAtomSetAtomCount();
        while (this.readLine() != null && this.line.indexOf("DESCRIPTION") < 0) {
            if (this.line.indexOf("ROOT") < 0) continue;
            int n2 = this.getTokens().length - 2;
            String[][] stringArray = new String[n * 3 + 1][];
            this.fillDataBlock(stringArray);
            for (int i = 0; i < n2; ++i) {
                float f = this.parseFloat(stringArray[0][i]);
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                hashtable.put("freq", new Float(f));
                hashtable.put("label", "");
                vector.addElement(hashtable);
                this.baseAtomIndex = this.atomSetCollection.getAtomCount();
                this.atomSetCollection.cloneLastAtomSet();
                Atom[] atomArray = this.atomSetCollection.getAtoms();
                this.atomSetCollection.setAtomSetName(f + " cm^-1");
                this.atomSetCollection.setAtomSetProperty(".PATH", "Frequencies");
                Vector vector3 = new Vector();
                int n3 = 1;
                for (int j = 0; j < n; ++j) {
                    float f2 = this.parseFloat(stringArray[n3++][i + 1]);
                    float f3 = this.parseFloat(stringArray[n3++][i + 1]);
                    float f4 = this.parseFloat(stringArray[n3++][i + 1]);
                    atomArray[this.baseAtomIndex + j].addVibrationVector(f2, f3, f4);
                    Vector<Float> vector4 = new Vector<Float>();
                    vector4.addElement(new Float(f2));
                    vector4.addElement(new Float(f3));
                    vector4.addElement(new Float(f4));
                    vector3.addElement(vector4);
                }
                vector2.addElement(vector3);
            }
        }
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("VibFreqs", vector);
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("vibration", vector2);
    }
}

