/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import java.util.Hashtable;
import org.jmol.adapter.readers.more.MopacData;
import org.jmol.adapter.readers.more.MopacDataReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class MopacGraphfReader
extends MopacDataReader {
    int[] atomicNumbers;
    int atomCount;
    float[][] invMatrix;

    public void readAtomSetCollection(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
        this.atomSetCollection = new AtomSetCollection("mopacGraphf");
        try {
            this.readAtoms();
            this.readSlaterBasis();
            this.readMOs(false);
            if (this.readKeywords()) {
                this.readMOs(true);
            }
        }
        catch (Exception exception) {
            this.setError(exception);
        }
    }

    void readAtoms() throws Exception {
        this.atomSetCollection.newAtomSet();
        this.atomCount = this.parseInt(this.readLine());
        this.atomicNumbers = new int[this.atomCount];
        for (int i = 0; i < this.atomCount; ++i) {
            this.readLine();
            this.atomicNumbers[i] = this.parseInt(this.line.substring(0, 4));
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.x = this.parseFloat(this.line.substring(4, 17));
            atom.y = this.parseFloat(this.line.substring(17, 29));
            atom.z = this.parseFloat(this.line.substring(29, 41));
            if (this.line.length() > 41) {
                atom.partialCharge = this.parseFloat(this.line.substring(41));
            }
            atom.elementSymbol = AtomSetCollectionReader.getElementSymbol(this.atomicNumbers[i]);
        }
    }

    void readSlaterBasis() throws Exception {
        this.nOrbitals = 0;
        float[] fArray = new float[3];
        for (int i = 0; i < this.atomCount; ++i) {
            float f;
            int n;
            MopacGraphfReader.getTokensFloat(this.readLine(), fArray, 3);
            int n2 = this.atomicNumbers[i];
            float f2 = fArray[0];
            if (f2 != 0.0f) {
                this.addSlater(i, 0, 0, 0, MopacData.getNPQs(n2) - 1, f2, MopacData.getMopacConstS(n2, f2));
            }
            if ((f2 = fArray[1]) != 0.0f) {
                n = MopacData.getNPQp(n2) - 2;
                f = MopacData.getMopacConstP(n2, f2);
                this.addSlater(i, 1, 0, 0, n, f2, f);
                this.addSlater(i, 0, 1, 0, n, f2, f);
                this.addSlater(i, 0, 0, 1, n, f2, f);
            }
            if ((f2 = fArray[2]) == 0.0f) continue;
            n = MopacData.getNPQd(n2) - 3;
            f = MopacData.getMopacConstD(n2, f2);
            int n3 = 0;
            for (int j = 0; j < 5; ++j) {
                this.addSlater(i, dValues[n3++], dValues[n3++], dValues[n3++], n, f2, f * MopacData.getFactorD(j));
            }
        }
        this.nOrbitals = this.intinfo.size();
        this.setSlaters();
    }

    void readMOs(boolean bl) throws Exception {
        int n;
        int n2;
        int n3;
        float[][] fArray = new float[this.nOrbitals][this.nOrbitals];
        for (n3 = 0; n3 < this.nOrbitals; ++n3) {
            n2 = -1;
            for (n = 0; n < this.nOrbitals; ++n) {
                if ((n2 = (n2 + 1) % 5) == 0) {
                    this.readLine();
                }
                fArray[n3][n] = this.parseFloat(this.line.substring(n2 * 15, (n2 + 1) * 15));
            }
        }
        if (!bl) {
            this.invMatrix = new float[this.nOrbitals][this.nOrbitals];
            for (n3 = 0; n3 < this.nOrbitals; ++n3) {
                n2 = -1;
                for (n = 0; n < n3 + 1; ++n) {
                    if ((n2 = (n2 + 1) % 5) == 0) {
                        this.readLine();
                    }
                    float f = this.parseFloat(this.line.substring(n2 * 15, (n2 + 1) * 15));
                    this.invMatrix[n][n3] = f;
                    this.invMatrix[n3][n] = f;
                }
            }
        }
        float[][] fArray2 = new float[this.nOrbitals][this.nOrbitals];
        for (n2 = 0; n2 < this.nOrbitals; ++n2) {
            for (n = 0; n < this.nOrbitals; ++n) {
                for (int i = 0; i < this.nOrbitals; ++i) {
                    float[] fArray3 = fArray2[n2];
                    int n4 = n;
                    fArray3[n4] = fArray3[n4] + fArray[n2][i] * this.invMatrix[i][n];
                }
                if (!(Math.abs(fArray2[n2][n]) < 1.0E-4f)) continue;
                fArray2[n2][n] = 0.0f;
            }
        }
        float[] fArray4 = new float[2];
        for (n = 0; n < this.nOrbitals; ++n) {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            MopacGraphfReader.getTokensFloat(this.readLine(), fArray4, 2);
            hashtable.put("energy", new Float(fArray4[0]));
            hashtable.put("occupancy", new Float(fArray4[1]));
            hashtable.put("coefficients", fArray2[n]);
            if (bl) {
                hashtable.put("type", "beta");
            }
            this.orbitals.addElement(hashtable);
        }
        this.setMOs("eV");
    }

    private boolean readKeywords() throws Exception {
        boolean bl;
        if (this.readLine() == null || this.line.indexOf(" Keywords:") < 0) {
            return false;
        }
        this.calculationType = this.line.substring(11).trim();
        this.moData.put("calculationType", this.calculationType);
        boolean bl2 = bl = this.line.indexOf("UHF") >= 0;
        if (bl) {
            int n = this.orbitals.size();
            while (--n >= 0) {
                ((Hashtable)this.orbitals.get(n)).put("type", "alpha");
            }
        }
        return bl;
    }
}

