/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

public class MopacData {
    private static final int[] principalQuantumNumber = new int[]{0, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6};
    private static final int[] pnqD = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 5, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 7};
    private static final float[] fact = new float[20];
    private static final float fourPi = (float)Math.PI * 4;
    private static final float[] factorDs;

    private static final boolean isNoble(int n) {
        switch (n) {
            case 2: 
            case 10: 
            case 18: 
            case 36: 
            case 54: 
            case 86: {
                return true;
            }
        }
        return false;
    }

    private static final int getNPQ(int n) {
        return n < principalQuantumNumber.length ? principalQuantumNumber[n] : 0;
    }

    public static final int getNPQs(int n) {
        return MopacData.getNPQ(n) + (n > 2 && MopacData.isNoble(n) ? 1 : 0);
    }

    public static final int getNPQp(int n) {
        return MopacData.getNPQ(n) + (n == 2 ? 1 : 0);
    }

    public static final int getNPQd(int n) {
        return n < pnqD.length ? pnqD[n] : 0;
    }

    public static final float getMopacConstS(int n, float f) {
        int n2 = MopacData.getNPQs(n);
        return (float)(Math.pow(2.0f * f, (double)n2 + 0.5) * Math.sqrt(0.07957747f / fact[2 * n2]));
    }

    public static final float getMopacConstP(int n, float f) {
        int n2 = MopacData.getNPQp(n);
        return (float)(Math.pow(2.0f * f, (double)n2 + 0.5) * Math.sqrt(0.23873241f / fact[2 * n2]));
    }

    public static float getFactorD(int n) {
        return factorDs[n];
    }

    public static final float getMopacConstD(int n, float f) {
        int n2 = MopacData.getNPQd(n);
        return (float)(Math.pow(2.0f * f, (double)n2 + 0.5) * Math.sqrt(1.193662f / fact[2 * n2]));
    }

    static {
        MopacData.fact[0] = 1.0f;
        for (int i = 1; i < fact.length; ++i) {
            MopacData.fact[i] = fact[i - 1] * (float)i;
        }
        factorDs = new float[]{0.5f, 1.0f, (float)(0.5 / Math.sqrt(3.0)), 1.0f, 1.0f};
    }
}

