/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import javax.vecmath.Vector3f;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Logger;

public class AimsReader
extends AtomSetCollectionReader {
    public void readAtomSetCollection(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
        this.atomSetCollection = new AtomSetCollection("aims");
        int n = 0;
        Vector3f[] vector3fArray = new Vector3f[3];
        try {
            while (this.readLine() != null) {
                Atom atom;
                float f;
                float f2;
                float f3;
                String[] stringArray = this.getTokens();
                if (stringArray.length == 0) continue;
                if (stringArray[0].equals("atom")) {
                    if (stringArray.length < 5) {
                        Logger.warn("cannot read line with FHI-aims atom data: " + this.line);
                    } else {
                        f3 = this.parseFloat(stringArray[1]);
                        f2 = this.parseFloat(stringArray[2]);
                        f = this.parseFloat(stringArray[3]);
                        String string = stringArray[4];
                        atom = this.atomSetCollection.addNewAtom();
                        atom.set(f3, f2, f);
                        atom.elementSymbol = string;
                    }
                }
                if (stringArray[0].equals("multipole")) {
                    if (stringArray.length < 6) {
                        Logger.warn("cannot read line with FHI-aims atom data: " + this.line);
                    } else {
                        f3 = this.parseFloat(stringArray[1]);
                        f2 = this.parseFloat(stringArray[2]);
                        f = this.parseFloat(stringArray[3]);
                        int n2 = this.parseInt(stringArray[4]);
                        float f4 = this.parseFloat(stringArray[5]);
                        if (n2 > 0) {
                            Logger.warn("multipole line ignored since only monopoles are currently supported: " + this.line);
                            continue;
                        }
                        atom = this.atomSetCollection.addNewAtom();
                        atom.set(f3, f2, f);
                        atom.partialCharge = f4;
                        atom.formalCharge = Math.round(f4);
                    }
                }
                if (!stringArray[0].equals("lattice_vector")) continue;
                if (stringArray.length < 4) {
                    Logger.warn("cannot read line with FHI-aims lattice vector: " + this.line);
                } else if (n > 2) {
                    Logger.warn("more than 3 FHI-aims lattice vectors found with line: " + this.line);
                } else {
                    f3 = this.parseFloat(stringArray[1]);
                    f2 = this.parseFloat(stringArray[2]);
                    f = this.parseFloat(stringArray[3]);
                    vector3fArray[n] = new Vector3f(f3, f2, f);
                }
                ++n;
            }
            if (n == 3) {
                this.doApplySymmetry = true;
                this.setFractionalCoordinates(false);
                this.setUnitCellFromLatticeVectors(vector3fArray);
                int n3 = this.atomSetCollection.getAtomCount();
                for (int i = 0; i < n3; ++i) {
                    Atom atom = this.atomSetCollection.getAtom(i);
                    this.setAtomCoord(atom);
                }
                this.applySymmetryAndSetTrajectory();
            }
        }
        catch (Exception exception) {
            this.setError(exception);
        }
    }

    private void setUnitCellFromLatticeVectors(Vector3f[] vector3fArray) {
        float f = vector3fArray[0].length();
        float f2 = vector3fArray[1].length();
        float f3 = vector3fArray[2].length();
        float f4 = (float)Math.toDegrees(vector3fArray[1].angle(vector3fArray[2]));
        float f5 = (float)Math.toDegrees(vector3fArray[2].angle(vector3fArray[0]));
        float f6 = (float)Math.toDegrees(vector3fArray[0].angle(vector3fArray[1]));
        this.setUnitCell(f, f2, f3, f4, f5, f6);
        float[] fArray = new float[3];
        for (int i = 0; i < 3; ++i) {
            vector3fArray[i].get(fArray);
            this.addPrimitiveLatticeVector(i, fArray);
        }
    }
}

