/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.discovery.resource.names;

import java.util.Hashtable;
import org.apache.commons.discovery.ResourceNameDiscover;
import org.apache.commons.discovery.ResourceNameIterator;
import org.apache.commons.discovery.log.DiscoveryLogFactory;
import org.apache.commons.discovery.resource.names.ResourceNameDiscoverImpl;
import org.apache.commons.logging.Log;

public class DiscoverMappedNames
extends ResourceNameDiscoverImpl
implements ResourceNameDiscover {
    private static Log log = DiscoveryLogFactory.newLog(DiscoverMappedNames.class);
    private Hashtable mapping = new Hashtable();

    public static void setLog(Log _log) {
        log = _log;
    }

    public void map(String fromName, String toName) {
        this.mapping.put(fromName, toName);
    }

    public void map(String fromName, String[] toNames) {
        this.mapping.put(fromName, toNames);
    }

    @Override
    public ResourceNameIterator findResourceNames(String resourceName) {
        Object obj;
        if (log.isDebugEnabled()) {
            log.debug("find: resourceName='" + resourceName + "', mapping to constants");
        }
        final String[] names = (obj = this.mapping.get(resourceName)) instanceof String ? new String[]{(String)obj} : (obj instanceof String[] ? (String[])obj : null);
        return new ResourceNameIterator(){
            private int idx = 0;

            @Override
            public boolean hasNext() {
                if (names != null) {
                    while (this.idx < names.length && names[this.idx] == null) {
                        ++this.idx;
                    }
                    return this.idx < names.length;
                }
                return false;
            }

            @Override
            public String nextResourceName() {
                return this.hasNext() ? names[this.idx++] : null;
            }
        };
    }
}

