/*
 * Decompiled with CFR 0.152.
 */
package model;

import interfaces.Sequence;
import java.awt.Color;

public class SequenceImpl
implements Sequence {
    private String name;
    private char[] sequence;
    private Color clusterColor;
    private int start;
    private int end;
    private boolean clusterStart;
    private boolean clusterEnd;

    public SequenceImpl(SequenceImpl seq) {
        this.name = seq.getName();
        this.sequence = seq.getSequence();
        this.start = seq.getStart();
        this.end = seq.getEnd();
    }

    public SequenceImpl(String name, String sequence, int start, int end) {
        this.name = name;
        this.sequence = sequence.toCharArray();
        this.start = start;
        this.end = end;
    }

    public SequenceImpl(String name, String sequence) {
        this(name, sequence, 1, -1);
    }

    @Override
    public char getLetterAt(int i) {
        if (i < this.sequence.length) {
            return this.sequence[i];
        }
        return ' ';
    }

    @Override
    public int getStart() {
        return this.start;
    }

    public int findPosition(int i) {
        int pos = this.start;
        int seqlen = this.sequence.length;
        for (int j = 0; j < i && j < seqlen; ++j) {
            ++pos;
        }
        return pos;
    }

    @Override
    public void setStart(int start) {
        this.start = start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public void setEnd(int end) {
        this.end = end;
    }

    @Override
    public int getLength() {
        return this.sequence.length;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public char[] getSequence(int start, int end) {
        if (start < 0) {
            start = 0;
        }
        if (start >= this.sequence.length) {
            return new char[0];
        }
        if (end >= this.sequence.length) {
            end = this.sequence.length;
        }
        char[] charseq = new char[end - start];
        System.arraycopy(this.sequence, start, charseq, 0, end - start);
        return charseq;
    }

    @Override
    public void setSequence(String sequence) {
        this.sequence = sequence.toCharArray();
    }

    public void setSequence(char[] sequence) {
        this.sequence = sequence;
    }

    @Override
    public String getSequenceAsString() {
        return new String(this.sequence);
    }

    @Override
    public char[] getSequence() {
        return this.sequence;
    }

    public Color getClusterColor() {
        return this.clusterColor;
    }

    public void setClusterColor(Color clusterColor) {
        this.clusterColor = clusterColor;
    }

    public boolean isClusterStart() {
        return this.clusterStart;
    }

    public void setClusterStart(boolean clusterStart) {
        this.clusterStart = clusterStart;
    }

    public boolean isClusterEnd() {
        return this.clusterEnd;
    }

    public void setClusterEnd(boolean clusterEnd) {
        this.clusterEnd = clusterEnd;
    }
}

