/*
 * Decompiled with CFR 0.152.
 */
package model;

import model.S3DetObject;
import model.UDMObject;
import model.XDetObject;

public class Methods {
    private boolean xDetUsed;
    private double xDetCutoff;
    private double currentXDetCutoff;
    private boolean entropyUsed;
    private double entropyCutoff;
    private double currentEntropyCutoff;
    private boolean s3DetUsed;
    private double s3DetCutoff;
    private double currentS3DetCutoff;
    private int udmNumber;
    private int methodNumber;
    private XDetObject xDetObject;
    private S3DetObject s3DetObject;
    private UDMObject[] udmObjects;
    private double[] scoreCutoff;

    public void addUdmObject(UDMObject addObject) {
        UDMObject[] newObjects = null;
        if (this.udmObjects != null) {
            newObjects = new UDMObject[this.udmObjects.length + 1];
            for (int i = 0; i < this.udmObjects.length; ++i) {
                newObjects[i] = this.udmObjects[i];
            }
            newObjects[i] = addObject;
        } else {
            newObjects = new UDMObject[]{addObject};
        }
        this.setUdmObjects(newObjects);
    }

    public void setUdmObjects(UDMObject[] udmObjects) {
        this.udmNumber = udmObjects.length;
        this.udmObjects = udmObjects;
    }

    public boolean isxDetUsed() {
        return this.xDetUsed;
    }

    public void setxDetUsed(boolean xDetUsed) {
        this.xDetUsed = xDetUsed;
    }

    public boolean isEntropyUsed() {
        return this.entropyUsed;
    }

    public void setEntropyUsed(boolean entropyUsed) {
        this.entropyUsed = entropyUsed;
    }

    public boolean isS3DetUsed() {
        return this.s3DetUsed;
    }

    public void setS3DetUsed(boolean s3DetUsed) {
        this.s3DetUsed = s3DetUsed;
    }

    public int getMethodNumber() {
        int count = 0;
        if (this.isxDetUsed()) {
            ++count;
        }
        if (this.isEntropyUsed()) {
            ++count;
        }
        if (this.isS3DetUsed()) {
            ++count;
        }
        this.methodNumber = count += this.udmNumber;
        return this.methodNumber;
    }

    public void setMethodNumber(int methodNumber) {
        this.methodNumber = methodNumber;
    }

    public XDetObject getxDetObject() {
        return this.xDetObject;
    }

    public void setxDetObject(XDetObject xDetObject) {
        this.xDetObject = xDetObject;
    }

    public S3DetObject getS3DetObject() {
        return this.s3DetObject;
    }

    public void setS3DetObject(S3DetObject s3DetObject) {
        this.s3DetObject = s3DetObject;
    }

    public int getUdmNumber() {
        return this.udmNumber;
    }

    public double getxDetCutoff() {
        return this.xDetCutoff;
    }

    public void setxDetCutoff(double xDetCutoff) {
        this.xDetCutoff = xDetCutoff;
    }

    public double getEntropyCutoff() {
        return this.entropyCutoff;
    }

    public void setEntropyCutoff(double entropyCutoff) {
        this.entropyCutoff = entropyCutoff;
    }

    public double getS3DetCutoff() {
        return this.s3DetCutoff;
    }

    public void setS3DetCutoff(double s3DetCutoff) {
        this.s3DetCutoff = s3DetCutoff;
    }

    public UDMObject[] getUdmObjects() {
        return this.udmObjects;
    }

    public double[] getScoreCutoffs() {
        this.scoreCutoff = new double[this.udmObjects.length];
        for (int i = 0; i < this.udmObjects.length; ++i) {
            this.scoreCutoff[i] = this.udmObjects[i].getScoreCutoff();
        }
        return this.scoreCutoff;
    }

    public double getCurrentXDetCutoff() {
        return this.currentXDetCutoff;
    }

    public void setCurrentXDetCutoff(double currentXDetCutoff) {
        this.currentXDetCutoff = currentXDetCutoff;
    }

    public double getCurrentEntropyCutoff() {
        return this.currentEntropyCutoff;
    }

    public void setCurrentEntropyCutoff(double currentEntropyCutoff) {
        this.currentEntropyCutoff = currentEntropyCutoff;
    }

    public double getCurrentS3DetCutoff() {
        return this.currentS3DetCutoff;
    }

    public void setCurrentS3DetCutoff(double currentS3DetCutoff) {
        this.currentS3DetCutoff = currentS3DetCutoff;
    }
}

