/*
 * Decompiled with CFR 0.152.
 */
package model;

import model.Methods;
import model.SequenceImpl;
import util.SelectionManager;
import view.AlignFrame;

public class AlignObject {
    private String filename;
    private SequenceImpl[] sequences;
    private int proteinNumber;

    public AlignObject() {
    }

    public AlignObject(SequenceImpl[] sequences) {
        this.sequences = sequences;
    }

    public int getHeight() {
        return this.sequences.length;
    }

    public int getWidth() {
        int max = -1;
        for (int i = 0; i < this.sequences.length; ++i) {
            if (this.getSequenceAt(i).getLength() <= max) continue;
            max = this.getSequenceAt(i).getLength();
        }
        return max;
    }

    public SequenceImpl getSequenceAt(int i) {
        if (i < this.sequences.length) {
            return this.sequences[i];
        }
        return null;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public SequenceImpl[] getSequences() {
        return this.sequences;
    }

    public void setSequences(SequenceImpl[] sequences) {
        this.sequences = sequences;
    }

    public int getProteinNumber() {
        return this.proteinNumber;
    }

    public void setProteinNumber(int proteinNumber) {
        this.proteinNumber = proteinNumber;
    }

    public void reloadOnlyAlignment(AlignFrame alignFrame) {
        try {
            if (alignFrame != null) {
                alignFrame.closeOtherWindows();
                alignFrame.dispose();
            }
            alignFrame = new AlignFrame(alignFrame.getAlObj(), new Methods(), 1100, 650, false);
            alignFrame.pack();
            alignFrame.setVisible(true);
            SelectionManager.setEnabled(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clearGaps() {
        for (int pos = this.getWidth() - 1; pos >= 0; --pos) {
            boolean allAreGaps = true;
            for (SequenceImpl s : this.getSequences()) {
                if (s.getLetterAt(pos) == '-') continue;
                allAreGaps = false;
            }
            if (!allAreGaps) continue;
            for (SequenceImpl s : this.getSequences()) {
                String newSeq = s.getSequenceAsString().substring(0, pos);
                if (pos < s.getLength() - 1) {
                    newSeq = newSeq + s.getSequenceAsString().substring(pos + 1);
                }
                s.setSequence(newSeq);
            }
        }
    }
}

