/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.Bounds;
import javax.media.j3d.CachedTargets;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Font3D;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.NnuId;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.PickInfo;
import javax.media.j3d.PickShape;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.SceneGraphObjectRetained;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.TargetsInterface;
import javax.media.j3d.Transform3D;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

class Text3DRetained
extends GeometryRetained {
    Font3D font3D = null;
    String string = null;
    Point3f position = new Point3f(0.0f, 0.0f, 0.0f);
    int alignment = 1;
    int path = 1;
    float charSpacing = 0.0f;
    int numChars = 0;
    static final int targetThreads = 8384;
    Transform3D[] charTransforms = new Transform3D[0];
    GeometryArrayRetained[] geometryList = new GeometryArrayRetained[0];
    GlyphVector[] glyphVecs = new GlyphVector[0];
    Point3d lower = new Point3d();
    Point3d upper = new Point3d();
    ArrayList newGeometryAtomList = new ArrayList();
    ArrayList oldGeometryAtomList = new ArrayList();
    Transform3D vpcToEc;
    Transform3D drawTransform;

    Text3DRetained() {
        this.geoType = 16;
    }

    synchronized void computeBoundingBox() {
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d();
        Vector3f vector3f = new Vector3f(this.position);
        int n = 0;
        int n2 = 0;
        double d = 0.0;
        double d2 = 0.0;
        point3d.set(vector3f);
        point3d2.set(vector3f);
        if (this.numChars != 0) {
            Rectangle2D rectangle2D;
            if (this.path == 1 || this.path == 2) {
                n = 0;
                n2 = this.numChars + 1;
            } else if (this.path == 0 || this.path == 3) {
                n = 1;
                n2 = this.numChars;
                rectangle2D = this.glyphVecs[0].getVisualBounds();
                point3d2.x += rectangle2D.getWidth();
                point3d2.y += rectangle2D.getHeight();
            }
            int n3 = 1;
            while (n3 < n2) {
                d = this.glyphVecs[n].getLogicalBounds().getWidth();
                rectangle2D = this.glyphVecs[n].getVisualBounds();
                d += (double)this.charSpacing;
                d2 = rectangle2D.getHeight();
                switch (this.path) {
                    case 1: {
                        point3d2.x += d;
                        if (!(point3d2.y < d2 + (double)vector3f.y)) break;
                        point3d2.y = (double)vector3f.y + d2;
                        break;
                    }
                    case 0: {
                        point3d.x -= d;
                        if (!(point3d2.y < d2 + (double)vector3f.y)) break;
                        point3d2.y = (double)vector3f.y + d2;
                        break;
                    }
                    case 2: {
                        point3d2.y += d2;
                        if (!(point3d2.x < rectangle2D.getWidth() + (double)vector3f.x)) break;
                        point3d2.x = (double)vector3f.x + rectangle2D.getWidth();
                        break;
                    }
                    case 3: {
                        point3d.y -= d2;
                        if (!(point3d2.x < rectangle2D.getWidth() + (double)vector3f.x)) break;
                        point3d2.x = (double)vector3f.x + rectangle2D.getWidth();
                    }
                }
                ++n3;
                ++n;
            }
            if (this.alignment != 1) {
                double d3 = point3d2.x - point3d.x;
                double d4 = point3d2.y - point3d.y;
                if (this.alignment == 0) {
                    d3 *= 0.5;
                    d4 *= 0.5;
                }
                switch (this.path) {
                    case 1: {
                        point3d.x -= d3;
                        point3d2.x -= d3;
                        break;
                    }
                    case 0: {
                        point3d.x += d3;
                        point3d2.x += d3;
                        break;
                    }
                    case 2: {
                        point3d.y -= d4;
                        point3d2.y -= d4;
                        break;
                    }
                    case 3: {
                        point3d.y += d4;
                        point3d2.y += d4;
                    }
                }
            }
        }
        point3d.z = 0.0;
        point3d2.z = this.font3D == null || this.font3D.fontExtrusion == null ? point3d.z : point3d.z + (double)this.font3D.fontExtrusion.length;
    }

    void update() {
    }

    final Font3D getFont3D() {
        return this.font3D;
    }

    final void setFont3D(Font3D font3D) {
        this.geomLock.getLock();
        this.font3D = font3D;
        this.updateCharacterData();
        this.geomLock.unLock();
        this.sendDataChangedMessage();
    }

    final String getString() {
        return this.string;
    }

    final void setString(String string) {
        this.geomLock.getLock();
        this.string = string;
        this.numChars = string == null ? 0 : string.length();
        this.updateCharacterData();
        this.geomLock.unLock();
        this.sendDataChangedMessage();
    }

    final void getPosition(Point3f point3f) {
        point3f.set(this.position);
    }

    final void setPosition(Point3f point3f) {
        this.geomLock.getLock();
        this.position.set(point3f);
        this.updateTransformData();
        this.geomLock.unLock();
        this.sendTransformChangedMessage();
    }

    final int getAlignment() {
        return this.alignment;
    }

    final void setAlignment(int n) {
        this.geomLock.getLock();
        this.alignment = n;
        this.updateTransformData();
        this.geomLock.unLock();
        this.sendTransformChangedMessage();
    }

    final int getPath() {
        return this.path;
    }

    final void setPath(int n) {
        this.path = n;
        this.updateTransformData();
        this.sendTransformChangedMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void getBoundingBox(BoundingBox boundingBox) {
        Text3DRetained text3DRetained = this;
        synchronized (text3DRetained) {
            boundingBox.setLower(this.lower);
            boundingBox.setUpper(this.upper);
        }
    }

    final float getCharacterSpacing() {
        return this.charSpacing;
    }

    final void setCharacterSpacing(float f) {
        this.geomLock.getLock();
        this.charSpacing = f;
        this.updateTransformData();
        this.geomLock.unLock();
        this.sendTransformChangedMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void sendDataChangedMessage() {
        ArrayList<TargetsInterface> arrayList = new ArrayList<TargetsInterface>();
        ArrayList<CachedTargets[]> arrayList2 = new ArrayList<CachedTargets[]>();
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source.isLive()) {
                ArrayList arrayList3 = this.universeList;
                synchronized (arrayList3) {
                    int n = this.universeList.size();
                    J3dMessage[] j3dMessageArray = new J3dMessage[n];
                    for (int i = 0; i < n; ++i) {
                        SceneGraphObjectRetained sceneGraphObjectRetained;
                        SceneGraphObjectRetained sceneGraphObjectRetained2;
                        int n2;
                        int n3;
                        Object object2;
                        Object object3;
                        int n4;
                        j3dMessageArray[i] = new J3dMessage();
                        j3dMessageArray[i].type = 26;
                        j3dMessageArray[i].threads = 8384;
                        ArrayList arrayList4 = (ArrayList)this.userLists.get(i);
                        this.newGeometryAtomList.clear();
                        this.oldGeometryAtomList.clear();
                        for (n4 = 0; n4 < arrayList4.size(); ++n4) {
                            GeometryRetained geometryRetained;
                            Shape3DRetained shape3DRetained = (Shape3DRetained)arrayList4.get(n4);
                            if (shape3DRetained.boundsAutoCompute) {
                                shape3DRetained.getCombineBounds((BoundingBox)shape3DRetained.bounds);
                            }
                            int n5 = shape3DRetained.geometryList.size();
                            object3 = Shape3DRetained.getGeomAtom(shape3DRetained);
                            object2 = new GeometryAtom();
                            int n6 = 0;
                            for (n3 = 0; n3 < n5; ++n3) {
                                GeometryRetained geometryRetained2 = (GeometryRetained)shape3DRetained.geometryList.get(n3);
                                if (geometryRetained2 != null) {
                                    geometryRetained = (Text3DRetained)geometryRetained2;
                                    n6 += geometryRetained.numChars;
                                    continue;
                                }
                                ++n6;
                            }
                            object2.geometryArray = new GeometryRetained[n6];
                            object2.lastLocalTransformArray = new Transform3D[n6];
                            n6 = 0;
                            object2.locale = shape3DRetained.locale;
                            object2.visible = shape3DRetained.visible;
                            object2.source = shape3DRetained;
                            geometryRetained = null;
                            for (n2 = 0; n2 < n5; ++n2) {
                                geometryRetained = (GeometryRetained)shape3DRetained.geometryList.get(n2);
                                if (geometryRetained == null) continue;
                                object2.geoType = geometryRetained.geoType;
                                object2.alphaEditable = shape3DRetained.isAlphaEditable(geometryRetained);
                                break;
                            }
                            while (n2 < n5) {
                                geometryRetained = (GeometryRetained)shape3DRetained.geometryList.get(n2);
                                if (geometryRetained == null) {
                                    object2.geometryArray[n2] = null;
                                } else {
                                    sceneGraphObjectRetained2 = geometryRetained;
                                    n3 = 0;
                                    while (n3 < ((Text3DRetained)sceneGraphObjectRetained2).numChars) {
                                        sceneGraphObjectRetained = ((Text3DRetained)sceneGraphObjectRetained2).geometryList[n3];
                                        if (sceneGraphObjectRetained != null) {
                                            object2.geometryArray[n6] = sceneGraphObjectRetained;
                                            object2.lastLocalTransformArray[n6] = ((Text3DRetained)sceneGraphObjectRetained2).charTransforms[n3];
                                        } else {
                                            object2.geometryArray[n6] = null;
                                            object2.lastLocalTransformArray[n6] = null;
                                        }
                                        ++n3;
                                        ++n6;
                                    }
                                }
                                ++n2;
                            }
                            this.oldGeometryAtomList.add(object3);
                            this.newGeometryAtomList.add(object2);
                            Shape3DRetained.setGeomAtom(shape3DRetained, (GeometryAtom)object2);
                        }
                        object3 = this.oldGeometryAtomList.toArray();
                        object2 = this.newGeometryAtomList.toArray();
                        ArrayList arrayList5 = this.getUniqueSource(arrayList4);
                        n2 = arrayList5.size();
                        for (n4 = 0; n4 < n2; ++n4) {
                            CachedTargets[] cachedTargetsArray = null;
                            sceneGraphObjectRetained = (Shape3DRetained)arrayList5.get(n4);
                            int n7 = sceneGraphObjectRetained.mirrorShape3D.size();
                            TargetsInterface targetsInterface = ((GroupRetained)sceneGraphObjectRetained.parent).getClosestTargetsInterface(0);
                            if (targetsInterface == null) continue;
                            cachedTargetsArray = new CachedTargets[n7];
                            for (n3 = 0; n3 < n7; ++n3) {
                                CachedTargets cachedTargets;
                                int n8;
                                sceneGraphObjectRetained2 = (Shape3DRetained)sceneGraphObjectRetained.mirrorShape3D.get(n3);
                                GeometryAtom geometryAtom = Shape3DRetained.getGeomAtom(sceneGraphObjectRetained2);
                                for (n8 = 0; n8 < ((Object[])object2).length && geometryAtom != object2[n8]; ++n8) {
                                }
                                if (n8 == ((Object[])object2).length) {
                                    System.err.println("Text3DRetained : Problem !!! Can't find matching geomAtom");
                                }
                                if ((cachedTargets = targetsInterface.getCachedTargets(0, n3, -1)) != null) {
                                    cachedTargetsArray[n3] = new CachedTargets();
                                    cachedTargetsArray[n3].copy(cachedTargets);
                                    cachedTargetsArray[n3].replace((NnuId)object3[n8], (NnuId)object2[n8], 0);
                                    continue;
                                }
                                cachedTargetsArray[n3] = null;
                            }
                            targetsInterface.resetCachedTargets(0, cachedTargetsArray, -1);
                            arrayList.add(targetsInterface);
                            arrayList2.add(cachedTargetsArray);
                        }
                        j3dMessageArray[i].args[0] = object3;
                        j3dMessageArray[i].args[1] = object2;
                        j3dMessageArray[i].universe = (VirtualUniverse)this.universeList.get(i);
                        if (arrayList.size() > 0) {
                            j3dMessageArray[i].args[2] = arrayList.toArray();
                            j3dMessageArray[i].args[3] = arrayList2.toArray();
                        }
                        arrayList.clear();
                        arrayList2.clear();
                    }
                    VirtualUniverse.mc.processMessage(j3dMessageArray);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void sendTransformChangedMessage() {
        ArrayList<GeometryAtom> arrayList = new ArrayList<GeometryAtom>();
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source.isLive()) {
                ArrayList arrayList2 = this.universeList;
                synchronized (arrayList2) {
                    int n = this.universeList.size();
                    J3dMessage[] j3dMessageArray = new J3dMessage[n];
                    for (int i = 0; i < n; ++i) {
                        j3dMessageArray[i] = new J3dMessage();
                        j3dMessageArray[i].type = 25;
                        j3dMessageArray[i].threads = 8384;
                        ArrayList arrayList3 = (ArrayList)this.userLists.get(i);
                        for (int j = 0; j < arrayList3.size(); ++j) {
                            GeometryRetained geometryRetained;
                            int n2;
                            Shape3DRetained shape3DRetained = (Shape3DRetained)arrayList3.get(j);
                            for (n2 = 0; n2 < shape3DRetained.geometryList.size() && (geometryRetained = (GeometryRetained)shape3DRetained.geometryList.get(n2)) != this; ++n2) {
                            }
                            if (n2 >= shape3DRetained.geometryList.size()) continue;
                            arrayList.add(Shape3DRetained.getGeomAtom(shape3DRetained));
                        }
                        j3dMessageArray[i].args[0] = arrayList.toArray();
                        j3dMessageArray[i].args[1] = this.charTransforms;
                        j3dMessageArray[i].universe = (VirtualUniverse)this.universeList.get(i);
                    }
                    VirtualUniverse.mc.processMessage(j3dMessageArray);
                }
            }
        }
    }

    final void updateCharacterData() {
        char[] cArray = new char[1];
        if (this.geometryList.length != this.numChars) {
            this.geometryList = new GeometryArrayRetained[this.numChars];
            this.glyphVecs = new GlyphVector[this.numChars];
        }
        if (this.font3D != null) {
            for (int i = 0; i < this.numChars; ++i) {
                cArray[0] = this.string.charAt(i);
                this.glyphVecs[i] = this.font3D.font.createGlyphVector(this.font3D.frc, cArray);
                this.geometryList[i] = this.font3D.triangulateGlyphs(this.glyphVecs[i], cArray[0]);
            }
        }
        this.updateTransformData();
    }

    final void updateTransformData() {
        int n;
        int n2 = 0;
        int n3 = 0;
        double d = 0.0;
        double d2 = 0.0;
        Vector3f vector3f = new Vector3f(this.position);
        this.lower.set(vector3f);
        this.upper.set(vector3f);
        this.charTransforms = new Transform3D[this.numChars];
        for (n = 0; n < this.numChars; ++n) {
            this.charTransforms[n] = new Transform3D();
        }
        if (this.numChars != 0) {
            Rectangle2D rectangle2D;
            this.charTransforms[0].set(vector3f);
            if (this.path == 1 || this.path == 2) {
                n2 = 0;
                n3 = this.numChars + 1;
            } else if (this.path == 0 || this.path == 3) {
                n2 = 1;
                n3 = this.numChars;
                rectangle2D = this.glyphVecs[0].getVisualBounds();
                this.upper.x += rectangle2D.getWidth();
                this.upper.y += rectangle2D.getHeight();
            }
            n = 1;
            while (n < n3) {
                d = this.glyphVecs[n2].getLogicalBounds().getWidth();
                rectangle2D = this.glyphVecs[n2].getVisualBounds();
                d += (double)this.charSpacing;
                d2 = rectangle2D.getHeight();
                switch (this.path) {
                    case 1: {
                        vector3f.x = (float)((double)vector3f.x + d);
                        this.upper.x += d;
                        if (!(this.upper.y < d2 + (double)vector3f.y)) break;
                        this.upper.y = (double)vector3f.y + d2;
                        break;
                    }
                    case 0: {
                        vector3f.x = (float)((double)vector3f.x - d);
                        this.lower.x -= d;
                        if (!(this.upper.y < d2 + (double)vector3f.y)) break;
                        this.upper.y = (double)vector3f.y + d2;
                        break;
                    }
                    case 2: {
                        vector3f.y = (float)((double)vector3f.y + d2);
                        this.upper.y += d2;
                        if (!(this.upper.x < rectangle2D.getWidth() + (double)vector3f.x)) break;
                        this.upper.x = (double)vector3f.x + rectangle2D.getWidth();
                        break;
                    }
                    case 3: {
                        vector3f.y = (float)((double)vector3f.y - d2);
                        this.lower.y -= d2;
                        if (!(this.upper.x < rectangle2D.getWidth() + (double)vector3f.x)) break;
                        this.upper.x = (double)vector3f.x + rectangle2D.getWidth();
                    }
                }
                if (n < this.numChars) {
                    this.charTransforms[n].set(vector3f);
                }
                ++n;
                ++n2;
            }
            if (this.alignment != 1) {
                double d3 = this.upper.x - this.lower.x;
                double d4 = this.upper.y - this.lower.y;
                if (this.alignment == 0) {
                    d3 *= 0.5;
                    d4 *= 0.5;
                }
                switch (this.path) {
                    case 1: {
                        for (n = 0; n < this.numChars; ++n) {
                            this.charTransforms[n].mat[3] = this.charTransforms[n].mat[3] - d3;
                        }
                        this.lower.x -= d3;
                        this.upper.x -= d3;
                        break;
                    }
                    case 0: {
                        for (n = 0; n < this.numChars; ++n) {
                            this.charTransforms[n].mat[3] = this.charTransforms[n].mat[3] + d3;
                        }
                        this.lower.x += d3;
                        this.upper.x += d3;
                        break;
                    }
                    case 2: {
                        for (n = 0; n < this.numChars; ++n) {
                            this.charTransforms[n].mat[7] = this.charTransforms[n].mat[7] - d4;
                        }
                        this.lower.y -= d4;
                        this.upper.y -= d4;
                        break;
                    }
                    case 3: {
                        for (n = 0; n < this.numChars; ++n) {
                            this.charTransforms[n].mat[7] = this.charTransforms[n].mat[7] + d4;
                        }
                        this.lower.y += d4;
                        this.upper.y += d4;
                    }
                }
            }
        }
        this.lower.z = 0.0;
        this.upper.z = this.font3D == null || this.font3D.fontExtrusion == null ? this.lower.z : this.lower.z + (double)this.font3D.fontExtrusion.length;
        this.getBoundingBox(this.geoBounds);
    }

    void setLive(boolean bl, int n) {
        this.updateCharacterData();
        super.doSetLive(bl, n);
        super.markAsLive();
    }

    boolean intersect(PickShape pickShape, PickInfo pickInfo, int n, Point3d point3d, GeometryRetained geometryRetained, int n2) {
        Transform3D transform3D = new Transform3D();
        GeometryArrayRetained geometryArrayRetained = null;
        int n3 = -1;
        double d = Double.MAX_VALUE;
        double d2 = 0.0;
        Point3d point3d2 = new Point3d();
        for (int i = 0; i < this.numChars; ++i) {
            geometryArrayRetained = this.geometryList[i];
            if (geometryArrayRetained == null) continue;
            transform3D.invert(this.charTransforms[i]);
            PickShape pickShape2 = pickShape.transform(transform3D);
            if (!geometryArrayRetained.intersect(pickShape2, pickInfo, n, point3d, geometryRetained, n2)) continue;
            if (n == 0) {
                return true;
            }
            d2 = pickShape2.distance(point3d);
            if (!(d2 < d)) continue;
            n3 = i;
            d = d2;
            point3d2.set(point3d);
        }
        if (n3 >= 0) {
            point3d.set(point3d2);
            this.charTransforms[n3].transform(point3d);
            return true;
        }
        return false;
    }

    boolean intersect(Point3d[] point3dArray) {
        int n;
        Transform3D transform3D = new Transform3D();
        boolean bl = false;
        Point3d[] point3dArray2 = new Point3d[point3dArray.length];
        for (n = point3dArray.length - 1; n >= 0; --n) {
            point3dArray2[n] = new Point3d();
        }
        for (n = this.numChars - 1; n >= 0; --n) {
            GeometryArrayRetained geometryArrayRetained = this.geometryList[n];
            if (geometryArrayRetained == null) continue;
            transform3D.invert(this.charTransforms[n]);
            for (int i = point3dArray.length - 1; i >= 0; --i) {
                transform3D.transform(point3dArray[i], point3dArray2[i]);
            }
            if (!geometryArrayRetained.intersect(point3dArray2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    boolean intersect(Transform3D transform3D, GeometryRetained geometryRetained) {
        for (int i = this.numChars - 1; i >= 0; --i) {
            GeometryArrayRetained geometryArrayRetained = this.geometryList[i];
            if (geometryArrayRetained == null || !geometryArrayRetained.intersect(transform3D, geometryRetained)) continue;
            return true;
        }
        return false;
    }

    boolean intersect(Bounds bounds) {
        for (int i = this.numChars - 1; i >= 0; --i) {
            GeometryArrayRetained geometryArrayRetained = this.geometryList[i];
            if (geometryArrayRetained == null || !geometryArrayRetained.intersect(bounds)) continue;
            return true;
        }
        return false;
    }

    void setModelViewMatrix(Transform3D transform3D, Transform3D transform3D2) {
        this.vpcToEc = transform3D;
        this.drawTransform = transform3D2;
    }

    void execute(Canvas3D canvas3D, RenderAtom renderAtom, boolean bl, boolean bl2, float f, int n, boolean bl3) {
        Transform3D transform3D = new Transform3D();
        for (int i = 0; i < this.geometryList.length; ++i) {
            transform3D.set(this.drawTransform);
            transform3D.mul(this.charTransforms[i]);
            canvas3D.setModelViewMatrix(canvas3D.ctx, this.vpcToEc.mat, transform3D);
            this.geometryList[i].execute(canvas3D, renderAtom, bl, bl2, f, n, bl3);
        }
    }

    int getClassType() {
        return 6;
    }

    ArrayList getUniqueSource(ArrayList arrayList) {
        ArrayList<NodeRetained> arrayList2 = new ArrayList<NodeRetained>();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            NodeRetained nodeRetained = ((Shape3DRetained)arrayList.get((int)i)).sourceNode;
            int n2 = arrayList2.indexOf(nodeRetained);
            if (n2 != -1) continue;
            arrayList2.add(nodeRetained);
        }
        return arrayList2;
    }
}

