/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.BadTransformException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Transform3D;
import javax.media.j3d.View;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class PhysicalBody {
    private static final double HALF_IPD = 0.033;
    private static final double EAR_X = 0.08;
    private static final double EAR_Y = -0.03;
    private static final double EAR_Z = 0.095;
    Point3d leftEyePosition = new Point3d(-0.033, 0.0, 0.0);
    Point3d rightEyePosition = new Point3d(0.033, 0.0, 0.0);
    Point3d leftEarPosition = new Point3d(-0.08, -0.03, 0.095);
    Point3d rightEarPosition = new Point3d(0.08, -0.03, 0.095);
    double nominalEyeHeightFromGround = 1.68;
    double nominalEyeOffsetFromNominalScreen = 0.4572;
    Transform3D headToHeadTracker = new Transform3D();
    ArrayList users = new ArrayList();
    int pbDirtyMask = 0xF000000;

    public PhysicalBody() {
        this.initHeadToHeadTracker();
    }

    synchronized void removeUser(View view) {
        int n = this.users.indexOf(view);
        if (n >= 0) {
            this.users.remove(n);
        }
    }

    synchronized void addUser(View view) {
        int n = this.users.indexOf(view);
        if (n < 0) {
            this.users.add(view);
        }
    }

    synchronized void notifyUsers() {
        for (int i = this.users.size() - 1; i >= 0; --i) {
            View view = (View)this.users.get(i);
            if (view.soundScheduler != null) {
                view.soundScheduler.setListenerFlag(3);
            }
            view.repaint();
        }
    }

    public PhysicalBody(Point3d point3d, Point3d point3d2) {
        this.leftEyePosition.set(point3d);
        this.rightEyePosition.set(point3d2);
        this.initHeadToHeadTracker();
    }

    public PhysicalBody(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4) {
        this.leftEyePosition.set(point3d);
        this.rightEyePosition.set(point3d2);
        this.leftEarPosition.set(point3d3);
        this.rightEarPosition.set(point3d4);
        this.initHeadToHeadTracker();
    }

    public String toString() {
        return "eyePosition = (" + this.leftEyePosition + ", " + this.rightEyePosition + ")\n" + "earPosition = (" + this.leftEarPosition + ", " + this.rightEarPosition + ")";
    }

    public void getLeftEyePosition(Point3d point3d) {
        point3d.set(this.leftEyePosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLeftEyePosition(Point3d point3d) {
        PhysicalBody physicalBody = this;
        synchronized (physicalBody) {
            this.leftEyePosition.set(point3d);
            this.pbDirtyMask |= 0x1000000;
        }
        this.notifyUsers();
    }

    public void getRightEyePosition(Point3d point3d) {
        point3d.set(this.rightEyePosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRightEyePosition(Point3d point3d) {
        PhysicalBody physicalBody = this;
        synchronized (physicalBody) {
            this.rightEyePosition.set(point3d);
            this.pbDirtyMask |= 0x1000000;
        }
        this.notifyUsers();
    }

    public void getLeftEarPosition(Point3d point3d) {
        point3d.set(this.leftEarPosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLeftEarPosition(Point3d point3d) {
        PhysicalBody physicalBody = this;
        synchronized (physicalBody) {
            this.leftEarPosition.set(point3d);
            this.pbDirtyMask |= 0x2000000;
        }
        this.notifyUsers();
    }

    public void getRightEarPosition(Point3d point3d) {
        point3d.set(this.rightEarPosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRightEarPosition(Point3d point3d) {
        PhysicalBody physicalBody = this;
        synchronized (physicalBody) {
            this.rightEarPosition.set(point3d);
            this.pbDirtyMask |= 0x2000000;
        }
        this.notifyUsers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNominalEyeHeightFromGround(double d) {
        PhysicalBody physicalBody = this;
        synchronized (physicalBody) {
            this.nominalEyeHeightFromGround = d;
            this.pbDirtyMask |= 0x4000000;
        }
        this.notifyUsers();
    }

    public double getNominalEyeHeightFromGround() {
        return this.nominalEyeHeightFromGround;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNominalEyeOffsetFromNominalScreen(double d) {
        PhysicalBody physicalBody = this;
        synchronized (physicalBody) {
            this.nominalEyeOffsetFromNominalScreen = d;
            this.pbDirtyMask |= 0x8000000;
        }
        this.notifyUsers();
    }

    public double getNominalEyeOffsetFromNominalScreen() {
        return this.nominalEyeOffsetFromNominalScreen;
    }

    public void setHeadToHeadTracker(Transform3D transform3D) {
        if (!transform3D.isRigid()) {
            throw new BadTransformException(J3dI18N.getString("PhysicalBody0"));
        }
        this.headToHeadTracker.setWithLock(transform3D);
        this.notifyUsers();
    }

    public void getHeadToHeadTracker(Transform3D transform3D) {
        transform3D.set(this.headToHeadTracker);
    }

    private void initHeadToHeadTracker() {
        Vector3d vector3d = new Vector3d(0.0, 0.02, 0.035);
        this.headToHeadTracker.set(vector3d);
    }
}

