/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.Rectangle;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.RenderBin;
import javax.media.j3d.ScreenViewCache;
import javax.media.j3d.Transform3D;
import javax.media.j3d.ViewCache;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;
import javax.vecmath.SingularMatrixException;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

class CanvasViewCache {
    private static Object debugLock = new Object();
    private Canvas3D canvas;
    int cvcDirtyMask = 0;
    private ScreenViewCache screenViewCache;
    private ViewCache viewCache;
    private int awtCanvasX;
    private int awtCanvasY;
    private int awtCanvasWidth;
    private int awtCanvasHeight;
    private RenderBin renderBin;
    private boolean useStereo;
    private int monoscopicViewPolicy;
    private Point3d leftManualEyeInImagePlate = new Point3d();
    private Point3d rightManualEyeInImagePlate = new Point3d();
    double physicalScreenWidth;
    double physicalScreenHeight;
    int screenWidth;
    int screenHeight;
    double metersPerPixelX;
    double metersPerPixelY;
    private int canvasX;
    private int canvasY;
    private int canvasWidth;
    private int canvasHeight;
    private int effectiveMonoscopicViewPolicy;
    private Transform3D leftProjection = new Transform3D();
    private Transform3D rightProjection = new Transform3D();
    private Transform3D infLeftProjection = new Transform3D();
    private Transform3D infRightProjection = new Transform3D();
    private Transform3D leftVpcToEc = new Transform3D();
    private Transform3D rightVpcToEc = new Transform3D();
    private Transform3D infLeftVpcToEc = new Transform3D();
    private Transform3D infRightVpcToEc = new Transform3D();
    private Transform3D leftEcToVpc = new Transform3D();
    private Transform3D rightEcToVpc = new Transform3D();
    private Transform3D infLeftEcToVpc = new Transform3D();
    private Transform3D infRightEcToVpc = new Transform3D();
    private Vector4d[] leftFrustumPlanes = new Vector4d[6];
    private Vector4d[] rightFrustumPlanes = new Vector4d[6];
    private Point4d[] leftFrustumPoints = new Point4d[8];
    private Point4d[] rightFrustumPoints = new Point4d[8];
    private Transform3D headTrackerToLeftImagePlate = new Transform3D();
    private Transform3D headTrackerToRightImagePlate = new Transform3D();
    private Point3d leftTrackedEyeInImagePlate = new Point3d();
    private Point3d rightTrackedEyeInImagePlate = new Point3d();
    private Point3d leftEyeInImagePlate = new Point3d();
    private Point3d rightEyeInImagePlate = new Point3d();
    private Point3d centerEyeInImagePlate = new Point3d();
    private double nominalEyeOffset;
    private double physicalWindowXLeft;
    private double physicalWindowYBottom;
    private double physicalWindowXRight;
    private double physicalWindowYTop;
    private double physicalWindowWidth;
    private double physicalWindowHeight;
    private Point3d physicalWindowCenter = new Point3d();
    private double screenScale;
    private double windowScale;
    private double viewPlatformScale;
    private Transform3D leftCcToVworld = new Transform3D();
    private Transform3D rightCcToVworld = new Transform3D();
    private Transform3D coexistenceToLeftPlate = new Transform3D();
    private Transform3D coexistenceToRightPlate = new Transform3D();
    private Transform3D vpcToCoexistence = new Transform3D();
    private Transform3D vpcToLeftPlate = new Transform3D();
    private Transform3D vpcToRightPlate = new Transform3D();
    private Transform3D leftPlateToVpc = new Transform3D();
    private Transform3D rightPlateToVpc = new Transform3D();
    private Transform3D vworldToLeftPlate = new Transform3D();
    private Transform3D lastVworldToLeftPlate = new Transform3D();
    private Transform3D vworldToRightPlate = new Transform3D();
    private Transform3D leftPlateToVworld = new Transform3D();
    private Transform3D rightPlateToVworld = new Transform3D();
    private Transform3D headToLeftImagePlate = new Transform3D();
    private Transform3D headToRightImagePlate = new Transform3D();
    private Transform3D vworldToTrackerBase = new Transform3D();
    private Transform3D tempTrans = new Transform3D();
    private Transform3D headToVworld = new Transform3D();
    private Vector3d coexistenceCenter = new Vector3d();
    private double vworldToCoexistenceScale;
    private double infVworldToCoexistenceScale;
    private Transform3D tMat1 = new Transform3D();
    private Transform3D tMat2 = new Transform3D();
    private Vector3d tVec1 = new Vector3d();
    private Vector3d tVec2 = new Vector3d();
    private Vector3d tVec3 = new Vector3d();
    private Point3d tPnt1 = new Point3d();
    private Point3d tPnt2 = new Point3d();
    private Matrix4d tMatrix = new Matrix4d();
    private Transform3D vworldToVpc = new Transform3D();
    private Transform3D vpcToVworld = new Transform3D();
    private Transform3D infVworldToVpc = new Transform3D();
    private boolean lastDoInfinite = false;
    private boolean updateLastTime = false;

    void getCanvasPositionAndSize() {
        this.awtCanvasX = this.canvas.newPosition.x;
        this.awtCanvasY = this.canvas.newPosition.y;
        this.awtCanvasWidth = this.canvas.newSize.width;
        this.awtCanvasHeight = this.canvas.newSize.height;
        if (this.awtCanvasWidth <= 0 || this.awtCanvasHeight <= 0) {
            this.awtCanvasWidth = 1;
            this.awtCanvasHeight = 1;
        }
    }

    void computefrustumBBox(BoundingBox boundingBox) {
        int n;
        for (n = 0; n < this.leftFrustumPoints.length; ++n) {
            if (boundingBox.lower.x > this.leftFrustumPoints[n].x) {
                boundingBox.lower.x = this.leftFrustumPoints[n].x;
            }
            if (boundingBox.lower.y > this.leftFrustumPoints[n].y) {
                boundingBox.lower.y = this.leftFrustumPoints[n].y;
            }
            if (boundingBox.lower.z > this.leftFrustumPoints[n].z) {
                boundingBox.lower.z = this.leftFrustumPoints[n].z;
            }
            if (boundingBox.upper.x < this.leftFrustumPoints[n].x) {
                boundingBox.upper.x = this.leftFrustumPoints[n].x;
            }
            if (boundingBox.upper.y < this.leftFrustumPoints[n].y) {
                boundingBox.upper.y = this.leftFrustumPoints[n].y;
            }
            if (!(boundingBox.upper.z < this.leftFrustumPoints[n].z)) continue;
            boundingBox.upper.z = this.leftFrustumPoints[n].z;
        }
        if (this.useStereo) {
            for (n = 0; n < this.rightFrustumPoints.length; ++n) {
                if (boundingBox.lower.x > this.rightFrustumPoints[n].x) {
                    boundingBox.lower.x = this.rightFrustumPoints[n].x;
                }
                if (boundingBox.lower.y > this.rightFrustumPoints[n].y) {
                    boundingBox.lower.y = this.rightFrustumPoints[n].y;
                }
                if (boundingBox.lower.z > this.rightFrustumPoints[n].z) {
                    boundingBox.lower.z = this.rightFrustumPoints[n].z;
                }
                if (boundingBox.upper.x < this.rightFrustumPoints[n].x) {
                    boundingBox.upper.x = this.rightFrustumPoints[n].x;
                }
                if (boundingBox.upper.y < this.rightFrustumPoints[n].y) {
                    boundingBox.upper.y = this.rightFrustumPoints[n].y;
                }
                if (!(boundingBox.upper.z < this.rightFrustumPoints[n].z)) continue;
                boundingBox.upper.z = this.rightFrustumPoints[n].z;
            }
        }
    }

    void copyComputedCanvasViewCache(CanvasViewCache canvasViewCache, boolean bl) {
        canvasViewCache.useStereo = this.useStereo;
        canvasViewCache.canvasWidth = this.canvasWidth;
        canvasViewCache.canvasHeight = this.canvasHeight;
        canvasViewCache.leftProjection.set(this.leftProjection);
        canvasViewCache.rightProjection.set(this.rightProjection);
        canvasViewCache.leftVpcToEc.set(this.leftVpcToEc);
        canvasViewCache.rightVpcToEc.set(this.rightVpcToEc);
        canvasViewCache.vpcToVworld = this.vpcToVworld;
        canvasViewCache.vworldToVpc.set(this.vworldToVpc);
        if (bl) {
            canvasViewCache.infLeftProjection.set(this.infLeftProjection);
            canvasViewCache.infRightProjection.set(this.infRightProjection);
            canvasViewCache.infLeftVpcToEc.set(this.infLeftVpcToEc);
            canvasViewCache.infRightVpcToEc.set(this.infRightVpcToEc);
            canvasViewCache.infVworldToVpc.set(this.infVworldToVpc);
        }
        for (int i = 0; i < this.leftFrustumPlanes.length; ++i) {
            canvasViewCache.leftFrustumPlanes[i].x = this.leftFrustumPlanes[i].x;
            canvasViewCache.leftFrustumPlanes[i].y = this.leftFrustumPlanes[i].y;
            canvasViewCache.leftFrustumPlanes[i].z = this.leftFrustumPlanes[i].z;
            canvasViewCache.leftFrustumPlanes[i].w = this.leftFrustumPlanes[i].w;
            canvasViewCache.rightFrustumPlanes[i].x = this.rightFrustumPlanes[i].x;
            canvasViewCache.rightFrustumPlanes[i].y = this.rightFrustumPlanes[i].y;
            canvasViewCache.rightFrustumPlanes[i].z = this.rightFrustumPlanes[i].z;
            canvasViewCache.rightFrustumPlanes[i].w = this.rightFrustumPlanes[i].w;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void snapshot(boolean bl) {
        int n = bl ? 1 : 0;
        Object object = this.canvas.dirtyMaskLock;
        synchronized (object) {
            this.cvcDirtyMask = this.canvas.cvDirtyMask[n];
            this.canvas.cvDirtyMask[n] = 0;
        }
        this.useStereo = this.canvas.useStereo;
        this.monoscopicViewPolicy = this.canvas.monoscopicViewPolicy;
        this.leftManualEyeInImagePlate.set(this.canvas.leftManualEyeInImagePlate);
        this.rightManualEyeInImagePlate.set(this.canvas.rightManualEyeInImagePlate);
        if ((this.cvcDirtyMask & 8) != 0) {
            this.getCanvasPositionAndSize();
        }
        this.renderBin = this.canvas.view.renderBin;
    }

    synchronized void computeDerivedData(boolean bl, CanvasViewCache canvasViewCache, BoundingBox boundingBox, boolean bl2) {
        this.doComputeDerivedData(bl, canvasViewCache, boundingBox, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doComputeDerivedData(boolean bl, CanvasViewCache canvasViewCache, BoundingBox boundingBox, boolean bl2) {
        boolean bl3;
        int n;
        int n2 = boundingBox != null ? 1 : 0;
        ScreenViewCache screenViewCache = this.screenViewCache;
        synchronized (screenViewCache) {
            n = this.screenViewCache.scrvcDirtyMask[n2];
            if (this.canvas.offScreen) {
                this.screenViewCache.scrvcDirtyMask[n2] = 0;
            }
        }
        if (this.viewCache.vpRetained == null) {
            System.err.println("CanvasViewCache : Error! viewCache.vpRetained is null");
            return;
        }
        boolean bl4 = bl3 = this.viewCache.vpRetained.vprDirtyMask == 0;
        if (!(this.canvas.manualRendering || !bl3 || this.cvcDirtyMask != 0 || n != 0 || this.viewCache.vcDirtyMask != 0 || this.updateLastTime && bl2 != this.lastDoInfinite)) {
            if (boundingBox != null) {
                this.computefrustumBBox(boundingBox);
            }
            if (canvasViewCache != null) {
                this.copyComputedCanvasViewCache(canvasViewCache, bl2);
            }
            this.lastDoInfinite = bl2;
            this.updateLastTime = false;
            return;
        }
        this.lastDoInfinite = bl2;
        this.updateLastTime = true;
        if (bl) {
            this.vpcToVworld.set(this.viewCache.vpRetained.getCurrentLocalToVworld(null));
        } else {
            this.vpcToVworld.set(this.viewCache.vpRetained.getLastLocalToVworld(null));
        }
        try {
            this.vworldToVpc.invert(this.vpcToVworld);
        }
        catch (SingularMatrixException singularMatrixException) {
            this.vworldToVpc.setIdentity();
        }
        if (bl2) {
            this.vworldToVpc.getRotation(this.infVworldToVpc);
        }
        this.effectiveMonoscopicViewPolicy = this.monoscopicViewPolicy == 2 ? this.viewCache.monoscopicViewPolicy : this.monoscopicViewPolicy;
        this.computeCanvasInfo();
        this.computeCoexistenceCenter();
        this.cacheEyePosition();
        this.computeVpcToCoexistence();
        this.computeCoexistenceToPlate();
        this.computeView(bl2);
        this.computePlateToVworld();
        if (!bl) {
            this.lastVworldToLeftPlate.set(this.vworldToLeftPlate);
        }
        this.computeHeadToVworld();
        if (boundingBox != null) {
            this.computefrustumBBox(boundingBox);
        }
        assert (canvasViewCache == null);
        if (canvasViewCache != null) {
            this.copyComputedCanvasViewCache(canvasViewCache, bl2);
        }
        this.canvas.canvasDirty |= 0x8000;
    }

    private void computeCanvasInfo() {
        this.physicalScreenWidth = this.screenViewCache.physicalScreenWidth;
        this.physicalScreenHeight = this.screenViewCache.physicalScreenHeight;
        this.screenWidth = this.screenViewCache.screenWidth;
        this.screenHeight = this.screenViewCache.screenHeight;
        this.metersPerPixelX = this.screenViewCache.metersPerPixelX;
        this.metersPerPixelY = this.screenViewCache.metersPerPixelY;
        Rectangle rectangle = this.canvas.graphicsConfiguration.getBounds();
        this.canvasX = this.awtCanvasX - rectangle.x;
        this.canvasY = this.awtCanvasY - rectangle.y;
        this.canvasWidth = this.awtCanvasWidth;
        this.canvasHeight = this.awtCanvasHeight;
        this.physicalWindowWidth = (double)this.canvasWidth * this.metersPerPixelX;
        this.physicalWindowHeight = (double)this.canvasHeight * this.metersPerPixelY;
        this.physicalWindowXLeft = this.metersPerPixelX * (double)this.canvasX;
        this.physicalWindowYBottom = this.metersPerPixelY * (double)(this.screenHeight - this.canvasHeight - this.canvasY);
        this.physicalWindowXRight = this.physicalWindowXLeft + this.physicalWindowWidth;
        this.physicalWindowYTop = this.physicalWindowYBottom + this.physicalWindowHeight;
        this.physicalWindowCenter.x = this.physicalWindowXLeft + this.physicalWindowWidth / 2.0;
        this.physicalWindowCenter.y = this.physicalWindowYBottom + this.physicalWindowHeight / 2.0;
        this.physicalWindowCenter.z = 0.0;
        this.computeViewPlatformScale();
        if (!this.viewCache.compatibilityModeEnable && this.viewCache.viewPolicy == 1) {
            if (!this.useStereo) {
                switch (this.effectiveMonoscopicViewPolicy) {
                    case 2: {
                        break;
                    }
                    case 0: {
                        this.headTrackerToLeftImagePlate.set(this.screenViewCache.headTrackerToLeftImagePlate);
                        break;
                    }
                    case 1: {
                        this.headTrackerToLeftImagePlate.set(this.screenViewCache.headTrackerToRightImagePlate);
                    }
                }
            } else {
                this.headTrackerToLeftImagePlate.set(this.screenViewCache.headTrackerToLeftImagePlate);
                this.headTrackerToRightImagePlate.set(this.screenViewCache.headTrackerToRightImagePlate);
            }
        }
    }

    private void computeViewPlatformScale() {
        this.screenScale = 1.0;
        this.windowScale = 1.0;
        if (!this.viewCache.compatibilityModeEnable) {
            switch (this.viewCache.screenScalePolicy) {
                case 0: {
                    this.screenScale = this.physicalScreenWidth / 2.0;
                    break;
                }
                case 1: {
                    this.screenScale = this.viewCache.screenScale;
                }
            }
            if (this.viewCache.windowResizePolicy == 1) {
                this.windowScale = this.physicalWindowWidth / this.physicalScreenWidth;
            }
        }
        this.viewPlatformScale = this.windowScale * this.screenScale;
    }

    private void cacheEyePosFixedField() {
        this.rightEyeInImagePlate.y = this.leftEyeInImagePlate.y = this.physicalWindowCenter.y;
        if (!this.useStereo) {
            switch (this.effectiveMonoscopicViewPolicy) {
                case 2: {
                    this.leftEyeInImagePlate.x = this.physicalWindowCenter.x;
                    break;
                }
                case 0: {
                    this.leftEyeInImagePlate.x = this.physicalWindowCenter.x + this.viewCache.leftEyePosInHead.x;
                    break;
                }
                case 1: {
                    this.leftEyeInImagePlate.x = this.physicalWindowCenter.x + this.viewCache.rightEyePosInHead.x;
                }
            }
            this.rightEyeInImagePlate.x = this.leftEyeInImagePlate.x;
        } else {
            this.leftEyeInImagePlate.x = this.physicalWindowCenter.x + this.viewCache.leftEyePosInHead.x;
            this.rightEyeInImagePlate.x = this.physicalWindowCenter.x + this.viewCache.rightEyePosInHead.x;
        }
        this.rightEyeInImagePlate.z = this.leftEyeInImagePlate.z = this.physicalWindowWidth / (2.0 * Math.tan(this.viewCache.fieldOfView / 2.0));
        if (this.viewCache.view.soundScheduler != null) {
            this.viewCache.view.soundScheduler.setListenerFlag(2);
        }
    }

    private void cacheEyePosWindowRelative() {
        this.rightEyeInImagePlate.y = this.leftEyeInImagePlate.y = this.physicalWindowCenter.y;
        this.rightEyeInImagePlate.z = this.leftEyeInImagePlate.z = this.leftManualEyeInImagePlate.z;
        if (!this.useStereo) {
            switch (this.effectiveMonoscopicViewPolicy) {
                case 2: {
                    this.leftEyeInImagePlate.x = this.physicalWindowCenter.x;
                    break;
                }
                case 0: {
                    this.leftEyeInImagePlate.x = this.physicalWindowCenter.x + this.viewCache.leftEyePosInHead.x;
                    break;
                }
                case 1: {
                    this.leftEyeInImagePlate.x = this.physicalWindowCenter.x + this.viewCache.rightEyePosInHead.x;
                }
            }
            this.rightEyeInImagePlate.x = this.leftEyeInImagePlate.x;
        } else {
            this.leftEyeInImagePlate.x = this.physicalWindowCenter.x + this.viewCache.leftEyePosInHead.x;
            this.rightEyeInImagePlate.x = this.physicalWindowCenter.x + this.viewCache.rightEyePosInHead.x;
            this.rightEyeInImagePlate.z = this.rightManualEyeInImagePlate.z;
        }
        if (this.viewCache.view.soundScheduler != null) {
            this.viewCache.view.soundScheduler.setListenerFlag(2);
        }
    }

    private void cacheEyePosScreenRelative(Point3d point3d, Point3d point3d2) {
        if (!this.useStereo) {
            switch (this.effectiveMonoscopicViewPolicy) {
                case 2: {
                    this.leftEyeInImagePlate.x = (point3d.x + point3d2.x) / 2.0;
                    this.leftEyeInImagePlate.y = (point3d.y + point3d2.y) / 2.0;
                    this.leftEyeInImagePlate.z = (point3d.z + point3d2.z) / 2.0;
                    break;
                }
                case 0: {
                    this.leftEyeInImagePlate.set(point3d);
                    break;
                }
                case 1: {
                    this.leftEyeInImagePlate.set(point3d2);
                }
            }
            this.rightEyeInImagePlate.set(this.leftEyeInImagePlate);
        } else {
            this.leftEyeInImagePlate.set(point3d);
            this.rightEyeInImagePlate.set(point3d2);
        }
        if (this.viewCache.view.soundScheduler != null) {
            this.viewCache.view.soundScheduler.setListenerFlag(2);
        }
    }

    private void cacheEyePosCoexistenceRelative(Point3d point3d, Point3d point3d2) {
        this.tPnt1.set(point3d);
        this.viewCache.coexistenceToTrackerBase.transform(this.tPnt1);
        this.screenViewCache.trackerBaseToImagePlate.transform(this.tPnt1);
        this.tPnt1.add(this.coexistenceCenter);
        this.tPnt2.set(point3d2);
        this.viewCache.coexistenceToTrackerBase.transform(this.tPnt2);
        this.screenViewCache.trackerBaseToImagePlate.transform(this.tPnt2);
        this.tPnt2.add(this.coexistenceCenter);
        this.cacheEyePosScreenRelative(this.tPnt1, this.tPnt2);
    }

    private void computeTrackedEyePosition() {
        if (this.viewCache.viewPolicy != 1) {
            this.headToLeftImagePlate.set(this.coexistenceCenter);
            this.headToLeftImagePlate.mul(this.screenViewCache.trackerBaseToImagePlate);
            this.headToLeftImagePlate.mul(this.viewCache.headTrackerToTrackerBase);
            this.headToLeftImagePlate.mul(this.viewCache.headToHeadTracker);
            this.headToLeftImagePlate.transform(this.viewCache.leftEyePosInHead, this.leftTrackedEyeInImagePlate);
            this.headToLeftImagePlate.transform(this.viewCache.rightEyePosInHead, this.rightTrackedEyeInImagePlate);
        } else {
            this.headToLeftImagePlate.mul(this.headTrackerToLeftImagePlate, this.viewCache.headToHeadTracker);
            this.headToLeftImagePlate.transform(this.viewCache.leftEyePosInHead, this.leftTrackedEyeInImagePlate);
            if (this.useStereo) {
                this.headToRightImagePlate.mul(this.headTrackerToRightImagePlate, this.viewCache.headToHeadTracker);
                this.headToRightImagePlate.transform(this.viewCache.rightEyePosInHead, this.rightTrackedEyeInImagePlate);
            } else {
                this.headToLeftImagePlate.transform(this.viewCache.rightEyePosInHead, this.rightTrackedEyeInImagePlate);
            }
        }
    }

    private void cacheEyePosition() {
        if (this.viewCache.compatibilityModeEnable) {
            this.cacheEyePosScreenRelative(this.leftManualEyeInImagePlate, this.rightManualEyeInImagePlate);
        } else if (this.viewCache.getDoHeadTracking()) {
            this.computeTrackedEyePosition();
            this.cacheEyePosScreenRelative(this.leftTrackedEyeInImagePlate, this.rightTrackedEyeInImagePlate);
        } else {
            switch (this.viewCache.windowEyepointPolicy) {
                case 2: {
                    this.cacheEyePosFixedField();
                    break;
                }
                case 1: {
                    this.cacheEyePosWindowRelative();
                    break;
                }
                case 0: {
                    this.cacheEyePosScreenRelative(this.leftManualEyeInImagePlate, this.rightManualEyeInImagePlate);
                    break;
                }
                case 3: {
                    this.cacheEyePosCoexistenceRelative(this.viewCache.leftManualEyeInCoexistence, this.viewCache.rightManualEyeInCoexistence);
                }
            }
        }
        this.centerEyeInImagePlate.add(this.leftEyeInImagePlate, this.rightEyeInImagePlate);
        this.centerEyeInImagePlate.scale(0.5);
        this.nominalEyeOffset = this.viewCache.windowEyepointPolicy == 2 ? this.centerEyeInImagePlate.z : this.viewCache.nominalEyeOffsetFromNominalScreen;
    }

    private void computePlateToVworld() {
        if (this.viewCache.compatibilityModeEnable) {
            this.leftPlateToVworld.setIdentity();
            this.vworldToLeftPlate.setIdentity();
        } else {
            try {
                this.leftPlateToVpc.invert(this.vpcToLeftPlate);
            }
            catch (SingularMatrixException singularMatrixException) {
                this.leftPlateToVpc.setIdentity();
            }
            this.leftPlateToVworld.mul(this.vpcToVworld, this.leftPlateToVpc);
            this.vworldToLeftPlate.mul(this.vpcToLeftPlate, this.vworldToVpc);
            if (this.useStereo) {
                try {
                    this.rightPlateToVpc.invert(this.vpcToRightPlate);
                }
                catch (SingularMatrixException singularMatrixException) {
                    this.rightPlateToVpc.setIdentity();
                }
                this.rightPlateToVworld.mul(this.vpcToVworld, this.rightPlateToVpc);
                this.vworldToRightPlate.mul(this.vpcToRightPlate, this.vworldToVpc);
            }
        }
        if (this.viewCache.view.soundScheduler != null) {
            this.viewCache.view.soundScheduler.setListenerFlag(4);
        }
    }

    private void computeHeadToVworld() {
        if (this.viewCache.compatibilityModeEnable) {
            this.headToVworld.setIdentity();
        } else {
            this.headToVworld.mul(this.leftPlateToVworld, this.headToLeftImagePlate);
        }
        if (this.viewCache.view.soundScheduler != null) {
            this.viewCache.view.soundScheduler.setListenerFlag(8);
        }
    }

    private void computeVpcToCoexistence() {
        this.tMat1.set(this.viewPlatformScale);
        if (this.viewCache.viewPolicy != 1) {
            block0 : switch (this.viewCache.coexistenceCenterInPworldPolicy) {
                case 2: {
                    switch (this.viewCache.viewAttachPolicy) {
                        case 2: {
                            this.tMat2.setIdentity();
                            break;
                        }
                        case 0: {
                            this.tVec1.set(0.0, 0.0, this.nominalEyeOffset);
                            this.tMat2.set(this.tVec1);
                            break;
                        }
                        case 1: {
                            this.tVec1.set(0.0, -this.viewCache.nominalEyeHeightFromGround, this.nominalEyeOffset);
                            this.tMat2.set(this.tVec1);
                        }
                    }
                    break;
                }
                case 0: {
                    switch (this.viewCache.viewAttachPolicy) {
                        case 2: {
                            this.tVec1.set(0.0, 0.0, -this.nominalEyeOffset);
                            this.tMat2.set(this.tVec1);
                            break;
                        }
                        case 0: {
                            this.tMat2.setIdentity();
                            break;
                        }
                        case 1: {
                            this.tVec1.set(0.0, -this.viewCache.nominalEyeHeightFromGround, 0.0);
                            this.tMat2.set(this.tVec1);
                        }
                    }
                    break;
                }
                case 1: {
                    switch (this.viewCache.viewAttachPolicy) {
                        case 2: {
                            this.tVec1.set(0.0, this.viewCache.nominalEyeHeightFromGround, -this.nominalEyeOffset);
                            this.tMat2.set(this.tVec1);
                            break block0;
                        }
                        case 0: {
                            this.tVec1.set(0.0, this.viewCache.nominalEyeHeightFromGround, 0.0);
                            this.tMat2.set(this.tVec1);
                            break block0;
                        }
                        case 1: {
                            this.tMat2.setIdentity();
                        }
                    }
                }
            }
            this.vpcToCoexistence.mul(this.tMat2, this.tMat1);
        } else {
            this.vpcToCoexistence.set(this.tMat1);
        }
    }

    private void computeCoexistenceCenter() {
        if (!this.viewCache.compatibilityModeEnable && this.viewCache.viewPolicy != 1 && this.viewCache.coexistenceCenteringEnable && this.viewCache.coexistenceCenterInPworldPolicy == 2) {
            if (this.viewCache.windowMovementPolicy == 0) {
                this.coexistenceCenter.x = this.physicalScreenWidth / 2.0;
                this.coexistenceCenter.y = this.physicalScreenHeight / 2.0;
                this.coexistenceCenter.z = 0.0;
            } else {
                this.coexistenceCenter.x = this.physicalWindowCenter.x;
                this.coexistenceCenter.y = this.physicalWindowCenter.y;
                this.coexistenceCenter.z = 0.0;
            }
        } else {
            this.coexistenceCenter.set(0.0, 0.0, 0.0);
        }
    }

    private void computeCoexistenceToPlate() {
        if (this.viewCache.compatibilityModeEnable) {
            this.coexistenceToLeftPlate.setIdentity();
            return;
        }
        if (this.viewCache.viewPolicy != 1) {
            this.coexistenceToLeftPlate.set(this.coexistenceCenter);
            this.coexistenceToLeftPlate.mul(this.screenViewCache.trackerBaseToImagePlate);
            this.coexistenceToLeftPlate.mul(this.viewCache.coexistenceToTrackerBase);
            if (this.useStereo) {
                this.coexistenceToRightPlate.set(this.coexistenceToLeftPlate);
            }
        } else {
            this.coexistenceToLeftPlate.mul(this.headTrackerToLeftImagePlate, this.viewCache.trackerBaseToHeadTracker);
            this.coexistenceToLeftPlate.mul(this.viewCache.coexistenceToTrackerBase);
            if (this.useStereo) {
                this.coexistenceToRightPlate.mul(this.headTrackerToRightImagePlate, this.viewCache.trackerBaseToHeadTracker);
                this.coexistenceToRightPlate.mul(this.viewCache.coexistenceToTrackerBase);
            }
        }
    }

    private void computeView(boolean bl) {
        double d;
        int n;
        double d2;
        double d3;
        this.vworldToCoexistenceScale = this.vworldToVpc.getDistanceScale() * this.vpcToCoexistence.getDistanceScale();
        if (bl) {
            this.infVworldToCoexistenceScale = this.infVworldToVpc.getDistanceScale() * this.vpcToCoexistence.getDistanceScale();
        }
        this.tempTrans.mul(this.viewCache.coexistenceToTrackerBase, this.vpcToCoexistence);
        this.vworldToTrackerBase.mul(this.tempTrans, this.vworldToVpc);
        if (this.viewCache.compatibilityModeEnable) {
            this.leftProjection.set(this.viewCache.compatLeftProjection);
            this.leftVpcToEc.set(this.viewCache.compatVpcToEc);
            this.computeFrustumPlanes(this.leftProjection, this.leftVpcToEc, this.leftFrustumPlanes, this.leftFrustumPoints, this.leftCcToVworld);
            if (this.useStereo) {
                this.rightProjection.set(this.viewCache.compatRightProjection);
                this.rightVpcToEc.set(this.viewCache.compatVpcToEc);
                this.computeFrustumPlanes(this.rightProjection, this.rightVpcToEc, this.rightFrustumPlanes, this.rightFrustumPoints, this.rightCcToVworld);
            }
            return;
        }
        double d4 = this.viewCache.frontClipPolicy == 2 || this.viewCache.frontClipPolicy == 0 ? this.vworldToCoexistenceScale : this.windowScale;
        if (this.viewCache.frontClipPolicy == 3 || this.viewCache.frontClipPolicy == 2) {
            d3 = this.leftEyeInImagePlate.z + d4 * -this.viewCache.frontClipDistance;
            d2 = this.rightEyeInImagePlate.z + d4 * -this.viewCache.frontClipDistance;
        } else {
            d3 = d4 * -this.viewCache.frontClipDistance;
            d2 = d4 * -this.viewCache.frontClipDistance;
        }
        if (this.renderBin != null && this.renderBin.backClipActive) {
            n = 2;
            d = this.renderBin.backClipDistanceInVworld;
        } else {
            n = this.viewCache.backClipPolicy;
            d = this.viewCache.backClipDistance;
        }
        d4 = n == 2 || n == 0 ? this.vworldToCoexistenceScale : this.windowScale;
        double d5 = n == 3 || n == 2 ? this.leftEyeInImagePlate.z + d4 * -d : d4 * -d;
        this.buildProjView(this.leftEyeInImagePlate, this.coexistenceToLeftPlate, this.vpcToLeftPlate, d3, d5, this.leftProjection, this.leftVpcToEc, false);
        this.computeFrustumPlanes(this.leftProjection, this.leftVpcToEc, this.leftFrustumPlanes, this.leftFrustumPoints, this.leftCcToVworld);
        if (this.useStereo) {
            this.buildProjView(this.rightEyeInImagePlate, this.coexistenceToRightPlate, this.vpcToRightPlate, d2, d5, this.rightProjection, this.rightVpcToEc, false);
            this.computeFrustumPlanes(this.rightProjection, this.rightVpcToEc, this.rightFrustumPlanes, this.rightFrustumPoints, this.rightCcToVworld);
        }
        if (bl) {
            this.buildProjView(this.leftEyeInImagePlate, this.coexistenceToLeftPlate, this.vpcToLeftPlate, this.leftEyeInImagePlate.z - 0.05, this.leftEyeInImagePlate.z - 1.5, this.infLeftProjection, this.infLeftVpcToEc, true);
            if (this.useStereo) {
                this.buildProjView(this.rightEyeInImagePlate, this.coexistenceToRightPlate, this.vpcToRightPlate, this.rightEyeInImagePlate.z - 0.05, this.rightEyeInImagePlate.z - 1.5, this.infRightProjection, this.infRightVpcToEc, true);
            }
        }
    }

    private void analyzeProjection(Transform3D transform3D, double d) {
        if (this.viewCache.projectionPolicy == 0) {
            System.err.println("PARALLEL_PROJECTION =");
        } else {
            System.err.println("PERSPECTIVE_PROJECTION =");
        }
        System.err.println(transform3D);
        double d2 = (transform3D.mat[0] * d + transform3D.mat[3] - transform3D.mat[15]) / (transform3D.mat[14] - transform3D.mat[2]);
        System.err.println("projection plane at z = " + d2);
    }

    private void buildProjView(Point3d point3d, Transform3D transform3D, Transform3D transform3D2, double d, double d2, Transform3D transform3D3, Transform3D transform3D4, boolean bl) {
        double d3 = this.physicalWindowXLeft;
        double d4 = this.physicalWindowXRight;
        double d5 = this.physicalWindowYBottom;
        double d6 = this.physicalWindowYTop;
        transform3D3.setIdentity();
        if (this.viewCache.projectionPolicy == 0) {
            double d7 = 1.0 / (d4 - d3);
            double d8 = 1.0 / (d6 - d5);
            double d9 = 1.0 / (d - d2);
            transform3D3.mat[0] = 2.0 * d7;
            transform3D3.mat[3] = -(d4 + d3) * d7;
            transform3D3.mat[5] = 2.0 * d8;
            transform3D3.mat[7] = -(d6 + d5) * d8;
            transform3D3.mat[10] = 2.0 * d9;
            transform3D3.mat[11] = -(d + d2) * d9;
        } else {
            double d10 = 1.0 / (d4 - d3);
            double d11 = 1.0 / (d6 - d5);
            double d12 = 1.0 / (point3d.z - d2);
            double d13 = point3d.z * d12;
            transform3D3.mat[0] = d13 * 2.0 * d10;
            transform3D3.mat[5] = d13 * 2.0 * d11;
            transform3D3.mat[2] = d12 * (d4 + d3 - 2.0 * point3d.x) * d10;
            transform3D3.mat[6] = d12 * (d6 + d5 - 2.0 * point3d.y) * d11;
            transform3D3.mat[10] = d12 * (d2 + d - 2.0 * point3d.z) / (d2 - d);
            transform3D3.mat[14] = -d12;
            transform3D3.mat[3] = d13 * (-d4 - d3) * d10;
            transform3D3.mat[7] = d13 * (-d6 - d5) * d11;
            transform3D3.mat[11] = d12 * (d2 - point3d.z - d2 * (d2 + d - 2.0 * point3d.z) / (d2 - d));
            transform3D3.mat[15] = d13;
        }
        transform3D3.setOrthoDirtyBit();
        this.tVec1.set(point3d.x, point3d.y, point3d.z);
        this.tMat1.set(this.tVec1);
        transform3D3.mul(this.tMat1);
        if (!bl) {
            transform3D2.mul(transform3D, this.vpcToCoexistence);
            this.tVec1.set(-point3d.x, -point3d.y, -point3d.z);
            this.tMat1.set(this.tVec1);
            transform3D4.mul(this.tMat1, transform3D2);
        } else {
            this.tVec1.set(-point3d.x, -point3d.y, -point3d.z);
            this.tMat1.set(this.tVec1);
            this.tMat1.mul(this.tMat1, transform3D2);
            this.tMat1.getRotation(transform3D4);
        }
    }

    private void computeFrustumPlanes(Transform3D transform3D, Transform3D transform3D2, Vector4d[] vector4dArray, Point4d[] point4dArray, Transform3D transform3D3) {
        this.tMat2.mul(transform3D, transform3D2);
        transform3D3.mul(this.tMat2, this.vworldToVpc);
        try {
            transform3D3.invert();
        }
        catch (SingularMatrixException singularMatrixException) {
            transform3D3.setIdentity();
        }
        point4dArray[0].set(-1.0, -1.0, 1.0, 1.0);
        point4dArray[1].set(-1.0, 1.0, 1.0, 1.0);
        point4dArray[2].set(1.0, 1.0, 1.0, 1.0);
        point4dArray[3].set(1.0, -1.0, 1.0, 1.0);
        point4dArray[4].set(-1.0, -1.0, -1.0, 1.0);
        point4dArray[5].set(-1.0, 1.0, -1.0, 1.0);
        point4dArray[6].set(1.0, 1.0, -1.0, 1.0);
        point4dArray[7].set(1.0, -1.0, -1.0, 1.0);
        transform3D3.get(this.tMatrix);
        for (int i = 0; i < point4dArray.length; ++i) {
            this.tMatrix.transform(point4dArray[i]);
            double d = 1.0 / point4dArray[i].w;
            point4dArray[i].x *= d;
            point4dArray[i].y *= d;
            point4dArray[i].z *= d;
        }
        this.computePlaneEq(point4dArray[0], point4dArray[4], point4dArray[5], point4dArray[1], vector4dArray[0]);
        this.computePlaneEq(point4dArray[3], point4dArray[2], point4dArray[6], point4dArray[7], vector4dArray[1]);
        this.computePlaneEq(point4dArray[1], point4dArray[5], point4dArray[6], point4dArray[2], vector4dArray[2]);
        this.computePlaneEq(point4dArray[0], point4dArray[3], point4dArray[7], point4dArray[4], vector4dArray[3]);
        this.computePlaneEq(point4dArray[0], point4dArray[1], point4dArray[2], point4dArray[3], vector4dArray[4]);
        this.computePlaneEq(point4dArray[4], point4dArray[7], point4dArray[6], point4dArray[5], vector4dArray[5]);
    }

    private void computePlaneEq(Point4d point4d, Point4d point4d2, Point4d point4d3, Point4d point4d4, Vector4d vector4d) {
        this.tVec1.x = point4d3.x - point4d.x;
        this.tVec1.y = point4d3.y - point4d.y;
        this.tVec1.z = point4d3.z - point4d.z;
        this.tVec2.x = point4d2.x - point4d.x;
        this.tVec2.y = point4d2.y - point4d.y;
        this.tVec2.z = point4d2.z - point4d.z;
        this.tVec3.cross(this.tVec2, this.tVec1);
        this.tVec3.normalize();
        vector4d.x = this.tVec3.x;
        vector4d.y = this.tVec3.y;
        vector4d.z = this.tVec3.z;
        vector4d.w = -(vector4d.x * point4d.x + vector4d.y * point4d.y + vector4d.z * point4d.z);
    }

    int getCanvasX() {
        return this.canvasX;
    }

    int getCanvasY() {
        return this.canvasY;
    }

    int getCanvasWidth() {
        return this.canvasWidth;
    }

    int getCanvasHeight() {
        return this.canvasHeight;
    }

    double getPhysicalWindowWidth() {
        return this.physicalWindowWidth;
    }

    double getPhysicalWindowHeight() {
        return this.physicalWindowHeight;
    }

    boolean getUseStereo() {
        return this.useStereo;
    }

    Transform3D getLeftProjection() {
        return this.leftProjection;
    }

    Transform3D getRightProjection() {
        return this.rightProjection;
    }

    Transform3D getLeftVpcToEc() {
        return this.leftVpcToEc;
    }

    Transform3D getRightVpcToEc() {
        return this.rightVpcToEc;
    }

    Transform3D getLeftEcToVpc() {
        return this.leftEcToVpc;
    }

    Transform3D getRightEcToVpc() {
        return this.rightEcToVpc;
    }

    Transform3D getInfLeftProjection() {
        return this.infLeftProjection;
    }

    Transform3D getInfRightProjection() {
        return this.infLeftProjection;
    }

    Transform3D getInfLeftVpcToEc() {
        return this.infLeftVpcToEc;
    }

    Transform3D getInfRightVpcToEc() {
        return this.infRightVpcToEc;
    }

    Transform3D getInfLeftEcToVpc() {
        return this.infLeftEcToVpc;
    }

    Transform3D getInfgRightEcToVpc() {
        return this.infRightEcToVpc;
    }

    Transform3D getInfVworldToVpc() {
        return this.infVworldToVpc;
    }

    Transform3D getLeftCcToVworld() {
        return this.leftCcToVworld;
    }

    Transform3D getRightCcToVworld() {
        return this.rightCcToVworld;
    }

    Transform3D getImagePlateToVworld() {
        return this.leftPlateToVworld;
    }

    Transform3D getLastVworldToImagePlate() {
        return this.lastVworldToLeftPlate;
    }

    Transform3D getVworldToImagePlate() {
        return this.vworldToLeftPlate;
    }

    Transform3D getVworldToTrackerBase() {
        return this.vworldToTrackerBase;
    }

    double getVworldToCoexistenceScale() {
        return this.vworldToCoexistenceScale;
    }

    double getInfVworldToCoexistenceScale() {
        return this.infVworldToCoexistenceScale;
    }

    Point3d getLeftEyeInImagePlate() {
        return this.leftEyeInImagePlate;
    }

    Point3d getRightEyeInImagePlate() {
        return this.rightEyeInImagePlate;
    }

    Point3d getCenterEyeInImagePlate() {
        return this.centerEyeInImagePlate;
    }

    Transform3D getHeadToVworld() {
        return this.headToVworld;
    }

    Transform3D getVpcToVworld() {
        return this.vpcToVworld;
    }

    Transform3D getVworldToVpc() {
        return this.vworldToVpc;
    }

    double getWindowXInImagePlate(double d) {
        double d2 = d + (double)this.canvasX;
        return this.metersPerPixelX * d2;
    }

    double getWindowYInImagePlate(double d) {
        double d2 = d + (double)this.canvasY;
        return this.metersPerPixelY * ((double)(this.screenHeight - 1) - d2);
    }

    Vector4d[] getLeftFrustumPlanesInVworld() {
        return this.leftFrustumPlanes;
    }

    Vector4d[] getRightFrustumPlanesInVworld() {
        return this.rightFrustumPlanes;
    }

    void getPixelLocationInImagePlate(double d, double d2, double d3, Point3d point3d) {
        double d4 = (d + (double)this.canvasX) * this.metersPerPixelX;
        double d5 = ((double)(this.screenHeight - 1 - this.canvasY) - d2) * this.metersPerPixelY;
        if (this.viewCache.projectionPolicy == 1 && this.centerEyeInImagePlate.z != 0.0) {
            double d6 = 1.0 - d3 / this.centerEyeInImagePlate.z;
            point3d.x = (d4 - this.centerEyeInImagePlate.x) * d6 + this.centerEyeInImagePlate.x;
            point3d.y = (d5 - this.centerEyeInImagePlate.y) * d6 + this.centerEyeInImagePlate.y;
        } else {
            point3d.x = d4;
            point3d.y = d5;
        }
        point3d.z = d3;
    }

    void getPixelLocationFromImagePlate(Point3d point3d, Point2d point2d) {
        double d;
        double d2;
        if (this.viewCache.projectionPolicy == 1) {
            this.tVec1.sub(point3d, this.centerEyeInImagePlate);
            if (this.tVec1.z != 0.0) {
                double d3 = this.centerEyeInImagePlate.z / -this.tVec1.z;
                d2 = this.centerEyeInImagePlate.x + this.tVec1.x * d3;
                d = this.centerEyeInImagePlate.y + this.tVec1.y * d3;
            } else {
                d2 = point3d.x;
                d = point3d.y;
            }
        } else {
            d2 = point3d.x;
            d = point3d.y;
        }
        point2d.x = d2 / this.screenViewCache.metersPerPixelX - (double)this.canvasX;
        point2d.y = (double)(this.screenViewCache.screenHeight - 1) - d / this.screenViewCache.metersPerPixelY - (double)this.canvasY;
    }

    CanvasViewCache(Canvas3D canvas3D, ScreenViewCache screenViewCache, ViewCache viewCache) {
        int n;
        this.canvas = canvas3D;
        this.screenViewCache = screenViewCache;
        this.viewCache = viewCache;
        for (n = 0; n < this.leftFrustumPlanes.length; ++n) {
            this.leftFrustumPlanes[n] = new Vector4d();
            this.rightFrustumPlanes[n] = new Vector4d();
        }
        for (n = 0; n < this.leftFrustumPoints.length; ++n) {
            this.leftFrustumPoints[n] = new Point4d();
            this.rightFrustumPoints[n] = new Point4d();
        }
        if (canvas3D != null) {
            this.leftEyeInImagePlate.set(canvas3D.leftManualEyeInImagePlate);
            this.rightEyeInImagePlate.set(canvas3D.rightManualEyeInImagePlate);
            this.centerEyeInImagePlate.add(this.leftEyeInImagePlate, this.rightEyeInImagePlate);
            this.centerEyeInImagePlate.scale(0.5);
        }
    }

    synchronized void setCanvas(Canvas3D canvas3D) {
        this.canvas = canvas3D;
    }

    synchronized void setScreenViewCache(ScreenViewCache screenViewCache) {
        this.screenViewCache = screenViewCache;
    }

    synchronized void setViewCache(ViewCache viewCache) {
        this.viewCache = viewCache;
    }
}

