/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import com.sun.j3d.utils.geometry.GeomBuffer;
import com.sun.j3d.utils.geometry.Primitive;
import javax.media.j3d.Appearance;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.vecmath.Vector3f;

public class Box
extends Primitive {
    public static final int FRONT = 0;
    public static final int BACK = 1;
    public static final int RIGHT = 2;
    public static final int LEFT = 3;
    public static final int TOP = 4;
    public static final int BOTTOM = 5;
    float xDim;
    float yDim;
    float zDim;
    int numTexUnit = 1;
    private static final float[] verts = new float[]{1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f};
    private static final double[] tcoords = new double[]{1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0};
    private static final Vector3f[] normals = new Vector3f[]{new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, -1.0f, 0.0f)};

    public Box() {
        this(1.0f, 1.0f, 1.0f, 1, null);
    }

    public Box(float f, float f2, float f3, Appearance appearance) {
        this(f, f2, f3, 1, appearance);
    }

    public Box(float f, float f2, float f3, int n, Appearance appearance, int n2) {
        this.xDim = f;
        this.yDim = f2;
        this.zDim = f3;
        this.flags = n;
        boolean bl = (this.flags & 8) != 0;
        double d = (this.flags & 4) != 0 ? -1.0 : 1.0;
        Shape3D[] shape3DArray = new Shape3D[6];
        GeomBuffer geomBuffer = null;
        for (int i = 0; i <= 5; ++i) {
            geomBuffer = this.getCachedGeometry(8, f, f2, f3, i, i, n);
            if (geomBuffer != null) {
                shape3DArray[i] = new Shape3D(geomBuffer.getComputedGeometry());
                this.numVerts += geomBuffer.getNumVerts();
                this.numTris += geomBuffer.getNumTris();
            } else {
                int n3;
                GeomBuffer geomBuffer2 = new GeomBuffer(4, n2);
                geomBuffer2.begin(1);
                for (n3 = 0; n3 < 2; ++n3) {
                    geomBuffer2.normal3d((double)Box.normals[i].x * d, (double)Box.normals[i].y * d, (double)Box.normals[i].z * d);
                    if (bl) {
                        geomBuffer2.texCoord2d(tcoords[i * 8 + n3 * 2], 1.0 - tcoords[i * 8 + n3 * 2 + 1]);
                    } else {
                        geomBuffer2.texCoord2d(tcoords[i * 8 + n3 * 2], tcoords[i * 8 + n3 * 2 + 1]);
                    }
                    geomBuffer2.vertex3d((double)verts[i * 12 + n3 * 3] * (double)f, (double)verts[i * 12 + n3 * 3 + 1] * (double)f2, (double)verts[i * 12 + n3 * 3 + 2] * (double)f3);
                }
                for (n3 = 3; n3 > 1; --n3) {
                    geomBuffer2.normal3d((double)Box.normals[i].x * d, (double)Box.normals[i].y * d, (double)Box.normals[i].z * d);
                    if (bl) {
                        geomBuffer2.texCoord2d(tcoords[i * 8 + n3 * 2], 1.0 - tcoords[i * 8 + n3 * 2 + 1]);
                    } else {
                        geomBuffer2.texCoord2d(tcoords[i * 8 + n3 * 2], tcoords[i * 8 + n3 * 2 + 1]);
                    }
                    geomBuffer2.vertex3d((double)verts[i * 12 + n3 * 3] * (double)f, (double)verts[i * 12 + n3 * 3 + 1] * (double)f2, (double)verts[i * 12 + n3 * 3 + 2] * (double)f3);
                }
                geomBuffer2.end();
                shape3DArray[i] = new Shape3D(geomBuffer2.getGeom(this.flags));
                this.numVerts = geomBuffer2.getNumVerts();
                this.numTris = geomBuffer2.getNumTris();
                if ((n & 0x10) == 0) {
                    this.cacheGeometry(8, f, f2, f3, i, i, n, geomBuffer2);
                }
            }
            if ((this.flags & 0x40) != 0) {
                shape3DArray[i].setCapability(14);
                shape3DArray[i].setCapability(15);
            }
            if ((this.flags & 0x20) != 0) {
                shape3DArray[i].setCapability(12);
            }
            this.addChild(shape3DArray[i]);
        }
        if (appearance == null) {
            this.setAppearance();
        } else {
            this.setAppearance(appearance);
        }
    }

    public Box(float f, float f2, float f3, int n, Appearance appearance) {
        this(f, f2, f3, n, appearance, 1);
    }

    public Shape3D getShape(int n) {
        if (n >= 0 && n <= 5) {
            return (Shape3D)this.getChild(n);
        }
        return null;
    }

    public void setAppearance(Appearance appearance) {
        ((Shape3D)this.getChild(4)).setAppearance(appearance);
        ((Shape3D)this.getChild(3)).setAppearance(appearance);
        ((Shape3D)this.getChild(2)).setAppearance(appearance);
        ((Shape3D)this.getChild(0)).setAppearance(appearance);
        ((Shape3D)this.getChild(1)).setAppearance(appearance);
        ((Shape3D)this.getChild(5)).setAppearance(appearance);
    }

    public Appearance getAppearance(int n) {
        if (n > 5 || n < 0) {
            return null;
        }
        return this.getShape(n).getAppearance();
    }

    public Node cloneNode(boolean bl) {
        Box box = new Box(this.xDim, this.yDim, this.zDim, this.flags, this.getAppearance());
        box.duplicateNode(this, bl);
        return box;
    }

    public void duplicateNode(Node node, boolean bl) {
        super.duplicateNode(node, bl);
    }

    public float getXdimension() {
        return this.xDim;
    }

    public float getYdimension() {
        return this.yDim;
    }

    public float getZdimension() {
        return this.zDim;
    }
}

