/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsdl.extensions.soap12;

import com.ibm.wsdl.Constants;
import com.ibm.wsdl.util.StringUtils;
import com.ibm.wsdl.util.xml.DOMUtils;
import java.io.PrintWriter;
import java.io.Serializable;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap12.SOAP12Body;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public class SOAP12BodySerializer
implements ExtensionSerializer,
ExtensionDeserializer,
Serializable {
    public static final long serialVersionUID = 1L;

    @Override
    public void marshall(Class clazz, QName qName, ExtensibilityElement extensibilityElement, PrintWriter printWriter, Definition definition, ExtensionRegistry extensionRegistry) throws WSDLException {
        SOAP12Body sOAP12Body = (SOAP12Body)extensibilityElement;
        if (sOAP12Body != null) {
            String string = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/soap12/", "body", definition);
            if (clazz != null && MIMEPart.class.isAssignableFrom(clazz)) {
                printWriter.print("    ");
            }
            printWriter.print("        <" + string);
            DOMUtils.printAttribute("parts", StringUtils.getNMTokens(sOAP12Body.getParts()), printWriter);
            DOMUtils.printAttribute("use", sOAP12Body.getUse(), printWriter);
            DOMUtils.printAttribute("encodingStyle", sOAP12Body.getEncodingStyle(), printWriter);
            DOMUtils.printAttribute("namespace", sOAP12Body.getNamespaceURI(), printWriter);
            Boolean bl = sOAP12Body.getRequired();
            if (bl != null) {
                DOMUtils.printQualifiedAttribute(Constants.Q_ATTR_REQUIRED, bl.toString(), definition, printWriter);
            }
            printWriter.println("/>");
        }
    }

    @Override
    public ExtensibilityElement unmarshall(Class clazz, QName qName, Element element, Definition definition, ExtensionRegistry extensionRegistry) throws WSDLException {
        SOAP12Body sOAP12Body = (SOAP12Body)extensionRegistry.createExtension(clazz, qName);
        String string = DOMUtils.getAttribute(element, "parts");
        String string2 = DOMUtils.getAttribute(element, "use");
        String string3 = DOMUtils.getAttribute(element, "encodingStyle");
        String string4 = DOMUtils.getAttribute(element, "namespace");
        String string5 = DOMUtils.getAttributeNS(element, "http://schemas.xmlsoap.org/wsdl/", "required");
        if (string != null) {
            sOAP12Body.setParts(StringUtils.parseNMTokens(string));
        }
        if (string2 != null) {
            sOAP12Body.setUse(string2);
        }
        if (string3 != null) {
            sOAP12Body.setEncodingStyle(string3);
        }
        if (string4 != null) {
            sOAP12Body.setNamespaceURI(string4);
        }
        if (string5 != null) {
            sOAP12Body.setRequired(new Boolean(string5));
        }
        return sOAP12Body;
    }
}

